	PAGE	60,132

	TITLE	CMD.COM - Execute COMMAND.COM as a child process

;	Version 2.0 (C) 06-Jul-86 by John Stetson

;	Command line syntax:

;	CMD {<command_name> <command_operands>}

;	This program demonstrates how a program can temporarily
;	transfer control to COMMAND.COM.  This is a very useful
;	capability to have in programs such as text editors,
;	modem communications programs, etc. where the user is
;	likely to spend long periods of time inside the program
;	but would occasionally like to be able to execute DOS
;	commands without losing the program environment.

;	If no command line operands are specified, this program
;	simply executes COMMAND.COM as a child process.  In this
;	case, the user must type 'EXIT' to return to the program
;	which will then terminate.  This allows the user to
;	perform a series of commands before returning; e.g.

;	D>CMD
;	Entering child COMMAND.COM
;	D>CHKDSK
;	...
;	D>RAM
;	...
;	D>EXIT
;	Exiting child COMMAND.COM
;	D>

;	Any valid DOS command may be specified on the command
;	line, including any possible command line parameters
;	for the command; for example:

;	D>CMD BASICA EXAMPLE.BAS
;	Entering child COMMAND.COM
;	...
;	Exiting child COMMAND.COM
;	D>

;	In this case, control automatically returns to this program
;	when the specified command terminates.	This allows the user
;	to execute a single command, without typing 'EXIT' to return.

;	The user can verify that he is running COMMAND.COM as a
;	child process by using CHKDSK (or an equivalent program,
;	such as RAM.COM) to display the amount of system RAM in use.

;	It takes about 3.5k of available memory to execute
;	COMMAND.COM as a child process under MS-DOS 2.X.

;	It takes about 4.5k of available memory to execute
;	COMMAND.COM as a child process under MS-DOS 3.X.

;	COMMAND.COM and CMD.COM may be nested underneath themselves
;	as deeply as the available memory permits.

;	MASM, LINK, and EXE2BIN to make CMD.COM

;	MS-DOS Interrupt Equates

MSDOS	EQU	21H		;MS-DOS System Functions
EXIT	EQU	20H		;MS-DOS Program Termination

;	MS-DOS System Function Equates

OUTSTR	EQU	09H		;Output string to console
GVERS	EQU	30H		;Get system version
MEMMOD	EQU	4AH		;Modify allocated memory blocks
EXEC	EQU	4BH		;Load and execute a program

;	Program Segment Prefix Equates

DEFIOA	EQU	80H		;Default I/O area

;	ASCII Character Equates

CR	EQU	0DH
LF	EQU	0AH
EOS	EQU	'$'

;	Program Initialization

CODE	SEGMENT PUBLIC

	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	100H		;Origin after program segment prefix

;	Start of Program

CMD:	MOV	AH,GVERS	;Get version of MS-DOS
	INT	MSDOS

	CMP	AL,2		;Greater or equal to 2.0?
	JNL	VEROK		;Jump if so

	MOV	DX,OFFSET VERMSG
	MOV	AH,OUTSTR	;Print error message
	INT	MSDOS
	JMP	BYE

;	Release all allocated memory past this segment

VEROK:	MOV	BX,OFFSET ENDDATA ;ES = segment, BX = offset
	MOV	CL,4		;paragraphs = bytes / 16
	SHR	BX,CL		;BX = memory size in paragraphs
	MOV	AH,MEMMOD	;Modify allocated memory block
	INT	MSDOS
	JNC	RELOK		;Jump if release ok

	MOV	DX,OFFSET MEMMSG
	MOV	AH,OUTSTR	;Print error message
	INT	MSDOS
	JMP	BYE

;	Inform user of status

RELOK:	MOV	DX,OFFSET INITMSG
	MOV	AH,OUTSTR
	INT	MSDOS

;	Move command line text to command buffer

	MOV	SI,DEFIOA	;A(Length of command line tail)
	MOV	CL,[SI] 	;CL=length of command line tail

	CMP	CL,1		;Command line operands present?
	JGE	GOTOP		;Jump if so

	MOV	CMDLEN,WORD PTR 0 ;Indicate no command line
	JMP	INIT

GOTOP:	MOV	AL,CL		;Command text length
	ADD	AL,2		;Account for /C
	MOV	CMDLEN,AL	;Set command text length

	INC	SI		;Point past length byte
	MOV	DI,OFFSET CMDBUFF ;Destination for move
	XOR	CH,CH		;CX = command length

LOOP:	MOV	AL,[SI] 	;Move command text
	MOV	[DI],AL
	INC	SI
	INC	DI
	LOOP	LOOP

	MOV	[DI],BYTE PTR CR ;Mark end of command line

;	Initialize EXEC parameter block

INIT:	MOV	P_DTA+2,CS
	MOV	P_FCB1+2,CS
	MOV	P_FCB2+2,CS
 
;	Save stack registers

	MOV	SAVESS,SS
	MOV	SAVESP,SP

;	Set up local stack (for .EXE files)

	CLI			;Interrupts off
	MOV	AX,CS
	MOV	SS,AX
	MOV	SP,OFFSET STACK
	STI			;Interrupts on

;	Execute COMMAND.COM as a child process

	MOV	DX,OFFSET CMDPATH ;DS:DX -> path name
	MOV	BX,OFFSET P_BLK   ;ES:BX -> parm block
	MOV	AH,EXEC 	;Exec function call
	XOR	AL,AL		;Load and execute program
	INT	MSDOS		;Error code returned in AX

;	Restore original stack

	CLI			;Interrupts off
	MOV	SS,CS:SAVESS
	MOV	SP,CS:SAVESP
	STI			;Interrupts on

;	Restore data segment register

	MOV	BX,CS
	MOV	DS,BX

;	Check for error

	JNC	DONE		;Jump if no error

;	Print error message

	PUSH	AX		;Save error code

	MOV	DX,OFFSET ERRMSG
	MOV	AH,OUTSTR
	INT	MSDOS

	POP	AX		;Restore error code

	CMP	AL,1
	JNZ	CHK2
	MOV	DX,OFFSET ERROR1
	JMP	SHORT ERRPRT

CHK2:	CMP	AL,2
	JNZ	CHK8
	MOV	DX,OFFSET ERROR2
	JMP	SHORT ERRPRT

CHK8:	CMP	AL,8
	JNZ	CHK10
	MOV	DX,OFFSET ERROR8
	JMP	SHORT ERRPRT

CHK10:	CMP	AL,10
	JNZ	CHK11
	MOV	DX,OFFSET ERROR10
	JMP	SHORT ERRPRT

CHK11:	CMP	AL,11
	JNZ	ERRUNK
	MOV	DX,OFFSET ERROR11
	JMP	SHORT ERRPRT

ERRUNK: MOV	DX,OFFSET ERRORUN

ERRPRT: MOV	AH,OUTSTR	;Print reason for error
	INT	MSDOS
	JMP	BYE

;	Inform user of status

DONE:	MOV	DX,OFFSET ENDMSG
	MOV	AH,OUTSTR
	INT	MSDOS

;	Exit to our parent COMMAND.COM

BYE:	INT	EXIT

;	Data Areas
 
INITMSG DB	'Entering child COMMAND.COM',CR,LF,EOS
ENDMSG	DB	'Exiting child COMMAND.COM',CR,LF,EOS

VERMSG	DB	'DOS 2.0 or higher required!',CR,LF,EOS
MEMMSG	DB	'Unable to release memory!',CR,LF,EOS

ERRMSG	DB	'Unable to execute COMMAND.COM - ',EOS
ERROR1	DB	'invalid function',CR,LF,EOS
ERROR2	DB	'file not found',CR,LF,EOS
ERROR8	DB	'not enough memory',CR,LF,EOS
ERROR10 DB	'bad environment',CR,LF,EOS
ERROR11 DB	'bad format',CR,LF,EOS
ERRORUN DB	'reason unknown',CR,LF,EOS

;	It may be necessary to specify the drive letter
;	of the boot disk in the following path name

CMDPATH DB	'\COMMAND.COM',0 ;Path and file name

SAVESS	DW	?		;Save area for SS register
SAVESP	DW	?		;Save area for SP register

P_BLK	EQU	$		;Parameter block for EXEC call
P_ENV	DW	0		;WORD segment address of environment
				;Zero passes parent's environment
P_DTA	DW	OFFSET DTA	;DWORD pointer to cmd line at DTA
	DW	?
P_FCB1	DW	OFFSET FCB1	;DWORD pointer to 1st default FCB
	DW	?
P_FCB2	DW	OFFSET FCB2	;DWORD pointer to 2nd default FCB
	DW	?

DTA	EQU	$		;Default Disk Transfer Address
CMDLEN	DB	CMDBUFE-CMDBUFS ;Command line length
CMDBUFS DB	'/C'		;COMMAND.COM switch
CMDBUFF DB	128 DUP (' ')	;Text of command line
	DB	CR		;Command line delimiter
CMDBUFE EQU	$		;End of command line

FCB1	DB	32 DUP (0)	;1st default File Control Block
FCB2	DB	32 DUP (0)	;2nd default File Control Block
	 
	DW	128 DUP(?)	;local stack
STACK	EQU	$

;	Align on a paragraph (16 byte) boundary

	IF	($-CMD) MOD 16
	ORG	($+16)-(($-CMD) MOD 16)
	ENDIF

ENDDATA EQU	$		;End of memory area to keep

CODE	ENDS

	END	CMD
