	PAGE	60,132

	TITLE	RAMFIT.COM - MS-DOS RAM Allocation Strategy Command

;	Version 1.0 (C) 06-Jul-86 by John Stetson

;	This program provides an interface to INT 21H function 58H
;	which was added in MS-DOS 3.1.	This function is referred
;	to as "Get/Set Allocation Strategy" and can be used to
;	either determine which of three different memory allocation
;	strategies is currently in use by DOS, or to request that
;	the current strategy be changed to the specified value.

;	The three memory allocation strategies are:

;	First Fit - DOS starts searching at the lowest available
;	block and allocates the first block it finds (the allocated
;	memory is the lowest available block).	This is the default
;	strategy used starting at boot time.

;	Best Fit - DOS searches each available block and allocates
;	the smallest available block that satisfies the request.

;	Last Fit - DOS starts searching at the highest available
;	block and allocates the first block it finds (the allocated
;	memory is the highest available block).

;	Note - this program is intended for experimentation only;
;	use the alternate allocation strategies at your own risk!
;	First Fit and Best Fit appear to work well under DOS 3.1,
;	but there appear to be some bugs with the Last Fit strategy.

;	Syntax: D>RAMFIT [FIRST/BEST/LAST]

;	If no operand is specified, the current strategy is shown.

;	MASM, LINK, and EXE2BIN to make RAMFIT.COM

;	Operating System Definitions

MSDOS	EQU	21H		;DOS System Function Interrupt

OUTSTR	EQU	09H		;Output String to Console
DOSVER	EQU	30H		;Get DOS Version Number
TERM	EQU	4CH		;Terminate Process
RAMSTR	EQU	58H		;RAM Allocation Strategy

;	Program Segment Prefix Definitions

DEFDTA	EQU	80H		;Default Disk Transfer Area
PSPEND	EQU	100H		;End of PSP Area

;	ASCII Character Definitions

LF	EQU	0AH		;Line Feed
CR	EQU	0DH		;Carriage Return
EOS	EQU	'$'		;End of String

;	Segment Definitions

CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

	ORG	PSPEND

;	Start of program

RAMFIT: MOV	AH,DOSVER
	INT	MSDOS		;Get DOS Version Number

	CMP	AL,3		;Major Version Number GE 3?
	JL	DOSBAD		;Jump if not
	CMP	AH,1		;Minor Version Number GE 1?
	JGE	DOSOK		;Jump if so

DOSBAD: MOV	AH,OUTSTR
	MOV	DX,OFFSET MSG1
	INT	MSDOS		;Give error message
	JMP	BYE

DOSOK:	MOV	SI,DEFDTA	;SI -> Default DTA
	MOV	AL,[SI] 	;Length of possible operand
	CMP	AL,2		;Operand present?
	JGE	SETSTR		;Jump if so

;	Get RAM Allocation Strategy

	XOR	AL,AL		;Indicate Get
	MOV	AH,RAMSTR
	INT	MSDOS		;Get Strategy
	JC	OOPS

;	Display Strategy Type Message

CHK0:	CMP	AX,0
	JNZ	CHK1
	MOV	DX,OFFSET FIRST
	JMP	SHORT OUT

CHK1:	CMP	AX,1
	JNZ	CHK2
	MOV	DX,OFFSET BEST
	JMP	SHORT OUT

CHK2:	CMP	AX,2
	JNZ	OOPS
	MOV	DX,OFFSET LAST

OUT:	MOV	AH,OUTSTR
	INT	MSDOS		;Display strategy message
	JMP	BYE		;and exit

;	Set RAM Allocation Strategy

SETSTR: MOV	AL,[SI+2]	;AL = first char of operand
	CMP	AL,'a'
	JL	CASEOK
	SUB	AL,32		;Convert to upper case

CASEOK: CMP	AL,'F'
	JNZ	CHKB
	MOV	BX,0
	JMP	SHORT SET

CHKB:	CMP	AL,'B'
	JNZ	CHKL
	MOV	BX,1
	JMP	SHORT SET

CHKL:	CMP	AL,'L'
	JNZ	OOPS
	MOV	BX,2

SET:	MOV	SAVE,BX
	MOV	AL,1		;Indicate Set
	MOV	AH,RAMSTR
	INT	MSDOS		;Set Strategy
	JC	OOPS

	MOV	AH,OUTSTR
	MOV	DX,OFFSET SETMSG
	INT	MSDOS		;Give Set message
	MOV	AX,SAVE
	JMP	CHK0		;and type message

;	Display error message

OOPS:	MOV	AH,OUTSTR
	MOV	DX,OFFSET MSG2
	INT	MSDOS		;Give error message

;	Exit to parent process

BYE:	XOR	AL,AL		;Return code = 0
	MOV	AH,TERM
	INT	MSDOS		;Terminate process

;	Data Areas

MSG1	DB	'DOS 3.1 or higher is required',CR,LF,EOS
MSG2	DB	'Bad Memory Strategy Function',CR,LF,EOS
SETMSG	DB	'New Memory Allocation Strategy Set',CR,LF,EOS
FIRST	DB	'Memory Allocation Strategy is First Fit',CR,LF,EOS
BEST	DB	'Memory Allocation Strategy is Best Fit',CR,LF,EOS
LAST	DB	'Memory Allocation Strategy is Last Fit',CR,LF,EOS
SAVE	DW	0

CODE	ENDS

	END	RAMFIT
