;CRT RESET FUNCTION FOR H-89 TERMINAL
;
;	This program will reset the H-89 terminal to the
;	power up configuration.
;
;BY WILLIAM M. ADNEY--1-29-83
;
BOOT	  EQU	  0000H
BDOS	  EQU	  0005H
CONIN	  EQU	  1
CONOUT	  EQU	  2
PLINE	  EQU	  9
CR	  EQU	  0DH
LF	  EQU	  0AH
;
	  ORG	  0100H
MAIN:	  LXI	  D,HRAM	      ;RESET TO POWER UP CONFIGURATION
	  CALL	  SENDLINE
	  LXI	  D,LINE1	  
	  CALL	  SENDLINE	  
	  LXI	  D,LINE2
	  CALL	  SENDLINE
	  RET
;
;************************************
;				    *
;    SUBROUTINES		    *
;				    *
;************************************
;
SENDLINE: MVI	    C,PLINE
	  CALL	    BDOS
	  RET
;
;
CLEARIT:  DB	1BH,45H,'$'	;CLEAR FUNCTION--ESCAPE E
;
HRAM:	DB	1BH,7AH,'$'	;HEATH RESET TO POWER UP--ESC z
;
;
LINE1:	DB  'This program resets the CRT to the power up',CR,LF,'$'
LINE2:	DB  'configuration and sets the 25th line to blanks.',CR,LF,'$'
	DS	014H		;RESERVE SPACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  ;STORAGE AREA STARTS HERE
	  END	  MAIN
PACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  