;BLOCK CURSOR/blinking FUNCTION FOR Z-100 TERMINAL
;
;	This program will set the z-100 for the block cursor.
;	Does not change the blinking for the cursor.
;
;BY WILLIAM M. ADNEY--5-7-83
;
BOOT	  EQU	  0000H
BDOS	  EQU	  0005H
CONIN	  EQU	  1
CONOUT	  EQU	  2
PLINE	  EQU	  9
CR	  EQU	  0DH
LF	  EQU	  0AH
;
	  ORG	0100H
MAIN:	  LXI	  D,RESETCRT	      ;RESET CRT TO POWER UP CONFIGURATION
	  CALL	  SENDLINE
	  LXI	  D,LINE1	  
	  CALL	  SENDLINE	  
	  LXI	  D,LINE2
	  CALL	  SENDLINE
;
;
;Set CRT for block cursor
;
	  LXI	  D,BCURS	      ;SET FOR BLOCK CURSOR
	  CALL	  SENDLINE
	  RET
;
;************************************
;				    *
;    SUBROUTINES		    *
;				    *
;************************************
;
SENDLINE: MVI	    C,PLINE
	  CALL	    BDOS
	  RET
;
;
CLEARIT:  DB	1BH,45H,'$'	;CLEAR FUNCTION--ESCAPE E
;
BCURS:	  DB	1BH,'x','4','$'     ;HEATH BLOCK CURSOR--ESC x 4
;
RESETCRT: DB	1BH,'z','$'	;HEATH crt reset function--ESC z
;
LINE1:	DB  'This program sets the block cursor for the',CR,LF,'$'
LINE2:	DB  'Z-100 and provides a  blinking cursor.',CR,LF,'$'
	DS	014H		;RESERVE SPACE FOR 10 ENTRIES
STACK	  DS	  001H		  ;TOP OF STACK IS HERE
BUFFER	  EQU	  $		  ;STORAGE AREA STARTS HERE
	  END	  MAIN
PACE FOR 1