;ERAFIX.ASM
;
;	Recovers an erased file
;
;	Command line: ERAFIX [d:] ufn
;
WBOOT	EQU	0000H	;WARM BOOT
CPM	EQU	0005H	;BDOS CALL
FCBIN	EQU	005CH	;DEFAULT FCB ADDRESS
CPMBUF	EQU	0080H	;DEFAULT CP/M BUFFER
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
;
;
;
CRTPRT	  EQU	  9	  ;PRINT STRING ON CRT
CRTRED	  EQU	  10	  ;READ CRT INPUT LINE
CPMVSN	  EQU	  12	  ;CP/M VERSION
SLDISK	  EQU	  14	  ;SELECT DISK
FLCLOS	  EQU	  16	  ;CLOSE FILE
SFIRST	  EQU	  17	  ;SEARCH FIRST DIRECTORY ENTRY
SNEXT1	  EQU	  18	  ;SEARCH NEXT DIRECTORY ENTRY
MAKFIL	  EQU	  22	  ;MAKE FILE
SETDMA	  EQU	  26	  ;SET DMA
GETDPB	  EQU	  31	  ;GET DPB FWA
RESETD	  EQU	  37	  ;RESET DISK DRIVE
;
	ORG	100H
;
	LXI	SP,STACK
	JMP	REF
;
;		DATA SPACE
;
DBNDX:	DB	0	;DIRECTORY ENTRY BUFFER INDEX
DBTMP:	DB	0	;TEMP FOR COUNT
CHTMP:	DB	0	;TEMP FOR 2ND CHARACTER
;
FCB:	DB	'?'
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0
EXT:	DB	0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
NR:	DB	0,0,0,0
;
CBUFF:	DB	64	;CONSOLE INPUT BUFFER
	DS	64+1
;
	DS	2*32
STACK	EQU	$
;
REF:	LXI	H,FCBIN+1      ;GET THE FILENAME
	LXI	D,FCB+1
	MVI	C,11
	CALL	MMC
;
	LDA	FCBIN		;SELECT DISK
	ORA	A
	JZ	REF1		;IF NO SELECTION
;
	DCR	A
	MOV	E,A
	MVI	C,SLDISK
	CALL	CPM 
;
REF1:	MVI	A,0		;RESET DIRECTORY ENTRY BUFFER
	STA	DBNDX
	MVI	C,CPMVSN	  ;CHECK FOR CP/M 2.2
	CALL	CPM 
	MOV	A,L
	ORA	A
	JZ	REF9		;IF NOT 2.X
;
	MVI	C,GETDPB	;GET EXTENT MASK
	CALL	CPM 
	LXI	D,4
	DAD	D
	MOV	A,M
	CMA
	STA	MFNA
;
	LXI	D,CPMBUF	 ;SET DMA
	MVI	C,SETDMA
	CALL	CPM 
;
	MVI	C,SFIRST	  ;SEARCH FOR FIRST DIRECTORY ENTRY
	LXI	D,FCB
	CALL	CPM 
	CPI	0FFH
	JZ	REF5		;IF FILE NOT FOUND
;
REF2:	CALL	FFA		;SET HL=FNT ADDRESSS
	PUSH	H
	LXI	D,FCB+1
	INX	H
	MVI	C,11
	CALL	KST		;COMPARE STRINGS
	POP	D
	JNZ	REF3		;IF NOT OUR FILENAME
;
;	WE HAVE A DIRECTORY ENTRY WITH MATCHING FILENAME
;
	LXI	H,DBNDX 	;GET BUFFER INDEX
	MOV	A,M
	INR	M		;ADVANCE BUFFER INDEX
	MOV	L,A		;SET HL=NEXT BUFFER INDEX
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H		;MULTIPLY BY 32
	LXI	B,MBUFF
	DAD	B
;
	XCHG			;SAVE THE DIRECTORY ENTRY
	MVI	C,32
	CALL	MMC
;
;	SEARCH FOR NEXT OCCURRENCE
;
REF3:	MVI	C,SNEXT1
	CALL	CPM 
	CPI	0FFH
	JNZ	REF2		;LOOP TO END OF DIRECTORY
;
;	WE HAVE SEARCHED THE ENTIRE DIRECTORY
;
	LDA	DBNDX		;CHECK FILE FOUND
	ORA	A
	JZ	REF5		;IF FILE NOT FOUND
;
;	IF FILE NOT ERASED, THEN DON'T RESTORE IT
;
	CALL	CFE		;CHECK FILE ERASED
	JNZ	REF7		;IF FILE NOT ERASED
;
;	IF MULTIPLE ERASED FILES, ISSUE A WARNING
;
	CALL	CME		;CHECK MULTIPLE ENTRIES
	JNZ	REF8		;IF MORE THAN ONE FILE
;
;	RESTORE THE FILE
;
	CALL	RAE		;RESTORE ALL EXTENTS
REF4:	JMP	WBOOT		;WARMBOOT
;
;	FILE NOT FOUND
;
REF5:	LXI	D,REFA		;"FILE NOT FOUND"
REF6:	MVI	C,CRTPRT
	CALL	CPM 
	JMP	REF4
;
;	FILE NOT ERASED
;
REF7:	LXI	D,REFB		;"FILE NOT ERASED"
	JMP	REF6
;
;	MULTIPLE IDENTICAL EXTENT NUMBERS FOUND
;
REF8:	LXI	D,REFC		;"MULTIPLE FILES FOUND"
	MVI	C,CRTPRT
	CALL	CPM 
	MVI	C,CRTRED	  ;READ CRT RESPONSE
	LXI	D,CBUFF
	CALL	CPM 
	LDA	CBUFF+2
	ANI	5FH
	CPI	'Y'
	JNZ	REF4		;IF NOT YES
;
;	CLOSE EACH EXTENT UNDER A UNIQUE NAME
;
	CALL	MFN		;MODIFY ALL FILE NAMES
	CALL	RAE		;RESTORE ALL EXTENTS
	CALL	DFN		;DISPLAY NEW FILE NAMES
	JMP	REF4
;
;	WE NEED CP/M 2.X
;
REF9:	LXI	D,REFD		;"NEED 2.X"
	JMP	REF6
;
REFA:	DB	'FILE NOT FOUND.$'
REFB:	DB	'FILE NOT ERASED.$'
REFC:	DB	'MULTIPLE FILES FOUND.'
	DB	CR,LF,'RESTORE ALL? (Y/N) <N> : $'
REFD:	DB	'THIS PROGRAM NEEDS CP/M 2.0 OR LATER$'
;
;	MFN --- MODIFY ALL FILE NAMES.
;	INSERT UNIQUE 2ND CHARACTER INTO EACH FILENAME.
;	SET 3RD FILENAME CHAR TO 'A' FOR PHY EXT 0, 'B' FOR 1, ETC.
;	MARK ALL EXTENTS 00.
;
MFN:	LDA	DBNDX
	STA	DBTMP
	LXI	H,MBUFF+2	;2ND CHAR
	LXI	D,MBUFF+0CH	;EXTENT
	LXI	B,32
	MVI	A,'A'
;
MFN1:	MOV	M,A		;INSERT NEW 2ND CHAR
	INR	A
	STA	CHTMP
	LDAX	D		;SET 3RD CHAR = 'EXT'
	ANI	0FFH		;EXTENT MASK
MFNA	EQU	$-1
	ADI	'A'
	INX	H
	MOV	M,A
	DCX	H
	XRA	A		;SET EXTENT = 00
	STAX	D
;
	XCHG
	DAD	B
	XCHG
	DAD	B
;
	LDA	DBTMP
	DCR	A
	STA	DBTMP
	LDA	CHTMP
	JNZ	MFN1		;LOOP OVER ALL EXTENTS
	RET
;
;
;	RAE - RESTORE ALL EXTENTS
;
RAE:	MVI	A,0
	STA	FCB
	LDA	DBNDX
	MOV	C,A
	LXI	H,MBUFF+1
;
RAE1:	PUSH	B
	MVI	C,15
	LXI	D,FCB+1
	CALL	MMC		;MOVE FILE NAME
	PUSH	H
	LXI	D,FCB
	MVI	C,MAKFIL	;CREATE DIRECTORY ENTRY
	CALL	CPM 
	LDA	FCB+0EH 	;CLEAR 'NOT-WRITTEN' BIT
	ANI	7FH
	STA	FCB+0EH
	POP	H		;POINTS TO RBT IMAGE
	DCX	H		;GET RECORD COUNT
	MOV	A,M
	LXI	D,FCB+15
	STAX	D
	INX	D
	INX	H
	MVI	C,16
	CALL	MMC
	PUSH	H
	LXI	D,FCB		;CLOSE CURRENT EXTENT
	MVI	C,FLCLOS
	CALL	CPM 
	POP	H
	POP	B
	INX	H
	DCR	C
	JNZ	RAE1		;LOOP OVER ALL EXTENTS
	RET
;
;	DFN -- DISPLAY NEW FILENAMES
;
DFN:	LXI	D,DFNA		;"FILE NAMES CREATED:"
	MVI	C,CRTPRT
	CALL	CPM 
	LDA	DBNDX
	LXI	H,MBUFF+1
;
DFN1:	PUSH	H
	STA	DBTMP
	LXI	D,DFNB		;MOVE FILE NAME
	MVI	C,8
	CALL	MMC
	INX	D		;MOVE FILE TYPE
	MVI	C,3
	CALL	MMC
	LXI	D,DFNB
	MVI	C,CRTPRT
	CALL	CPM 
	POP	H
	LXI	B,32
	DAD	B
	LDA	DBTMP
	DCR	A
	JNZ	DFN1		;LOOP FOR ALL EXTENTS
	RET
;
DFNA:	DB	CR,LF,'FILE NAMES CREATED:',CR,LF,'$'
DFNB:	DB	'        .   ',CR,LF,'$'
;
;	CME - CHECK MULTIPLE ERASED ENTRIES
;	EXIT	Z = TRUE, IF ONE FILE FOUND
;		E = FILE COUNT
;
CME:	LDA	DBNDX
	MOV	C,A
	LXI	H,MBUFF+0CH	;POINT TO EXTENT BYTES
;
CME1:	MOV	A,M
	CALL	CIE		;COUNT IDENTICAL EXTENTS
	RNZ			;IF MULTIPLE FILES FOUND
;
	LXI	D,32
	DAD	D
	DCR	C
	JNZ	CME1		;LOOP OVER ALL EXTENTS
	RET
;
;	CIE - COUNT IDENTICAL ENTRIES
;	ENTRY	A = CURRENT EXTENT
;	EXIT	Z = TRUE, IF ONE SUCH EXTENT FOUND
;		E = EXTENT COUNT
;
CIE:	PUSH	H
	PUSH	B
	MVI	E,0
	LXI	H,DBNDX
	MOV	C,M
	LXI	H,MBUFF+0CH
;
CIE1:	MOV	B,M
	CMP	B
	JNZ	CIE2		;IF NOT SAME EXTENT
	INR	E		;ADVANCE EXTENT COUNT
CIE2:	PUSH	D
	LXI	D,32
	DAD	D
	POP	D
	DCR	C
	JNZ	CIE1		;LOOP OVER ALL EXTENTS
;
	MOV	A,E		;CHECK EXTENTS FOUND
	CPI	1
	POP	B
	POP	H
	RET
;
;	CFE - CHECK FILE ERASED
;	EXIT	Z = TRUE, IF FILE ERASED
;
CFE:	LDA	DBNDX
	MOV	C,A
	LXI	H,MBUFF
	LXI	D,32
;
CFE1:	MOV	A,M
	CPI	0E5H
	RNZ			;IF UNERASED EXTENT FOUND
;
	DAD	D
	DCR	C
	JNZ	CFE1		;LOOP OVER ALL EXTENTS
	RET
;
;	FFA - FORM FILE ADDRESS
;	ENTRY	A = FNT ORDINAL
;	EXIT	HL = FNT ADDRESS
;
FFA:	ORA	A
	RAL
	RAL
	RAL
	RAL
	RAL			;MULTIPLY BY 32
	MOV	E,A
	MVI	D,0
	LXI	H,CPMBUF
	DAD	D
	RET
;
;	KST - COMPARE STRINGS
;	ENTRY	HL = STRING1 FWA
;		DE = STRING2 FWA
;		 C = STRING COMPARE LENGTH
;	EXIT	Z = TRUE, IF STRING1 = STRING2
;
KST:	LDAX	D
	CMP	M
	RNZ			;IF MISMATCH
;
	INX	H
	INX	D
	DCR	C
	JNZ	KST		;LOOP OVER COMPARE LENGTH
	RET
;
;	MMC - MOVE MEMORY
;	ENTRY	HL = SOURCE FWA
;		DE = DESTINATION FWA
;		C  = BYTE COUNT
;
MMC:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	MMC		;LOOP FOR C BYTES
	RET
;
	ORG	16*($/16)+16
;
MBUFF	EQU	$
NT
;
MMC:	MOV	A,M
	STAX	D
	INX	H
	INX	D
