	TITLE	'CP/M-85 BIOS (8085 CODE PORTION)     10 MAR 83'
;***
;
;	THIS IS THE 8085 CODED PORTION OF THE BIOS FOR CP/M-85.
;	IT RESIDES IN THE FILE 'BIOS85.SYS'.
;

TRUE	EQU	1
FALSE	EQU	0

ASM86	EQU	FALSE
REL0	EQU	TRUE




;***	MACROS
;


;**	EXTRA PSEUDO OPS FOR USE WITH MAC
;

RB	MACRO	A
	DS	A
	ENDM

RW	MACRO	A
	DS	2*A
	ENDM





;***	EQUATES
;


;**	Z-MACHINE MEMORY MAP UTILIZATION EQUATES
;

BOOTORG	EQU	0400H			;BOOT CODE LOAD ADDRESS
BCODEL	EQU	256+32			;MAXIMUM BOOT CODE LENGTH

BLDR88	EQU	BOOTORG+BCODEL		;BIOS LOADER (8088 PORTION)
BLDR88L	EQU	64			;MAXIMUM BIOS LOADER (8088) LENGTH

B88STK	EQU	2*1024			;8088 STACK AREA

B88DAT	EQU	B88STK			;MONITOR ROM DATA AREA START ADDR

BIOS88	EQU	4*1024			;WHERE 8088 CODE OF BIOS WILL RESIDE

BLDRP0	EQU	16*1024			;BIOS LOADER PAGE ZERO BIAS VALUE

	IF	REL0
BLOADER	EQU	0000H			;WHERE BOOT CODE LOADS BIOS LOADER
	ENDIF
	IF	NOT REL0
BLOADER	EQU	0100H			;WHERE BOOT CODE LOADS BIOS LOADER
	ENDIF
BLDR85L	EQU	8*128-BCODEL-BLDR88L	;MAXIMUM BIOS LOADER (8085) LENGTH

BOOT85	EQU	0000H			;WHERE 8085 STARTS AFTER PROCESSOR SWAP

SWISWAP	EQU	0FEH			;SWI FOR SWAPPING PROCESSORS
SWAPVEC	EQU	SWISWAP*4		; VECTOR ADDRESS


BIAS	EQU	0
;**	CP/M-85 SYSTEM EQUATES
;

;	OS VALUES

CCPL	EQU	0800H			;LENGTH OF CCP
BDOSL	EQU	0E00H			;LENGTH OF BDOS

;	RESERVED LOCATIONS IN PAGE ZERO

	ORG	BIAS
BOOT	RB	3			;JUMP TO WARM START ENTRY
IOBYTE	RB	1			;IOBYTE
DFTDRV	RB	1			;CURRENT EFAULT DRIVE
BDOS	RB	3			;JUMP TO BDOS
INT1	RB	8			;INTERRUPT LOCATION 1
INT2	RB	8			;INTERRUPT LOCATION 2
INT3	RB	8			;INTERRUPT LOCATION 3
INT4	RB	8			;INTERRUPT LOCATION 4
INT5	RB	8			;INTERRUPT LOCATION 5
INT6	RB	8			;INTERRUPT LOCATION 6 (RESERVED)
INT7	RB	8			;INTERRUPT LOCATION 7 (USED BY DDT)
BSCR	RB	16			;16 BYTE SCRATCH AREA FOR BIOS
	RB	12			;12 BYTES NOT USED BUT RESERVED
TFCB	RB	36			;TRANSIENT DEFAULT FCB
TFCB2	EQU	TFCB+16			;TRANSIENT 2ND FILENAME
TBUFF	RB	128			;DEFAULT DISK BUFFER
TPA	RB	0			;START OF TRANSIENT PROGRAM AREA

;	HEATH PAGE ZERO LOCATIONS

	IF	ASM86
	ORG	OFFSET INT1+3
	ENDIF
	IF	NOT ASM86
	ORG	INT1+3
	ENDIF
TICCNT	RW	2			;32 BIT TIMER TIC COUNTER
TIMEFLG	RB	1			;TIMER 2 FLAG (0=RUNNING , 1=TIME OUT)

	IF	ASM86
	ORG	OFFSET INT2
	ENDIF
	IF	NOT ASM86
	ORG	INT2
	ENDIF
COMREG	RB	0			;BIOS88 COMMUNICATION REGION
COMFUNC	RB	1			; BIOS FUNCTION VALUE = (#-CBOOT)/3
COMRA	RB	1			; (A)
COMRBC	RW	0			; (BC)
COMRC	RB	1			;  (C)
COMRB	RB	1			;  (B)
COMRDE	RW	0			; (DE)
COMRE	RB	1			;  (E)
COMRD	RB	1			;  (D)
COMRHL	RW	0			; (HL)
COMRL	RB	1			;  (L)
COMRH	RB	1			;  (H)
COMWHO	RB	1			;WHICH PROCESSOR IS RUNNING
					; ZPSPPS5 = 8085
					; ZPSPPS8 = 8088

BDMAP	EQU	BSCR+00H		;DRIVE MAP (MAX OF 8 ENTRIES 0-7)
	IF	ASM86
BBIOS	EQU	WORD PTR BSCR+0EH	;TRUE ADDRESS FOR START OF BIOS
	ENDIF
	IF	NOT ASM86
BBIOS	EQU	BSCR+0EH		;TRUE ADDRESS FOR START OF BIOS
	ENDIF

;	CP/M FUNCTIONS

RESET	EQU	0			;SYSTEM RESET
RDCON	EQU	1			;READ CONSOLE
WRCON	EQU	2			;WRITE CONSOLE
RDRDR	EQU	3			;READ READER
WRPUN	EQU	4			;WRITE PUNCH
WRLST	EQU	5			;WRITE LIST
DCONIO	EQU	6			;DIRECT CONSOLE I/O (2)
IOSTAT	EQU	7			;INTERROGATE I/O STATUS
ASTAT	EQU	8			;ALTER I/O STATUS
PRCONB	EQU	9			;PRINT CONSOLE BUFFER
RDCONB	EQU	10			;READ CONSOLE BUFFER
CCSTAT	EQU	11			;CHECK CONSOLE STATUS
LDH	EQU	12			;LIFT DISK HEAD
CPMVER	EQU	LDH			;GET CP/M VERSION (2)
RDS	EQU	13			;RESET DISK SYSTEM
SELDSK	EQU	14			;SELECT DISK
OPEN	EQU	15			;OPEN FILE
CLOSE	EQU	16			;CLOSE FILE
S1ST	EQU	17			;SEARCH FIRST
SNXT	EQU	18			;SEARCH NEXT
DELETE	EQU	19			;DELETE FILE
READ	EQU	20			;READ RECORD
WRITE	EQU	21			;WRITE RECORD
CREATE	EQU	22			;CREATE FILE
RENAME	EQU	23			;RENAME FILE
ILOG	EQU	24			;INTERROGATE LOGIN
IDSK	EQU	25			;INTERROGATE DISK
SETDMA	EQU	26			;SET DMA ADDRESS
IALLOC	EQU	27			;INTERROGATE ALLOCATION
WPD	EQU	28			;WRITE PROTECT DISK
GROV	EQU	29			;GET READ/ONLY VECTOR
SFA	EQU	30			;SET FILE ATTRIBUTES
GADPB	EQU	31			;GET ADDR OF DPB
SGUSR	EQU	32			;SET/GET USER CODE
READRR	EQU	33			;READ RANDOM RECORD
WRITERR	EQU	34			;WRITE RANDOM RECORD
CFSIZE	EQU	35			;COMPUTE FILE SIZE
SRR	EQU	36			;SET RANDOM RECORD
RESDRV	EQU	37			;RESET DRIVE
WRITERZ	EQU	40			;WRITE RANDOM WITH ZERO FILL

;	BIOS ENTRY POINTS.
;	  GIVEN AS DISPLACEMENTS FROM WARM BOOT ENTRY POINT WHOSE
;	  ADDRESS IS USUALLY AT LOCATION BOOT+1.
;	  TO COMPUTE DISPLACEMENTS FROM VALUE STORED AT 'BBIOS'
;	  SUBTRACT 'CBOOT'.  EG. DISPLACEMENT FOR WARM BOOT = WBOOT-CBOOT

CBOOT	EQU	-0003H			;COLD BOOT
WBOOT	EQU	0000H			;WARM BOOT
CONST	EQU	0003H			;CONSOLE STATUS
CONIN	EQU	0006H			;CONSOLE INPUT
CONOUT	EQU	0009H			;CONSOLE OUTPUT
LSTOUT	EQU	000CH			;LIST OUTPUT
PUNOUT	EQU	000FH			;PUNCH OUTPUT
RDRIN	EQU	0012H			;READER INPUT
HOME	EQU	0015H			;HOME DISK
SETDSK	EQU	0018H			;SET (SELECT) DISK DRIVE
SETTRK	EQU	001BH			;SET TRACK NUMBER
SETSEC	EQU	001EH			;SET SECTOR NUMBER
SDMA	EQU	0021H			;SET DMA ADDRESS
BREAD	EQU	0024H			;READ SELECTED SECTOR
BWRITE	EQU	0027H			;WRITE SELECTED SECTOR
BLSTST	EQU	002AH			;CHECK LIST DEVICE STATUS
BSECTRN	EQU	002DH			;SECTOR TRANSLATE ROUTINE
BFMT	EQU	0030H			;FORMAT
BRDTRK	EQU	0033H			;READ TRACK
BWRTRK	EQU	0036H			;WRITE TRACK
BWPC	EQU	0039H			;WRITE PROTECT CHECK
BCBD	EQU	003CH			;CLEAR BUFFERS FOR DRIVE

;	BIOS WRITE TYPES

BWRNOR	EQU	0			;NORMAL WRITE
BWRDIR	EQU	1			;WRITE TO A DIRECTORY SECTOR
BRWUA1	EQU	2			;WRITE TO 1ST SECTOR OF UNALLOC BLOCK

;	FILE CONTROL BLOCK

	ORG	0
FCBDN	RB	1			;DISK NAME
FCBFN	RB	8			;FILE NAME
FCBFNL	EQU	8			;FILE NAME LENGTH
FCBFT	RB	3			;FILE TYPE
FCBFTL	EQU	3			;FILE TYPE LENGTH
FCBRO	EQU	FCBFT+0			;R/O FLAG
FCBROF	EQU	10000000B		; R/O FLAG VALUE
FCBSYS	EQU	FCBFT+1			;SYS FLAG
FCBSYSF	EQU	10000000B		; SYS FLAG VALUE
FCBEX	RB	1			;EXTENT
	RB	1
FCBRWF	RB	1			;R/W FLAG
FCBRWFF EQU	10000000B		; R/W FLAG VALUE
FCBRC	RB	1			;RECORD COUNT
FCBDM	RB	16			;DISK ALLOCATION MAP
FCBNR	RB	1			;NEXT RECORD TO BE READ OR WRITTEN
FCBLS	EQU	33			;FCB LENGTH FOR SEQUENTIAL I/O
FCBRR	RB	3			;RANDOM RECORD POINTER
FCBLR	EQU	36			;FCB LENGTH FOR RANDOM I/O



;**	CHARACTER I/O TABLE DEFINITIONS
;

	ORG	0

;	TABLE

CIOTBL	RB	0

CIOBP	RB	1			;BASE PORT
CIOBR	RW	1			;BAUD RATE
CIOF1	RB	1			;FLAG BYTE 1
CIOF2	RB	1			;FLAG BYTE 2
CIOIM	RB	1			;INPUT READY MASK
CIOIPM	RB	1			;INPUT READY POLARITY MASK
CIOOM	RB	1			;OUTPUT READY MASK
CIOOPM	RB	1			;OUTPUT READY POLARITY MASK
CIOECNT	RB	1			;# OF CHARACTERS BEFORE SENDING <ETX>
CIOECTR	RB	1			;CHARACTER COUNTER FOR SENDING <ETX>
CIONCHR	RB	1			;SEND NULLS AFTER THIS CHARACTER
CIONCNT	RB	1			;# OF NULLS TO SEND
CIONCTR	RB	1			;NULL COUNTER
CIOVAL1	RB	1			;DEVICE DEPENDANT VALUE 1
CIOVAL2	RB	1			;DEVICE DEPENDANT VALUE 2
CIOVAL3	RB	1			;DEVICE DEPENDANT VALUE 3
CIOVAL4	RB	1			;DEVICE DEPNEDANT VALUE 4
CIOVAL5	RB	1			;DEVICE DEPENDANT VALUE 5
CIOVAL6	RB	1			;DEVICE DEPENDANT VALUE 6
CIOVAL7	RB	1			;DEVICE DEPENDANT VALUE 7
CIOVAL8	RB	1			;DEVICE DEPENDANT VALUE 8
CIOIN	RW	1			;ADDRESS OF DEVICE INIT ROUTINE
CIOIS	RW	1			;ADDRESS OF INPUT INPUT STATUS ROUTINE
CIOID	RW	1			;ADDRESS OF INPUT DATA ROUTINE
CIOOS	RW	1			;ADDRESS OF INPUT OUTPUT STATUS ROUTINE
CIOOD	RW	1			;ADDRESS OF OUTPUT DATA ROUTINE

	IF	ASM86
CIOTBLL	EQU	OFFSET $-OFFSET CIOTBL	;LENGTH OF CIO TABLE
	ENDIF
	IF	NOT ASM86
CIOTBLL	EQU	$-CIOTBL		;LENGTH OF CIO TABLE
	ENDIF

;	FLAG BYTE 1

CIOSPI	EQU	00000001B		;STRIP PARITY BIT ON INPUT
CIOSPO	EQU	00000010B		;STRIP PARITY BIT ON OUTPUT
CIOMLI	EQU	00000100B		;MAP LOWER CASE ON INPUT
CIOMLO	EQU	00001000B		;MAP LOWER CASE ON OUTPUT
CIOEAH	EQU	00010000B		;USE <ETX>/<ACK> HANDSHAKING
CIODCH	EQU	00100000B		;USE <DC1>/<DC3> HANDSHAKING

;	FLAG BYTE 2

CIOW4A	EQU	CIOEAH			;<ETX> SENT, WAITING FOR <ACK>
CIOW4D	EQU	CIODCH			;WAITING FOR <DC1>



;**	DEFINITION OF LOCATIONS AT THE HEAD OF THE BIOS FOR CP/M-85
;
;  * * *   N O T E   * * *
;
;    IF THE BIOS IS ALTERED, THEN THIS FILE MUST ALSO BE UPDATED.
;

BVERSN	EQU	101			;VERSION # FOR CURRENT BIOS
					; USE THIS EQUATE IN USER PROGRAMS
					;  THAT WISH TO KNOW VERSION #
					;   THEY WERE ASSEMBLED FOR
BREVSN	EQU	' '			;REVISION LETTER

BMO	EQU	03			;DATE
BDY	EQU	10
BYR	EQU	83

NDRIVES	EQU	6			;MAXIMUM NUMBER OF DRIVE TABLES

;

	ORG	0042H			;SKIP BIOS JUMP VECTOR CODE

BIOSVER	RB	1			;BIOS VERSION
DEFIOB	RB	1			;DEFAULT I/O BYTE

MODE	RB	1			;MODE FLAGS BYTE

BSIZE	RB	1			;BIOS SIZE IN PAGES
BEND	RW	1			;ENDING ADDR OF BIOS + 1
HECNT	RW	1			;HARD ERROR COUNT (SINCE COLD BOOT)
SECNT	RW	1			;SOFT ERROR COUNT (SINCE COLD BOOT)
NDISKS	RB	1			;NUMBER OF DISK POSSIBLE IN THIS BIOS

;	AUTO EXEC COMMAND BUFFERS

AUTOCBC	RB	41			;COLD BOOT AUTO COMMAND
AUTOWBC	RB	41			;WARM BOOT AUTO COMMAND

;  CHARACTER I/O TABLES

CRTTBL	RB	CIOTBLL			;CRT: (KEYBOARD/DISPLAY)
SERATBL	RB	CIOTBLL			;SERIAL PORT A
SERBTBL	RB	CIOTBLL			;SERIAL PORT B
PPRTTBL	RB	CIOTBLL			;PARALLEL PRINTER PORT
DUMMYTBL RB	CIOTBLL			;DUMMY UNIT

;	DISK PARAMETER ENTRY TABLES

DPEBASE	RB	0			;START OF DISK PARAMETER ENTRY TABLES



;**	6821 PERIPHERAL INTERFACE ADAPTER EQUATES
;

;	REGISTER DISPLACEMENTS

PIADATA	EQU	0			;PERIPHERAL DATA REGISTER A
PIADDRA	EQU	0			;DATA DIRECTION REGISTER A
PIACTLA	EQU	1			;CONTROL REGISTER A
PIADATB	EQU	2			;PERIPHERAL DATA REGISTER B
PIADDRB	EQU	2			;DATA DIRECTION REGISTER B
PIACTLB	EQU	3			;CONTROL REGISTER B

;	CONTROL WORD FORMAT

PIAC1	EQU	00000011B	;CONTROL OF CA1(CB1) INTERRUPT LINE
PIAC10	EQU	00H		; ACTIVE TRANSITION 1->0
				;  IRQ PIN IS DISABLED
PIAC11	EQU	01H		; ACTIVE TRANSITION 1->0
				;  IRQ PIN IS ENABLED
PIAC12	EQU	02H		; ACTIVE TRANSITION 0->1
				;  IRQ PIN IS DISABLED
PIAC13	EQU	03H		; ACTIVE TRANSITION 0->1
				;  IRQ PIN IS ENABLED

PIADDAC	EQU	00000100B	;DATA DIRECTION ACCESS CONTROL BIT
				; 0=DATA DIRECTION REG , 1=PERIPHERAL DATA REG

PIAC2	EQU	00111000B	;CONTROL OF CA2(CB2)
				; INPUT MODES
PIAC20	EQU	00H		;  ACTIVE TRANSITION 1->0
				;   IRQ PIN IS DISABLED
PIAC21	EQU	08H		;  ACTIVE TRANSITION 1->0
				;   IRQ PIN IS ENABLED
PIAC22	EQU	10H		;  ACTIVE TRANSITION 0->1
				;   IRQ PIN IS DISABLED
PIAC23	EQU	18H		;  ACTIVE TRANSITION 0->1
				;   IRQ PIN IS ENABLED
				; OUTPUT MODES
PIAC24	EQU	20H		;  0 ON R(W) OPERATION , 1 ON ACTIVE CA1(CB1)
PIAC25	EQU	28H		;  0 ON R(W) OPERATION , 1 ON E AFTER DESELECT
PIAC26	EQU	30H		;  RESET
PIAC27	EQU	38H		;  SET


PIAIRQ2	EQU	01000000B		;IRQ FOR CA2(CB2)
PIAIRQ1	EQU	10000000B		;IRQ FOR CA1(CB1)



;**	EP2DEF -- EQUATES FOR ENHANCED PROGRAMMABLE COMMUNICATION
;	 	  INTERFACE CHIP 2661-2.
;

;	PORT DISPLACEMENTS

EPDATA	EQU	0		;DATA
EPSTAT	EQU	1		;STATUS
EPSYN	EQU	1		;SYN1/SYN2/DLE
EPMODE	EQU	2		;MODE
EPCMD	EQU	3		;COMMAND

;	STATUS REGISTER

EPTXR	EQU	00000001B	;TRANSMITTER READY
EPRXR	EQU	00000010B	;RECEIVER READY
EPTXE	EQU	00000100B	;TRANSMITTER EMPTY
EPDSC	EQU	00000100B	;DATA SET CHANGE
EPPE	EQU	00001000B	;PARITY ERROR
EPOE	EQU	00010000B	;OVERRUN ERROR
EPFE	EQU	00100000B	;FRAME ERROR
EPSD	EQU	00100000B	;SYNC DETECTED
EPDCD	EQU	01000000B	;DATA CARRIER DETECT
EPDSR	EQU	10000000B	;DATA SET READY

;	MODE REGISTER 1

EPMBRF	EQU	00000011B	;MODE AND BAUDRATE FACTOR
EPS1X	EQU	000H		;  SYNCHRONOUS 1X RATE
EPA1X	EQU	001H		;  ASYNCHRONOUS 1X RATE
EPA16X	EQU	002H		;  ASYNCHRONOUS 16X RATE
EPA64X	EQU	003H		;  ASYNCHRONOUS 64X RATE

EPCL	EQU	00001100B	;CHARACTER LENGTH
EPCL5	EQU	000H		;  LENGTH 5
EPCL6	EQU	004H		;  LENGTH 6
EPCL7	EQU	008H		;  LENGTH 7
EPCL8	EQU	00CH		;  LENGTH 8

EPPC	EQU	00010000B	;PARITY CONTROL (0=DISABLED , 1=ENABLED)
EPPT	EQU	00100000B	;PARITY TYPE (0=ODD , 1=EVEN)

EPASBL	EQU	11000000B	;ASYNCHRONOUS STOP BIT LENGTH
EPSB1	EQU	040H		;  LENGTH 1
EPSB15	EQU	080H		;  LENGTH 1.5
EPSB2	EQU	0C0H		;  LENGTH 2

EPSTC	EQU	01000000B	;SYNCHRONOUS TRANSPARENCY CONTROL
				; (0=NORMAL , 1=TRANSPARENT)
EPNSC	EQU	10000000B	;NUMBER OF SYNC CHARACTERS
				; (0=DOUBLE , 1=SINGLE)

;	MODE REGISTER 2

EPBRS	EQU	00001111B	;BAUD RATE SELECTION
EPMR2U	EQU	11110000B	;SEE TEXT

;	COMMAND REGISTER

EPTXEN	EQU	00000001B	;TRANSMITTER ENABLE
EPDTR	EQU	00000010B	;DATA TERMINAL READY
EPRXEN	EQU	00000100B	;RECEIVER ENABLE
EPSBRK	EQU	00001000B	;SEND BREAK (ASYNC)
EPSDLE	EQU	00001000B	;SEND DLE (SYNC)
EPRESE	EQU	00010000B	;RESET STATUS ERRORS
EPRTS	EQU	00100000B	;REQUEST TO SEND

EPOM	EQU	11000000B	;OPERATING MODE
EPNORM	EQU	000H		;  NORMAL
EPOM1	EQU	040H		;  MODE 1
EPOMLL	EQU	080H		;  LOCAL LOOP BACK
EPOMRL	EQU	0C0H		;  REMOTE LOOP BACK

;	BAUDRATE SELECTION VALUES

EPB455	EQU	0		;45.5
EPB050	EQU	1		;50
EPB075	EQU	2		;75
EPB110	EQU	3		;110
EPB134	EQU	4		;134.5
EPB150	EQU	5		;150
EPB300	EQU	6		;300
EPB600	EQU	7		;600
EPB120	EQU	8		;1200
EPB180	EQU	9		;1800
EPB200	EQU	10		;2000
EPB240	EQU	11		;2400
EPB480	EQU	12		;4800
EPB960	EQU	13		;9600
EPB192	EQU	14		;19200
EPB384	EQU	15		;38400



;**	Z207 EQUATES
;

;	PORT ASSIGNMENTS

FDBASE	EQU	0B0H		;BASE PORT ADDRESS
FDCMD	EQU	FDBASE		;1797 COMMAND REGISTER
FDSTA	EQU	FDBASE		;     STATUS REGISTER
FDTRK	EQU	FDBASE+1	;     TRACK REGISTER
FDSEC	EQU	FDBASE+2	;     SECTOR REGISTER
FDDAT	EQU	FDBASE+3	;     DATA REGISTER
FDCON	EQU	FDBASE+4	;DISK CONTROL PORT
FDAS	EQU	FDBASE+5	;AUX STATUS PORT

;	COMMANDS

FDCRST	EQU	000H		;RESTORE
FDCSEK	EQU	010H		;SEEK
FDCSTP	EQU	020H		;STEP
FDCSTI	EQU	040H		;STEP IN
FDCSTO	EQU	060H		;STEP OUT
FDCRDS	EQU	080H		;READ SECTOR
FDCWRS	EQU	0A0H		;WRITE SECTOR
FDCRDA	EQU	0C0H		;READ ADDRESS
FDCRDT	EQU	0E0H		;READ TRACK
FDCWRT	EQU	0F0H		;WRITE TRACK
FDCFI	EQU	0D0H		;FORCE INTERRUPT

;	TYPE 1 COMMAND FLAGS

FDFUTR	EQU	00010000B	;UPDATE TRACK REGISTER
FDFHLB	EQU	00001000B	;HEAD LOAD AT BEGINNING
FDFVRF	EQU	00000100B	;VERIFY FLAGS

;	TYPE 1 COMMAND STEP RATE FLAGS

FDFSRM	EQU	00000011B	;STEP RATE MASK
FDFS6	EQU	00000000B	;STEP RATE  6(3) MS
FDFS12	EQU	00000001B	;          12(6)
FDFS20	EQU	00000010B	;          20(10)
FDFS30	EQU	00000011B	;          30(15)

;	TYPE 2&3 COMMAND FLAGS

FDFMRF	EQU	00010000B	;MULTIPLE RECORD FLAG
FDFSLF	EQU	00001000B	;SECTOR LENGTH FLAG
FDFDLF	EQU	00000100B	;30 MS DELAY
FDFSS1	EQU	00000010B	;SELECT SIDE 1
FDFDDM	EQU	00000001B	;DELETED DATA MARK

;	TYPE 4 COMMAND FLAGS

FDFINI	EQU	00000000B	;TERMINATE WITH NO INTERRUPT
FDFII0	EQU	00000001B	;NOT READY TO READY TRANSITION
FDFII1	EQU	00000010B	;READY TO NOT READY TRANSITION
FDFII2	EQU	00000100B	;INDEX PULSE
FDFII3	EQU	00001000B	;IMMEDIATE INTERRUPT

;	STATUS FLAGS

FDSNRD	EQU	10000000B	;NOT READY
FDSWPV	EQU	01000000B	;WRITE PROTECT VIOLATION
FDSHLD	EQU	00100000B	;HEAD IS LOADED
FDSRTE	EQU	00100000B	;RECORD TYPE
FDSWTF	EQU	00100000B	;WRITE FAULT
FDSSEK	EQU	00010000B	;SEEK ERROR
FDSRNF	EQU	00010000B	;RECORD NOT FOUND
FDSCRC	EQU	00001000B	;CRC ERROR
FDSTK0	EQU	00000100B	;FOUND TRACK 0
FDSLDT	EQU	00000100B	;LOST DATA
FDSIND	EQU	00000010B	;INDEX HOLE
FDSDRQ	EQU	00000010B	;DRQ
FDSBSY	EQU	00000001B	;BUSY

;	INFO RETURNED BY A READ ADDRESS COMMAND

FDRATRK	EQU	0		;TRACK
FDRASID	EQU	1		;SIDE
FDRASEC	EQU	2		;SECTOR
FDRASL	EQU	3		;SECTOR LENGTH
FDRACRC	EQU	4		;2 BYTE CRC
FDRAL	EQU	6		;LENGTH OF READ ADDRESS INFO

;	DISK HEADER SECTOR LENGTH VALUES

FDSL128	EQU	0		;SECTOR LENGTH 128
FDSL256	EQU	1		;SECTOR LENGTH 256
FDSL512	EQU	2		;SECTOR LENGTH 512
FDSL1K	EQU	3		;SECTOR LENGTH 1024

;	CONTROL REGISTER FLAGS

CONDS	EQU	00000011B	;DRIVE SELECT BITS
CONDS8	EQU	00000100B	;0=5 1/4" , 1=8"
CONDSEN	EQU	00001000B	;DRIVE SELECT ENABLE
CONPC	EQU	00010000B	;WRITE PRE-COMPENSATION
				; 5 1/4"  0=YES , 1=NO
				; 8"  0=ALL TRACKS , 1=TRACKS 44-76
CON5FS	EQU	00100000B	;5 1/4" FAST STEP
CONWE	EQU	01000000B	;ENABLE WAIT FOR DRQ OR IRQ
CONSD	EQU	10000000B	;ENABLE SINGLE DENSITY

;	AUXILARY STATUS REGISTER FLAGS

ASIRQ	EQU	00000001B	;1797 INTERRUPT REQUEST
ASMO	EQU	00000010B	;5 1/4" MOTOR ON
AS96T	EQU	00001000B	;5 1/4" DRIVES ARE 96TPI
AS5PC	EQU	00010000B	;5 1/4" DRIVES NEED WRITE PRE-COMPENSATION
AS2S	EQU	01000000B	;SELECTED 8" DRIVE CONTAINS 2 SIDED MEDIA
ASDRQ	EQU	10000000B	;1797 DRQ

;	MISCELLANEOUS VALUES

NTRKS37	EQU	40		;# TRACKS SINGLE DENSITY 5 1/4" (48 TPI)
NTRKD37	EQU	80		;# TRACKS DOUBLE DENSITY 5 1/4" (96 TPI)
NTRK837	EQU	77		;NUMBER OF TRACKS 8"
NSBT37	EQU	52		;NUMBER OF CP/M RECORDS TO BE LOADED AT BOOT



;**	Z217 EQUATES
;

WINSPT	EQU	18			;# PHYSICAL SECTORS PER TRACK
WICSZ	EQU	512			;CELL SIZE USED

;*	PORT ASSIGNMENTS

WIPBASE	EQU	0AEH			;BASE PORT
WIPCMD	EQU	WIPBASE+0		; COMMAND
WIPSTAT	EQU	WIPBASE+0		; HARDWARE STATUS
WIPRES	EQU	WIPBASE+1		; RESET
WIPINTA	EQU	WIPBASE+1		; INTERRUPT ACKNOWLEDGE/HARDWARE STATUS

;*	HARDWARE STATUS REGISTER

WISINT	EQU	10000000B		;INTERRUPT PENDING
WISBUSY	EQU	01000000B		;BUSY
WISBM	EQU	00100000B		;BURST MODE
WISTMA	EQU	00010000B		;TMA IN PROGRESS
WISERR	EQU	00001000B		;ERROR
WISIERR	EQU	00000100B		;IMMEDIATE MODE ERROR
WISPAUS	EQU	00000010B		;PAUSED
WISDONE	EQU	00000001B		;DONE

;*	DIRECT MODE COMMANDS

WISETUP	EQU	08H			;SETUP
WIEXEC	EQU	10H			;EXECUTE
WIPAUS	EQU	18H			;PAUSE
WICONT	EQU	20H			;CONTINUE

;*	CONTROL BLOCK COMMANDS

WIRECAL	EQU	00H			;RECALIBRATE
WISTAT	EQU	01H			;STATUS
WIWRL	EQU	10H			;WRITE LOGICAL
WIRDL	EQU	11H			;READ LOGICAL
WISEKL	EQU	13H			;SEEK LOGICAL
WIFMTD	EQU	20H			;FORMAT DRIVE
WIFMTT	EQU	21H			;FORMAT TRACK
WISDP	EQU	22H			;SET DRIVE PARAMETERS
WIWRA	EQU	30H			;WRITE ABSOLUTE
WIRDA	EQU	31H			;READ ABSOLUTE
WISEKA	EQU	33H			;SEEK ABSOLUTE

;*	FORMAT OF COMMANDS

;		TYPE 0 & 1

	ORG	0
WI01BLK	RB	0
WI01OP	RB	1			;COMMAND OP CODE
WI01DHS	RB	1			;BIT 7-5 -- DRIVE SELECT
					;    4-0 -- HIGH BYTE OF LOG SECTOR #
WI01D	EQU	11100000B		;  DRIVE SELECT MASK
WI01HS	EQU	00011111B		;  HIGH BYTE OF LOG SECTOR # MASK
WI01MS	RB	1			;MIDDLE BYTE OF LOGICAL SECTOR #
WI01LS	RB	1			;LOW BYTE OF LOGICAL SECTOR #
WI01SC	RB	1			;SECTOR COUNT
WI01HT	RB	1			;HIGH BYTE OF DATA TMA ADDRESS
WI01MT	RB	1			;MIDDLE BYTE OF DATA TMA ADDRESS
WI01LT	RB	1			;LOW BYTE OF DATA TMA ADDRESS
WI01HN	RB	1			;HIGH BYTE OF NEXT COMMAND ADDRESS
WI01MN	RB	1			;MIDDLE BYTE OF NEXT COMMAND ADDRESS
WI01LN	RB	1			;LOW BYTE OF NEXT COMMAND ADDRESS
WI01FLG	RB	1			;FLAGS
WI01EEC	RB	1			;ERROR CODE
WI01EDH	RB	1			;BIT 7-5 -- DRIVE SELECT
					;    4-0 -- HIGHT BYTE OF LOG SECTOR #
WI01ED	EQU	11100000B		;  ERROR DRIVE SELECT MASK
WI01EHS	EQU	00011111B		;  ERROR HIGH BYTE OF LOG SECTOR # MASK
WI01EMS	RB	1			;ERROR MIDDLE BYTE OF LOGICAL SECTOR #
WI01ELS	RB	1			;ERROR LOW BYTE OF LOGICAL SECTOR #
	IF	ASM86
WI01BKL	EQU	OFFSET $ - OFFSET WI01BLK
	ENDIF
	IF	NOT ASM86
WI01BKL	EQU	$-WI01BLK
	ENDIF
	IF	WI01BKL NE 16
%:	TYPE 0 & 1 COMMAND BLOCK IS WRONG LENGTH
	ENDIF

;		TYPE 2

	ORG	0
WI2BLK	RB	0
WI2OP	RB	1			;COMMAND OP CODE
WI2DH	RB	1			;BIT 7-5 -- DRIVE SELECT
					;    2-0 -- (MAX) HEAD #
WI2D	EQU	11100000B		;  DRIVE SELECT MASK
WI2H	EQU	00000111B		;  HEAD # MASK
WI2HMC	RB	1			;HIGH BYTE OF MAX CYLINDER #
WI2LMC	RB	1			;LOW BYTE OF MAX CYLINDER #
WI2HRWC	RB	1			;HIGH BYTE OF RWC CYLINDER #
WI2LRWC	RB	1			;LOW BYTE OF RWC CYLINDER #
WI2HPC	RB	1			;HIGH BYTE OF PRE-COMP CYLINDER #
WI2LPC	RB	1			;LOW BYTE OF PRE-COMP CYLINDER #
WI2SR	RB	1			;STEP RATE (LSB = 20uS)
WI2ECC	RB	1			;ECC SPAN
WI2CSIF	RB	1			;BIT 6   -- CELL SIZE
					;    4-0 -- INTERLEAVE FACTOR
WI2CS	EQU	01000000B		;  CELL SIZE MASK
WI2CS5	EQU	00000000B		;    CELL SIZE =  512 BYTES/LOG SECTOR
WI2CS1K	EQU	01000000B		;    CELL SIZE = 1024 BYTES/LOG SECTOR
WI2IF	EQU	00011111B		;  INTERLEAVE FACTOR MASK
WI2FC	RB	1			;FILL CHARACTER
WI2EEC	RB	1			;ERROR CODE
WI2EHS	RB	1			;BIT 7-5 -- ERROR HEAD #
					;    4-0 -- ERROR SECTOR #
WI2EH	EQU	11100000B		;  ERROR HEAD # MASK
WI2ES	EQU	00011111B		;  ERROR SECTOR # MASK
WI2EHC	RB	1			;ERROR HIGH BYTE OF CYLINDER #
WI2ELC	RB	1			;ERROR LOW BYTE OF CYLINDER #
	IF	ASM86
WI2BLKL	EQU	OFFSET $ - OFFSET WI2BLK
	ENDIF
	IF	NOT ASM86
WI2BLKL EQU	$-WI2BLK
	ENDIF
	IF	WI2BLKL NE 16
%:	TYPE 2 COMMAND BLOCK IS WRONG LENGTH
	ENDIF

;		TYPE 3

	ORG	0
WI3BLK	RB	0
WI3OP	RB	1			;COMMAND OP CODE
WI3DH	RB	1			;BIT 7-5 -- DRIVE SELECT
					;    2-0 -- HEAD #
WI3D	EQU	11100000B		;  DRIVE SELECT MASK
WI3H	EQU	00000111B		;  HEAD # MASK
WI3HC	RB	1			;HIGH BYTE OF CYLINDER #
WI3LC	RB	1			;LOW BYTE OF CYLINDER #
WI3S	RB	1			;SECTOR #
WI3HT	RB	1			;HIGH BYTE OF DATA TMA ADDRESS
WI3MT	RB	1			;MIDDLE BYTE OF DATA TMA ADDRESS
WI3LT	RB	1			;LOW BYTE OF DATA TMA ADDRESS
WI3HN	RB	1			;HIGH BYTE OF NEXT COMMAND ADDRESS
WI3MN	RB	1			;MIDDLE BYTE OF NEXT COMMAND ADDRESS
WI3LN	RB	1			;LOW BYTE OF NEXT COMMAND ADDRESS
WI3FLG	RB	1			;FLAGS
WI3EEC	RB	1			;ERROR CODE
WI3EHS	RB	1			;BIT 7-5 -- ERROR HEAD #
					;    4-0 -- ERROR SECTOR #
WI3EH	EQU	11100000B		;  ERROR HEAD # MASK
WI3ES	EQU	00011111B		;  ERROR SECTOR # MASK
WI3EHC	RB	1			;ERROR HIGH BYTE OF CYLINDER #
WI3ELC	RB	1			;ERROR LOW BYTE OF CYLINDER #
	IF	ASM86
WI3BLKL	EQU	OFFSET $ - OFFSET WI3BLK
	ENDIF
	IF	NOT ASM86
WI3BLKL	EQU	$-WI3BLK
	ENDIF
	IF	WI3BLKL NE 16
%:	TYPE 3 COMMAND BLOCK IS WRONG LENGTH
	ENDIF

;		COMMAND BLOCK FLAG BYTE

WIFINTE	EQU	10000000B		;INTERRUPTS ENABLED
WIFBM	EQU	01000000B		;USE BURST MODE TMA
WIFIPCC	EQU	00100000B		;IGNORE PAUSE AND CONTINUE COMMANDS
WIFIDR	EQU	00000100B		;DISABLE RETRIES
WIFDECC	EQU	00000010B		;DISABLE ECC
WIFCHN	EQU	00000001B		;CHAIN NEXT COMMAND IMMEDIATELY

;*	FORMAT OF STATUS RETURNED BY 01 COMMAND

	ORG	0
WISBLK	RB	0
WISFLG	RB	1			;FLAG BYTE
WISDR	EQU	00000100B		;  BIT 2 -- DRIVE READY
WISACC	EQU	00000010B		;      1 -- ACCESSED
WISSC	EQU	00000001B		;      0 -- SEEK COMPLETE
WISHMC	RB	1			;HIGH BYTE OF MAX CYLINDER #
WISLMC	RB	1			;LOW BYTE OF MAX CYLINDER #
WISHRWC	RB	1			;HIGH BYTE OF RWC CYLINDER #
WISLRWC	RB	1			;LOW BYTE OF RWC CYLINDER #
WISHPC	RB	1			;HIGH BYTE OF PRE-COMP CYLINDER #
WISLPC	RB	1			;LOW BYTE OF PRE-COMP CYLINDER #
WISHCC	RB	1			;HIGH BYTE OF CURRENT CYLINDER #
WISLCC	RB	1			;LOW BYTE OF CURRENT CYLINDER #
WISSR	RB	1			;STEP RATE (LSB = 20uS)
	RB	1			;RESERVED
WISIF	RB	1			;INTERLEAVE FACTOR
WISCS	RB	1			;CELL SIZE
WISCS5	EQU	1			;  =  512 BYTES/LOG SECTOR
WISCS1K	EQU	2			;  = 1024 BYTES/LOG SECTOR
WISMH	RB	1			;MAX HEAD #
WISFC	RB	1			;FILL CHARACTER
	RB	1			;RESERVED
	IF	ASM86
WISBLKL	EQU	OFFSET $ - OFFSET WISBLK
	ENDIF
	IF	NOT ASM86
WISBLKL	EQU	$-WISBLK
	ENDIF
	IF	WISBLKL NE 16
%:	STATUS BLOCK IS WRONG LENGTH
	ENDIF

;*	ERROR CODES

WIENE	EQU	00H			;NO ERROR
WIEDNR	EQU	01H			;DRIVE NOT READY
WIENSC	EQU	02H			;NO SEEK COMPLETE
WIENT0	EQU	03H			;NO TRACK 0
WIENI	EQU	04H			;NO INDEX
WIENDS	EQU	05H			;NO DRIVE SELECT
WIEHNF	EQU	10H			;HEADER ADDRESS MARK NOT FOUND
WIESEK	EQU	11H			;SEEK ERROR (BAD CYLINDER # IN HEADER)
WIESNF	EQU	12H			;SECTOR NOT FOUND
WIEECCH	EQU	13H			;ECC ERROR IN HEADER
WIEDNF	EQU	14H			;DATA ADDRESS MARK NOT FOUND
WIENECC	EQU	15H			;NONCORRECTABLE ECC ERROR IN DATA FIELD
WIEECC	EQU	16H			;CORRECTABLE ECC ERROR IN DATA FIELD
WIEWF	EQU	17H			;WRITE FAULT
WIEIOP	EQU	20H			;ILLEGAL OP CODE
WIEIDA	EQU	21H			;ILLEGAL DISK ADDRESS
WIEFMTP	EQU	22H			;FORMAT PROTECTED
WIEWRP	EQU	23H			;WRITE PROTECTED
WIEMISC	EQU	30H			;MISCELLANEOUS ERROR
WIEDIAG	EQU	40H			;ERROR DURING DIAGNOSTIC
WIEPNA	EQU	80H			;PARTION NOT ASSIGNED
WIESNWP	EQU	81H			;SECTOR NOT WITHIN PARTITION

;*	CP/M RELATED VALUES

WIRPS	EQU	WICSZ/128		;CP/M RECORDS PER SECTOR
WIRPT	EQU	WIRPS*WINSPT		;CP/M RECORDS PER TRACK
WINST	EQU	1			;# OF SYSTEM TRACKS
WINSYS	EQU	WINST*WINSPT		;# SECTORS IN SYSTEM TRACK(S)

WIMIN	EQU	1024/WICSZ*64+WINSYS	;MINIMUM # USEABLE SECTORS
WIMAX	EQU	1024/WICSZ*8*1024+WINSYS ;MAX # USEABLE SECTORS



;**	DISK PARAMETER TABLE EQUATES
;

;	DISK PARAMETER ENTRY DESCRIPTION

	ORG	0
DPEXLT	RW	1		;SECTOR TRANSLATE TABLE ADDRESS
	RW	3
DPEDIRB	RW	1		;DIRECTORY BUFFER ADDRESS
DPEDPB	RW	1		;DISK PARAMETER BLOCK ADDRESS
DPECSV	RW	1		;CHECKSUM VECTOR ADDRESS
DPEALV	RW	1		;ALLOCATION VECTOR ADDRESS
DPEHTH	RB	8		;HEATH EXTENSIONS
DPEL	EQU	24		;LENGTH OF DISK PARAMETER ENTRY

;	HEATH EXTENSIONS

DPEFLAG	EQU	DPEHTH+0	;FLAGS
DPETYPE	EQU	11100000B	;BIT 7-5 = DEVICE TYPE
DPENE	EQU	00000000B	; NON-EXISTENT
DPEZ207	EQU	00100000B	; Z207
DPEZ217	EQU	01000000B	; Z217
DPE48RO	EQU	00010000B	;BIT 4 -- FOR Z207
				;  48 TPI MEDIA IN 96 TPI DRIVE (R/O)
DPE96T	EQU	00001000B	;BIT 3 -- 0=48 TPI DRIVE  1=96 TPI DRIVE
DPEASGN	EQU	00001000B	;BIT 3 -- FOR Z217 WINCHESTER DISK
				;         0=UNASSIGNED A PARTITION
				;         1=ASSIGNED A PARTITION
DPET0SD	EQU	00000100B	;BIT 2 -- 1=TRACK 0 IS SINGLE DENSITY
DPEDD	EQU	00000010B	;BIT 1 -- 0=SINGLE DENSITY  1=DOUBLE
DPELSIO	EQU	00000010B	;BIT 1 -- Z217 LOGICAL SECTOR I/O
DPE2S	EQU	00000001B	;BIT 0 -- 0=SINGLE SIDED  1=DOUBLE
DPEPRIM	EQU	00000001B	;BIT 0 -- Z217 PRIMARY DPE FOR UNIT

DPEUNIT	EQU	DPEHTH+1	;UNIT SELECT VALUE
DPERPS	EQU	DPEHTH+2	;CP/M RECORDS PER PHYSICAL SECTOR
DPERPAB	EQU	DPEHTH+3	;CP/M RECORDS PER ALLOCATION BLOCK
DPETRK	EQU	DPEHTH+4	;TRACK COUNTER
DPEUNK	EQU	10000000B	; TRACK POSITION UNKNOWN
DPELPB	EQU	DPEHTH+4	;Z217 LOWER PARTITION BOUNDARY (LOG SECTOR #)
DPESEK	EQU	DPEHTH+5	;MOTOR SPEED AND SEEK SPEED
				;BIT 3-0 = SEEK SPEED VALUE
DPEFS	EQU	01000000B	;BIT 6 = FAST STEP FOR Z207
DPEMO	EQU	10000000B	;BIT 7 = MOTOR UP TO SPEED FLAG
				;  0=1 SEC  1=250 MSEC
DPEUPB	EQU	DPEHTH+6	;Z217 UPPER PARTITION BOUNDARY + 1
DPEFLG2	EQU	DPEHTH+6	;2ND FLAG BYTE
DPEHLS	EQU	00000100B	;BIT 2  DRIVE HAS HEAD LOAD SELONOID
DPEIMG	EQU	00000010B	;BIT 1  IMAGINARY DRIVE
DPE96TM	EQU	00000001B	;BIT 0  0=48 TPI MEDIA  1=96 TPI MEDIA
DPELUN	EQU	DPEHTH+7	;LAST LOGICAL UNIT MOUNTED
DPELOG	EQU	11110000B	; CP/M LOGICAL DRIVE NAME FOR THIS ENTRY
DPEREAL	EQU	00001111B	; FOR IMAGINARY DRIVE, LOGICAL DRIVE NAME
				;  FOR CORRESPONDING REAL DRIVE
DPEMNT	EQU	00001111B	; FOR REAL DRIVE, LOGICAL DRIVE NAME FOR
				;  CURRENLY MOUNTED DISK

DPEHL	EQU	8		;LENGTH OF HEATH EXTENSION

;	DISK PARAMETER BLOCK

	ORG	0
DPBSPT	RW	1		;SECTORS PER TRACK
DPBBSH	RB	1		;BLOCK SHIFT FACTOR
DPBBLM	RB	1		;BLOCK MASK
DPBEXM	RB	1		;EXTENT MASK
DPBDSM	RW	1		;TOTAL # OF BLOCKS - 1
DPBDRM	RW	1		;# OF DIRECTORY ENTRIES - 1
DPBAL0	RB	1		;INITIAL AL0 VALUE
DPBAL1	RB	1		;INITIAL AL1 VALUE
DPBCKS	RW	1		;SIZE OF DIRECTORY CHECK VECTOR
DPBOFF	RW	1		;NUMBER OF SYSTEM TRACKS
DPBL	EQU	15		;LENGTH OF DISK PARAMETER BLOCK



;**	Z-MACHINE PORT ASSIGNMENTS
;


ZVIDEO	EQU	0D8H		;VIDEO 68A21
ZCRTC	EQU	0DCH		;VIDEO 6845 CRTC
ZLPEN	EQU	0DEH		;LIGHT PEN COUNTER
ZGDP	EQU	0E0H		;GENERAL DATA PORT (68A21)
ZTIMER	EQU	0E4H		;8253 TIMER
ZSERA	EQU	0E8H		;SERIAL A
ZSERB	EQU	0ECH		;SERIAL B
Z8259AS	EQU	0F0H		;8259A SLAVE
Z8259AM	EQU	0F2H		;8259A MASTER
ZKEYBD	EQU	0F4H		;KEYBOARD
ZTSTAT	EQU	0FBH		;TIMER STATUS
ZMCL	EQU	0FCH		;MEMORY CONTROL LATCH
ZHAL	EQU	0FDH		;HI-ADDRESS LATCH
ZPSP	EQU	0FEH		;PROCESSOR SWAP PORT
ZDIPSW	EQU	0FFH		;DIP SWITCHES

;	MEMORY CONTROL LATCH

ZMCLMS	EQU	00000011B	;MAP SELECT MASK
ZMS0	EQU	000H		; MAP SELECT 0
ZMS1	EQU	001H		; MAP SELECT 1
ZMS2	EQU	002H		; MAP SELECT 2
ZMS3	EQU	003H		; MAP SELECT 3

ZMCLRM	EQU	00001100B	;MONITOR ROM MAPPING
ZRM0	EQU	000H		; POWER UP MODE - ROM EVERYWHERE ON READS
ZRM1	EQU	004H		; ROM AT THE TOP 8K OF EVERY 64K
ZRM2	EQU	008H		; ROM AT THE TOP 8K OF THE 8088'S ADDR SPACE
ZRM3	EQU	00CH		; DISABLE ROM

ZMCLP	EQU	00110000B	;PARITY HANDLING
ZMCLPZ	EQU	00010000B	; 0=SET PARITY TO THE ZERO STATE
ZMCLPK	EQU	00100000B	; 0=DISABLE PARITY CHECKING CIRCUITRY

;	HI-ADDRESS LATCH

ZHAL85	EQU	11111111B	;8085 MASK
ZHAL88	EQU	00001111B	;8088 MASK

;	PROCESSOR SWAP PORT

ZPSPPS	EQU	10000000B	;PROCESSOR SELECT (0=8085 , 1=8088)
ZPSPPS5	EQU	000H		; SELECT 8085
ZPSPPS8	EQU	080H		; SELECT 8088
ZPSPGIS	EQU	00000010B	;GENERATE INTERRUPT ON SWAPPING
ZPSPI88	EQU	00000001B	;8088 PROCESSES ALL INTERRUPTS




;**	Z-100 GENERAL DATA PORT DEFINITIONS
;
;	HARDWARE IS A 6821
;

;	PORT ASSIGNMENTS

GDPDATA	EQU	ZGDP+PIADATA		;DATA PORT A
GDPDDRA	EQU	ZGDP+PIADDRA		;DATA DIRECTION PORT A
GDPCTLA	EQU	ZGDP+PIACTLA		;CONTROL PORT A
GDPDATB	EQU	ZGDP+PIADATB		;DATA PORT B
GDPDDRB	EQU	ZGDP+PIADDRB		;DATA DIRECTION PORT B
GDPCTLB	EQU	ZGDP+PIACTLB		;CONTROL PORT B

;	CONTROL PORT A ASSIGNMENTS

GDPCAV	EQU	PIAC12+PIAC23+PIADDAC	;INITIALIZATION VALUE
LPENSI	EQU	PIAIRQ1			;CA1 = LIGHT PEN STROBE
					;      INTERRUPT ON 0->1
VSYNCI	EQU	PIAIRQ2			;CA2 = VERTICAL SYNC
					;      INTERRUPT ON 0->1

;	DATA DIRECTION PORT A ASSIGNMENTS

GDPDDAV	EQU	10101111B

;	DATA PORT A ASSIGNMENTS

PPRTM10	EQU	00000011B		;PRINTER D1-D0 MASK
PPRTSTB	EQU	00000100B		;PRINTER STROBE (OUTPUT ACTIVE LOW)
PPRTPRM	EQU	00001000B		;PRINTER PRIME (OUTPUT ACTIVE LOW)
VSYNC	EQU	00010000B		;VERTICAL SYNC (INPUT ACTIVE HIGH)
VSYNCE	EQU	00100000B		;VERT SYNC TO CA2 (0=DISABLE, 1=ENABLE)
LPEN	EQU	01000000B		;LIGHT PEN SWITCH (INPUT ACTIVE HIGH)
LPENSE	EQU	10000000B	;LIGHT PEN STROBE TO CA1 (0=DISABLE, 1=ENABLE)

;	CONTROL PORT B ASSIGNMENTS

GDPCBV	EQU	PIAC12+PIAC20+PIADDAC	;INITIALIZATION VALUE
PRTACKI	EQU	PIAIRQ1			;CB1 = PRINTER ACKNOWLEDGE
					;      NO INTERRUPT ON 0->1
PRTBSYI	EQU	PIAIRQ2			;CB2 = PRINTER BUSY
					;      NO INTERRUPT ON 1->0

;	DATA DIRECTION PORT B ASSIGNMENTS

GDPBDDV	EQU	11111100B

;	DATA PORT B ASSIGNMENTS

PPRTBSY	EQU	00000001B		;PRINTER BUSY (INPUT ACTIVE HIGH)
PPRTFLT	EQU	00000010B		;PRINTER FAULT (INPUT ACTIVE LOW)
PPRTM72	EQU	11111100B		;PRINTER D7-D2 MASK



;**	Z-MACHINE KEYBOARD DEFINITIONS
;

;	PORT ASSIGNMENTS

ZKEYBDD	EQU	ZKEYBD+0		;DATA
ZKEYBDC	EQU	ZKEYBD+1		;COMMAND
ZKEYBDS	EQU	ZKEYBD+1		;STATUS

;	STATUS REGISTER

ZKEYOBF	EQU	00000001B		;OUTPUT BUFFER FULL
ZKEYIBF	EQU	00000010B		;INPUT BUFFER FULL

;	COMMANDS

ZKEYRES	EQU	000H			;RESET
ZKEYARO	EQU	001H			;AUTOREPEAT ON
ZKEYARF	EQU	002H			;AUTOREPEAT OFF
ZKEYKCO	EQU	003H			;KEY CLICK ON
ZKEYKCF	EQU	004H			;KEY CLICK OFF
ZKEYCF	EQU	005H			;CLEAR FIFO
ZKEYCLK	EQU	006H			;CLICK
ZKEYBEP	EQU	007H			;BEEP
ZKEYEK	EQU	008H			;ENABLE KEYBOARD
ZKEYDK	EQU	009H			;DISABLE KEYBOARD
ZKEYUDM	EQU	00AH			;KEY UP/DOWN MODE
ZKEYNSM	EQU	00BH			;NORMAL SCAN MODE
ZKEYEI	EQU	00CH			;ENABLE INTERRUPTS
ZKEYDI	EQU	00DH			;DISABLE INTERRUPTS

;	SPECIAL KEYS

ZKEYBRK	EQU	0AAH			;BREAK KEY


;**	MISCELLANEOUS EQUATES

	IF	REL0
	ORG	0000H
	ELSE
	ORG	0100H
	ENDIF
BIOSORG	EQU	$
CCPORG	EQU	BIOSORG-BDOSL-CCPL	;ORIGIN FOR CCP
CCPAUTO	EQU	CCPORG			; ENTRY TO CCP FOR AUTO EXEC COMMAND
CCPNORM	EQU	CCPORG+3		; NORMAL ENTRY TO CCP
CCPCMD	EQU	CCPORG+7		; BUFFER FOR AUTO EXEC COMMAND
AUTOCL	EQU	40			; MAX COMMAND LENGTH
BDOSORG	EQU	BIOSORG-BDOSL		;ORIGIN FOR BDOS
BDOSE	EQU	BDOSORG+6		; ENTRY TO BDOS

MIJMP	EQU	0C3H			;8080 'JMP' INSTRUCTION


	PAGE
;**	BIOS JUMP VECTORS
;

	JMP	CBOOTE			;COLD BOOT ENTRY
	JMP	WBOOTE			;WARM BOOT
	JMP	CONSTE			;CONSOLE STATUS
	JMP	CONINE			;CONSOLE INPUT
	JMP	CONOUTE			;CONSOLE OUTPUT ENTRY
	JMP	LSTOUTE			;LIST OUTPUT
	JMP	PUNOUTE			;PUNCH OUTPUT
	JMP	RDRINE			;READER INPUT
	JMP	HOMEE			;HOME HEAD ENTRY
	JMP	SETDSKE			;SET DISK ENTRY
	JMP	SETTRKE			;SET TRACK ENTRY
	JMP	SETSECE			;SET SECTOR ENTRY
	JMP	SETDMAE			;SET DMA ENTRY
	JMP	READE			;READ CP/M SECTOR ENTRY
	JMP	WRITEE			;WRITE CP/M SECTOR ENTRY
	JMP	LSTSTE			;LIST STATUS
	JMP	SECTRNE			;SECTOR TRANSLATE ENTRY
	JMP	FORMATE			;FORMAT
	JMP	RDTRKE			;READ TRACK
	JMP	WRTRKE			;WRITE TRACK
	JMP	WPCE			;WRITE PROTECT CHECK
	JMP	CLRBUFD			;CLEAR BUFFERS FOR DRIVE

	PAGE
;**	BIOS HEADER TABLES
;

	DB	BVERSN			;BIOS VERSION
	DB	00010101B		;DEFAULT I/O BYTE
XMODE	DB	0			;MODE FLAGS
	DB	(BIOSEND-BIOSORG+256)/256	;BIOS SIZE IN PAGES
	DW	BIOSEND			;ENDING ADDR OF BIOS + 1
	DW	0			;HARD ERROR COUNT (SINCE COLD BOOT)
	DW	0			;SOFT ERROR COUNT (SINCE COLD BOOT)
	DB	NDRIVES			;NUMBER OF DRIVES POSSIBLE IN THIS BIOS

;	AUTO EXEC COMMAND BUFFERS

ACBC	DB	0			;COLD BOOT AUTO COMMAND
	DS	AUTOCL
AWBC	DB	0			;WARM BOOT AUTO COMMAND
	DS	AUTOCL

;	CHARACTER I/O DEVICE TABLES

XCRTTBL	DS	0			;CRT: TABLE
	DB	0
	DW	0
	DB	0,0
	DB	0FFH,0
	DB	0,0
	DB	0,0
	DB	0,0,0
	DB	0,0,0,0,0,0,0,0
	DW	0,0,0,0,0
	IF	$-XCRTTBL NE CIOTBLL
%:	CRT: CIO TABLE IS NOT CORRECT
	ENDIF

TTYTBL	DS	0			;TTY: (SERIAL PORT A)
	DB	ZSERA
	DW	EPB480
	DB	0,0
	DB	EPRXR,0
	DB	EPDCD+EPTXR,0
	DB	0,0
	DB	0,0,0
	DB	EPSB1+EPCL8+EPA16X
	DB	070H
	DB	EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR+EPTXEN
	DB	0,0,0,0,0
	DW	0,0,0,0,0
	IF	$-TTYTBL NE CIOTBLL
%:	TTY: CIO TABLE IS NOT CORRECT
	ENDIF

UL1TBL	DS	0		;UC1: , UR1: , UP1: , UL1: (SERIAL PORT B)
	DB	ZSERB
	DW	EPB300
	DB	0,0
	DB	EPDSR+EPDCD+EPRXR,0
	DB	EPDSR+EPDCD+EPTXR,0
	DB	0,0
	DB	0,0,0
	DB	EPSB1+EPCL8+EPA16X
	DB	070H
	DB	EPNORM+EPRTS+EPRESE+EPRXEN+EPDTR+EPTXEN
	DB	0,0,0,0,0
	DW	0,0,0,0,0
	IF	$-UL1TBL NE CIOTBLL
%:	UL1: CIO TABLE IS NOT CORRECT
	ENDIF

LPTTBL	DS	0		;LPT: (GENERAL DATA PORT PARALLEL PRINTER)
	DB	0
	DW	0
	DB	0,0
	DB	0,0
	DB	PPRTBSY,PPRTBSY
	DB	0,0
	DB	0,0,0
	DB	LPENSE+VSYNCE+PPRTPRM+PPRTSTB
	DB	GDPDDAV
	DB	GDPCAV
	DB	0
	DB	GDPBDDV
	DB	GDPCBV
	DB	0,0
	DW	0,0,0,0,0
	IF	$-LPTTBL NE CIOTBLL
%:	LPT: CIO TABLE IS NOT CORRECT
	ENDIF

XDUMMY	DS	0			;DUMMY UNIT
	DB	0
	DW	0
	DB	0,0
	DB	0,0
	DB	0,0
	DB	0,0
	DB	0,0,0
	DB	0,0,0,0,0,0,0,0
	DW	0,0,0,0,0
	IF	$-XDUMMY NE CIOTBLL
%:	DUMMY CIO TABLE IS NOT CORRECT
	ENDIF

;	DISK PARAMETER ENTRY TABLES

	IF	$-BIOSORG NE DPEBASE
%:	BIOS HEADER IS NOT CORRECT
	ENDIF

DPE1A	DS	0			;PHYSICAL DRIVE 0 -- Z207  5 1/4"
	DW	0,0,0,0
	DW	DIRBUF
	DW	DPB1A
	DW	CSV1A
	DW	ALV1A
	DB	DPEZ207+DPEDD
	DB	0
	DB	0
	DB	0
	DB	DPEUNK
	DB	DPEMO+FDFS6
	DB	0
	DB	0
	IF	$-DPE1A NE DPEL
%:	DPE1A IS INCORRECT LENGTH
	ENDIF

DPE1B	DS	0			;PHYSICAL DRIVE 1 -- Z207  5 1/4"
	DW	0,0,0,0
	DW	DIRBUF
	DW	DPB1B
	DW	CSV1B
	DW	ALV1B
	DB	DPEZ207+DPEDD
	DB	1
	DB	0
	DB	0
	DB	DPEUNK
	DB	DPEMO+FDFS6
	DB	0
	DB	0
	IF	$-DPE1B NE DPEL
%:	DPE1B IS INCORRECT LENGTH
	ENDIF

DPE1C	DS	0			;PHYSICAL DRIVE 2 -- Z207  8"
	DW	XLATE1,0,0,0
	DW	DIRBUF
	DW	DPB1C
	DW	CSV1C
	DW	ALV1C
	DB	DPEZ207+DPET0SD+DPEDD
	DB	CONPC+CONDS8+0
	DB	0
	DB	0
	DB	DPEUNK
	DB	FDFS6
	DB	DPEHLS
	DB	0
	IF	$-DPE1C NE DPEL
%:	DPE1C IS INCORRECT LENGTH
	ENDIF

DPE1D	DS	0			;PHYSICAL DRIVE 3 -- Z207  8"
	DW	XLATE2,0,0,0
	DW	DIRBUF
	DW	DPB1D
	DW	CSV1D
	DW	ALV1D
	DB	DPEZ207+DPET0SD+DPEDD
	DB	CONPC+CONDS8+1
	DB	0
	DB	0
	DB	DPEUNK
	DB	FDFS6
	DB	DPEHLS
	DB	0
	IF	$-DPE1D NE DPEL
%:	DPE1D IS INCORRECT LENGTH
	ENDIF

DPE2A	DS	0			;Z217 -- PARTITION 1
	DW	0,0,0,0
	DW	DIRBUF
	DW	DPB2A
	DW	0
	DW	ALV2A
	DB	DPEZ217+DPEPRIM
	DB	0
	DB	WIRPS
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	IF	$-DPE2A NE DPEL
%:	DPE2A IS INCORRECT LENGTH
	ENDIF

DPE2B	DS	0			;Z217 -- PARTITION 2
	DW	0,0,0,0
	DW	DIRBUF
	DW	DPB2B
	DW	0
	DW	ALV2B
	DB	DPEZ217
	DB	0
	DB	WIRPS
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	IF	$-DPE2B NE DPEL
%:	DPE2B IS INCORRECT LENGTH
	ENDIF

	PAGE
;**	COLD BOOT ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(C)=DEFAULT DRIVE # ('A:')
;		VIA:	AUTO ON
;			AUTO OFF
;	USES:	ALL
;

CBOOTE:
	LXI	SP,STACK		;INIT STACK POINTER

	MVI	A,(CBOOT-CBOOT)/3	;SET FUNCTION # IN SPECIAL LOCATION
	STA	BLDRP0+COMFUNC		; SINCE COLD BOOTING FROM BIOS LOADER
	CALL	SWAP881		;8088 CODE DOES MOST OF THE INITIALIZATION

	MVI	C,0			;DEFAULT DRIVE IS 'A:'
	LXI	D,ACBC			;POINTER TO AUTO COMMAND BUFFER
	JMP	WB1			;MERGE WITH WARM BOOT CODE


;**	WARM BOOT ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(C)=DEFAULT DRIVE #
;		VIA:	AUTO ON
;			AUTO OFF
;	USES:	ALL
;

WBOOTE:
	LXI	SP,STACK		;INIT STACK POINTER

	MVI	A,(WBOOT-CBOOT)/3	;SET FUNCTION #
	CALL	SWAP88			;8088 CODES DOES MOST OF WARM BOOT

	LDA	DFTDRV			;GET DEFAULT DRIVE
	MOV	C,A
	LXI	D,AWBC			;POINTER TO AUTO COMMAND BUFFER

WB1:
	MVI	A,MIJMP			;SET PAGE ZERO VALUES
	LXI	H,BIOSORG+3
	STA	BOOT
	SHLD	BOOT+1
	LXI	H,BDOSE
	STA	BDOS
	SHLD	BDOS+1

	LDAX	D			;CHECK IF AUTO SHOULD BE DONE
	ORA	A
	JZ	CCPNORM			; BR IF NO

	LDA	CCPCMD-1		;FILL COMMAND BUFFER WITH NULLS
	LXI	H,CCPCMD+1
WB2:	MVI	M,0
	INX	H
	DCR	A
	JNZ	WB2

	LDAX	D			;MOVE AUTO COMMAND TO CCP
	MOV	B,A			; COMMAND BUFFER
	INR	B
	LXI	H,CCPCMD
WB3:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	WB3

	JMP	CCPAUTO			;BR TO CCP ENTRY FOR AUTO


;**	CONSOLE STATUS ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=STATUS
;		    0=NO CHARACTER AVAILABLE , 0FFH=CHARACTER AVAILABLE
;	USES:	ALL
;

CONSTE:
	MVI	A,(CONST-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	CONSOLE INPUT ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=CHARACTER FROM CONSOLE
;	USES:	ALL
;

CONINE:
	MVI	A,(CONIN-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	CONSOLE OUTPUT ENTRY
;
;	ENTRY:	(C)=CHARACTER
;	EXIT:	NONE
;	USES:	ALL

CONOUTE:
	MVI	A,(CONOUT-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	LIST OUTPUT ENTRY
;
;	ENTRY:	(C)=CHARACTER
;	EXIT:	NONE
;	USES:	ALL
;

LSTOUTE:
	MVI	A,(LSTOUT-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	PUNCH OUTPUT ENTRY
;
;	ENTRY:	(C)=CHARACTER
;	EXIT:	NONE
;	USES:	ALL
;

PUNOUTE:
	MVI	A,(PUNOUT-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	READER INPUT ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=CHARACTER READ FROM READER
;	USES:	ALL
;

RDRINE:
	MVI	A,(RDRIN-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	SET DISK DRIVE ENTRY
;
;	ENTRY:	(C)=DRIVE NUMBER
;		(E)=LSB INDICATES 1ST TIME SELECTION
;		    0=1ST TIME , 1=SUBSEQUENT TIMES
;	EXIT:	(HL)=ADDRESS OF DPE FOR DRIVE
;		    =0 IF ERROR
;	USES:	ALL
;

SETDSKE:
	LXI	H,XLATES		;ADDRESS OF XLATE TABLE ADDRESSES
	MVI	A,(SETDSK-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	HOME HEAD ENTRY
;
;	ENTRY:	NONE
;	EXIT:	NONE
;	USES:	ALL

HOMEE:
	MVI	A,(HOME-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	SET TRACK NUMBER ENTRY
;
;	ENTRY:	(BC)=TRACK NUMBER
;	EXIT:	NONE
;	USES:	ALL
;

SETTRKE:
	MVI	A,(SETTRK-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	SET SECTOR NUMMBER ENTRY
;
;	ENTRY:	(BC)=SECTOR NUMBER
;	EXIT:	NONE
;	USES:	ALL
;

SETSECE:
	MVI	A,(SETSEC-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	SET DMA ADDRESS
;
;	ENTRY:	(BC)=ADDRESS
;	EXIT:	NONE
;	USES:	ALL
;

SETDMAE:
	MVI	A,(SDMA-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	READ CP/M SECTOR ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=ERROR CODE
;		    0=NO ERROR , 1=ERROR
;	USES:	ALL
;

READE:
	MVI	A,(BREAD-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	WRITE CP/M SECTOR ENTRY
;
;	ENTRY:	(C)=TYPE OF WRITE
;		    0=NORMAL WRITE
;		    1=WRITE TO A DIRECTORY SECTOR
;		    2=1ST WRITE TO A SECTOR IN AN UNALLOCATED BLOCK
;	EXIT:	(A)=ERROR CODE
;		    0=NO ERROR , 1=ERROR
;	USES:	ALL
;

WRITEE:
	MVI	A,(BWRITE-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	CHECK LIST DEVICE STATUS ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=STATUS
;		    0=NOT READY , 0FFH=READY
;	USES:	ALL
;

LSTSTE:
	MVI	A,(BLSTST-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	SECTOR TRANSLATE ENTRY
;
;	ENTRY:	(BC)=SECTOR NUMBER
;		(DE)=POINTER TO TRANSLATE TABLE
;	EXIT:	(HL)=TRANSLATED SECTOR NUMBER
;	USES:	ALL
;

SECTRNE:
	MVI	A,(BSECTRN-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	FORMAT ENTRY
;
;	ENTRY:	(C)=VERIFY FLAG  (0=NO , 1=YES)
;	EXIT:	(A)=STATUS BYTE
;	USES:	ALL
;

FORMATE:
	MVI	A,(BFMT-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	READ TRACK ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=ERROR STATUS
;	USES:	ALL
;

RDTRKE:
	MVI	A,(BRDTRK-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	WRITE TRACK ENTRY
;
;	ENTRY:	NONE
;	EXIT:	(A)=ERROR STATUS
;	USES:	ALL
;

WRTRKE:
	MVI	A,(BWRTRK-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	WRITE PROTECT CHECK
;
;	ENTRY:	NONE
;	EXIT:	(A)=STATUS     (0=R/W , 1=R/O)
;	USES:	ALL
;

WPCE:
	MVI	A,(BWPC-CBOOT)/3	;SET FUNCTION #
	JMP	SWAP88			;RETURN VIA 'SWAP88'


;**	CLEAR BUFFERS FOR DRIVE
;
;	ENTRY:	NONE
;	EXIT:	NONE
;	USES:	ALL
;

CLRBUFD:
	MVI	A,(BCBD-CBOOT)/3	;SET FUNCTION #
;	JMP	SWAP88			;RETURN VIA 'SWAP88'
	IF	$ NE SWAP88
%:	SWAP88 MUST BE NEXT
	ENDIF

	PAGE
;*	SWAP88 -- SWAP TO 8088 PROCESSOR
;
;	ENTRY:	(A)=FUNCTION #
;	EXIT:	(A),(HL)=VALUES PASSED BACK IN COMMUNICATION REGION
;	USES:	ALL
;

SWAP88:
	STA	COMFUNC			;SAVE FUNCTION # IN COM REGION
	SHLD	COMRHL			;STORE (HL) IN COM REGION
	MOV	H,B			;STORE (BC) IN COM REGION
	MOV	L,C
	SHLD	COMRBC
	XCHG				;STORE (DE) IN COM REGION
	SHLD	COMRDE

SWAP881:
	DI				;INSURE INTERRUPTS IN 8085 ARE OFF
	MVI	A,ZPSPPS5		;TURN OFF 8088'S PROCESSING OF INT'S
	OUT	ZPSP
	MVI	A,ZPSPPS8		;8088 PROCESSOR GETTING CONTROL
	STA	COMWHO
	OUT	ZPSP			;SWAP PROCESSOR TO 8088

	LDA	COMRA			;RETRIEVE (A)
	LHLD	COMRHL			;RETRIEVE (HL)

	RET

	PAGE
;**	DATA STORAGE
;

XLATES	DS	0			;XLATE TABLE ADDRESSES
	DW	0			; NO XLATE
	DW	XLATE1			; 8" SINGLE DENSITY
	DW	XLATE2			; 8" DOUBLE DENSITY

XLATE1	DS	0		;8" SINGLE DENSITY SECTOR TRANSLATE TABLE
	DB	1,7,13,19,25
	DB	5,11,17,23
	DB	3,9,15,21
	DB	2,8,14,20,26
	DB	6,12,18,24
	DB	4,10,16,22

XLATE2	DS	0		;8" DOUBLE DENSITY SECTOR TRANSLATE TABLE
	DB	1,2,19,20,37,38
	DB	3,4,21,22,39,40
	DB	5,6,23,24,41,42
	DB	7,8,25,26,43,44
	DB	9,10,27,28,45,46
	DB	11,12,29,30,47,48
	DB	13,14,31,32,49,50
	DB	15,16,33,34,51,52
	DB	17,18,35,36

PATCH	DS	64			;PATCH AREA

DIRBUF	DS	128

DPB1A	DS	DPBL
CSV1A	DS	64
ALV1A	DS	77
DPB1B	DS	DPBL
CSV1B	DS	64
ALV1B	DS	77
DPB1C	DS	DPBL
CSV1C	DS	64
ALV1C	DS	77
DPB1D	DS	DPBL
CSV1D	DS	64
ALV1D	DS	77
DPB2A	DS	DPBL
ALV2A	DS	256
DPB2B	DS	DPBL
ALV2B	DS	256

	DS	8			;STACK AREA
STACK	DS	0

BIOSEND	EQU	$-1


	END
	77
DP