;DISK UTILITY -
;DU.ASM 8/6/78 BY WARD CHRISTENSEN
;11/12/78 ADD LOGIN COMMAND
;11/26/78 ADD DISK # TO LOGIN COMMAND
;02/25/79 PUT SECTOR READ INTO "S" COMMAND
;03/15/79 ADD CHANGES FOR CP/M ON MICROPOLIS
;	  FIX WRAP-AROUND FROM TRACK 0 TO TRACK 76
;	  ON MINUS COMMAND.
;	  (BY KEITH PETERSEN, W8SDZ)
;03/18/79 ADD CHANGES TO CALCGRP ROUTINE TO ALLOW FOR
;	  CONDITIONAL ASSEMBLY FOR CP/M ON MICROPOLIS.
;	  ALSO REMOVED NSTAR CONDITIONAL ASSEMBLIES I PUT
;	  INTO 3/15/79 VERSION.  CP/M ON NORTHSTAR IS SAME AS
;	  STANDARD CP/M FOR THE SECTOR TABLE.
;	  (BY KEITH PETERSEN, W8SDZ)
;07/03/79 MODIFIED FOR HEATH H8 CP/M BY BOB MATHIAS.
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
STDCPM	EQU	TRUE	;TRUE HERE FOR STDCPM, FALSE FOR MICROP
MICROP	EQU	FALSE
H8CPM	EQU	FALSE
	IF	NOT H8CPM
BASE	EQU	0
	ENDIF
	IF	H8CPM
BASE	EQU	4200H
	ENDIF
FORG; 
;Functions supported:
;
;	Tnn	Seek to track nn (no read)
;	Snn	Position to sector nn, and read
;	Gnn	Position to group nn and read.
;	Fname	print directory for file "name"
;		N-O-T-E this is not a direct disk
;		read, so the W command MAY NOT be
;		executed after 'F'. (must do G, +
;		or - command first)
;
;	L	Logs in the disk (used if a disk other
;		than the one DU resides on, is placed
;		in the system)
;
;	Ln	Logs in disk 'n', such as: LA
;
;	D	Dump sector, hex + ASCII
;	A	Dump sector, ASCII only
;	H	Dump sector, hex only
;
;note all dump commands (D, A, H) may be optionally
;	followed by a starting and ending address:
;	D0,7F  is the same as just D
;	D3,5
;	A20,3F
;
;	CHaddr,val,val,val... change hex in sector
;	CAaddr,char string... change ASCII in sector
;		(must W to have changes written to disk)
;Note that the C command echoes the overlaid data for
;	verification
;
;	+	advance 1 sector (if below track 2,
;		this advances to next numerical, if
;		2 or >, advances based on CP/M's normal
;		sector scrambling algorithm, i.e. so +
;		will get the next logical sector of the file
;	-	backs up 1 logical sector
;
;		note + and - may take an amount:
;		for example, +F steps in 15 sectors
;
;	?	Says what sector, track, and group
;		are current
;	R	Reads the sector currently positioned to
;		into memory.  Note R (Read) is implicit in
;		the G, +, and - commands, but N-O-T in the
;		S and T commands (I did it because I was
;		tired of disk reading after T command before
;		I had a chance to issue the S command)
;	W	Write back the current sector (N-O-T-E may
;		not be used after an F command, as CP/M was
;		used to find the file in the directory
;	X	Exit back to CP/M (Must press return).	Ctl-c
;		was too easy to hit over modem lines, so I
;		decided on 2-byte (X, CR) to exit.
;
	ORG	BASE+100H
	LXI	SP,STACK
;SET UP LOCAL JMPS TO BIOS
	LHLD	BASE+1
	LXI	D,3
	DAD	D
	SHLD	VCONST+1
	DAD	D
	SHLD	VCONIN+1
	DAD	D
	SHLD	VCONOUT+1
	DAD	D	;LIST
	DAD	D	;PUNCH
	DAD	D	;RDR
	DAD	D
	SHLD	VHOME+1
	DAD	D	;SEL DISK
	DAD	D
	SHLD	VSETTRK+1
	DAD	D
	SHLD	VSETSEC+1
	DAD	D
	SHLD	VSETDMA+1
	DAD	D
	SHLD	VREAD+1
	DAD	D
	SHLD	VWRITE+1
	CALL	ILPRT
	DB	'DISK UTIL 7/03/79',0DH,0AH,0
PROMPT	LXI	SP,STACK
	CALL	RDBUF
	LXI	H,INBUF
	MOV	A,M
	INX	H
	CPI	'T'
	JZ	POS
	CPI	'S'
	JZ	POS
	CPI	'G'
	JZ	POS
	CPI	'F'
	JZ	POSFIL
	CPI	'L'
	JZ	LOGIN
	CPI	'D'
	JZ	DUMP
	CPI	'A'
	JZ	DUMP
	CPI	'H'
	JZ	DUMP
	CPI	'C'
	JZ	CHG
	CPI	'+'
	JZ	PLUS
	CPI	'-'
	JZ	MINUS
	CPI	'?'
	JZ	INQ
	CPI	'R'
	JZ	DOREAD
	CPI	'W'
	JZ	DOWRITE
	CPI	'X'
	JZ	BASE
	IF	H8CPM
	CPI	'8'
	JZ	H8SET
	ENDIF
WHAT	CALL	ILPRT
	DB	'?',0
	JMP	PROMPT
	IF	H8CPM
H8SET	EQU	$
	XRA	A
	STA	H8MODE		;RESET TO CPM MODE
	MOV	A,M
	CPI	'+'
	JNZ	PROMPT
	MVI	A,1
	STA	H8MODE
	JMP	PROMPT
H8MODE	DB	0
	ENDIF
LOGIN	MVI	C,RESETDK
	CALL	BDOS
	LDA	INBUF+1 ;DISK REQ?
	LXI	D,0
	CPI	0DH
	JZ	LGNODK
	SUI	'A'
	MOV	E,A
LGNODK	MVI	C,SELDK
	CALL	BDOS
	CALL	NOWRITE
	JMP	PROMPT
;
NOWRITE XRA	A	;GET 0
	STA	WRFLG	;CAN'T WRITE NOW
	RET
;
DUMP	LDA	WRFLG
	ORA	A
	JNZ	DUMPOK
	CALL	ILPRT
	DB	'++CAN''T DUMP, NO SECTOR READ.',0DH,0AH,0
EXPL	CALL	ILPRT
	DB	'USE G COMMAND FOLLOWING F,',0DH,0AH
	DB	'OR R FOLLOWING S OR T',0DH,0AH,0
	JMP	PROMPT
;
DUMPOK	MOV	A,M
	CPI	0DH
	JNZ	DUMPNDF
;USE DEFAULT
	LXI	B,0
	LXI	D,7FH
	JMP	DUMP1
DUMPNDF CALL	HEXIN
	MOV	B,D
	MOV	C,E
	CPI	0DH
	JZ	DUMP1
	INX	H	;SKIP ','
	CALL	HEXIN
;
;BC = START, DE = END
;
DUMP1	MOV	A,B
	ORA	D
	JNZ	WHAT
	MOV	A,C
	ORA	E
	JM	WHAT	;>7FH
	MOV	H,B
	MOV	A,C
	ORI	80H
	MOV	L,A
	MOV	A,E
	ORI	80H
	MOV	E,A
	IF	H8CPM
	MVI	H,42H
	ENDIF
DUMPLP	MOV	A,L
	ANI	7FH
	CALL	HEX
	CALL	SPACE
	CALL	SPACE
	LDA	INBUF
	CPI	'A'
	JZ	DUMPAS
	PUSH	H	;SAVE START
DHEX	MOV	A,M
	CALL	HEX
	MOV	A,L
	ANI	3
	CPI	3
	CZ	SPACE
	MOV	A,L
	ANI	7
	CPI	7
	CZ	SPACE
	MOV	A,E
	CMP	L
	JZ	DPOP
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DHEX
DPOP	LDA	INBUF
	CPI	'H'
	JZ	DNOAS	;HEX ONLY
	POP	H	;GET START ADDR
DUMPAS	CALL	ASTER
DCHR	MOV	A,M
	CPI	' '
	JC	DPER
	CPI	7FH
	JC	DOK
DPER	MVI	A,'.'
DOK	CALL	TYPE
	MOV	A,E
	CMP	L
	JZ	DEND
	INX	H
	MOV	A,L
	ANI	0FH
	JNZ	DCHR
DEND	CALL	ASTER
	CALL	CRLF
	CALL	CONST
	INR	A
	JZ	PROMPT
	MOV	A,E
	CMP	L
	JZ	PROMPT
	JMP	DUMPLP
DNOAS	POP	B
	CALL	CRLF
	MOV	A,E
	CMP	L
	JZ	PROMPT
	JMP	DUMPLP
;
;POSITION
;
POS	PUSH	PSW
	CALL	NOWRITE
	MOV	A,M
	CPI	0DH
	JZ	WHAT
	CALL	HEXIN
	POP	PSW
	CPI	'T'
	JZ	POSTRK
	CPI	'S'
	JZ	POSSEC
	CPI	'G'
	JZ	POSGRP
	JMP	WHAT
;
POSTRK	MOV	A,E
	CALL	SETTRK
	JMP	CALCGRP
POSSEC	MOV	A,E
	ORA	A
	JZ	WHAT
	IF	STDCPM
	CPI	27
	ENDIF
	IF	MICROP
	CPI	33
	ENDIF
	IF	H8CPM
	CPI	21
	ENDIF
	JNC	WHAT
	CALL	SETSEC
	CALL	READ
;
CALCGRP LDA	CURTRK
	IF	NOT H8CPM
	SUI	2	;GRP 0 IS TRK 2
	ENDIF
	IF	H8CPM
	SUI	3	;GRP 0 IS TRK 3
	ENDIF
	MOV	L,A
	MVI	H,0
	MOV	D,H
	MOV	E,L
	DAD	H	;X2
	IF	STDCPM
	DAD	D	;X3
	DAD	H	;X6
	DAD	H	;X12
	DAD	D	;X13
	DAD	H	;X26
	ENDIF
	IF	MICROP
	DAD	H	;X4
	DAD	H	;X8
	DAD	H	;X16
	DAD	H	;X32
	ENDIF
	IF	H8CPM
	DAD	H	;X4
	DAD	H	;X8
	DAD	D	;X9
	DAD	D	;X10
	DAD	H	;X20
	ENDIF
	LDA	CURSEC
	DCR	A
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	MOV	A,L
	IF	STDCPM
	ANI	7
	ENDIF
	IF	MICROP
	ANI	15
	ENDIF
	IF	H8CPM
	ANI	7
	ENDIF
	STA	DISP
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	IF	STDCPM OR H8CPM
	DAD	H
	ENDIF
	MOV	A,H
	STA	GROUP
	JMP	INQ
;
POSGRP	MOV	A,E
	STA	GROUP
	XRA	A
	STA	DISP
	MOV	L,E	;MULTIPLY
	MVI	H,0	;BY 8
	DAD	H
	DAD	H
	DAD	H
	IF	MICROP
	DAD	H	;MULTIPLY BY 16 INSTEAD OF 8
	ENDIF
	IF	STDCPM
;DIVIDE BY 26, QUOTIENT = TRK, REMAINDER = SECTOR
	LXI	D,-26
	ENDIF
	IF	MICROP
;DIVIDE BY 32, QUOTIENT = TRK, REMAINDER = SECTOR
	LXI	D,-32
	ENDIF
	IF	H8CPM
	LXI	D,-20
	ENDIF
	MVI	B,0	;TRK
DIVLP	INR	B
	DAD	D
	JC	DIVLP
	DCR	B
	IF	STDCPM
	LXI	D,26
	ENDIF
	IF	MICROP
	LXI	D,32
	ENDIF
	IF	H8CPM
	LXI	D,20
	ENDIF
	DAD	D
	MOV	A,B
	IF NOT H8CPM
	ADI	2	;GROUP 0 IS TRK 2
	ENDIF
	IF	H8CPM
	ADI	3	;GROUP 0 IS TRK 3
	ENDIF
	CALL	SETTRK
	MOV	A,L
	INR	A
	CALL	SETSEC
	CALL	READ
	JMP	INQ
;
POSFIL	CALL	NOWRITE
	LXI	D,FCB
	XRA	A
	STAX	D
	INX	D
	MVI	B,8
	CALL	MVNAME
	MVI	B,3
	CALL	MVNAME
	LXI	D,FCB
	MVI	C,OPEN
	CALL	BDOS
	INR	A
	JNZ	FLOK
	CALL	ILPRT
	DB	'++FILE NOT FOUND',0
	JMP	PROMPT
FLOK	DCR	A
	ANI	3
	MOV	L,A
	MVI	H,0
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	LXI	D,BASE+80H
	DAD	D
	LXI	D,32
	XCHG
	DAD	D
	XCHG
	MVI	A,'I'
	STA	INBUF+1
	JMP	DUMPLP
;
MVNAME	MOV	A,M
	CPI	'.'
	JZ	MVIPAD
	CPI	0DH
	JZ	PAD
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	MVNAME
	MOV	A,M
	CPI	0DH
	RZ
	INX	H
	CPI	'.'
	RZ
	JMP	WHAT
MVIPAD	INX	H
PAD	MVI	A,' '
	STAX	D
	INX	D
	DCR	B
	JNZ	PAD
	RET
;
PLUS	LXI	D,1
	MOV	A,M
	CPI	0DH
	JZ	PLUSGO
	CALL	HEXIN
PLUSGO	LDA	CURSEC
	INR	A
	IF	STDCPM
	CPI	27
	ENDIF
	IF	MICROP
	CPI	33
	ENDIF
	IF	H8CPM
	CPI	21
	ENDIF
	JNZ	PLUSOK
	LDA	CURTRK
	INR	A
	STA	CURTRK
	MVI	A,1
PLUSOK	STA	CURSEC
	DCR	E
	JNZ	PLUSGO
PLUSMI	LDA	CURSEC
	CALL	SETSEC
	LDA	CURTRK
	CALL	SETTRK
	CALL	READ
	JMP	CALCGRP
;
MINUS	LXI	D,1
	MOV	A,M
	CPI	0DH
	JZ	MINGO
	CALL	HEXIN
MINGO	LDA	CURSEC
	DCR	A
	JNZ	MINOK
	LDA	CURTRK
	DCR	A
	STA	CURTRK
	IF	STDCPM
	MVI	A,26
	ENDIF
	IF	MICROP
	MVI	A,32
	ENDIF
	IF	H8CPM
	MVI	A,20
	ENDIF
MINOK	STA	CURSEC
	DCR	E
	JNZ	MINGO
	JMP	PLUSMI
;
INQ	LDA	CURTRK
	CPI	2
	JC	NOGRP
	CALL	ILPRT
	DB	'G=',0
	LDA	GROUP
	CALL	HEX
	MVI	A,':'
	CALL	TYPE
	LDA	DISP
	IF	STDCPM OR H8CPM
	ORI	'0'
	CALL	TYPE
	ENDIF
	IF	MICROP
	CALL	HEX
	ENDIF
	MVI	A,','
	CALL	TYPE
NOGRP	CALL	ILPRT
	DB	' T=',0
	LDA	CURTRK
	CALL	HEX
	CALL	ILPRT
	DB	', S=',0
	LDA	CURSEC
	CALL	HEX
	JMP	PROMPT
;
CHG	MOV	A,M	;GET TYPE (HEX, ASCII)
	PUSH	PSW
	INX	H
	CALL	HEXIN
	INX	H
	CPI	','
	JNZ	WHAT
	MOV	A,D
	ORA	A
	JNZ	WHAT
	MOV	A,E
	ORA	A
	JM	WHAT
	ORI	80H
	MOV	E,A	;POINT TO BUFFER
	IF	H8CPM
	MVI	D,42H
	ENDIF
	POP	PSW
	CPI	'H'
	JZ	CHGHEX
	CPI	'A'
	JNZ	WHAT
;CHANGE ASCII
CHGALP	MOV	A,M
	CPI	0DH
	JZ	PROMPT
	LDAX	D
	CPI	' '
	JC	CHGAHX
	CPI	7FH
	JNC	CHGAHX
	JMP	CHGA2
CHGAHX	MVI	A,'('
	CALL	TYPE
	LDAX	D
	CALL	HEX
	MVI	A,')'
CHGA2	CALL	TYPE
	MOV	A,M
	STAX	D
	INX	H
	INR	E
	JNZ	CHGALP
	MOV	A,M
	CPI	0DH
	JZ	PROMPT
	JMP	WHAT
;CHANGE HEX
CHGHEX	MOV	A,M
	CPI	0DH
	JZ	PROMPT
	PUSH	D
	CALL	HEXIN
	MOV	A,E
	POP	D
	PUSH	PSW
	LDAX	D
	CALL	HEX
	POP	PSW
	STAX	D
	MOV	A,M
	CPI	0DH
	JZ	PROMPT
	CPI	','
	INX	H
	INR	E
	JNZ	CHGHEX
	MOV	A,M
	CPI	0DH
	JZ	PROMPT
	JMP	WHAT
;
DOREAD	CALL	READ
	JMP	PROMPT
DOWRITE CALL	WRITE
	JMP	PROMPT
;
HEX	PUSH	PSW
	RAR
	RAR
	RAR
	RAR
	CALL	NIBBL
	POP	PSW
NIBBL	ANI	0FH
	CPI	10
	JC	HEXNU
	ADI	7
HEXNU	ADI	'0'
	JMP	TYPE
;
SPACE	MVI	A,' '
	JMP	TYPE
ASTER	MVI	A,'*'
	JMP	TYPE
;
ILPRT	XTHL
ILPLP	MOV	A,M
	CALL	TYPE
	INX	H
	MOV	A,M
	ORA	A
	JNZ	ILPLP
	INX	H
	XTHL
	RET
;
HEXIN	LXI	D,0
HINLP	MOV	A,M
	CPI	0DH
	RZ
	CPI	','
	RZ
	CPI	'0'
	JC	WHAT
	CPI	'9'+1
	JC	HINNUM
	CPI	'A'
	JC	WHAT
	CPI	'F'+1
	JNC	WHAT
	SUI	7
HINNUM	SUI	'0'
	XCHG
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	ADD	L
	MOV	L,A
	XCHG
	INX	H
	JMP	HINLP
RDBUF	CALL	ILPRT
	DB	0DH,0AH,':',0
	LXI	H,INBUF
	MVI	B,0
RDBLP	PUSH	H
	CALL	CONIN
	POP	H
	CPI	'U'-40H
	JZ	RDCTLU
	CPI	0DH
	JZ	RDCR
	CPI	8
	JZ	RDBS
	CPI	7FH
	JZ	RDBS
	CPI	'R'-40H
	JZ	RDCTLR
	MOV	M,A
	INX	H
	INR	B
	CALL	TYPE
	JMP	RDBLP
RDCR	MOV	M,A
	CALL	TYPE
	MVI	A,0AH
	CALL	TYPE
	RET
RDBS	XRA	A
	ORA	B
	JZ	RDCTLU
	DCX	H
	DCR	B
	MOV	A,M
	CALL	TYPE
	JMP	RDBLP
RDCTLR	MVI	M,0DH
	CALL	CRLF
	LXI	H,INBUF
	MVI	B,0
RDCRL	MOV	A,M
	CPI	0DH
	JZ	RDBLP
	CALL	TYPE
	INR	B
	INX	H
	JMP	RDCRL
RDCTLU	MVI	A,'^'
	CALL	TYPE
	MVI	A,'U'
	CALL	TYPE
	JMP	RDBUF
CRLF	MVI	A,0DH
	CALL	TYPE
	MVI	A,0AH
	JMP	TYPE
MOVER	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVER
	RET
CONST:
VCONST	JMP	$-$
CONIN:
VCONIN	JMP	$-$
TYPE:
	MOV	C,A
	PUSH	H
	CALL	VCONOUT
	POP	H
	RET
VCONOUT JMP	$-$
HOME:
VHOME	JMP	$-$
	IF	H8CPM
SETTRK	CPI	40	;TRAP OUT MORE THAT 40
	ENDIF
	IF	NOT H8CPM
SETTRK	CPI	77	;TRAP OUT MORE THAN 77
	ENDIF
	JC	SETTRK2
	IF	H8CPM
	MVI	A,39	;41TH TRACK IS 39
	ENDIF
	IF	NOT H8CPM
	MVI	A,76	;77TH TRACK IS 76
	ENDIF
SETTRK2 STA	CURTRK
	MOV	C,A
VSETTRK JMP	$-$
SETSEC	STA	CURSEC
	MOV	C,A
	LDA	CURTRK
	IF	NOT H8CPM
	CPI	2
	ENDIF
	IF	H8CPM
	CPI	3
	ENDIF
	JC	VSETSEC ;DON'T SCRAMBLE TRK'S 0-1
	IF	H8CPM
	LDA	H8MODE
	ANA	A
	JNZ	VSETSEC
	ENDIF
	PUSH	H
	LXI	H,SECTBL-1
	MOV	A,C
	ADD	L
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A
	MOV	A,M
	POP	H
	MOV	C,A
VSETSEC JMP	$-$
SETDMA:
VSETDMA JMP	$-$
READ:
	MVI	A,1
	STA	WRFLG
VREAD	JMP	$-$
WRITE:
	LDA	WRFLG
	ORA	A
	JNZ	VWRITE
	CALL	ILPRT
	DB	'++CANNOT WRITE UNLESS READ ISSUED'
	DB	0DH,0AH,0
	JMP	EXPL
VWRITE	JMP	$-$
; 
	IF	STDCPM
SECTBL	DB	1,7,13,19,25,5,11,17,23,3,09,15,21
	DB	2,8,14,20,26,6,12,18,24,4,10,16,22
	ENDIF
; 
	IF	MICROP
SECTBL	DB	1,2,11,12,21,22,31,32,9,10,19,20,29,30,7,8
	DB	17,18,27,28,5,6,15,16,25,26,3,4,13,14,23,24
	ENDIF
	IF	H8CPM
SECTBL	DB	1,2,9,10,17,18,5,6,13,14,3,4,11,12,19,20,7,8,15,16
	ENDIF
; 
GROUP	DB	0
DISP	DB	0
CURTRK	DB	0
CURSEC	DB	1
WRFLG	DB	0	;MAY NOT WRITE UNTIL '+', '-',
;			 OR 'G' COMMAND
	DS	40
STACK:
INBUF	DS	128
FCB	EQU	BASE+5CH
BDOS	EQU	BASE+5
RESETDK EQU	13
SELDK	EQU	14
OPEN	EQU	15
; 
	END	BASE+100H
 
40
STACK:
INBUF	DS	128
FCB	EQU	BASE+5CH
BDOS	EQU	BASE+5
RESETDK EQU	13
SELDK	EQU	14
OPEN	EQU	15
; 
	END	BASE+100H
