;	KEYMAP -- MAP FUNCTION KEYS TO USER DEFINED CHARACTERS
;
;	THIS PROGRAM MAPS THE VARIOUS FUNCTION KEYS TO USER
;	DEFINED CHARACTER SEQUENCES.  THE SEQUENCE FOR ANY
;	ONE KEY CAN BE UP TO 20 CHARACTERS.
;
;	THIS VERSION IS FOR USE UNDER CP/M-85 ON H/Z-100 COMPUTERS
;
;	BY P. SWAYNE, HUG  25-FEB-85
;	COPYRIGHT (C) 1985 BY HEATH USERS' GROUP

;	DEFINITIONS

TEST	EQU	0		;ASSEMBLE TEST VERSION IF -1

BIOS	EQU	0		;BIOS JUMP VECTOR
BDOS	EQU	5		;BDOS JUMP VECTOR
CURDSK	EQU	4		;CURRENT DISK CELL
CCPSIZ	EQU	800H		;SIZE OF CCP
DCIO	EQU	6		;DIRECT CONSOLE I/O
PRINTF	EQU	9		;TYPE STRING

	ORG	100H

START:	LHLD	BIOS+1		;GET BIOS VECTOR
	INX	H		;SKIP JUMP
	MOV	E,M
	INX	H
	MOV	D,M		;DE = WARM BOOT
	CALL	CPHD		;TEST IF KEYMAP ALREADY IN
	JC	LDED		;SOMETHING'S IN, EXIT
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	LXI	D,5
	DAD	D		;MOVE TO SIGNATURE
	MOV	A,M		;GET FIRST CHARACTER
	CPI	'K'		;IS IT "P"?
	JNZ	NTLDED		;IF NOT, KEYMAP NOT LOADED
	INX	H
	MOV	A,M		;GET SECOND CHARACTER
	CPI	'M'		;IS IT "S"?
	JNZ	NTLDED		;NO, OK TO LOAD
LDED:	LXI	D,ITSIN
	MVI	C,PRINTF
	CALL	BDOS		;ELSE, SAY "IT'S IN"
	JMP	BIOS		;RETURN TO CP/M

;	PREPARE TO RELOCATE CODE

NTLDED:	LHLD	BIOS+1		;GET BIOS TABLE ADDRESS
	INX	H		;SKIP JUMP INST.
	MOV	E,M		;GET ADDRESS
	INX	H
	MOV	D,M		;DE = WARM BOOT ADDRESS
	XCHG
	SHLD	OLDWB		;SAVE OLD WARM BOOT ADDRESS
	XCHG
	LHLD	BDOS+1		;GET BDOS ADDRESS
	LXI	D,-(JBDOS+CCPSIZ+RESMEM)	;CODE START + SPACE ALLOWED
	DAD	D		;CALCULATE OFFSET FOR MOVED CODE
	SHLD	BIAS		;STORE IT
	LXI	H,MYCONST	;HL = ORG ADDR
	LXI	D,CODEND 	;END OF CODE TO FIX
LOCAT0	MOV	A,M		;GET OPCODE
	MOV	B,A		;SAVE IT
	PUSH	H		;SAVE ADDRESS

; LOCATE TWO AND THREE BYTE OPCODES

	LXI	H,THBYT		;THREE BYTE TABLE
LOCAT1	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT5		;YES, PROCESS IT
	CPI	0F7H		;END OF TABLE?
	INX	H
	JNZ	LOCAT1		;IF NOT, CONTINUE
	LXI	H,TWBYT		;TWO BYTE TABLE
LOCAT2	MOV	A,M		;GET TABLE OPCODE
	CMP	B		;MATCHES PROGRAM OPCODE?
	JZ	LOCAT3		;YES, SKIP DATA BYTE
	CPI	0F7H		;END OF TABLE?
	INX	H		;MOVE POINTER
	JNZ	LOCAT2		;IF NOT, CONTINUE
	JMP	LOCAT4		;ONE BYTE INSTRUCTION
LOCAT3	POP	H		;RESTORE ADDRESS POINTER
	INX	H		;SKIP DATA BYTE
	PUSH	H		;SAVE ADDRESS
LOCAT4	POP	H		;RESTORE ADDRESS
	CALL	CPHD		;END OF PROGRAM?
	JNC	LOCAT0		;IF NOT, CONTINUE
	JMP	LOCAT8		;CODE FIXED

; FIX THREE BYTE INSTRUCTIONS

LOCAT5	POP	H		;RESTORE ADDRESS
	INX	H		;POINT TO CODE ARGUMENT
	PUSH	D		;SAVE END POINTER
	MOV	E,M
	INX	H
	MOV	D,M		;DE = ADDR TO CHECK
	PUSH	H		;SAVE ADDRESS POINTER
	LXI	H,JBDOS-1 	;CHECK IF ADDRESS IS
	CALL	CPHD		;BELOW PROGRAM?
	JC	LOCAT6		;IF SO, DO NOT ADJUST
	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
	DCX	H		;ADDR LOW BYTE
	LDA	BIAS		;FIX CODE
	ADD	M
	MOV	M,A
	INX	H
	LDA	BIAS+1
	ADC	M
	MOV	M,A		;ADDR = ADDR + BIAS
	JMP	LOCAT7
LOCAT6	POP	H		;RESTORE ADDRESS
	POP	D		;RESTORE END POINTER
LOCAT7	CALL	CPHD		;END OF FIXABLE CODE?
	JNC	LOCAT0		;IF NOT, CONTINUE
LOCAT8:	LHLD	BIAS		;GET RELOCATION BIAS
	MOV	B,H
	MOV	C,L		;IN BC
	LXI	H,MAPTBL	;POINT TO MAP TABLE
	MVI	A,41		;SET A COUNTER
FIXTBL:	MOV	E,M		;GET TABLE ENTRY
	INX	H
	MOV	D,M
	XCHG
	DAD	B		;ADD BIAS
	XCHG
	MOV	M,D		;REPLACE ENTRY
	DCX	H
	MOV	M,E
	INX	H
	INX	H		;MOVE TO NEXT ENTRY
	DCR	A		;COUNT THIS ONE
	JNZ	FIXTBL		;ENSURE ALL ENTRIES FIXED


;	CODE IS FIXED, NOW ALTER BIOS TABLE

	LHLD	BIOS+1		;GET BIOS TABLE ADDRESS
	INX	H		;SKIP JUMP INSTRUCTION
	LXI	D,MYWBOOT	;GET MY WARM BOOT ADDRESS
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	MOV	M,E		;INSERT IT IN BIOS TABLE
	INX	H
	MOV	M,D
	INX	H
	INX	H		;MOVE TO CONST ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONST ADDRESS
	XCHG
	SHLD	CONSTV		;SET UP CONST CALL
	XCHG
	LXI	D,MYCONST	;GET MY CONST VECTOR
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D		;STICK IT IN BIOS
	INX	H
	INX	H		;MOVE TO CONIN ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONIN ADDRESS
	XCHG
	SHLD	CONINV		;SET UP CONIN CALL
	XCHG
	LXI	D,MYCONIN	;GET MY CONIN VECTOR
	XCHG
	DAD	B		;ADD OFFSET
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D		;STICK IT IN BIOS
	INX	H
	INX	H		;MOVE TO CONOUT ADDRESS
	MOV	E,M
	INX	H
	MOV	D,M		;DE = CONOUT ADDRESS
	XCHG
	SHLD	CONOUTV		;SET UP CONOUT CALL
	LHLD	BDOS+1		;GET BDOS ADDRESS
	PUSH	H		;SAVE IT
	SHLD	JBDOS+1		;SAVE IT HERE, TOO
	LXI	D,-(CCPSIZ+3)
	DAD	D		;CALCULATE CCP CLEAR START ADDR
	SHLD	JCCP		;SET UP WARM BOOT EXIT
	LXI	H,JBDOS
	DAD	B		;ADD OFFSET
	SHLD	BDOS+1		;UPDATE BDOS VECTOR
	POP	H		;GET OLD BDOS ADDRESS
	LXI	D,-(CCPSIZ+RESMEM)
	DAD	D		;SUBTRACT CCP AND PROGRAM SIZE
	LXI	D,JBDOS		;KEYMAP CODE STARTS HERE
	LXI	B,LEND-JBDOS	;SIZE OF CODE
MOVE	LDAX	D		;GET A BYTE
	MOV	M,A		;MOVE IT
	INX	H		;INCREMENT POINTERS
	INX	D
	DCX	B		;DECREMENT COUNTER
	MOV	A,B
	ORA	C		;DONE?
	JNZ	MOVE		;LOOP UNTIL DONE
	LXI	D,LMSG
	MVI	C,PRINTF
	CALL	BDOS		;PRINT SIGN ON MSG
	LXI	H,SPADM		;POINT TO BOTTOM MESSAGE
	MVI	B,0
MLOOP:	MOV	A,M
	CPI	1AH		;END OF MSG?
	JZ	BIOS		;RETURN TO CP/M
	PUSH	H
	PUSH	B
	MVI	C,DCIO
	MOV	E,A
	CALL	BDOS		;PRINT BOTTOM LINE MSG CHARACTER
	POP	B
	POP	H
	INX	H
	DCR	B
	JNZ	MLOOP
	JMP	BIOS

; COMPARE HL TO DE

CPHD	INX	H		;INCREMENT HL
	MOV	A,E
	SUB	L
	MOV	A,D
	SBB	H
	RET

; TABLE OF THREE BYTE INSTRUCTIONS
; THAT REQUIRE FIXING

THBYT	DB	01H		;LXI B
	DB	11H		;LXI D
	DB	21H		;LXI H
	DB	31H		;LXI SP
	DB	22H		;SHLD
	DB	2AH		;LHLD
	DB	32H		;STA
	DB	3AH		;LDA
	DB	0CDH		;CALL
	DB	0CCH		;CZ
	DB	0C3H		;JMP
	DB	0C2H		;JNZ
	DB	0CAH		;JZ
	DB	0D2H		;JNC
	DB	0DAH		;JC
	DB	0F2H		;JP
	DB	0FAH		;JM
	DB	0F7H		;END OF TABLE

; TWO BYTE OPCODES

TWBYT	DB	3EH		;MVI A
	DB	6		;MVI B
	DB	0EH		;MVI C
	DB	16H		;MVI D
	DB	1EH		;MVI E
	DB	26H		;MVI H
	DB	2EH		;MVI L
	DB	36H		;MVI M
	DB	0C6H		;ADI
	DB	0CEH		;ACI
	DB	0D6H		;SUI
	DB	0E6H		;ANI
	DB	0EEH		;XRI
	DB	0FEH		;CPI
	DB	0D3H		;OUT
	DB	0DBH		;IN
	DB	0F7H		;END OF TABLE

BIAS	DW	0		;RELOCATION BIAS
LMSG	DB	13,10
	DB	'CP/M-85 KEYMAP Function Key Mapper, Version 1.0'
	DB	' (by PS:) is now installed.$'
ITSIN	DB	13,10
	DB	'ERROR -- KEYMAP or other extension '
	DB	'already loaded.$'

;	RESIDENT CODE STARTS HERE

JBDOS	JMP	0		;BDOS JUMP VECTOR
OLDWB	DW	0		;OLD WARM BOOT ADDR
	DB	'KM'		;INDICATION THAT KEYMAP IS LOADED

;	THIS IS THE MAIN CODE THAT INTERCEPTS BIOS CONSOLE
;	STATUS AND INPUT CALLS TO DETECT FUNCTION KEYS AND
;	MAP THE USER-DEFINED CHARACTERS TO THEM

;	MY CONSOLE STATUS ROUTINE

MYCONST:LDA	MAPFLG
	ORA	A		;ARE WE MAPPING
	JNZ	MAPST		;YES
CCONST:	JMP	0		;GET CONSOLE STATUS
CONSTV	EQU	$-2		;(PUT CONST VECTOR HERE)
MAPST:	LHLD	MAPPTR		;GET MAP CHARACTER POINTER
	MOV	A,M		;GET NEXT CHARACTER
	ORA	A		;DONE MAPPING?
	JZ	CKRST		;YES, CHECK REGULAR STATUS
	MVI	A,0FFH		;ELSE, RETURN CHAR READY
	RET			;AND EXIT
CKRST:	STA	MAPFLG		;CLEAR MAP FLAG
	JMP	CCONST		;CHECK STATUS

;	MY CONSOLE INPUT ROUTINE

MYCONIN:LDA	MAPFLG
	ORA	A		;ARE WE MAPPING?
	JNZ	MAP		;YES, RETURN MAPPED CHARACTER
NMAP:	CALL	CCONIN		;GET CHARACTER
	CPI	'^'-'@'		;TOGGLE KEYMAP?
TGLK	EQU	$-1
	JZ	TOGGLE		;GO TOGGLE KEYMAP
	CPI	'\'-'@'
OFFLNK	EQU	$-1
	JZ	OFFLIN		;GO OFF LINE
	CPI	27		;ESCAPE?
ESCCHR	EQU	$-1
	RNZ			;NOTHING SPECIAL, RETURN

;	WE HAVE AN ESCAPE CHAR -- SEE IF IT'S PART OF AN ESCAPE SEQUENCE

GOTESC:	LXI	H,TGLFLG
	INR	M
	DCR	M		;TEST FOR OFF/ON TOGGLE
	RNZ			;KEYMAP IS OFF
KEYON:	MVI	C,50		;TRY FOR ESC-CH 50 TIMES
ESCLP:	CALL	CCONST		;CHECK CONSOLE STATUS
	ORA	A
	JNZ	GOTCHR		;GOT A CHARACTER
	DCR	C		;ELSE, DECREMENT COUNTER
	JNZ	ESCLP		;TRY AGAIN
	XRA	A
	STA	ASFLG		;CLEAR ALTERNATE SEL. FLAG
	MVI	A,27
	RET			;RETURN WITH ESC

;	IT'S AN ESCAPE SEQUENCE -- SEE IF IT IS A FUNCTION KEY

GOTCHR:	CALL	CCONIN		;GET NEXT CHARACTER
	LXI	H,HELPKEY	;ASSUME HELP
	CPI	'~'		;IS IT HELP?
	JZ	MHELP
	LXI	H,MAPTBL1	;ASSUME F9-F12
	CPI	'0'		;IS IT?
	JZ	MAPT1		;YES
	LXI	H,MAPTBL2	;ASSUME SHIFT-F KEYS
	CPI	'1'		;IS IT?
	JZ	MAPT2		;YES
	LXI	H,MAPTBL	;ELSE, USE REGULAR TABLE
	CPI	'@'		;"@" OR MORE?
	JC	SPMAP		;NO
	CPI	'W'+1		;"W" OR LESS?
	JNC	SPMAP		;NO
	JMP	GDCHR		;ELSE, GOOD CHARACTER
MHELP:	SUI	'~'-'@'		;FIX A FOR INDEX INTO TABLE
	JMP	NOAS
MAPT1:	PUSH	H
	CALL	CCONIN		;GET NEXT CHARACTER
	POP	H
	SUI	'I'-'@'		;FIX A
	JMP	NOAS
MAPT2:	PUSH	H
	CALL	CCONIN		;GET NEXT CHARACTER
	POP	H
	SUI	1		;FIX AL
MAPT3:	JMP	NOAS		;AND PROCESS KEY
GDCHR:	PUSH	H
	LXI	H,ASFLG
	INR	M
	DCR	M		;WORKING ON ALTERNATE KEY?
	POP	H
	JNZ	NOAS		;IF SO, SKIP SHIFT CHECK
	CPI	0		;IS THIS THE ALTERNATE SEL. KEY?
ASKEY	EQU	$-1
	JNZ	NOAS		;NO
	PUSH	H
	LXI	H,ASFLG
	INR	M		;ELSE, SET ALTERNATE SEL. FLAG
	POP	H
	CALL	CCONIN		;GET SECOND KEY
	CPI	27		;ESCAPE?
	JZ	KEYON		;IT'S ESCAPE, GET NEXT CHARACTER
	PUSH	H
	LXI	H,ASFLG
	DCR	M		;ELSE, CLEAR ALTERNATE SEL. FLAG
	POP	H
	RET	

;	IT'S A VALID FUNCTION KEY -- TURN MAPPING ON

NOAS:	PUSH	H
	LXI	H,MAPFLG
	INR	M		;SET MAP FLAG
	POP	H
	SUI	'@'		;REMOVE ASCII FROM CHARACTER
	ADD	A		;DOUBLE IT
	ADD	L		;ADD RESULT TO HL
	MOV	L,A
	MOV	A,H
	ACI	0
	MOV	H,A		;HL POINTS TO TABLE ENTRY
	MOV	A,M		;GET IT
	INX	H
	MOV	H,M
	MOV	L,A		;HL POINTS TO MAP STRING
	LDA	ASFLG
	ORA	A		;ALTERNATE FUNCTION?
	JZ	NOAS1		;NO
	MVI	D,LTBL SHR 8
	MVI	E,LTBL AND 0FFH	;ELSE, USE SECOND SHIFT TABLE ENTRY
	DAD	D
	XRA	A
	STA	ASFLG		;CLEAR ALTERNATE FLAG
NOAS1:	SHLD	MAPPTR		;SET UP MAP POINTER

;	MAPPING ROUTINE -- SENDS A CHARACTER FROM THE USER SUPPLIED
;	STRING AS LONG AS THE SYSTEM REQUESTS KEYBOARD INPUT, UNTIL
;	THE END OF THE STRING IS REACHED.  THEN NORMAL INPUT IS
;	RESUMED

MAP:	LHLD	MAPPTR		;GET MAP POINTER
	MOV	A,M		;GET MAPPED CHARACTER
	STA	SAVCHR		;SAVE CHARACTER
	INX	H
	MOV	A,M		;PREVIEW NEXT CHARACTER
	ORA	A		;END OF STRING?
	JNZ	NOTEND		;NO
	STA	MAPFLG		;ELSE, CLEAR MAP FLAG
NOTEND:	MVI	A,0		;GET CHARACTER
SAVCHR	EQU	$-1
	SHLD	MAPPTR		;UPDATE MAP POINTER
	RET			;RETURN WITH MAPPED CHARACTER

;	TOGGLE KEYMAP OFF AND ON

TOGGLE:	LDA	TGLFLG
	XRI	1		;TOGGLE TOGGLE FLAG
	STA	TGLFLG
	LXI	H,SPADM		;ASSUME FLAG NOT SET
	JZ	TOGGLE1		;FLAG NOT SET, PRINT BOTTOM MSG
	LDA	BLMSG
	CPI	1AH		;ANY BOTTOM LINE MESSAGE?
	LXI	H,UNSHF		;ASSUME NONE
	JZ	TOGGLE1		;IF NONE, LEAVE BOTTOM LINE ALONE
	LXI	H,ERABL		;ELSE, ERASE IT
TOGGLE1:MVI	B,0		;SET A COUNTER
PBLMSG:	PUSH	B		;SAVE COUNTER
	MOV	A,M		;GET A CHARACTER
	CPI	1AH		;END OF FILE?
	JZ	TOGGLE2		;IF SO, EXIT
	PUSH	H
	MOV	C,A
	CALL	CCNOUT		;PRINT THIS CHAR
	POP	H
	POP	B
	INX	H		;INCREMENT POINTER
	DCR	B
	JNZ	PBLMSG		;IF NOT DONE, CONTINUE
	PUSH	B
TOGGLE2:POP	B		;FIX STACK
	JMP	NMAP		;GET CHARACTER FOR INPUT CALLER

;	TAKE "TERMINAL" OFF LINE, SO USER CAN ENTER ESCAPE SEQUENCES, ETC.

OFFLIN:	MOV	D,A		;SAVE TOGGLE CHARACTER
OFFLP:	PUSH	D
	CALL	CCONIN		;GET A CHARACTER
	POP	D
	CMP	D		;GO BACK ON LINE?
	JZ	NMAP		;YES, GET CHAR FOR INPUT CALLER
	PUSH	D
	MOV	C,A
	CALL	CCNOUT		;ELSE, ECHO CHARACTER
	POP	D
	JMP	OFFLP		;GO AROUND AGAIN

;	MAP NON-DEFINDED ESCAPE SEQUENCES
;	TO PRESERVE THEM INTACT

SPMAP:	STA	SPCHAR		;INSERT CHARACTER IN BUFFER
	LXI	H,MAPFLG
	INR	M		;TURN ON MAPPING
	LXI	H,SPCHAR
	SHLD	MAPPTR		;SET UP MAP POINTER
	MVI	A,27		;RETURN WITH ESC. CHARACTER
	RET	

;	CALL BIOS CONSOLE INPUT FUNCTION

CCONIN:	JMP	0		;JUMP TO CONSOLE INPUT ROUTINE
CONINV	EQU	$-2

;	CALL BIOS CONSOLE OUTPUT FUNCTION

CCNOUT:	JMP	0		;JUMP TO CONSOLE OUTPUT ROUTINE
CONOUTV	EQU	$-2

;	LOCAL WARM BOOT ROUTINE, TO PROTECT THIS PROGRAM

MYWBOOT	LHLD	JBDOS+1		;GET BDOS ADDRESS
	LXI	D,JBDOS		;AND START OF KEYMAP
	MVI	B,6		;SET A COUNTER
MVSER	DCX	H		;DECREMENT POINTERS
	DCX	D
	MOV	A,M		;MOVE CP/M SERIAL NO.
	STAX	D		;TO BEFORE KEYMAP
	DCR	B
	JNZ	MVSER
	LDA	CURDSK		;GET CURRENT DISK
	MOV	C,A		;IN C
	JMP	0		;JUMP TO CCP
JCCP	EQU	$-2
CODEND:

;	TABLE OF MAPPED SEQUENCES

MAPTBL	DW	IC
	DW	UP
	DW	DN
	DW	FWD
	DW	BK
	DW	SF0
	DW	ESCF
	DW	ESCG
	DW	HOME
	DW	ESCI
	DW	F0
	DW	ESCK
	DW	IL
	DW	DLX
	DW	DC
	DW	ESCO
	DW	F6
	DW	F7
	DW	F8
	DW	F1
	DW	F2
	DW	F3
	DW	F4
	DW	F5
MAPTBL1	DW	F9
	DW	F10
	DW	F11
	DW	F12
MAPTBL2	DW	SF1
	DW	SF2
	DW	SF3
	DW	SF4
	DW	SF5
	DW	SF6
	DW	SF7
	DW	SF8
	DW	SF9
	DW	SF10
	DW	SF11
	DW	SF12
HELPKEY	DW	HELP

;	MAPPED CHARACTER SEQUENCES

	IF	TEST
F0	DB	'TEST',0
	DS	16
	ENDIF
	IF	NOT TEST
F0	DB	27,'J',0
	DS	18
	ENDIF
F1	DB	27,'S',0
	DS	18
F2	DB	27,'T',0
	DS	18
F3	DB	27,'U',0
	DS	18
F4	DB	27,'V',0
	DS	18
F5	DB	27,'W',0
	DS	18
F6	DB	27,'P',0
	DS	18
F7	DB	27,'Q',0
	DS	18
F8	DB	27,'R',0
	DS	18
F9	DB	27,'0I',0
	DS	17
F10	DB	27,'0J',0
	DS	17
F11	DB	27,'0K',0
	DS	17
F12	DB	27,'0L',0
	DS	17
SF0	DB	27,'E',0
	DS	18
SF1	DB	27,'1A',0
	DS	17
SF2	DB	27,'1B',0
	DS	17
SF3	DB	27,'1C',0
	DS	17
SF4	DB	27,'1D',0
	DS	17
SF5	DB	27,'1E',0
	DS	17
SF6	DB	27,'1F',0
	DS	17
SF7	DB	27,'1G',0
	DS	17
SF8	DB	27,'1H',0
	DS	17
SF9	DB	27,'1I',0
	DS	17
SF10	DB	27,'1J',0
	DS	17
SF11	DB	27,'1K',0
	DS	17
SF12	DB	27,'1L',0
	DS	17
IC	DB	27,'@',0
	DS	18
DC	DB	27,'N',0
	DS	18
IL	DB	27,'L',0
	DS	18
DLX	DB	27,'M',0
	DS	18
HOME	DB	27,'H',0
	DS	18
BK	DB	27,'D',0
	DS	18
FWD	DB	27,'C',0
	DS	18
UP	DB	27,'A',0
	DS	18
DN	DB	27,'B',0
	DS	18
HELP	DB	27,'~',0
	DS	18
ESCF	DB	27,'F',0
ESCG	DB	27,'G',0
ESCI	DB	27,'I',0
ESCK	DB	27,'K',0
ESCO	DB	27,'O',0

;	ALTERNATE MAPPED CHARACTER SEQUENCES

F0S	DB	27,'J',0
LTBL	EQU	F0S-F0
	DS	18
F1S	DB	27,'S',0
	DS	18
F2S	DB	27,'T',0
	DS	18
F3S	DB	27,'U',0
	DS	18
F4S	DB	27,'V',0
	DS	18
F5S	DB	27,'W',0
	DS	18
F6S	DB	27,'P',0
	DS	18
F7S	DB	27,'Q',0
	DS	18
F8S	DB	27,'R',0
	DS	18
F9S	DB	27,'0I',0
	DS	17
F10S	DB	27,'0J',0
	DS	17
F11S	DB	27,'0K',0
	DS	17
F12S	DB	27,'0L',0
	DS	17
SF0S	DB	27,'E',0
	DS	18
SF1S	DB	27,'1A',0
	DS	17
SF2S	DB	27,'1B',0
	DS	17
SF3S	DB	27,'1C',0
	DS	17
SF4S	DB	27,'1D',0
	DS	17
SF5S	DB	27,'1E',0
	DS	17
SF6S	DB	27,'1F',0
	DS	17
SF7S	DB	27,'1G',0
	DS	17
SF8S	DB	27,'1H',0
	DS	17
SF9S	DB	27,'1I',0
	DS	17
SF10S	DB	27,'1J',0
	DS	17
SF11S	DB	27,'1K',0
	DS	17
SF12S	DB	27,'1L',0
	DS	17
ICS	DB	27,'@',0
	DS	18
DCS	DB	27,'N',0
	DS	18
ILS	DB	27,'L',0
	DS	18
DLS	DB	27,'M',0
	DS	18
HOMES	DB	27,'H',0
	DS	18
BKS	DB	27,'D',0
	DS	18
FWDS	DB	27,'C',0
	DS	18
UPS	DB	27,'A',0
	DS	18
DNS	DB	27,'B',0
	DS	18
HELPS	DB	27,'~',0
	DS	18
ESCFS	DB	27,'F',0
ESCGS	DB	27,'G',0
ESCIS	DB	27,'I',0
ESCKS	DB	27,'K',0
ESCOS	DB	27,'O',0
SPCHAR	DB	0,0		;SPECIAL CHAR FOR UNDEF. SEQ.
SPADM	DB	0,0,0		;SHIFT KEYPAD MESSAGE
	DB	27,'x?'		;ENSURE KEYS EXPANDED
BLMSG	DB	1AH
	DS	248		;BOTTOM LINE MESSAGE

MAPFLG	DB	0		;MAPPING IN PROGRESS FLAG
MAPPTR	DW	0		;MAPPED CHARACTER POINTER
ASFLG	DB	0		;ALTERNATE SELECT FLAG
TGLFLG	DB	0		;ON/OFF TOGGLE FLAG
ERABL	DB	27,'y1'		;ERASE BOTTOM LINE
	DB	27,'x1'
UNSHF	DB	27,'y6',1AH	;UNSHIFT KEYPAD
LEND:				;END OF RESIDENT CODE
RESMEM	EQU	(LEND-JBDOS+255) AND 0FF00H	;MEMORY TO RESERVE

	END
