;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;


;
;  This table contains pointers to the actual disk
;  tables used by the bios. 
;
;  LAST MODIFIED: 1/20/83 - bcb
;

; These variables must be located before DSK_TPTR

VERFLG		DB 0		; != 0 if operation is a verify

; Variables used by timer(must disable interrupts when acessing them)

DSKT_FG		DB 0		; !=0 timer should look at remaining vars
DSKT_DNCTR	DW ?		; Down counter for deselect(100ths of secs)
DSKT_PORT	DW ?		; Port number to use to deselect drive
DSKT_DSEL	DB ?		; Deselect command

	DW OFFSET SPDISK ; Special disk (before DSK_TPTR)

DSK_TPTR	LABEL	WORD

	DW	OFFSET DISK0
	DW	OFFSET DISK1

	DW	OFFSET DISK2
	DW	OFFSET DISK3

	DW	OFFSET DISK4
	DW	OFFSET DISK5
	DW	OFFSET DISK6
	DW	OFFSET DISK7
	DW	-1			; Mark end of table

SPDISK	DB	DSK_SIZE DUP(0FFH)	; Initialized to an invalid value

;
;   5.25 inch Unit 0
;

DISK0	LABEL	BYTE
	ERRNZ	DISK0,DSK_STA
	DW	0			; Status
	ERRNZ	DISK0,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK0,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK0,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK0,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK0,DSK_SEL
	DB	CONDSEN+0+CONPC		; Select disk 0, no precomp
	ERRNZ	DISK0,DSK_RS
	DB	FDCRST+FDFHLB+FDFS30	; Restore(home) command
	ERRNZ	DISK0,DSK_SPHI
	DB	FDCSTI+FDFHLB+FDFS30+FDFUTR ; Step in command 
	ERRNZ	DISK0,DSK_FMT
	DB	FDCWRT+FDFDLF		; Format(write track) command
	ERRNZ	DISK0,DSK_RD
	DB	FDCRDS+FDFSLF		; Read command
	ERRNZ	DISK0,DSK_WR
	DB	FDCWRS+FDFSLF		; Write command
	ERRNZ	DISK0,DSK_SK
	DB	FDCSEK+FDFHLB+FDFS30	; Seek command
	ERRNZ	DISK0,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK0,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK0,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK0,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK0,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK0,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK0,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK0,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK0,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK0,DSK_PORT
	DW	Z207A			; Base Port number
	ERRNZ	DISK0,DSK_RDT
	DB	FDCRDT+FDFDLF		; Read track command
	ERRNZ	DISK0,DSK_IMGFLG
	DB	DSKIF_DV		; Drive exits
	ERRNZ	DISK0,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK0,DSK_NAME
	DB	'A'			; Drive A:
	ERRNZ	DISK0,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK0,DSK_SIZE

;
;  5.25 inch, Unit 1
;

DISK1	LABEL	BYTE
	ERRNZ	DISK1,DSK_STA
	DW	0			; Status
	ERRNZ	DISK1,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK1,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK1,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK1,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK1,DSK_SEL
	DB	CONDSEN+1+CONPC		; Select disk 1, no precomp
	ERRNZ	DISK1,DSK_RS
	DB	FDCRST+FDFHLB+FDFS30	; Restore(home) command
	ERRNZ	DISK1,DSK_SPHI
	DB	FDCSTI+FDFHLB+FDFS30+FDFUTR ; Step in command 
	ERRNZ	DISK1,DSK_FMT
	DB	FDCWRT+FDFDLF		; Format(write track) command
	ERRNZ	DISK1,DSK_RD
	DB	FDCRDS+FDFSLF		; Read command
	ERRNZ	DISK1,DSK_WR
	DB	FDCWRS+FDFSLF		; Write command
	ERRNZ	DISK1,DSK_SK
	DB	FDCSEK+FDFHLB+FDFS30	; Seek command
	ERRNZ	DISK1,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK1,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK1,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK1,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK1,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK1,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK1,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK1,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK1,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK1,DSK_PORT
	DW	Z207A			; Base Port number
	ERRNZ	DISK1,DSK_RDT
	DB	FDCRDT+FDFDLF		; Read track command
	ERRNZ	DISK1,DSK_IMGFLG
	DB	DSKIF_DV		; Drive exits
	ERRNZ	DISK1,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK1,DSK_NAME
	DB	'B'			; Drive B:
	ERRNZ	DISK1,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK1,DSK_SIZE

;
;	DISK2 - 8" unit 0
;

DISK2	LABEL	BYTE
	ERRNZ	DISK2,DSK_STA
	DW	0			; Status
	ERRNZ	DISK2,DSK_TYPE
	DB	DSK_TZ2078		; Z-207 type disk
	ERRNZ	DISK2,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK2,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK2,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FRS	; Double sided disk
	ERRNZ	DISK2,DSK_SEL
	DB	CONDSEN+0+CONDS8+CONPC	; Select disk 0, no precomp
	ERRNZ	DISK2,DSK_RS
	DB	FDCRST+FDFHLB+FDFS30	; Restore(home) command
	ERRNZ	DISK2,DSK_SPHI
	DB	FDCSTI+FDFHLB+FDFS30+FDFUTR ; Step in command 
	ERRNZ	DISK2,DSK_FMT
	DB	FDCWRT+FDFDLF		; Format(write track) command
	ERRNZ	DISK2,DSK_RD
	DB	FDCRDS+FDFSLF		; Read command
	ERRNZ	DISK2,DSK_WR
	DB	FDCWRS+FDFSLF		; Write command
	ERRNZ	DISK2,DSK_SK
	DB	FDCSEK+FDFHLB+FDFVRF+FDFS30	; Seek command
	ERRNZ	DISK2,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK2,DSK_MAXT
	DB	77			; Number of tracks on disk
	ERRNZ	DISK2,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK2,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK2,DSK_BPS
	DW	1024			; Bytes per sector
	ERRNZ	DISK2,DSK_BPWT
	DW	1			; Bytes per write track
	ERRNZ	DISK2,DSK_BPRT
	DW	1			; Bytes per read track
	ERRNZ	DISK2,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK2,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK2,DSK_PORT
	DW	Z207A			; Base Port number
	ERRNZ	DISK2,DSK_RDT
	DB	FDCRDT+FDFDLF		; Read track command
	ERRNZ	DISK2,DSK_IMGFLG
	DB	DSKIF_DV		; Drive exits
	ERRNZ	DISK2,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK2,DSK_NAME
	DB	'C'			; Drive C:
	ERRNZ	DISK2,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK2,DSK_SIZE

;
;	DISK3 - 8" unit 1
;

DISK3	LABEL	BYTE
	ERRNZ	DISK3,DSK_STA
	DW	0			; Status
	ERRNZ	DISK3,DSK_TYPE
	DB	DSK_TZ2078		; Z-207 type disk
	ERRNZ	DISK3,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK3,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK3,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FRS	; Double sided disk
	ERRNZ	DISK3,DSK_SEL
	DB	CONDSEN+1+CONDS8+CONPC	; Select disk 1, no precomp
	ERRNZ	DISK3,DSK_RS
	DB	FDCRST+FDFHLB+FDFS30	; Restore(home) command
	ERRNZ	DISK3,DSK_SPHI
	DB	FDCSTI+FDFHLB+FDFS30+FDFUTR ; Step in command 
	ERRNZ	DISK3,DSK_FMT
	DB	FDCWRT+FDFDLF		; Format(write track) command
	ERRNZ	DISK3,DSK_RD
	DB	FDCRDS+FDFSLF		; Read command
	ERRNZ	DISK3,DSK_WR
	DB	FDCWRS+FDFSLF		; Write command
	ERRNZ	DISK3,DSK_SK
	DB	FDCSEK+FDFHLB+FDFVRF+FDFS30	; Seek command
	ERRNZ	DISK3,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK3,DSK_MAXT
	DB	77			; Number of tracks on disk
	ERRNZ	DISK3,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK3,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK3,DSK_BPS
	DW	1024			; Bytes per sector
	ERRNZ	DISK3,DSK_BPWT
	DW	1			; Bytes per write track
	ERRNZ	DISK3,DSK_BPRT
	DW	1			; Bytes per read track
	ERRNZ	DISK3,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK3,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK3,DSK_PORT
	DW	Z207A			; Base Port number
	ERRNZ	DISK3,DSK_RDT
	DB	FDCRDT+FDFDLF		; Read track command
	ERRNZ	DISK3,DSK_IMGFLG
	DB	DSKIF_DV		; Drive exits
	ERRNZ	DISK3,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK3,DSK_NAME
	DB	'D'			; Drive D:
	ERRNZ	DISK3,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK3,DSK_SIZE

;
;	DISK4 - Winchester unit E:
;

DISK4	LABEL	BYTE
	ERRNZ	DISK4,DSK_STA
	DW	0			; Status
	ERRNZ	DISK4,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK4,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK4,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK4,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK4,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK4,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK4,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK4,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK4,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK4,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK4,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK4,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK4,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK4,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK4,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK4,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK4,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK4,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK4,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK4,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK4,DSK_PORT
	DW	Z217A			; Base Port number
	ERRNZ	DISK4,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK4,DSK_IMGFLG
	DB	DSKIF_DV+DSKIF_NM	; Drive exits but can't be reused
	ERRNZ	DISK4,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK4,DSK_NAME
	DB	'E'			; Drive E:
	ERRNZ	DISK4,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK4,DSK_SIZE
	ERRNZ	DISK4,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK4,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK4,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK4,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK4,DSKW_WUN
	DB	0			; Drive unit number
	ERRNZ	DISK4,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK4,DSKW_SIZE


;
;	DISK5 - Winchester unit F:
;

DISK5	LABEL	BYTE
	ERRNZ	DISK5,DSK_STA
	DW	0			; Status
	ERRNZ	DISK5,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK5,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK5,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK5,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK5,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK5,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK5,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK5,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK5,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK5,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK5,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK5,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK5,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK5,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK5,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK5,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK5,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK5,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK5,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK5,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK5,DSK_PORT
	DW	Z217A			; Base Port number
	ERRNZ	DISK5,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK5,DSK_IMGFLG
	DB	DSKIF_DV+DSKIF_NM	; Drive exits but can't be reused
	ERRNZ	DISK5,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK5,DSK_NAME
	DB	'F'			; Drive F:
	ERRNZ	DISK5,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK5,DSK_SIZE
	ERRNZ	DISK5,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK5,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK5,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK5,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK5,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK5,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK5,DSKW_SIZE

;
;	DISK6 - Winchester unit G:
;

DISK6	LABEL	BYTE
	ERRNZ	DISK6,DSK_STA
	DW	0			; Status
	ERRNZ	DISK6,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK6,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK6,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK6,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK6,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK6,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK6,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK6,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK6,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK6,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK6,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK6,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK6,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK6,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK6,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK6,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK6,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK6,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK6,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK6,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK6,DSK_PORT
	DW	Z217A			; Base Port number
	ERRNZ	DISK6,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK6,DSK_IMGFLG
	DB	DSKIF_DV+DSKIF_NM	; Drive exits but can't be reused
	ERRNZ	DISK6,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK6,DSK_NAME
	DB	'G'			; Drive H:
	ERRNZ	DISK6,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK6,DSK_SIZE
	ERRNZ	DISK6,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK6,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK6,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK6,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK6,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK6,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK6,DSKW_SIZE

;
;	DISK7 - Winchester unit H:
;

DISK7	LABEL	BYTE
	ERRNZ	DISK7,DSK_STA
	DW	0			; Status
	ERRNZ	DISK7,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK7,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK7,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK7,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK7,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK7,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK7,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK7,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK7,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK7,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK7,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK7,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK7,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK7,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK7,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK7,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK7,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK7,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK7,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK7,DSK_LDELAY
	DW	8000			; 8000 instr = 30mls
	ERRNZ	DISK7,DSK_PORT
	DW	Z217A			; Base Port number
	ERRNZ	DISK7,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK7,DSK_IMGFLG
	DB	DSKIF_DV+DSKIF_NM	; Drive exits but can't be reused
	ERRNZ	DISK7,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK7,DSK_NAME
	DB	'H'			; Drive H:
	ERRNZ	DISK7,DSK_TIMOUT
	DW	0			; Current timeout
	ERRNZ	DISK7,DSK_SIZE
	ERRNZ	DISK7,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK7,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK7,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK7,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK7,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK7,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK7,DSKW_SIZE

;
;	Command block for winchester I/O
;
;	NOTE: This table must IMMEDIATELY follow the table
;	for the 8th disk drive. DISK7+DSKW_SIZE is used
;	to locate this table.
;

DSK_WCB	LABEL	BYTE
	DB	WI1_SIZE DUP (0)	; Fill with zeros
	ERRNZ	DSK_WCB,WI1_SIZE
	ERRNZ	DSK_WCB,WI3_SIZE	; Insure enough for both
