;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

;
;  PBE_AUXIN - Aux input
;
;     Wait for a character from the MODEM(auxiliary) input device.
;
;     Returns:
;         AL = character read
;
;     Uses: No registers are modified.
;

PBE_AUXIN PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BAUXIN1:
	PUSH	AX
	MOV	AH,CHR_READ	; Get read function code
	PUSH	CS		; Make call into far call
	CALL	NEAR PTR BIOS_AUXFUNC ; Read char, any errors
	MOV	BL,AL		; Save char
	POP	AX
	JC	BAUXIN1		; If an error, then try again

	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;    and return


PBE_AUXIN ENDP



;
;  PBE_AUXOUT - Aux output
;
;     Output a character to the MODEM(auxiliary) output device.
;
;     Call with:
;         AL = character to output
;
;     Uses: No registers are modified.
;

PBE_AUXOUT PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BAUXOUT1:
	PUSH	AX
	MOV	AH,CHR_WRITE	; Get write function code
	PUSH	CS		; Make call into far call
	CALL	NEAR PTR BIOS_AUXFUNC ; Write char, any errors ?
	POP	AX
	JC	BAUXOUT1	; If an error, then try again

	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;    and return
PBE_AUXOUT ENDP

