	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFEP2.ASM
	INCLUDE DEFCONFG.ASM
	INCLUDE U8250.DEF
	INCLUDE DEFCHR.ASM
	INCLUDE DEF8259A.ASM
	INCLUDE DEFIPAGE.ASM
.LIST

LOOPCOUNT	=	6000H		; Loop constant for UART programming

EVN_SRA		=	2		; Event flag value for SERA int
EVN_SRB		=	1		; Event flag value for SERB int


BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS, DS:BIOS, SS:BIOS

	EXTRN	CHRFIS_QS:NEAR
	EXTRN	CHRCTS_GEX:NEAR
	EXTRN	CHRCTS_BEX:NEAR
	EXTRN	CHRCTI_QF:NEAR
	EXTRN	CQ_ZSERA:BYTE
	EXTRN	CQ_ZSERB:BYTE
	EXTRN	Q_GET:NEAR
	EXTRN	Q_PUT:NEAR
	EXTRN	TCID:BYTE
	EXTRN	CID_AUX:BYTE
	EXTRN	CID_PRN:BYTE
	EXTRN	ISR_SACC:BYTE
	EXTRN	ISR_SBCC:BYTE
	EXTRN	EVN_FLG:WORD
	EXTRN	SER_EXIST:BYTE


	PUBLIC	SERA_ISR, SERB_ISR, CHRFID_SER, CHRFOD_SER
	PUBLIC	CHRCTS_SER, CHRCTI_SER, CHRCTO_SER, CHRFIS_SER
	PUBLIC	CHRFOS_SER, CHRCTS_SITAB, Q_ZSERA, Q_ZSERB

CHAR_LEN	DW	0

DATA_MASK	LABEL	BYTE
		DB	00011111B
		DB	00111111B
		DB	01111111B
		DB	11111111B


;	SER_ISR - Serial device interrupt service routine
;	
;	The interrupt is assumed to be genereated by a new character
;	in the receiver buffer register.
;

SERA_ISR:
	STI				; Allow other interrupts
	PUSH	AX
	PUSH	BX
	PUSH	DX

	MOV	DX,ZSERA		; Get serial A base port
	MOV	BX,OFFSET CQ_ZSERA	; Get A's queue descriptor address
	JMP	SER_ISR2		; Skip on down

SERB_ISR:
	STI				; Allow other interrupts
	PUSH	AX
	PUSH	BX
	PUSH	DX

	MOV	DX,ZSERB		; Get serial B base port
	MOV	BX,OFFSET CQ_ZSERB	; Get B's queue descriptor address

;	DX has base port, BX has queue descriptor address

SER_ISR2:
	IN	AL,DX			; Get the character
	XOR	AH,AH			; Show not used yet
	CMP	DX,ZSERA		; Is this from serial A?
	JNZ	SER_ISR3		; No, must be from B
	OR	CS:WORD PTR EVN_FLG,EVN_SRA
	INT	INT_USAIA		; User interrupt for serial A
	JMP	SHORT SER_ISR4		; Skip
SER_ISR3:
	OR	CS:WORD PTR EVN_FLG,EVN_SRB
	INT	INT_USBIA		; User interrupt for serial B
SER_ISR4:
	CLI
	OR	AH,AH			; Was it used?
	JNZ	SER_ISR8		; Jump if so
	
;	See if DC1 or DC3 (in case using DC1/DC3 protocol)

	PUSH	BX
	MOV	BL,1
	CMP	AL,CC_DC3		; Is it DC3 (^S)?
	JNZ	SER_ISR5		; No, jump
	JMP	SHORT SER_ISRCC		; Is a control character
SER_ISR5:
	DEC	BL
	CMP	AL,CC_DC1		; Is it DC1 (^Q)?
	JNZ	SER_ISR7		; No, jump
SER_ISRCC:
	CMP	DX,ZSERA		; Is this serial A ?
	JNZ	SER_ISR6		; No, skip
	MOV	CS:BYTE PTR ISR_SACC,BL	; Save BL as control flag
	JMP	SHORT SER_ISR7		; Skip
SER_ISR6:
	MOV	CS:BYTE PTR ISR_SBCC,BL	; Save BL as control flag
SER_ISR7:
	POP	BX
	CALL	Q_PUT			; Put char into queue, did it fit?
	JNC	SER_ISR8		; Yes, skip
	OR	BYTE PTR CS:CQ_STATUS[BX],CHRS_RXOF	; Show error
SER_ISR8:
	MOV	AL,OCW2OP+OCW2EOI	; Ready to show that we are done
	OUT	ZM8259A+OCW2,AL		; Send it
	POP	DX
	POP	BX
	POP	AX
	IRET


;	CHRFID_SER - Raw data input routines for serial devices
;
;	Entry:	SI - Address of CID
;
;	Exit:	AL - data byte read
;
;	Uses:	DX
;

CHRFID_SER	PROC	NEAR
	MOV	DX,CID_CHRD+CHRD_PORT[SI] ; Get base port
	CMP	DX,ZSERA	; Is it the serial A port ?
	JNE	CHRFID_SER1	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERA ; Get addr of queue descriptor
	JMP	CHRFID_QL	; Join common code
CHRFID_SER1:
	CMP	DX,ZSERB	; Is it the serial B port ?
	JNE	CHRFID_SER2	;   No, skip
	PUSH	BX		;   Yes, save regs
	MOV	BX,OFFSET CQ_ZSERB ; Get addr of queue descriptor

CHRFID_QL:
	CLI			; Disable interrupts for a bit
	CALL	Q_GET		; Get char from type ahead queue
	STI			; Turn interrupts back on
	NOP			; Let an interrupt in
	JZ	CHRFID_QL	; If typeahead queue empty

;	AL = character from input que

	CMP	AL,CC_DC1	; DC1 character?
	JNZ	CHRFID_QL1

;	Character is DC1/DC3 - See if we should ignore this guy

CHRFID_QL2:
	CMP	BYTE PTR [SI+CID_CHRD+CHRD_HSHK],CHRDH_DCH	; DC1/DC3?
	JZ	CHRFID_QL	; Yep, skip this guy and get another
	JMP	SHORT CHRFID_QL3
CHRFID_QL1:
	CMP	AL,CC_DC3	; DC3?
	JZ	CHRFID_QL2	;  Yes, see if need to ignore
CHRFID_QL3:
	POP	BX		; Restore regs
	RET			;   and return

CHRFID_SER2:
	MOV	DX,CID_IPORT[SI] ; Get input data port
	IN	AL,DX		; Read data
	RET

CHRFID_SER	ENDP



;
; Raw Output data routines for serial ports
;
;     Call with:
;         AL = char to write
;         SI -> CID
;
;     Uses: DX, AH
;

CHRFOD_SER	PROC	NEAR
	CLI
	PUSH	AX
	XOR	AH,AH		; Show AH = 0
	CMP	WORD PTR CID_CHRD+CHRD_PORT[SI],ZSERA	; Get base port
	JNZ	CHRFOD_SER1
	INT	INT_USAOA	; Interrupt on it
	JMP	SHORT CHRFOD_SER2
CHRFOD_SER1:
	INT	INT_USBOA	; Serial B interrupt
CHRFOD_SER2:
	CLI
	OR	AH,AH		; Test return value
	POP	AX
	JNZ	CHRFOD_SER3	; If to ignore the character
	MOV	DX,CID_CHRD+CHRD_PORT[SI] ; Get output data port addr
	OUT	DX,AL		; Write the byte
CHRFOD_SER3:
	STI
	RET			;  and return

CHRFOD_SER	ENDP

;
;     Character device control function for serial devices
;	New setup routine
;
;     Call with:
;         SI -> CID
;         AL = Subfunction
;
;         * AL = CHR_CFSU - Set up new configuration using parms at ES:BX
;
;     Returns:
;         CY clear - returns to CHRCTS_GEX
;         CY set - returns to CHRCTS_BEX
;
;     Uses: DI, DX

CHRCTS_SER:

; Check if baud rate OK

	CMP	BYTE PTR TCID+CID_CHRD+CHRD_BAUD,BDMAX ; Is baud rate valid ?
	JNA	CHRCTS_SER1	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, join failure exit
CHRCTS_SER1:

; Compute ports

	MOV	CX,WORD PTR TCID+CID_CHRD+CHRD_PORT ; Get base port
	OR	CX,CX		; Was port specified ?
	JNZ	CHRCTS_SER1B	;   Yes, skip
	MOV	CX,ZSERA	;   No, assume a port
	CMP	SI,OFFSET CID_AUX ; Are we setting up AUX: ?
	JNE	CHRCTS_SER1A	;   No, skip
	MOV	CX,ZSERB	;   Yes, get default port for it
CHRCTS_SER1A:
	MOV	WORD PTR TCID+CID_CHRD+CHRD_PORT,CX ; Save base port
CHRCTS_SER1B:
	ADD	CX,UR_RBR	; Compute input/output ports
	MOV	WORD PTR TCID+CID_IPORT,CX ; Store input data port
	MOV	WORD PTR TCID+CID_OPORT,CX ; Store output data port
	ADD	CX,UR_MSR-UR_RBR ; Compute status port
	MOV	WORD PTR TCID+CID_SPORT,CX ; Store status port
	SUB	CX,UR_MSR-UR_MCR ; Compute command port
	MOV	WORD PTR TCID+CID_CPORT,CX ; Store command port	

; Check if handshaking is ok and setup ready and polarity masks

	MOV	CL,TCID+CID_CHRD+CHRD_HSHK ; Get handshaking type
	CMP	CL,CHRDH_MAX	; Is type valid ?
	JNA	CHRCTS_SER2	;   Yes, skip
	JMP	CHRCTS_BEX	;   No, join failure exit
CHRCTS_SER2:
	XOR	CH,CH		; Clear upper half
	MOV	DI,CX		; Make avail as index
	SHL	DI,1		; Mult by 4 (the size of a table entry)
	SHL	DI,1
	MOV	CL,BYTE PTR CHRCTS_SITAB+0[DI] ; Get first entry
	MOV	TCID+CID_IRM,CL	; Store input ready mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+1[DI] ; Get second entry
	MOV	TCID+CID_IPM,CL	; Store input polarity mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+2[DI] ; Get third entry
	MOV	TCID+CID_ORM,CL	; Store output ready mask
	MOV	CL,BYTE PTR CHRCTS_SITAB+3[DI] ; Get fourth entry
	MOV	TCID+CID_OPM,CL	; Store output polarity ready mask

; Program the 8250

	CLI				; Disable interrupts
	MOV	DX,WORD PTR TCID+CID_CHRD+CHRD_PORT	; Get base port
	CMP	DX,ZSERA		;Serial A?
	JNZ	CHRCTS_SER0X		;No, skip
	TEST	SER_EXIST,0FFH		;Does it exist?
	JNZ	CHRCTS_SER9X		;Yes, continue
CHRCTS_NOEXIST:
	STI
	JMP	CHRCTS_GEX		;No, bail out with no error
CHRCTS_SER0X:
	CMP	DX,ZSERB		;Serial B?
	JNZ	CHRCTS_SER9X		;No, let it fall through
	TEST	SER_EXIST[1],0FFH	;Does it exist?
	JZ	CHRCTS_NOEXIST		;No, bail out
CHRCTS_SER9X:
	MOV	CX,DX			;Save this place
	ADD	DL,UR_LCR		;Point to LCR
	SUB 	AL,AL			;Want to zero DLAB
	OUT	DX,AL			;On Chip
	MOV	DX,CX			;Point back to output port
	INC	DX			;Then to IER
	OUT	DX,AL			;Turn off ints
	DEC	DX			;And point back to base port
CHRCTS_SER3A:
	ADD	DL,UR_MSR		;Point to MSR
	IN	AL,DX			;Read it to clear int
	DEC	DX			;Point to LSR
	MOV	CX,DX			;Save this place
	IN	AL,DX			;Read it to clear int
	SUB	DL,UR_LSR		;Point to receive buffer
	IN	AL,DX			;Read it to clear ints
	ADD	DX,2			;Point to IIR	
	IN	AL,DX			;Clear all ints
	SUB	DX,2			;Point back to base port
	CMP	AL,1			;All ints cleared?
	JNE	CHRCTS_SER3A		;No-try again
	XCHG	CX,DX			;Point to Line status reg
	DEC	DX			;Then to MCR
	MOV	AL,UC_LOO		;Set loopback mode
	OUT	DX,AL			;While programming UART
	DEC	DX        		;Point to Line Control Register
	MOV	AL,UC_DLA		;Divisor Latch Access bit ON
	OUT	DX,AL			;Set DLA=1
	XCHG	DX,CX			;Point to LS divisor
	MOV	AL,TCID+CID_CHRD+CHRD_BAUD	;Get baud rate code
	CBW
	SHL	AX,1			;Make it a word pointer
	MOV	DI,OFFSET BAUD_TABLE	;Point to baud rate divisor table
	ADD	DI,AX			;Point to baud rate divisor
	MOV	AX,CS:WORD PTR [DI]	;Get divisor
	OUT	DX,AL			;Set LS divisor
	INC	DX			;Point to MS divisor
	MOV	AL,AH			;MS divisor in AL
	OUT	DX,AL			;Set MS divisor
	INC	DX			;Point to IIR
	INC	DX			;Point to LCR

	MOV	AL,BYTE PTR TCID+CID_CHRD+CHRD_BCTL	; Get 2661 mode reg 1
	MOV	AH,AL			;Keep a copy
	SHR	AL,1			;Shift bits so 'char length' aligns
	SHR	AL,1
	AND	AL,03H			;Mask char length
	SHR	AH,1			;Shift to align parity bits
	OR	AH,03H			;Do not affect char length
	OR	AL,0F8H			;Do affect everything else
	AND	AL,AH			;Set parity control bits in AL
	MOV	AH,60H			;Set up mask for stop bits
	AND	AH,AL			;Get stop bits in AH
	OR	AL,04H			;Assume 2 stop bits
	CMP	AH,60H			;2 stop bits?
	JZ	CHRCTS_SER3B		;If so, skip
	CMP	AH,20H			;1 stop bit?
	JZ	CHRCTS_SER3C		;Yes, skip
	CMP	AH,40H			;1.5 stop bits?
	JZ	CHRCTS_SER3D		;Skip if so
	STI				;Enable interrupts
	JMP	CHRCTS_BEX		;Error if not
CHRCTS_SER3D:
	MOV	AH,AL			;Get current LCR
	AND	AH,03H			;Get char length
	JZ	CHRCTS_SER3B		;Done
	STI
	JMP	CHRCTS_BEX		;Error if char length is not 5 bits
CHRCTS_SER3C:
	AND	AL,0FBH			;Reset stop bits indicator bit
CHRCTS_SER3B:
	AND	AL,3FH			;Reset DLAB and BREAK bits
	OUT	DX,AL			;Set LCR
	AND	AL,03H			;Get char length code
	MOV	CS:BYTE PTR CHAR_LEN,AL ;Save for later
	ADD	DX,2			;Point to LSR
	MOV	BX,DX			;Save till later
	SUB	DX,UR_LSR		;Point to transmit reg
	IN	AL,DX			;Input first of 2 chars to clear UART
	MOV	CX,LOOPCOUNT		;Prepare for a delay
CHRCTS_SER3:
	LOOP	CHRCTS_SER3		;Let UART stabilize
	MOV	CX,LOOPCOUNT		; for a long time
CHRCTS_SER4:
	LOOP	CHRCTS_SER4
	MOV	CX,LOOPCOUNT		;Set up for next delay
	IN	AL,DX			;Input second char
	MOV	AL,'K'			;Output a 'K' for test
	MOV	AH,AL			;Copy to AH for comparison
	PUSH	DI
	MOV	DI,CS:CHAR_LEN		;Get char length code
	AND	AH,CS:DATA_MASK[DI]	;Mask non-transmitted bits
	POP	DI
	OUT	DX,AL			;Send it
	XCHG	DX,BX			;Point to LSR
CHRCTS_SER5:
	IN	AL,DX			;Get the status
	TEST	AL,UC_DR		;Is 'data ready' set?
	JNZ	CHRCTS_SER6		;Yes, jump!
	LOOP	CHRCTS_SER5		;Try again if not
	STI
	JMP	CHRCTS_BEX		;Bad news... jump to error exit
CHRCTS_SER6:
	AND	AL,UC_OR+UC_PE+UC_FE+UC_BI	;Check for errors
	JZ	CHRCTS_SER7		;Skip if no errors
	STI
	JMP	CHRCTS_BEX		;Jump if there were errors
CHRCTS_SER7:
	XCHG	DX,BX			;Point to reciever reg
	IN	AL,DX			;Get the character
	CMP	AL,AH			;Do they match?
	JZ	CHRCTS_SER8		;Skip if so
	STI
	JMP	CHRCTS_BEX		;No, jump
CHRCTS_SER8:
	ADD	DX,UR_MCR		;Point to modem control reg
	MOV	AL,UC_RTS+UC_DTR+UC_OU2	;Set control lines and on-board int enable
	OUT	DX,AL			;Send it
	SUB	DX,3			;Point to IER
	MOV	AL,UC_EDA		;Enable 'Data Available' interrupt
	OUT	DX,AL			;Set it once
	OUT	DX,AL			;Set it again
	STI				;Restore interrupts
	JMP	CHRCTS_GEX		;Done


;	Device dependent code for 'clear input' function
;
CHRCTI_SER:
	CLI				;Disable interrupts
	MOV	DX,WORD PTR CID_CHRD+CHRD_PORT[SI]	;Get base port
	ADD	DX,UR_LSR		;Point to line status register
	IN	AL,DX			;Read it to clear errors
	SUB	DX,UR_LSR		;Point back to base port
	IN	AL,DX			;Read the input buffer
	IN	AL,DX			;Again
	CMP	DX,ZSERA		;Is it serial A port?
	JNZ	CHRCTI_SER1		;No, skip
	PUSH	BX			;Yes, save reg
	MOV	BX,OFFSET CQ_ZSERA	;Get address of queue descriptor
	JMP	CHRCTI_QF		;Join common code
CHRCTI_SER1:
	CMP	DX,ZSERB		;Is it serial B port?
	JNZ	CHRCTI_SER2		;No, skip
	PUSH	BX			;Yes, save reg
	MOV	BX,OFFSET CQ_ZSERB	;Get address of queue descriptor
	JMP	CHRCTI_QF		;Join common code
CHRCTI_SER2:
	CLC				;Show success
	STI				;Enable interrupts
	RET


;	Device dependent code for 'clear output' function
;
CHRCTO_SER:
	CLC
	RET


;	Device dependent code for 'input status' function
;
CHRFIS_SER:
	MOV	DX,CID_CHRD+CHRD_PORT[SI]	; Get base port
	PUSH	DX
	CALL	STAT8250			; Get 2661 stat from 8250
	POP	DX				; Retrieve base port
	CMP	DX,ZSERA			; Serial A port?
	JNZ	CHRFIS_SER1			; No, skip
	PUSH	BX				; Yes, save reg
	MOV	BX,OFFSET CQ_ZSERA		; Get addr of queue descriptor
	JMP	CHRFIS_QS			; Join common code
CHRFIS_SER1:
	CMP	DX,ZSERB			; Serial B port?
	JNZ	CHRFIS_SER2			; No, skip
	PUSH	BX				; Yes, save reg
	MOV	BX,OFFSET CQ_ZSERB		; Get address of queue descriptor
	JMP	CHRFIS_QS			; Join common code
CHRFIS_SER2:
	XOR	DX,DX				; Clear queue status
	RET
	
;	Device dependent code for output status
;
CHRFOS_SER:
	MOV	DX,CID_CHRD+CHRD_PORT[SI]	; Get base port
	CALL	STAT8250		; Get 2661-type status from 8250
	MOV	AL,AH			; Move status into AL
	RET




;	STAT8250 - Get status from 8250 and return 2661 type status
;	in AH.
;
;	Entry:	DX - 8250 base port
;
;	Exit:	AH - 2661 raw status
;
STAT8250:
	ADD	DX,UR_MSR		; Point to MSR
	IN	AL,DX			; Get modem status

;	Translate 8250 status to 2661 status

	SHL	AL,1			; Align some bits
	SHL	AL,1
	AND	AL,0CCH			; Get DSR,DDSR,CTS,DCTS bits
	OR	AH,AL			; Get bits in AH
	SHR	AL,1			; Align DDSR bit
	AND	AL,04H			; Isolate DDSR bit
	OR	AH,AL			; Move it into AH
	AND	AH,0C4H			; Clear 2661 parity error bit

	DEC	DX			; Point to Line Status Register
	IN	AL,DX			; Get line status
	PUSH	BX			; Save BX
	ROL	AL,1			; Align some bits
	MOV	BL,AL			; Save a copy
	AND	AL,0AH			; Get data ready and parity error
	OR	AH,AL			; Store them
	ROL	BL,1			; Align a bit
	MOV	AL,BL			; Get a copy
	AND	AL,20H			; Get framing error bit
	OR	AH,AL			; Move it in
	ROL	BL,1			; Align a bit
	MOV	AL,BL			; Get a copy
	AND	AL,11H			; Get overrun error and xmt empty bits
	OR	AH,AL			; Move it in 
	POP	BX			; Restore BX
	RET



;	Table of READY and POLARITY masks for 8250

CHRCTS_SITAB:

; No handshaking: input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; <ACK>/<ETX>:input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; <DC3>/<DC1>: input ready, input polarity, output ready, output polarity
	DB	EPRXR
	DB	0
	DB	EPTXR
	DB	0

; DCD high: input ready, input polarity, output ready, output polarity
	DB	EPDCD+EPRXR
	DB	0
	DB	EPDCD+EPTXR
	DB	0

; DCD low: input ready, input polarity, output ready, output polarity
	DB	EPDCD+EPRXR
	DB	0
	DB	EPDCD+EPTXR
	DB	EPDCD

; DSR high: input ready, input polarity, output ready, output polarity
	DB	EPDSR+EPRXR
	DB	0
	DB	EPDSR+EPTXR
	DB	0

; DSR low: input ready, input polarity, output ready, output polarity
	DB	EPDSR+EPRXR
	DB	0
	DB	EPDSR+EPTXR
	DB	EPDSR

;	Baud rate divisor table for 8250

BAUD_TABLE:
	DW	09E4H			; 45.5 BAUD
	DW	0900H			; 50 BAUD
	DW	0600H			; 75 BAUD
	DW	0417H			; 110 BAUD
	DW	0359H			; 134.5 BAUD
	DW	0300H			; 150 BAUD
	DW	0180H			; 300 BAUD
	DW	00C0H			; 600 BAUD
	DW	0060H			; 1200 BAUD
	DW	0040H			; 1800 BAUD
	DW	003AH			; 2000 BAUD
	DW	0030H			; 2400 BAUD
	DW	0018H			; 4800 BAUD
	DW	000CH			; 9600 BAUD
	DW	0006H			; 19200 BAUD
	DW	0003H			; 38400 BAUD

Q_ZSERA	DB	ZSERA_IQS DUP (?)
Q_ZSERB	DB	ZSERB_IQS DUP (?)


BIOS	ENDS
	END
           
