+ARCHIVE+ comygetc.asm   422 10/01/1984 17:08:30

;   com_getc: wait until a char is ready and read it

	include model.h
	include prologue.h
	public com_getc
if	@bigmodel
	extrn	com_rdy:far
com_getc	proc	far
else
	extrn	com_rdy:near
com_getc	proc	near
endif
not_ready:
	call	com_rdy
	or	ax,ax
	jz	not_ready
ready:
	push	bp
	mov	bp,sp
	mov	dx,@ab[bp]
	mov	ax,0200h
	int	014h
	xor	ah,ah
	pop	bp
	ret
com_getc	endp
 
	include epilogue.h
	end

+ARCHIVE+ comyputc.asm   425 10/01/1984 17:08:30

;   com_putc: send a character to the communications channel

	include model.h
	include prologue.h
	public com_putc
if	@bigmodel
com_putc	proc	far
else
com_putc	proc	near
endif
	push	bp
	mov	bp,sp
	mov	dx,@ab[bp]	; get comm channel number
	mov	ax,@ab+2[bp]	; get character
	mov	ah,1		; request transmit
	int	014h		; xmit it!
	pop	bp
	ret			; return status
com_putc	endp
 
	include epilogue.h
	end


+ARCHIVE+ comyrdy.asm    370 10/01/1984 17:08:30

;   com_rdy: is there a character ready ?

	include model.h
	include prologue.h
	public com_rdy
if	@bigmodel
com_rdy	proc	far
else
com_rdy	proc	near
endif

	push	bp
	mov	bp,sp
	mov	dx,@ab[bp]
	mov	ax,0300h
	int	014h
	test	ah,1
	jz	not_ready
	mov	ax,1
	pop	bp
	ret
not_ready:
	xor	ax,ax
	pop	bp
	ret
com_rdy	endp
 
	include epilogue.h
	end
+ARCHIVE+ comyrst.c      617 10/01/1984 17:08:50

/* 
	set communication parameters for channel 
*/
unsigned int com_rst(channel,baudrate,parity,stopbits,wordlen)
unsigned int channel;	/* 0 = COM1, 1 = COM2 */
unsigned int baudrate;	/* 7 = 9600 baud */
unsigned int parity;	/* 0 = no parity */
unsigned int stopbits;	/* 0 = 1 stop bit */
unsigned int wordlen;	/* 3 = 8 bits */
{
struct { unsigned int ax,bx,cx,dx,si,di,ds,es; }  srv;


    srv.ax = ((baudrate & 0x7) << 5) | 
	      ((parity & 0x3) << 3) | 
	      ((stopbits & 0x1) << 2) |
	      (wordlen & 0x3);
    srv.dx = channel;
    sysint(0x14,&srv,&srv);
    return srv.ax;
}




+ARCHIVE+ comystat.asm   306 10/01/1984 17:08:32

;   com_stat: return communication line status

	include model.h
	include prologue.h
	public com_stat

if	@bigmodel
com_stat	proc	far
else
com_stat	proc	near
endif

	push	bp
	mov	bp,sp
	mov	dx,@ab[bp]
	mov	ax,0300h
	int	014h
	pop	bp
	ret
com_stat	endp
 
	include epilogue.h
	end

+ARCHIVE+ crtycls.asm    409 10/01/1984 17:08:32
;
;
; crt_cls: clear screen on page 0 for 25 x 80 monitor
;
;
	include model.h
	include prologue.h
	public crt_cls

if	@bigmodel
crt_cls	proc	far
extrn crt_home:far
else
crt_cls	proc	near
extrn crt_home:near
endif
	push	bp
; clear the screen
	mov	ax,0600h
	mov	bx,7
	xor	cx,cx
	mov	dh,25
	mov	dl,80
	int	010h
	call	crt_home
	pop	bp
	ret
crt_cls	endp
	include epilogue.h
	end


+ARCHIVE+ crtygmod.asm   269 10/01/1984 17:08:34
;
; crt_gmod: get crt mode
;
;
	include model.h
	include prologue.h
	public crt_gmod

if	@bigmodel
crt_gmod proc far
else
crt_gmod proc near
endif
	push	bp
	mov	ax,0f00h
	int	10h
	and	ax,7
	pop	bp
	ret
crt_gmod endp

	include epilogue.h
	end


+ARCHIVE+ crtyhome.asm   292 10/01/1984 17:08:34
;
;
; crt_home: position cursor to 1,1
;
;
	include model.h
	include prologue.h
	public crt_home

if	@bigmodel
crt_home	proc	far
else
crt_home	proc	near
endif
	push	bp
	mov	ax,0200h
	xor	bx,bx
	xor	dx,dx
	int	010h
	pop	bp
	ret
crt_home	endp
	include epilogue.h
	end

+ARCHIVE+ crtyline.c    1236 10/01/1984 17:08:48
/*	draw a line in graphics mode on color monitor
*/

crt_line(x1,y1,x2,y2,color)
int x1;
int y1;
int x2;
int y2;
int color;
{
  struct regval{int ax,bx,cx,dx,si,di,ds,es;}srv,rrv;
  int dx;
  int dy;
  int xinc;
  int yinc;
  int tv;
  int sflag;
  int a;
  int b;

  srv.ax=0x0C00|(color&0xf);	/* set to write dot and set color */ 
  dx=x2-x1;	/* delta x and direction increment */
  xinc=1;
  if(dx<0){
    xinc=-1;	/* negative increment */
    dx=x1-x2;	/* make delta x positive */
  }
  dy=y2-y1;	/* delta y and direction increment */
  yinc=1;
  if(dy<0){
    yinc=-1;	/* negative increment */
    dy=y1-y2;	/* make delta y positive */
  }
  sflag=0;
  if(dy>dx){
    sflag=1;
    iswap(&dy,&dx);	/* dx must be greater of the two */
  }
  srv.cx=x1;	/* coordinates of first point */
  srv.dx=y1;
  tv=(dy<<1)-dx;	/* test variable for the move */
  a=dy<<1;		/* factor to add after each horizontal move */
  b=(dy-dx)<<1;		/* factor to add after each vertical move */
  for(dx++;dx;dx--){
    sysint(0x10,&srv,&rrv);
    if(tv<0)tv+=a;
    else{
      tv+=b;
      if(sflag)srv.cx+=xinc;
      else srv.dx+=yinc;
    }
    if(sflag)srv.dx+=yinc;
    else srv.cx+=xinc;
  }
}

+ARCHIVE+ crtymode.asm   285 10/01/1984 17:08:34
;
; crt_mode: set the crt_mode
;
;
	include model.h
	include prologue.h
	public crt_mode
if	@bigmodel
crt_mode proc far
else
crt_mode proc near
endif

	push	bp
	mov	bp,sp
	mov	ax,@ab[bp]
	and	ax,7
	int	010h	
	pop	bp
	ret
crt_mode endp
	include epilogue.h
	end

+ARCHIVE+ crtyrdot.asm   633 10/01/1984 17:08:36

        include model.h
	include prologue.h

        public crt_rdot

ROW     EQU     @ab[BP]
COL     EQU     @ab+2[BP]

;;;;;
;
;  CRT_RDOT - read a dot on the graphics monitor and return color
;
;  PARMS:  x - x coordinate to plot.
;          y - y coordinate to plot.
;
;;;;;

if	@bigmodel
crt_rdot	proc	far
else
CRT_RDOT        PROC    NEAR
endif
        push    BP
        mov     BP,SP
        mov     AH,13
        mov     CX,COL
        mov     DX,ROW
        int     10H
        xor     AH,AH
        pop     BP
        ret
CRT_RDOT        ENDP
        include epilogue.h
        end


+ARCHIVE+ crtyroll.c     306 10/01/1984 17:08:48
/*	scroll an area of the screen n lines
*/

crt_roll( top,bot,lef,rit,n)
int top,bot,lef,rit,n;
{
	struct { int ax,bx,cx,dx,si,di,ds,es; } srv;

	srv.cx = (top<<8) + lef;
	srv.dx = (bot<<8) + rit;
	srv.ax = ( n<0 ) ? 0x700 - n : 0x600 + n ;
	srv.bx = 0x700;
	sysint ( 0x10, &srv, &srv );
}

+ARCHIVE+ crtysrcp.asm   302 10/01/1984 17:08:36
;
;
;;
;
	include model.h
	include prologue.h

if	@bigmodel
crt_srcp proc far
else
crt_srcp proc near
endif
	public crt_srcp

	push	bp
	mov	ax,0200h
	mov	dh,@ab[bp]
	mov	dl,@ab+2[bp]
	mov	bh,@ab+4[bp]
	xor	bl,bl
	int	010h
	pop	bp
	ret
crt_srcp endp
	include epilogue.h
	end

+ARCHIVE+ crtywdot.asm   681 10/01/1984 17:08:36

;;;;;
;
;  CRT_WDOT - write a dot to the graphics monitor
;
;  PARMS:  x - x coordinate to plot.
;          y - y coordinate to plot.
;          color - color of point to plot.
;
;;;;;

        include model.h
	include prologue.h

        public crt_wdot

ROW     EQU     @ab[BP]
COL     EQU     @ab+2[BP]
COLOR   EQU     @ab+4[BP]


if	@bigmodel
CRT_WDOT	proc	far
else
CRT_WDOT        PROC    NEAR
endif
        push    BP
        mov     BP,SP
        mov     AH,12
        mov     AL,COLOR
        mov     CX,COL
        mov     DX,ROW
        int     10H
        pop     BP
        ret
CRT_WDOT        ENDP
	include epilogue.h
	end



+ARCHIVE+ keyygetc.asm   350 10/01/1984 17:08:38
;
; 	key_getc:  wait for a key to be pressed and return it
;
;
	include model.h
	include prologue.h
	public key_getc
if	@bigmodel
key_getc proc far
else
key_getc proc near
endif
	push	bp
	xor	ah,ah		; ah <- 0
	int	016h		; read keyboard
	pop	bp		; return al=character ah=scan code
	ret
key_getc endp
	include epilogue.h
	end



+ARCHIVE+ keyyscan.asm   378 10/01/1984 17:08:38
;
; 	key_scan:  scan keyboard
;
;
	include model.h
	include prologue.h
	public key_scan
if	@bigmodel
key_scan proc far
else
key_scan proc near
endif
	push	bp
	mov	ah,1
	int	016h 		; scan keyboard
	jnz	none_there	; no character available
	pop	bp
	ret
none_there:
	mov	ax,0ffffh	; return EOF
	pop	bp   
	ret
key_scan endp
	include epilogue.h
	end




+ARCHIVE+ keyyshft.asm   387 10/01/1984 17:08:38
;
; 	key_shft:  wait for a key to be pressed and return it
;
;
	include model.h
	include prologue.h
	public key_shft
if	@bigmodel
key_shft proc far
else
key_shft proc near
endif
	push	bp
	mov	ah,2		; get shift status
	int	016h		; read keyboard
	xor	ah,ah		; clear high byte
	pop	bp		; return keyboard shift status
	ret
key_shft endp
	include epilogue.h
	end




+ARCHIVE+ prtybusy.c     156 10/01/1984 17:08:50
/*

  prt_busy: returns 1 if the printer is busy, 0 if not

*/
prt_busy(printer)
int printer;
{

  return ((prt_stat(printer)&0x80) != 0);
}


+ARCHIVE+ prtyerr.c      395 10/01/1984 17:08:50

/*
  prt_err:  is there a printer error ? 
	    return 1 if Timeout, i/o error, out of paper, 
               	   0 otherwise
*/
prt_err(printer)
int printer;
{
int stat;

  stat = prt_stat(printer);

  if((stat & 0x10) == 0)  /* not selected */
    return 1;

  if(stat & 0x29) 	/* timeout, i/o error, or paper out set */ 
    return 1;

  return 0;		/* okay */
}




+ARCHIVE+ prtyputc.asm   555 10/01/1984 17:08:42
;
;
;  prt_putc: print the character to the printer
;
;	entry:	1 - printer to print to (0-2)
;		2 - character to print
;	returns: printer status byte in AL
;
;
	include model.h
	include prologue.h
	public	prt_putc
if	@bigmodel
prt_putc proc far
else
prt_putc proc near
endif
	push	bp
	mov	bp,sp
	mov	ax,@ab+2[bp]	; get character to print
	xor	ah,ah		; print character request
	mov	dx,@ab[bp]	; get printer to use
	int	017h		; line printer interrupt
	mov	al,ah
	xor	ah,ah
	pop	bp
	ret
prt_putc endp
	include epilogue.h
	end

+ARCHIVE+ prtyrst.asm    473 10/01/1984 17:08:40
;
;
;  prt_rst: reset printer port
;
;	entry:	1 - printer to be used
;
;	returns: printer status in AL
;
	include model.h
	include prologue.h
	public	prt_rst

if	@bigmodel
prt_rst proc far
else
prt_rst proc near
endif
	push	bp
	mov	bp,sp
	mov	ah,1		; reset printer port
	mov	dx,@ab[bp]	; get printer to use
	int	017h		; line printer interrupt
	mov	al,ah		; put printer status in AL
	xor	ah,ah
	pop	bp
	ret
prt_rst	endp
	include epilogue.h
	end
+ARCHIVE+ prtyscr.asm    229 10/01/1984 17:08:40
;
;	print screen to printer
;
	include model.h
	include prologue.h
	public prt_scr
if	@bigmodel
prt_scr	proc	far
else
prt_scr	proc	near
endif
	int	05h	; print screen
	ret

prt_scr	endp
	include epilogue.h
	end

+ARCHIVE+ prtystat.asm   478 10/01/1984 17:08:40
;
;
;  prt_stat: return printer status
;
;	entry:	1 - printer to be used
;
;	returns: printer status in AL
;
	include model.h
	include prologue.h
	public	prt_stat

if	@bigmodel
prt_stat proc far
else
prt_stat proc near
endif
	push	bp
	mov	bp,sp
	mov	ah,2		; get printer status
	mov	dx,@ab[bp]	; get printer to use
	int	017h		; line printer interrupt
	mov	al,ah		; move status into al
	xor	ah,ah
	pop	bp
	ret
prt_stat endp
	include epilogue.h
	end

