;***********************************************************************/
;*	dot.asm                                                       */
;***********************************************************************/
         PAGE ,132
         .SALL
;
INCLUDE MACROS.INC
INCLUDE BIOSDATA.INC

IFDEF MSDOS        ; DEFINED IN LATTICE 2.X M8086.MAC

PSEG

ENDIF
;****************************************************************
;
;	This function draws a colored dot in medium resolution
;	graphics mode. It is called as follows:
; 		dot(col,row,color);
;	where:
;		int col,row;  /* row and coloumn coordinates of point
;		int color;    /* color value between 0 and 3 */
;

	PUBLIC DOT

IF @BIGMODEL+LPROG       ;large code models

DOT	PROC	FAR
COL	EQU	6

ELSE

DOT	PROC	NEAR
COL	EQU	4

ENDIF

ROW	EQU	COL + 2
COLOR	EQU	COL + 4

	JMP PASTDATA

BITTBL	DB	03FH,0CFH,0F3H,0FCH  ; mask to locate proper bits

COLRTBL	DB	00H,040H,080H,0C0H   ; table of color masks
	DB	00H,010H,020H,030H
	DB	00H,004H,008H,00CH
	DB	00H,001H,002H,003H

PASTDATA:
	PUSH BP			;save registers changed
	MOV BP,SP
	PUSH ES
	PUSH BX
	PUSH SI
	PUSH DI

	MOV AX,0B800H	;point es to screen memory
	MOV ES,AX
	XOR DI,DI
	MOV AX,[BP+ROW] ;get row into ax and
	SHR AL,1        ;divide by two to get odd/even bit

	JNC EVENROW     ;even rows start at offset 0 and odd rows
	MOV DI,02000H   ;start at an offset 2000h 

EVENROW:
	SAL AX,1	;multiply row by 80 to get offset of correct
	SAL AX,1	;80 byte row for point
	SAL AX,1
	SAL AX,1
	MOV BX,AX
	SAL AX,1
	SAL AX,1
	ADD AX,BX	;now multiplied by 80

	ADD DI,AX	;add to odd/even offset for location in memory

	MOV AX,[BP+COL] ;get column
	MOV SI,AX	;store it in si
	SHR AX,1	;divide it by 4 to get specific byte (4 points/byte)
	SHR AX,1
	ADD DI,AX	;add to offset for exact byte - save it in di

	AND SI,03H		;mask off all bits except color bits
	MOV AL,CS:BITTBL[SI]	;get proper byte mask

	SHL SI,1		;multiply by 4 
	SHL SI,1
	ADD SI,[BP+COLOR]	;add to color to get correct color mask

	AND AL,ES:[DI]		;mask memory byte with bit mask
	OR  AL,CS:COLRTBL[SI]	;or it with color mask
	MOV ES:[DI],AL		;move it back to memory

	POP DI		;restore original register values
	POP SI
	POP BX
	POP ES
	POP BP
	RET

DOT	ENDP
;
IFDEF CI_C86

@CODE	ENDS

ELSE

ENDPS

ENDIF
	END


