/***********************************************************************/
/*	envirget.c                                                    */
/***********************************************************************/

/*  return a parameter string from the environment  */
envirget(spec,parm)
char *spec; /* the environment specification to look for */
char *parm; /* the returned parameter if spec is found; NUL if not found */
{
  extern unsigned _top; /* address of top of stack stored in XCMAIN (C.obj) */

  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  unsigned pspseg;  /* segment address of program segment prefix  */
  unsigned envseg;  /* segment address of environment */
  unsigned *ptr;    /* temporary pointer used get pspseg & envseg    */
  char line[129];   /* temporary area used to search evvironment */
  int i,j,k,l,m,n,length;   /* temporary variables  */
  int eq;           /* index into line for equal sign (=) */
  int parmend;	    /* index into line for NUL */


  ret_code = gdosint(0,&regs,&regs); /* get default ds for segmov below. */

  ptr = _top - 2; /* address of pspseg is first thing pushed onto stack by */
                 /* XCMAIN. Therefore, it can be found at _top - 2        */
  pspseg = *ptr;
  ptr = pspseg + 0x2C; /* environment address is at offset 2C in psp  */

  i = 2;    /* get address of environment (2 bytes) with segmov below */
  j = 0;    /* use default to segment in segmov by passing a 0 */
  k = 0x2C; /* offset in pspseg of environment address */
  ptr = &envseg;  /* only good for small data models */
  segmov(i,k,pspseg,ptr,regs.ds);
  ptr=&line[0]; /* used in segmov below */
  length = strlen(spec);  /* get length of specification */
  line[128] = '\0';  /* make sure we can use line as a string  */
  i = 128;  /* scan this many bytes at a time */
  j = 0;    /* use for default 'to' segment in segmov */
  k = 0;    /* used as offset for from seg */
  while (1 == 1){
	segmov(i,k,envseg,ptr,regs.ds);  /* move 128 bytes to line */
	eq = strchind('=',line);  /* look for end of spec */
	m = strindex(spec,line);	 
        if ( m > eq || m == -1 ){    /* not first spec in line so move down */
            parmend = strlen(line);  /* look for end of spec & parm */
            if ( parmend == 0 || parmend > 127) /* problem in environment */
                return(-99);
            if ( line[parmend+1] == '\0' )  /* end of environment */
                return(99);  /* specification not found */
            k = k + parmend+1;
            continue;  /* get more of environment to scan */
        }else{
	      parmend = strlen(line);  /* get end of spec & param */
              m = strsub(&line[eq],parm,1,parmend-eq,128);
              return(0);
        }
  }
}	
