/***********************************************************************/
/*	asystat.c                                                     */
/***********************************************************************/

asystat(comm,line,modem) /* get comm port status */
int comm; /* port number */
int *line; /* line status returned */                    
int *modem; /* modem status returned */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */
  
  if ( comm < 0 || comm > 1 )
     return(-1);
  regs.dh=0;
  regs.dl=comm;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  regs.ah=3;      /* get status of comm port */
  int_no=0x14;
  ret_code = gdosint(int_no,&regs,&regs);
  *line=regs.ah;  /* return status */
  *modem=regs.al;
  return(0);
}
