/***********************************************************************/
/*	strsub.c                                                      */
/***********************************************************************/

/* function to extract a substring of characters from a string */
strsub(ins,outs,pos,cnt,maxsize)
char *ins; /* source string */
char *outs; /* output (target) string */
int pos; /* starting character position */
int cnt; /* # of characters to be extracted */
int maxsize; /* size of output (target) string */
{
int i; /* return value (actual characters extracted ) */
/* check for negative starting position */
if(pos < 0) return(-1);
/* check for non positive maximun size */
if(maxsize < 1) return(-2);
/* check for starting position passed null terminator */
for(i = 0; i < pos; ++i)
  {
  if(ins[i] == '\0') return(-3);
  }
/* check for non positive count */
if(cnt < 0) return(-4);
/* check for cnt > maxsize */
if(cnt > (maxsize - 1)) return(-5);
for( i = pos; i < (cnt + pos); ++i)
  {
  outs[i - pos] = ins[i];
  if(ins[i] == '\0') return(i - pos);
  }
outs[i - pos] = '\0';
return(i - pos);
}
