;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
PAGE	,132
	TITLE	ANSI - ANSI device driver

	.LFCOND
	.TFCOND		; Use the /X switch to cause FALSE conds not to list

	INCLUDE	PARMS.ASM

    IF LISTI
	IF1
	%OUT	*Full listing being generated*
	ENDIF
    ELSE
	IF1
	%OUT	*Include files are not part of listing*
	ENDIF

	.XLIST
    ENDIF

INCLUDE	MACLIB.ASM
INCLUDE	DEFDEV.ASM
INCLUDE	DEFCHR.ASM
INCLUDE	DEFDOSI.ASM
INCLUDE	DEF6821.ASM
INCLUDE	DEFBIOS.ASM

	.LIST
	PAGE

CODE	SEGMENT	BYTE PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE

BIOS_DEVS LABEL	BYTE
DVH_ANSI LABEL	NEAR
	ERRNZ	DVH_ANSI,DVH_OFF
	DW	-1
	ERRNZ	DVH_ANSI,DVH_SEG
	DW	-1	
	ERRNZ	DVH_ANSI,DVH_ATTR
	DW	DVHA_CHR
	ERRNZ	DVH_ANSI,DVH_STRAT
	DW	OFFSET STRATEGY
	ERRNZ	DVH_ANSI,DVH_INTR
	DW	OFFSET INTR_ANSI
	ERRNZ	DVH_ANSI,DVH_NAME
	DB	"ANSI    "
	ERRNZ	DVH_ANSI,<SIZE DVH_STRUC>

ANSITBL	LABEL	NEAR
	ERRNZ	ANSITBL,SRHC_INIT
	DW	ANSI_INIT	; Initialization
	ERRNZ	ANSITBL,SRHC_MCHK*2
	DW	EXIT_SUCC	; Media check 
	ERRNZ	ANSITBL,SRHC_BPB*2
	DW	EXIT_SUCC	; Build BPB 
	ERRNZ	ANSITBL,SRHC_ICTL*2
	DW	EXIT_SUCC	; IOCTL input
	ERRNZ	ANSITBL,SRHC_IN*2
	DW	ANSI_IN		; Input
	ERRNZ	ANSITBL,SRHC_ICHK*2
	DW	ANSI_ICHK	; Non-destructive input no wait 
	ERRNZ	ANSITBL,SRHC_ISTAT*2
	DW	ANSI_ISTAT	; Input status 
	ERRNZ	ANSITBL,SRHC_IFL*2
	DW	ANSI_IFL		; Input flush 
	ERRNZ	ANSITBL,SRHC_OUT*2
	DW	ANSI_OUT		; Output
	ERRNZ	ANSITBL,SRHC_OUTV*2
	DW	ANSI_OUT		; Output (write) with verify
	ERRNZ	ANSITBL,SRHC_OSTAT*2
	DW	ANSI_OSTAT	; Output status 
	ERRNZ	ANSITBL,SRHC_OFL*2
	DW	ANSI_OFL		; Output flush 
	ERRNZ	ANSITBL,SRHC_OCTL*2
	DW	EXIT_SUCC	; IOCTL output
	ERRNZ	ANSITBL,(SRHC_MAX+1)*2

STRATP	PROC	FAR

PTRSAV		DD ?		; Request packet pointer

STRATEGY:
	MOV	WORD PTR CS:PTRSAV,BX
	MOV	WORD PTR CS:PTRSAV+2,ES
	RET
STRATP	ENDP

; Get addr of dispatch table and join common code

INTRP	PROC	FAR

INTR_ANSI:
	PUSH	SI
	MOV	SI,OFFSET ANSITBL
	PUSH	AX		; Save regs
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	

; Check if command valid, and then dispatch to it

	LES	BX,CS:PTRSAV	; Get packet addr
	MOV	CL,ES:SRH_CMD[BX]	; Get command
	CMP	CL,SRHC_MAX	; Is command valid ?
	JA	CMDERR		;   No, show error
	XOR	CH,CH		; Clear upper half
	SHL	CX,1		; Make into word offset
	ADD	SI,CX		; Compute table entry
	JMP	WORD PTR CS:[SI] ; Dispatch to command


; Busy exit

EXIT_BUS:
	MOV	AH,SRHS_BUI OR SRHS_DON ; Mark busy and done
	JMP	SHORT EXIT1	; Join common code


; Command error exit

CMDERR:
	MOV	AL,SRHS_EUKC	; Get UNKNOWN CODE
;	JMP	SHORT EXIT_ERR	; Join common code


; Error exit

EXIT_ERR:
	MOV	AH,SRHS_ERR OR SRHS_DON ; Mark error and done
	JMP	SHORT EXIT1	; Join code


; Success exit	

EXIT_SUCC:
	MOV	AH,SRHS_DON	; Mark as done
;	JMP	SHORT EXIT1	; Join common code


; Common exit code

EXIT1:
	LES	BX,CS:PTRSAV	; Get packet addr
	MOV	ES:SRH_STAT[BX],AX ; Store status

	POP	ES		; Restore regs
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POP	SI
	RET
INTRP	ENDP

;
; ANSI_INIT - Set up CON device
;

ANSI_INIT:
	MOV	AX,CS
	MOV	DS,AX
	MOV	DX,OFFSET END_DRIVER		; DS:DX Points to end
	MOV	ES:WORD PTR CIN_KADDR[BX],DX
	MOV	ES:WORD PTR CIN_KADDR[BX+2],AX	
	JMP	EXIT_SUCC

;
; Read from console
;

ANSI_IN:
	MOV	CX,ES:CRW_CNT[BX]	; Get byte count
	LES	DI,ES:CRW_TADDR[BX] ; Get transfer addr
ALL_IN1:
	PUSH	DI		; Save regs
	PUSH	CX
ALL_IN2:
	MOV	AH,CHR_READ	; Get read function
	PUSH	SI
	CALL	FAR PTR BIOS_CONFUNC
	POP	SI
	JC	ALL_IN2		;   Yes, try again

	POP	CX		; Restore regs
	POP	DI
	STOSB			; Store char
	LOOP	ALL_IN1		; Continue until done
	JMP	EXIT_SUCC	; Join common code
	

;
; Non-destructive read
;

ANSI_ICHK:
	MOV	BP,BX		; Save BX
	MOV	AH,CHR_LOOK	; Get Look function
	CALL	FAR PTR BIOS_CONFUNC
	MOV	BX,BP		; Recover BX
	JNC	ALL_ICHK1	;    No, skip
	JMP	EXIT_BUS	;    Yes, show busy
ALL_ICHK1:
	MOV	ES:CIC_CHAR[BX],AL	;    No, store char
	JMP	EXIT_SUCC	; and return

;
; Input status
;

ANSI_ISTAT:
	MOV	AH,CHR_STATUS	; Get Status function
	MOV	AL,CHR_SFGS	; Get status subfunction
	CALL	FAR PTR BIOS_CONFUNC
	TEST	AH,CHRS_RXR	; Does receiver have data ?
	JZ	ALL_ISTAT1	;   No, skip
	JMP	EXIT_SUCC	;   Yes, show it
ALL_ISTAT1:
	JMP	EXIT_BUS

;
; Input flush
;

ANSI_IFL:
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCI	; Get clear input subfunction
	CALL	FAR PTR BIOS_CONFUNC
	JMP	EXIT_SUCC	; Join common code

;
; Write to console
;

ANSI_OUT:
	MOV	CX,ES:CRW_CNT[BX]	; Get byte count
	LES	SI,ES:CRW_TADDR[BX] ; Get transfer addr
ALL_OUT1:
	MOV	AL,ES:[SI]
	INC	SI
	MOV	AH,CHR_WRITE	; Get read function
ALL_OUT2:
	MOV	BP,AX		; Save char and function
	PUSH	DI
	PUSH	CX
	PUSH	SI
	PUSH	ES
	PUSH	DS
	MOV	BX,CS
	MOV	DS,BX
	CALL	ANSI_CONFUNC
	POP	DS
	POP	ES
	POP	SI
	POP	CX
	POP	DI
	MOV	AX,BP		; Recover AX
	JC	ALL_OUT2	;   Yes, try again

	LOOP	ALL_OUT1		; Continue until done
	JMP	EXIT_SUCC	; Join common code

;
; Output status
;

ANSI_OSTAT:
	MOV	AH,CHR_STATUS	; Get Status function
	MOV	AL,CHR_SFGS	; Get status subfunction
	CALL	FAR PTR BIOS_CONFUNC
	TEST	AH,CHRS_TXR	; Is transmitter ready to send data
	JZ	ALL_OSTAT1	;   No, skip
	JMP	EXIT_SUCC	;   Yes, show it
ALL_OSTAT1:
	JMP	EXIT_BUS

;
; Flush output 
;

ANSI_OFL:
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCO	; Get clear output subfunction
	CALL	FAR PTR BIOS_CONFUNC
	JMP	EXIT_SUCC	; Join common code

;
;ANSI Info and routines. ANSI driver implemented as a finite state automata
;This ANSI driver translates the ANSI standard escape sequences into the
; Zenith Escape sequences used on the Zenith(Heath) Z(H)-19 terminal.
; not a full implementation of ANSI, but rather a minimal implementation
; which implements all of the necessary ANSI functions.
;


;
; ANSI console output driver.
;

ANSI_CONFUNC: MOV     DI,OFFSET  STATE ;Retrieve current ansi state.
        JMP     [DI]            ;Jump to it.

;
; State one (1).
;   Looks for an Escape character.
;

ST1:    CMP     AL,ESC          ;See if this the first character is ESC.
        JNZ     ST1A	        ;No, treat as regular character output.
        MOV     WORD PTR [DI],OFFSET ST2        ;Yes, setup state two.
        RET
ST1A:
	JMP	NEAR PTR OUTCHR

;
; State two (2).
;   Looks for the "[" character.
;

ST2:
        CMP     AL,'['          ;See if a valide state two.
        JZ      ST2A		; If an extra big one
	MOV	DI,OFFSET SAMCT	; Special ansi mode character table
ST2B:
	CMP	BYTE PTR [DI],0
	JZ	ST2D
	CMP	AL,BYTE PTR [DI]
	JZ	ST2C
	ADD	DI,3
	JMP	SHORT ST2B
ST2C:
	JMP	DS:WORD PTR [DI+1]
ST2A:
        MOV     BX,OFFSET PARAMS ;Yes, get parameter pointer.
        MOV     WORD PTR [PRMPNT],BX    ;Setup in pointer index.
        MOV     WORD PTR [BX],0 ;Clear first entry.
        MOV     WORD PTR [DI],OFFSET ST3;Setup for state three.
        RET
ST2D:
	JMP	NEAR PTR OUTCHR

;
; SKIP1 - Skip next character
;

SKIP1:
	MOV	WORD PTR STATE,OFFSET STSKIP
	RET

STSKIP:
	MOV	WORD PTR STATE,OFFSET ST1
	RET

;
; State three (3).
;   Entered one or more times for parameter passing.
;

ST3:    CMP     AL,';'          ;Look for decimal # seperator.
        JNZ     ST3A            ;No check phase A.
        INC     WORD PTR [PRMPNT]       ;Yes, incr. pointer to next param.
        MOV     AX,OFFSET LASTPRM       ;Check for outside parameter list.
        CMP     [PRMPNT],AX
        JBE     RETST3          ;Yes, proceed with next parameter.
        MOV     [PRMPNT],AX     ;No, treat as extentsion to old.
RETST3: MOV     DI,[PRMPNT]     ;Setup for next parameter.
        MOV     BYTE PTR [DI],0 ;Pre-Initialize it to zero.
        RET

;
; State three A (3A).
;   Check for a ascii digit.
;

ST3A:   CMP     AL,'0'          ;Check for ASCII digit.
        JB      ST3B            ;No, check for seconday command character.
        CMP     AL,'9'          ;Still checking for ASCII digit.
        JA      ST3B            ;No, it must be a secondary.
        SUB     AL,'0'          ;Convert to binary.
        MOV     DI,[PRMPNT]     ;Get the current parameter pointer.
        XCHG    [DI],AL         ;Get existing #.
        MOV     AH,10           ;Scale by 10.
        MUL     AH
        ADD     [DI],AL         ;Add to new digit.
        RET

;
; State three B (3B).
;   Wasn't a ascii digit, so check for secondary command.
;

ST3B:   MOV     WORD PTR [DI],OFFSET ST1         ;Preset STATE to state 1 just in case.
        MOV     DI,OFFSET PARAMS-1       ;Get pointer to start of parameters.
        MOV     [PRMPNT],DI             ;Save it in Parameter pointer.
        MOV     DI,OFFSET CMDTABL-3     ;Get start of Secondary command table.

ST3B1:  ADD     DI,3            ;Update Command table pointer.
        CMP     BYTE PTR [DI],0 ;Check for end of table.
        JNZ     ST3B2           ;No, continue processing.
        JMP     OUTCHR          ;Yes, treat as regular character.
ST3B2:  CMP     AL,[DI]         ;Check for valid. command.
        JNZ     ST3B1           ;No, keep checking.
        JMP     [DI+1]          ;Yes, transfer to that secondary command.

;
; Get binary parameter from storage and return a one if = 0
;

GETONE: CALL    GETPARM         ;Get parameter form list.
        OR      AL,AL           ;Verify for non-zero.
        JNZ     GETRET          ;Good, then return to caller.
        INC     AL              ;Bad, make it at least a one.
GETRET: CBW                     ;Sign extend AL.
        MOV     CX,AX           ;Copy of it to CX.
        RET

GETPARM:INC     WORD PTR [PRMPNT]       ;Increment parameter pointer.
GOTPARM:MOV     DI,[PRMPNT]     ;Get parameter pointer.
        MOV     AL,[DI]         ;Get parameter value.
        RET

; output character in AL

OUTCHR:
	MOV	AH,CHR_WRITE
	PUSH	BX
	CALL	BIOS_CONFUNC
	POP	BX
	RET

;
; Send escape, character sequence.
;

OUTESC: MOV     AL,ESC          ;Send escape character.
        CALL    OUTCHR
        MOV     AL,BL           ;Send follow character.
        JMP     OUTCHR

;
; Question mark, major command
;

QMARK:
	MOV     WORD PTR STATE,OFFSET ST3	; Look for params
	MOV	BYTE PTR QMARKFLG,1		; Set ? flag
	INC	WORD PTR [PRMPNT]		; Ready for parameters

;	NOP - Do nothing

NOP:
	RET

QMARKH:
	MOV	DI,OFFSET QMARKHT
	JMP	SHORT QMARK1
QMARKL:
	MOV	DI,OFFSET QMARKLT
QMARK1:
	CMP	BYTE PTR QMARKFLG,1
	JNZ	QMARKX
	MOV	BYTE PTR QMARKFLG,0		; Reset it
	PUSH	DI
	CALL	GETPARM
	POP	DI
	CMP	AX,17
	JNB	QMARKX				; Too large
	DEC	AX				; Make 0-15 based
	ADD	AX,AX				; Make word offset
	ADD	DI,AX
	CALL	WORD PTR [DI]
QMARKX:
	MOV	WORD PTR STATE,OFFSET ST1
	RET

;
; Enter / exit auto repeat mode
;

EAM:
	MOV	BL,'y'
	JMP	EAM1
XAM:
	MOV	BL,'x'
EAM1:
	CALL	OUTESC
	MOV	AL,'<'
	JMP	OUTCHR

;
; Cursor Positioning routines.
;

CUU:    MOV     BL,'A'          ;Cursor up.
        JMP     SHORT CURPOS
CUD:    MOV     BL,'B'          ;Cursor down.
        JMP     SHORT CURPOS
CUF:    MOV     BL,'C'          ;Cursor forward.
        JMP     SHORT CURPOS
CUB:    MOV     BL,'D'          ;Cursor back.

CURPOS: CALL    GETONE          ;Get number of positions to move into CX.
MOVCUR: CALL    OUTESC          ;Send escape, command characters.
        LOOP    MOVCUR          ;Keep moving until done.
        RET

;
; Insert and delete lines
;

DCS:
	MOV	BL,'N'
	JMP	CURPOS
ILS:
	MOV	BL,'L'
	JMP	CURPOS
DLS:
	MOV	BL,'M'
	JMP	CURPOS

;
; Wrap, don't wrap at end of line
;

WEL:
	MOV	BL,'v'
	JMP	CURPOS
DEL:
	MOV	BL,'w'
	JMP	CURPOS

;
; Enter/exit reverse video
;

ERV:
	MOV	BL,'p'
	JMP	CURPOS
XRV:
	MOV	BL,'q'
	JMP	CURPOS

;
; Direct cursor positioning routine.
;

CUP:    CALL    GETONE          ;Get X position.
        MOV     DX,AX           ;Save in DX.
        CALL    GETONE          ;Get Y position.
        MOV     BL,'Y'
        CALL    OUTESC          ;Send escape, "Y" sequence.
        MOV     AL,DL
        ADD     AL,' '-1        ;Convert binary to Character.
        CALL    OUTCHR          ;Send X posit.
        MOV     AL,CL
        ADD     AL,' '-1        ;Convert binary to Character.
        JMP     OUTCHR          ;Send Y posit.

;
; Erase all/part of screen.
;

ED:     CALL    GETPARM         ;Get trinary command type.
        MOV     BL,'b'
        DEC     AL              ;See if erase from begining of screen.
        JZ      ED1             ;Yes, perform ZDS function.
        MOV     BL,'E'
        DEC     AL              ;See if erase from end of screen.
        JZ      ED1             ;Yes, perform ZDS function.
        MOV     BL,'J'          ;Now we assume erase whole screen.
ED1:    JMP     OUTESC

;
; Erase all/part of a line.
;

EL:     CALL    GETPARM         ;Get trinary command type.
        MOV     BL,'o'
        DEC     AL              ;See if erase from begining of line.
        JZ      EL1             ;Yes, perform ZDS function.
        MOV     BL,'l'
        DEC     AL              ;See if erase whole line.
        JZ      EL1             ;Yes, perform ZDS function.
        MOV     BL,'K'          ;Now we assume erase to end of line.
EL1:    JMP     OUTESC

;
; Special video modes.
;

SGR:    CALL    GETPARM         ;Get trinary command type.
        MOV     BL,'p'
        CMP     AL,7            ;See if enter reverse video mode.
        JZ      SGR2            ;Yes, perform ZDS function.
        MOV     BL,'q'
        OR      AL,AL           ;See if exit reverse video mode.
        JZ      SGR2            ;No, ignore.
	MOV	BL,'F'
	CMP	AL,10		;Graphics on
	JZ	SGR2
	MOV	BL,'G'		;Graphics off
	CMP	AL,11
	JNZ	SGR3
SGR2:   CALL    OUTESC
SGR3:   RET

;
; Save / restore cursor position.
;

PSCP:   MOV     BL,'j'          ;Set save cursor posit. mode.
        JMP     OUTESC

PRCP:   MOV     BL,'k'          ;Restore last cursor save.
        JMP     OUTESC

;
;	Enter/exit alternate keypad mode
;

EAKM:	MOV	BL,'x'
	CALL	OUTESC
	MOV	AL,'7'
	JMP	OUTCHR
XAKM:	MOV	BL,'y'
	CALL	OUTESC
	MOV	AL,'7'
	JMP	OUTCHR

;
; IDENT - Identify as VT100 w/AVO option installed
;

IDENT:
	MOV	BL,'['
	CALL	OUTESC		; <esc> [
	MOV	BL,'?'
	CALL	OUTCHR		; ?
	MOV	BL,'1'
	CALL	OUTCHR		; 1
	MOV	BL,';'
	CALL	OUTCHR		; ;
	MOV	BL,'2'
	CALL	OUTCHR		; 2
	MOV	BL,'c'
	JMP	OUTCHR		; c

ESC     EQU     1BH             ;Escape character used in this implementation.

STATE   DW      ST1             ;Current ANSI character state.

PRMPNT  DW      PARAMS          ;Current parameter pointer.

PARAMS  DB      0,0,0,0,0,0,0   ;Allow for up to eight parameters.
LASTPRM DB      0               ;With this being the eight one.

CMDTABL DB      'A'             ;Cursor up.  "esc","[",#,"A"
        DW      CUU
        DB      'B'             ;Cursor down. "esc","[",#,"B"
        DW      CUD
        DB      'C'             ;Cursor forward. "esc","[",#,"C"
        DW      CUF
        DB      'D'             ;Cursor back. "esc","[",#,"D"
        DW      CUB
        DB      'H'             ;Direct cursor posit. "esc","[",x,y,"H"
        DW      CUP
        DB      'J'             ;Erase. "esc","[",code,"J"
        DW      ED
        DB      'K'             ;Erase in line. "esc","[",code,"K"
        DW      EL
	DB	'L'		;Insert 'x' lines
	DW	ILS
	DB	'M'		;Delete 'x' lines
	DW	DLS
	DB	'P'		;Delete character
	DW	DCS
        DB      'f'             ;Direct cursor posit. "esc","[",x,y,"f"
        DW      CUP
        DB      'm'             ;Special video mode. "esc","[",code,"m"
        DW      SGR
        DB      's'             ;Save cursor posit. "esc","[","s"
        DW      PSCP
        DB      'u'             ;Move cursor to saved. "esc","[","u"
        DW      PRCP
	DB	'?'		;Special functions
	DW	QMARK
	DB	'h'		;Set mode #2
	DW	QMARKH
	DB	'l'		;Reset mode #2
	DW	QMARKL
	DB	'c'		;Identify
	DW	IDENT
	DB	'r'		;Ignore any ending in 'r'
	DW	STSKIP
	DB	'q'		;   or ending in 'q'
	DW	STSKIP
	DB	'w'		;   or ending in 'w'
	DW	STSKIP
	DB	'i'		;   or ending in 'i'
	DW	STSKIP
	DB	'g'		;   or ending in 'g'
	DW	STSKIP
	DB	'n'		;   or ending in 'n'
	DW	STSKIP
	DB	'p'		;   or ending in 'p'
	DW	STSKIP
	DB	'v'		;   or ending in 'v'
	DW	STSKIP
	DB	'x'		;   or ending in 'x'
	DW	STSKIP
	DB	'z'		;   or ending in 'z'
	DW	STSKIP
	DB	'}'		;   or ending in '}'
	DW	STSKIP
        DB      00              ;End of table.

SAMCT	LABEL	BYTE
	DB	'='
	DW	EAKM
	DB	'>'
	DW	XAKM
	DB	')'
	DW	SKIP1
	DB	'('
	DW	SKIP1
	DB	'#'
	DW	SKIP1
	DB	0

QMARKFLG	DB	0	;=0 if no <esc>[? seen

QMARKHT	LABEL	BYTE
	DW	NOP		;1 = set cursor keys
	DW	NOP		;2 = Enter ZDS mode
	DW	NOP		;3 = set 132 column mode
	DW	NOP		;4 = enter soft scroll mode
	DW	ERV		;5 = reverse screen mode
	DW	NOP		;6 = relative addressing
	DW	WEL		;7 = wrap at end of line
	DW	EAM		;8 = Auto repeat on
	DW	NOP		;9 = interlace mode
	DW	NOP		;10 = edit mode
	DW	NOP		;11 = line transmit mode
	DW	NOP		;12 = undefined
	DW	NOP		;13 = space compression mode
	DW	NOP		;14 = transmit execution mode
	DW	NOP		;15 = undefined
	DW	NOP		;16 = set edit key immediate mode

QMARKLT	LABEL	BYTE
	DW	NOP		;1 = set cursor keys
	DW	NOP		;2 = Enter ZDS mode
	DW	NOP		;3 = set 132 column mode
	DW	NOP		;4 = enter soft scroll mode
	DW	XRV		;5 = reverse screen mode
	DW	NOP		;6 = relative addressing
	DW	DEL		;7 = wrap at end of line
	DW	XAM		;8 = Auto repeat on
	DW	NOP		;9 = interlace mode
	DW	NOP		;10 = edit mode
	DW	NOP		;11 = line transmit mode
	DW	NOP		;12 = undefined
	DW	NOP		;13 = space compression mode
	DW	NOP		;14 = transmit execution mode
	DW	NOP		;15 = undefined
	DW	NOP		;16 = set edit key immediate mode

END_DRIVER	LABEL	NEAR

CODE	ENDS
	END

