/* demo.c - essential software demonstration main program */

#include "graphics.h"

struct plotpos base;  /* required for graphics routines using base */

/* The following are externals declared for convenience here. */
/* They are used in all three demo functions as temporary variables */

int i,k,d1,d2,d3,dx[7],dy[7],l1[10],l2[10],l3[10];
int r1x[20],r1y[20],r2x[20],r2y[20],r3x[20],r3y[20],r4x[20],r4y[20];
char in[80],out[80],color;

main()
{
int j,n,p,g,c,d,v,m;  /* temporaries used by main   */
char h[80];
/* do equipment check to see if we can use multiple pages */
equipmnt(&p,&g,&c,&d,&v,&m);
if( v == 1) color = 'y';   /* v is video mode returned. 1 = color adapter */
  else color = 'n';
again:
clrscrn();
if(color == 'y')  /* use multiple video pages for color adapter */
  {
  setscmod(2);
  disppage(3);
  refpage(0);
  }
curlocat(4,0);
colrcprt("ESSENTIAL SOFTWARE, Inc.",7,0);
curlocat(6,0);
colrcprt("DEMO MENU",7,0);
curlocat(9,29);
colrprts("1: STRING CAPABILITIES",7,0);
curlocat(10,29);
colrprts("2: SCREEN HANDLING CAPABILITIES",7,0);
curlocat(11,29);
colrprts("3: GRAPHICS",7,0);
curlocat(12,29);
colrprts("4: EXIT DEMO",7,0);
if(color == 'y') disppage(0);
clearkbd();
key:
j = getkey(&n);
switch(n)
  {
  case 49: demo1();
           goto again;
  case 50: demo2();
           goto again;
  case 51: demo3();
           goto again;
  case 52: clrscrn();
           curtype(0,6,7);
           return;
  default: beep();
           goto key;
  }
}


/* function to get a string from the keyboard */
getstr(x)
char *x;
{
int i,j,k;
i = -1;
while(j != 13){
  ++i;
  k = getkey(&j);
  if (k == 0){       /* not a special key */
       wrtchtty(j,1);
       x[i] = j;
  }
}
x[i] = '\0';
}


/* function to get an integer from the keyboard for the demo */
getint()
{
char x[80],sign;
int i,j,k,l,n,p;
i = -1;
sign = '+';
while(j != 10000)
  {
  k = getkey(&j);
  curfwd();
  if((k == 0)&&(j == 13)) break;
  if((k == 0)&&(j == 32)) break;
  if((k == 0)&&(j == 45)&&(i == -1))
    {
    sign = '-';
    wrtch(1,j);
    continue;
    }
  if((k == 0)&&(j == 43)&&(i == -1))
    {
    sign = '+';
    wrtch(1,j);
    continue;
    }
  if((k != 0)||(j < 48)||(j > 57)||(i == 4))
    {
    beep();
    curback();
    continue;
    }
  wrtch(1,j);
  ++i;
  x[i] = j;
  }
if(i == -1) return(0);
n = i;
k = 0;
for(j = 0; j < i + 1; ++j)
  {
  p = exp(10,n);
  l = (x[j] - 48) * p;
  k = k + l;
  --n;
  }
if(sign == '-') return(-k);
return(k);
}


/* function to raise a number to a power for the getint function */
exp(a,b)
int a,b;
{
int x,y;
y = 1;
for(x = 1; x <= b; ++x) y = y * a;
return(y);
}
