/***********************************************************************/
/*	initgraf.c                                                    */
/***********************************************************************/

initgraf(mode,palette,bakrnd) /* initialize graphics modes and colors */
int mode; /* graphics mode to initialize */
int palette; /* color palette to be used */
int bakrnd; /* background color to be used */
{
  struct intregs regs; /* registers for gdosint    */
  int ret_code,int_no;        /* return code and interrupt for gdosint */

  if ( mode > 2 || mode < 0 )
     return(-1);
  if (mode == 0 )
     mode = 3;
  if ( mode == 1 )
     mode = 4;
  if ( mode == 2 ){
     setscmod(6);
     return(0);
  }
  setscmod(mode);

  regs.ah=11;
  regs.bh=0; /* 0 for setting background */
  regs.bl=bakrnd;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
  regs.ah=11;
  regs.bh=1; /* 1 for setting palette */
  regs.bl=palette;
  regs.es=regs.ds=0;   /* default value - no changes to register */
  int_no=0x10; /* video I/O BIOS call */
  ret_code = gdosint(int_no,&regs,&regs);
}
