;	Copyright(C) 1985, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	     This computer software and documentation 
;	are provided with RESTRICTED RIGHTS.  Use,
;	duplication or disclosure by the Government is
;	subject to restrictions as set forth in the
;	governing Rights in Technical Data and Computer
;	Software clause -- subdivision (b)(3)(B) of DAR
;	7-104.9(a) (May 1981) or subdivision (b)(3)(ii)
;	of DOD FAR Supp 252.227-7013 (May 1981).
;
;

LORGADDR	=	400H	; Loader org address


;
; BIOS entry points
;

BIOS_SEG SEGMENT AT 40H		; Segment where the BIOS is located

; MicroSoft(MS) defined entry points

	ORG 0*3
  BIOS_INIT	LABEL FAR	; Initialization routine (only exists
				;   at boot time)
	ORG 1*3
  BIOS_STATUS	LABEL FAR	; Console input status
	ORG 2*3
  BIOS_CONIN	LABEL FAR	; Console input
	ORG 3*3
  BIOS_CONOUT	LABEL FAR	; Console output
	ORG 4*3
  BIOS_PRINT	LABEL FAR	; Printer output
	ORG 5*3
  BIOS_AUXIN	LABEL FAR	; Aux input
	ORG 6*3
  BIOS_AUXOUT	LABEL FAR	; Aux output
	ORG 7*3
  BIOS_READ	LABEL FAR	; Disk input
	ORG 8*3
  BIOS_WRITE	LABEL FAR	; Disk output
	ORG 9*3
  BIOS_DSKCHG	LABEL FAR	; Disk change status
	ORG 10*3
  BIOS_SETDATE	LABEL FAR	; Set current date
	ORG 11*3
  BIOS_SETTIME	LABEL FAR	; Set current time
	ORG 12*3
  BIOS_GETDATE	LABEL FAR	; Get current date
	ORG 13*3
  BIOS_FLUSH	LABEL FAR	; Flush keyboard buffer
	ORG 14*3
  BIOS_MAPDEV	LABEL FAR	; Device mapping
	ORG 15*3
  BIOS_MRES9	LABEL FAR	; Reserved for MicroSoft entry points
	ORG 16*3
  BIOS_MRES8	LABEL FAR
	ORG 17*3
  BIOS_MRES7	LABEL FAR
	ORG 18*3
  BIOS_MRES6	LABEL FAR
	ORG 19*3
  BIOS_MRES5	LABEL FAR
	ORG 20*3
  BIOS_MRES4	LABEL FAR
	ORG 21*3
  BIOS_MRES3	LABEL FAR
	ORG 22*3
  BIOS_MRES2	LABEL FAR

; Zenith Data System(ZDS) defined entry points

	ORG 23*3
  BIOS_INTFUNC	LABEL FAR	; Interrupt functions
	ORG 24*3
  BIOS_DSKFUNC	LABEL FAR	; Disk function
	ORG 25*3
  BIOS_PRNFUNC	LABEL FAR	; PRN(Printer) function
	ORG 26*3
  BIOS_AUXFUNC	LABEL FAR	; AUX(modem) function
	ORG 27*3
  BIOS_CONFUNC	LABEL FAR	; CON(console) function
 	ORG 28*3
  BIOS_ZRES4	LABEL FAR	; Reserved for Zenith entry points
	ORG 29*3
  BIOS_ZRES3	LABEL FAR
	ORG 30*3
  BIOS_ZRES2	LABEL FAR
	ORG 31*3
  BIOS_ZRES1	LABEL FAR
	ORG 32*3
  BIOS_REL	LABEL BYTE	; Bios release number in hex 
				;  (ie 012H is release 1.2x)
	ORG OFFSET BIOS_REL+1
  BIOS_CTADDR	LABEL WORD	; Addr of configuration information
	ORG OFFSET BIOS_CTADDR+2
  BIOS_VER	LABEL BYTE	; Bios version number in hex
	ORG OFFSET BIOS_VER+1

BIOS_SEG ENDS


;
; Configuration vecter
;

CONFG_DSK	EQU 0		; Addr of disk vector
CONFG_PRN	EQU CONFG_DSK+2	; Addr of PRN configuraiton table
CONFG_AUX	EQU CONFG_PRN+2	; Addr of AUX configuration table
CONFG_CON	EQU CONFG_AUX+2	; Addr of CON configuration table
CONFG_FNT	EQU CONFG_CON+2	; Addr of Font information
  FNT_RAM	  EQU 0		  ; Ptr to font table in RAM
  FNT_ROM	  EQU FNT_RAM+4	  ; Ptr to font table in ROM
  FNT_SIZE	  EQU FNT_ROM+4	  ; Size of font table in ROM
  FNT_MSIZE	  EQU FNT_SIZE+2  ; Space allocated for font table in RAM
CONFG_CLOCK	EQU CONFG_FNT+2	; Addr of Date and time fields
  BIOS_DATE	  EQU 0		  ; Days since Jan 1, 1980
  BIOS_HRS	  EQU BIOS_DATE+2 ; Hours since midnight
  BIOS_MIN	  EQU BIOS_HRS+1  ; Minutes
  BIOS_SEC	  EQU BIOS_MIN+1  ; Seconds
  BIOS_HSEC	  EQU BIOS_SEC+1  ; Hundredths of seconds(a word)
CONFG_DOSTB	EQU CONFG_CLOCK+2	; Addr of DOS disk tables 
CONFG_MCL	EQU CONFG_DOSTB+2	; Addr of memory control info
CONFG_ASP	EQU CONFG_MCL+2	; Assorted special parameters
  ASP_XVAL	  EQU 0		  ; X aspect ratio value
  ASP_YVAL	  EQU ASP_XVAL+1  ; Y aspect ratio value
  ASP_LPEF	  EQU ASP_YVAL+1  ; Light pen error (in character cells)
  ASP_LPHF	  EQU ASP_LPEF+2  ; Light pen hit flag (=1 when hit)
  ASP_LPHCA	  EQU ASP_LPHF+1  ; Character address of hit
  ASP_LPHPA	  EQU ASP_LPHCA+2 ; Pixel address within character address
  ASP_LPHCNT	  EQU ASP_LPHPA+1 ; Byte lift count for light pen
  ASP_PRSCF	  EQU ASP_LPHCNT+1; Flag for PRINT SCREEN function
  ASP_EVN	  EQU ASP_PRSCF+1 ; Event flag values
  ASP_TIC	  EQU ASP_EVN+2	  ; TIC counter value
  ASP_GWBASIC	  EQU ASP_TIC+2   ; Byte for GWBASIC is in ram
CONFG_QCON	EQU CONFG_ASP+2	; Address of con que descriptor
CONFG_QSRA	EQU CONFG_QCON+2 ; Address of Serial A descriptor
CONFG_QSRB	EQU CONFG_QSRA+2 ; Address of Serial B descriptor
CONFG_EVN	EQU CONFG_QSRB+2 ; Address of event flags
CONFG_TIC	EQU CONFG_EVN+2	 ; Address of 16bit tic counter
CONFG_ASN	EQU CONFG_TIC+2	 ; Winchester drive assignment table
CONFG_SIZE	EQU CONFG_ASN+1  ; Length of configuration vector

BIOS_WORKSP	EQU 256		; Number of bytes needed for
				;   workspace in BIOS
BIOS_RELDATE	EQU 969		; Release date 8/27/82 (this changes
				;   for each release)
MS_SIZEMEM	EQU 1		; Flag for DOS to size memory at init

