/**** dumpfat - display a file allocation table on the screen
*
*	Programmer: Darron J Shaffer
*
*	Company:    SigmaSoft & Systems
*		    17000 Dallas Parkway, #207
*		    Dallas, Texas 75248
*
*	Date:	    July 3, 1987
*
*	Notes:	    Written under contract with William Adney for use
*		    in Heath Company MS-DOS course.
*
*		    This program is intended to compile under Microsoft C
*		    version 4.0.
*/

char	*notice[] =
	{
		    " Written by Darron J Shaffer \n",
		    "  SigmaSoft & Systems \n",
		    "  17000 Dallas Parkway, #207 \n",
		    "  Dallas, Texas 75248 \n"
	};

#define LINT_ARGS

#include    <stdio.h>
#include    <dos.h>
#include    <ctype.h>
#include    <string.h>
#include    "diskinfo.h"

#define MAXLINE 80
#define DELIM	" \t,:;"

char	fat_buffer[512];    /* buffer for working fat */
int	drive = 0;	    /* drive number to use: default is A: */

void	readfat();
void	showfat();
void	check_disk();

main(argc,argv)
int	argc;
char	*argv[];
{
    if ( argc>2 )	/* valid # of arguments? */
    {
	printf("\nUsage: dumpfat [d:]\n");
	exit(1);
    }
    if ( argc==2 )	/* do we have a drive name? */
    {
	/* process the drive name */

	    /* is the drive name valid? */
	if ( strlen(argv[1])!=2 || !isalpha(argv[1][0]) || argv[1][1]!=':' )
	{
	    printf("\nError: Invalid drive name.\n");
	    exit(1);
	}
	drive = toupper(argv[1][0]) - 'A';  /* convert drive to numeric */
    }

    /* now have processed any argument - get to work */

    check_disk();   /* check for valid disk type */
    readfat();	    /* read in the fat */
    showfat();	    /* and display it */

    return 0;	    /* no errors */
}

/**** readfat - read the fat off of the disk
*/

void	readfat()
{
    union REGS	regs;	    /* register image for int86 function */

    /* set up for sector read */
    regs.h.al = drive;
    regs.x.cx = 1;		    /* read only one sector */
    regs.x.dx = 1;		    /* read logical sector one */
    regs.x.bx = (int) fat_buffer;   /* read into working buffer (ds correct) */

    int86(0x25,&regs,&regs);	/* go do the read */

    if ( regs.x.cflag )
    {
	printf("\nError: Can't read specified disk.\n");
	exit(1);
    }
}

/**** showfat - display the fat
*/

void	showfat()
{
    int     column,line;

    printf("\n\t\tFile Allocation Table Display\n\n");

    printf("\n       File Allocation Table    |");
    printf("          Unpacked");
    printf("\n     0  1  2  3  4  5  6  7  8  |");
    printf("   0   1   2   3   4   5");
    printf("\n    ----------------------------+");
    printf("--------------------------");

    for ( line=0; line < 15; line++ )
    {
	printf("\n%2d: ",line);

	for ( column=0; column<9; column++ )
	    printf("%02X ", fat_buffer[line*9+column] & 0xff);
	printf(" |  ");
	for ( column=0; column<6; column++ )
	{
	    if ( line==0 && ( column==0 || column==1 ) )
		printf("*** ");
	    else
		printf("%03X ",unpack( line*6 + column ));
	}
    }

}

int unpack(index)
int	index;
{
    int 	    long_offset;
    unsigned long   long_value;

    long_offset = (index / 2) * 3;
    long_value = *( (unsigned long *) (fat_buffer + long_offset));

    if ( index & 1 )
	long_value >>= 12;  /* odd index, perform shift */

    return  long_value & 0x0fff;
}

/**** check_disk - check to make sure disk if proper format
*
*   This routine operates by checking the number of clusters on the disk.
*   This number is the most unique single parameter of the many types of
*   disk formats.  (Even the 'Media Descriptor' may have the same value from
*   hard disk partitions to floppy diskettes.)
*
*/

void check_disk()
{
    struct DISKINFO info;

    info = diskinfo(drive+1);

    if ( info.total_clusters != 354 )
    {
	printf("\nError: Wrong Type of Disk.\n");
	exit(1);
    }
}

