/**** ld - list a diskette directory on the screen
*
*	Programmer: Darron J Shaffer
*
*	Company:    SigmaSoft & Systems
*		    17000 Dallas Parkway, #207
*		    Dallas, Texas 75248
*
*	Date:	    July 6, 1987
*
*	Notes:	    Written under contract with William Adney for use
*		    in Heath Company MS-DOS course.
*
*		    This program is intended to compile under Microsoft C
*		    version 4.0.
*
*/

char	*notice[] =
	{
		    " Written by Darron J Shaffer \n",
		    "  SigmaSoft & Systems \n",
		    "  17000 Dallas Parkway, #207 \n",
		    "  Dallas, Texas 75248 \n"
	};

#define LINT_ARGS

#include    <stdio.h>
#include    <dos.h>
#include    <ctype.h>
#include    <string.h>
#include    <search.h>
#include    "diskinfo.h"
#include    "dir.h"

#define     MAXFILES	512	    /* maximum number of files to display */
#define     MAXLINE	80	    /* maximum length output line */
#define     NOMORE      18          /* ms-dos error for no-more files */

/**** constant tables ****/

char    *attr_name[] =
{   "Read-Only", "Hidden", "System", "Label", "Directory", "Archive", "", "" };

/**** global variables ****/

int	un_sorted = 0;		    /* true if /u option found */

char	pathname[100] = "*.*";	    /* pathname to display directory for */

char	*fnames[MAXFILES];	    /* array of pointers to filenames */
int	num_files = 0;		    /* number of files found */
int     drive = 0;                  /* drive referenced */

/*** function declarations ****/

int     open_dir(char *, FILE_INFO *);
int     find_next(void);
void    close_dir(void);
void    mputs(char *);

void	do_args(int, char **);
void	read_dir(void);
void	sort_dir(void);
void	display_dir(void);
char	*expand_name(FILE_INFO *);
void    dos_error(int);
int     cmp_file(char **, char **);
void    fix_name(void);
void    usage(void);

/**** main
*/

main(argc,argv)
int	argc;
char	*argv[];
{
    do_args(argc,argv);

    read_dir();
    if ( !un_sorted )	    /* if un-sorted, already displayed */
  	sort_dir();	    
    display_dir();
    return 0;
}

void    do_args(argc,argv)
int     argc;
char    **argv;
{
    int     i;  	/* loop index */

    if ( argc>3 )	/* valid # of arguments? */
        usage();

    for ( i=1; i<argc; i++ )
    {
        if ( argv[i][0]=='/' || argv[i][0]=='-' )
        {
            /* have switch */
            if ( strcmpi(argv[i]+1,"U")!=0 )
                usage();
            un_sorted = 1;          /* set flag: don't sort directory */
        }
        else    /* have pathname argument */
        {
            strcpy(pathname,argv[i]);
            fix_name();     /* fix up the name, if necessary */
        }
    }

    if ( pathname[1]==':' )
        drive = toupper(pathname[0]) - 'A' + 1;
}

/**** read_dir
*/

void	read_dir()
{
    FILE_INFO	info;
    int 	errcode;

    if ( (errcode=open_dir(pathname,&info))!=0 )
	dos_error(errcode);

    do
    {
	if ( num_files>=MAXFILES )
	{
	    printf("\nError: More than %d files.\n",MAXFILES);
	    exit(1);
	}
	if ( (fnames[num_files++] = expand_name(&info))==NULL )
        {
            printf("\nError: Not Enough Memory.\n");
            exit(1);
        }
	errcode = find_next();
    } while ( errcode==0 );

    if ( errcode!=NOMORE )
	dos_error(errcode);
}

/**** sort_dir - sort the directory
*/

void    sort_dir()
{
    qsort((char *) fnames, num_files, sizeof(char *), cmp_file );
}

/**** cmp_file - compare two filenames
*/

cmp_file(p1,p2)
char    **p1,**p2;
{
    return strcmp(*p1,*p2);
}

/**** display_dir - display the directory information
*/

void display_dir()
{
    int i;
    struct DISKINFO info;

    printf("\nFile Name---  ---Size  ----Date  ----Time  Attributes\n");

    for ( i=0; i<num_files; i++ )
	mputs(fnames[i]);

    printf("\n%d Files",num_files);

    info = diskinfo(drive);

    printf(", Free Bytes = %ld",
        ((long) info.avail_clusters)*info.sec_per_cluster*info.bytes_per_sector);
}

/**** expand_name - expand the info structure into a displayable filename line
*
*   This will return an alloc'ed string
*
*   Format:

FILENAME.EXT  sizexxx  dd-mm-yy  SYSTEM, HIDDEN, READONLY, ARCHIVE, LABEL, DIRECTORY

*/

char	*expand_name(info)
FILE_INFO   *info;
{
    char    working_line[MAXLINE+1];	/* buffer to build string in */
    int     pos,			/* current posistion in line */
            attr_pos,                   /* position for first attribute */
            i;                          /* loop index */

    pos  = sprintf(working_line,"%-12.12s",info->fi_name);

    pos += sprintf(working_line+pos," %8ld",info->fi_fsize);

    pos += sprintf(working_line+pos,"  %2d-%02d-%02d",
		FILE_MONTH(info), FILE_DAY(info), FILE_YEAR(info)-1900 );

    pos += sprintf(working_line+pos,"  %2d:%02d:%02d ",
		FILE_HR(info), FILE_MIN(info), FILE_SEC(info) );

    attr_pos = pos;
    for ( i=7; i>=0; --i )
    {
        if ( (info->fi_attrib>>i) & 1 )
        {
            if ( pos!=attr_pos )
                working_line[pos++] = ',';
            pos += sprintf(working_line+pos," %s",attr_name[i]);
        }
    }

    return ( strdup(working_line) );
}

/**** dos_error - display a ms-dos error
*/

void	dos_error(num)
int	num;
{
    printf("\nError: ");
    switch (num)
    {
	case	2:
	    printf("File not Found.\n");
	    break;
	case	3:
	    printf("Path not Found.\n");
	    break;
	case	15:
	    printf("Invalid Drive.\n");
	    break;
	default:
	    printf("Dos error #%d\n",num);
    }
    exit(1);
}

/**** fix_name - fix up a pathname for use with find-first/find-next
*/

void    fix_name()
{
    int     	i;
    char    	last;
    FILE_INFO   info;

    if ( strpbrk(pathname,"*?")!=NULL )
        return;

    i = strlen(pathname) - 1;
    last = pathname[i];
    if ( last=='/' || last=='\\' || last==':' )
    {
         strcat(pathname,"*.*");
         return;
    }

    if ( open_dir(pathname,&info)==0 )
        if ( info.fi_attrib & DIRECT )
            strcat(pathname,"/*.*");
    close_dir();
}

void    usage()
{
    printf("\nUsage: ld [d:][path][filename][/u]\n");
    exit(1);
}

