10 REM *** BASIC Compression Program ***
20 REM *** Copyright 1983 by General Business Systems, Inc. ***
30 REM *** Transcribed from The Model 100 Companion, 1984 Osborne/McGraw-Hill
600 CLS: CLEAR 1000: MAXFILES=2
700 DEFSTR R-S: DEFINT I-N: DEFSNG A-H
800 A1=0: LL=0: IS=0: IC=0: ID=0: IX=0: IY=0: IZ=0: LU=0: IP=0: LH=0: I1=0: J1=0: JC=0: JH=0: JL=0: KB=0: KE=0: KF=0: KL=0: KN=0: KR=0: KW=0: LC=0: ML=0
900 RC="": SA="": SB="": SC="": SD="": SG="": SJ="": SN="": S0="": SQ=CHR$(34)
1000 DIM LN(100),NL(100),NH(100),IR(2),SV(6)
1100 DATA ELSE,GOSUB,GOTO,RESUME,RESTORE,RUN,THEN
1200 FOR I1=0 TO 6
1300 READ SV(I1)
1400 NEXT
1500 GOSUB 2300
1600 IF IS <> 1 THEN GOSUB 29300
1700 IF IY=0 THEN PRINT "NO CHANGE TO PROGRAM"
1800 MENU
2000 REM ******************
2100 REM * INITIALIZATION *
2200 REM ******************
2300 PRINT@ 88, "Compress a BASIC Program": PRINT@ 200, "Press any key to continue..."
2310 A$=INKEY$: IF A$="" THEN 2310
2600 PRINT
2700 IS=0: ML=0: IY=0
2800 SJ=""
2900 IF SJ="" THEN GOSUB 3800: GOTO 2900
3000 IF IS >0 THEN RETURN
3100 I1=0
3200 IF I1=0 THEN GOSUB 9600: GOTO 3200
3300 RETURN
3500 REM ***************************
3600 REM * GET FILE NAMES AND OPEN *
3700 REM ***************************
3800 CLS: FILES: PRINT: PRINT "What .DO file do you want to compress?": INPUT SJ
3900 IF SJ="" THEN GOSUB 47900: RETURN
4000 I1=INSTR(SJ,":")
4100 IF I1 > 0 THEN SD=LEFT$(SJ,I1-1) ELSE SD="RAM"
4200 IF SD="cas" THEN SD="CAS"
4300 IF SD="ram" THEN SD="RAM"
4400 IF SD <> "CAS" AND SD <> "RAM" AND SD <> "0" THEN GOSUB 47900: SJ="": RETURN
4500 IF SD="CAS" THEN SD="RAM": ST="C" ELSE SD="": ST="X"
4600 IF SD="" THEN GOSUB 12600: GOTO 4600
4700 SN=RIGHT$(SJ,LEN(SJ)-I1)
4800 SO=SD + ":" + "C@@"
4900 IF LEN(SN) > 2 THEN SO= SO + LEFT$(SN,3) ELSE SO= SO+SN
5000 PRINT: PRINT"The name of the compressed file is ": PRINT SO;
5100 IF SD="RAM" OR SD="0" THEN PRINT ".DO": GOSUB 6000 ELSE PRINT
5200 IF IS >0 THEN RETURN
5300 OPEN SJ FOR INPUT AS 1
5400 OPEN SO FOR OUTPUT AS 2
5500 RETURN
5700 REM *****************************
5800 REM * TEST EXISTING OUTPUT FILE *
5900 REM *****************************
6000 ON ERROR GOTO 7800
6100 IS=1
6200 OPEN SO FOR INPUT AS 1
6300 ON ERROR GOTO 0
6400 IF IS=0 THEN RETURN
6500 CLOSE
6600 PRINT
6700 PRINT "File ";SO;" already exists."
6800 SG=""
6900 IF SG="" THEN GOSUB 8500: GOTO 6900
7000 IF SG="NO" THEN RETURN
7100 IS=0
7200 KILL SO + ".DO"
7300 RETURN
7500 REM ***************************
7600 REM * NON-EXISTENT FILE IS OK *
7700 REM ***************************
7800 IF ERR=52 THEN IS=0: RESUME NEXT
7900 ON ERROR GOTO 0
8000 RESUME
8200 REM ******************
8300 REM * KILL OLD FILE? *
8400 REM ******************
8500 INPUT "Do you want to kill it";SG
8600 IF SG="yes" OR SG="y" OR SG="Y" THEN SG="YES": RETURN
8700 IF SG="no" OR SG="n" OR SG="N" THEN SG="NO": RETURN
8800 IF SG="YES" OR SG="NO" THEN RETURN
8900 SG=""
9000 GOSUB 47900
9100 RETURN
9300 REM ***************
9400 REM * GET OPTIONS *
9500 REM ***************
9600 PRINT
9700 PRINT "Do you want to:"
9800 PRINT: PRINT TAB(3); "<1> Remove Blanks";TAB(24); "<5> 1 and 3"
9900 PRINT TAB(3); "<2> Remove Remarks";TAB(24); "<6> 2 and 3"
10000 PRINT TAB(3); "<3> Combine Lines";TAB(24); "<7> 1, 2, and 3"
10100 PRINT TAB(3); "<4> 1 and 2"
10200 INPUT I1
10300 IF I1 < 1 OR I1 > 7 THEN I1=0: GOSUB 47900: RETURN
10400 IR(0)=0: IR(1)=0: IR(2)=0
10500 IF I1=1 THEN IR(0)=1: RETURN
10600 IF I1=2 THEN IR(1)=1: GOSUB 13400: RETURN
10700 IF I1=4 THEN IR(0)=1: IR(1)=1: GOSUB 13400: RETURN
10800 IR(2)=1
10900 IF I1=5 OR I1=7 THEN IR(0)=1
11000 IF I1=6 OR I1=7 THEN IR(1)=1
11100 ML=0
11200 IF ML=0 THEN GOSUB 11800: GOTO 11200
11300 RETURN
11500 REM *****************
11600 REM * GET LINE SIZE *
11700 REM *****************
11800 PRINT "What is the maximum line length": INPUT "(1 to 255)";ML
11900 IF ML < 1 OR ML > 255 THEN ML=0: GOSUB 47900: RETURN
12000 GOSUB 13400
12100 RETURN
12300 REM *********************
12400 REM * GET OUTPUT DEVICE *
12500 REM *********************
12600 PRINT:PRINT "Do you want store compressed file on": INPUT "<C>assette, <T>PDD, or in <R>am";SD
12700 IF SD="C" OR SD="c" THEN SD="CAS": ST="T": RETURN
12710 IF SD="T" OR SD="t" THEN SD="0": ST="0": RETURN
12800 IF SD="R" OR SD="r" THEN SD="RAM": ST="R" ELSE GOSUB 47900:SD=""
12900 RETURN
13100 REM **********************************************
13200 REM * CONSTRUCT TABLE OF REFERENCED LINE NUMBERS *
13300 REM **********************************************
13400 IS=0: LL=0: LU=0: LH=0
13500 IF IS=0 THEN GOSUB 14100: GOTO 13500
13600 RETURN
13800 REM ******************
13900 REM * PROCESS A LINE *
14000 REM ******************
14100 IF EOF(1) THEN IS=2: RETURN
14200 LINE INPUT #1,SB
14300 IF SB="" THEN RETURN
14400 KR=1
14500 IF KR > 0 THEN GOSUB 16400: GOTO 14500
14600 KR=1
14700 IF KR > 0 THEN GOSUB 17200: GOTO 14700
14800 KR=INSTR(SB,"REM")
14900 I1=INSTR(SB,"'")
15000 IF KR=0 THEN KR=I1
15100 IF I1 > 0 AND I1 < KR THEN KR=I1
15200 IF KR=0 THEN KR=LEN(SB)+1
15300 SA=LEFT$(SB,KR-1)
15400 FOR i1=0 TO 6
15500 IY=0
15600 KW=1
15700 IF IY=0 THEN KW=INSTR(KW,SA,SV(I1)): GOSUB 18800: GOTO 15700
15800 NEXT
15900 RETURN
16100 REM ************************
16200 REM * REMOVE QUOTED STRING *
16300 REM ************************
16400 SG=SQ
16500 KR=INSTR(SB,SQ)
16600 IF KR > 0 THEN GOSUB 18000
16700 RETURN
16900 REM *************************
17000 REM * REMOVE DATA STATEMENT *
17100 REM *************************
17200 SG=":"
17300 KR=INSTR(SB,"DATA")
17400 IF KR > 0 THEN GOSUB 18000
17500 RETURN
17700 REM **************************************
17800 REM * SET CHARACTERS TO BLANKS UNTIL     *
17850 REM * END OF LINE OR CHAR IN SG IS FOUND *
17900 REM **************************************
18000 IF KR=LEN(SB) THEN I1=KR ELSE I1=INSTR(KR+1,SB,SG)
18100 IF I1=0 THEN I1=LEN(SB)
18200 MID$(SB,KR)=STRING$(I1-KR+1," ")
18300 RETURN
18500 REM ***********************************************
18600 REM * PROCESS ONE OCCURRENCE OF KEYWORD IN SV(I1) *
18700 REM ***********************************************
18800 IF KW=0 THEN IY=1: RETURN
18900 GOSUB 19600
19000 IF KW >= LEN(SA) THEN IY=1
19100 RETURN
19300 REM **********************
19400 REM * LEGITIMATE KEYWORD *
19500 REM **********************
19600 KW=KW + LEN(SV(I1))-1
19700 IP=0
19800 IF IP=0 THEN GOSUB 21100: GOTO 19800
19900 IF IP < 48 OR IP > 57 THEN RETURN
20000 A1=0
20100 IZ=0
20200 IF IZ=0 THEN GOSUB 21900: GOTO 20200
20300 IF SV(I1) <> "GOTO" AND SV(I1) <> "GOSUB" THEN RETURN
20400 IX=0
20500 IF IX=0 THEN GOSUB 22800: GOTO 20500
20600 RETURN
20800 REM ***************************************
20900 REM * LOCATE NEXT NON-BLANK CHARACTER AND *
20950 REM * RETURN VALUE IN ASCII               *
21000 REM ***************************************
21100 IF KW=LEN(SA) THEN IP=1: RETURN
21200 KW=KW+1
21300 IF MID$(SA,KW,1) <> " " THEN IP=ASC(MID$(SA,KW,1))
21400 RETURN
21600 REM ***************************************
21700 REM * CONSTRUCT LINE NO. AND ADD TO TABLE *
21800 REM ***************************************
21900 A1=A1*10+IP-48
22000 IP=0
22100 IF IP=0 THEN GOSUB 21100: GOTO 22100
22200 IF IP < 48 OR IP > 57 THEN IZ=1: GOSUB 24000
22300 RETURN
22500 REM ***************************************************
22600 REM * CHECK FOR MULTIPLE NUMBERS, SEPARATED BY COMMAS *
22700 REM ***************************************************
22800 IF MID$(SA,KW,1) <> "," THEN IX=1: RETURN
22900 IP=0
23000 IF IP=0 THEN GOSUB 21100: GOTO 23000
23100 IF IP < 48 OR IP > 57 THEN IX=1: RETURN
23200 A1=0
23300 IZ=Q
23400 IF IZ=0 THEN GOSUB 21900: GOTO 23400
23500 RETURN
23700 REM **********************
23800 REM * BUILD CHAINED LIST *
23900 REM **********************
24000 IF A1 > 32767 THEN LC=A1-65536 ELSE LC=A1
24100 GOSUB 24800
24200 IF J1=1 THEN GOSUB 28000
24300 RETURN
24500 REM ***************
24600 REM * SEARCH LIST *
24700 REM ***************
24800 J1=0: JC=LL: JL=0: JH=0
24900 IF LH > 0 AND LC > LN(LH) THEN J1=1: JL=LH: RETURN
25000 IF J1=0 THEN GOSUB 25600: GOTO 25000
25100 RETURN
25300 REM **********************
25400 REM * LOOK AT NEXT ENTRY *
25500 REM **********************
25600 IF JC=0 THEN J1=1: RETURN
25700 IF LC=LN(JC) THEN J1=2: RETURN
25800 IF LC < LN(JC) THEN GOSUB 26400 ELSE GOSUB 27200
25900 RETURN
26100 REM ************************************
26200 REM * LINE NO. LESS THAN CURRENT ENTRY *
26300 REM ************************************
26400 JH=JC
26500 IF JL=NL(JC) THEN J1=1: RETURN
26600 JC=NL(JC)
26700 RETURN
26900 REM ***************************************
27000 REM * LINE NO. GREATER THAN CURRENT ENTRY *
27100 REM ***************************************
27200 JL=JC
27300 IF JH=NH(JC) THEN J1=1: RETURN
27400 JC=NH(JC)
27500 RETURN
27700 REM ********************
27800 REM * ADD NEW LINE NO. *
27900 REM ********************
28000 IF LU=100 THEN PRINT "TOO MANY LINE NUMBER REFERENCES": IS=1: RETURN
28100 IS=0
28200 LU=LU+1
28300 LN(LU)=LC
28400 NL(LU)=JL
28500 NH(LU)=JH
28600 IF JL=0 THEN LL=LU ELSE NH(JL)=LU
28700 IF JH=0 THEN LH=LU ELSE NL(JH)=LU
28800 RETURN
29000 REM *****************************
29100 REM * BEGIN COMPRESSION PROCESS *
29200 REM *****************************
29300 IS=0: LU=0
29400 CLOSE 1
29500 IF ST="C" THEN GOSUB 30800: GOSUB 31700
29600 OPEN SJ FOR INPUT AS 1
29700 SC=""
29800 KL=0
29900 IF IS=0 THEN GOSUB 32300: GOTO 29900
30000 GOSUB 45900
30100 CLOSE
30200 IF ST ="C" THEN GOSUB 30800
30300 RETURN
30500 REM *************************
30600 REM * REWIND CASSETTE INPUT *
30700 REM *************************
30800 BEEP: INPUT "SET RECORDER TO 'REWIND', PRESS ENTER";SG
30900 MOTOR ON
31000 INPUT "PRESS ENTER WHEN REWIND DONE";SG
31100 MOTOR OFF
31200 RETURN
31400 REM ********************************
31500 REM * SET UP CASSETTE FOR 2ND PASS *
31600 REM ********************************
31700 INPUT "SET RECORDER TO 'PLAY'; PRESS ENTER";SG
31800 RETURN
32000 REM ******************
32100 REM * PROCESS A LINE *
32200 REM ******************
32300 IF EOF(1) THEN IS=2: RETURN
32400 LINE INPUT #1,SB
32500 IF SB="" THEN RETURN
32600 SA=""
32700 IC=0
32800 KL=0
32900 KN=Q
33000 A1=0
33100 IZ=0
33200 IF IZ=0 THEN GOSUB 35300: GOTO 33200
33300 IF A1 > 32767 THEN LC=A1-65536 ELSE LC=A1
33400 GOSUB 24800
33500 IF J1=2 THEN KL=1
33600 KB=ID
33700 SA=SA + " "
33800 IF IC < LEN(SB) AND MID$(SB,IC+1,1)=" " THEN IC=IC+1
33900 KF=1
34000 GOSUB 36400
34100 IZ=0
34200 IF IZ=0 THEN GOSUB 37700: GOTO 34200
34300 IF SA="" THEN IY=1: RETURN
34400 IF KF=1 THEN I1=INSTR(KB,SB,"IF") ELSE I1=0
34500 IF KF=1 AND I1 > 0 AND I1 < KR THEN KN=1
34600 GOSUB 44700
34700 IF KN=1 THEN GOSUB 45900
34800 RETURN
35000 REM *******************************************
35100 REM * MOVE LINE NUMBER TO REVISED SOURCE LINE *
35200 REM *******************************************
35300 IF IC=LEN(SB) THEN IZ=1: RETURN
35400 IC=IC+1
35500 IP=ASC(MID$(SB,IC,1))
35600 IF IP < 48 OR IP > 57 THEN IC=IC-1: ID=IC: IZ=1: RETURN
35700 A1=A1*10+IP-48
35800 SA=SA+CHR$(IP)
35900 RETURN
36100 REM **************************************
36200 REM * GET LOCATION OF FIRST SPECIAL ITEM *
36300 REM **************************************
36400 IF KB > LEN(SB) THEN KR=KB: RETURN
36500 SE="REM"
36600 KR=INSTR(KB,SB,SE)
36700 I1=INSTR(KB,SB,"'")
36800 IF KR=0 OR I1 > 0 AND I1 < KR THEN KR=I1: SE="'"
36900 I1=INSTR(KB,SB,"DATA")
37000 IF KR=0 OR I1 > 0 AND I1 < KR THEN KR=I1: SE="DATA"
37100 IF KR=0 THEN KR=LEN(SB)+1
37200 RETURN
37400 REM **********************************************
37500 REM * MOVE NEXT CHARACTER TO REVISED SOURCE LINE *
37600 REM **********************************************
37700 IF IC=LEN(SB) THEN IZ=1: RETURN
37800 IC=IC+1
37900 RC=MID$(SB,IC,1)
38000 IF RC=" " AND IR(0)=1 THEN IY=1: RETURN
38100 IF RC=SQ THEN GOSUB 38900: RETURN
38200 IF IC=KR THEN GOSUB 41000: RETURN
38300 SA=SA+RC
38400 RETURN
38600 REM ******************************
38700 REM * BEGINNING OF QUOTED STRING *
38800 REM ******************************
38900 I1=INSTR(KB,SB,"IF")
39000 IF I1 > 0 AND I1 < IC THEN KN=1: KF=0
39100 SA=SA+RC
39200 IX=0
39300 IF IX=0 THEN GOSUB 40100: GOTO 39300
39400 KB=IC+1
39500 GOSUB 36400
39600 RETURN
39800 REM ****************************************
39900 REM * MOVE NEXT CHARACTER OF QUOTED STRING *
40000 REM ****************************************
40100 IF IC=LEN(SB) THEN IX=1: RETURN
40200 IC=IC+1
40300 SA=SA + MID$(SB,IC,1)
40400 IF MID$(SB,IC,1)=SQ THEN IX=1
40500 RETURN
40700 REM *****************************************
40800 REM * BEGINNING OF DATA STATEMENT OR REMARK *
40900 REM *****************************************
41000 IF SE <> "DATA" THEN GOSUB 43500: RETURN
41100 I1=INSTR(KB,SB,"IF")
41200 IF I1 > 0 AND I1 < IC THEN KN=1: KF=0
41300 SA=SA+RC
41400 I1=0
41500 IF I1=0 THEN GOSUB 42300: GOTO 41500
41600 KB=IC+1
41700 GOSUB 36400
41800 RETURN
42000 REM **********************************
42100 REM * MOVE CHARS FROM DATA STATEMENT *
42200 REM **********************************
42300 IF IC=LEN(SB) THEN I1=1: RETURN
42400 IC=IC+1
42500 SA=SA + MID$(SB,IC,1)
42600 IF MID$(SB,IC,1)=":" THEN I1=1: RETURN
42700 IF MID$(SB,IC,1) <> SQ THEN RETURN
42800 IX=0
42900 IF IX=0 THEN GOSUB 40100: GOTO 42900
43000 RETURN
43200 REM ***********************
43300 REM * BEGINNING OF REMARK *
43400 REM ***********************
43500 IZ=1
43600 I1=LEN(SA)-ID
43700 SG=STRING$(I1," ")
43800 I1=INSTR(ID,SA,SG)
43900 IF IR(1)=0 OR J1=2 AND I1 > 0 THEN SA=SA + RIGHT$(SB,LEN(SB)-IC+1): KN=1: RETURN
44000 IY=1
44100 IF I1 > 0 OR LEN(SA)=ID THEN SA=""
44200 RETURN
44400 REM **********************
44500 REM * ADD TO OUTPUT LINE *
44600 REM **********************
44700 IF IR(2)=0 THEN SC=SA: KN=1 : RETURN
44800 GOSUB 46700
44900 IF SC="" THEN SC=SA: RETURN
45000 I1=LEN(SC) + LEN(SA)-ID-1
45100 IF I1 > ML OR KL=1 THEN GOSUB 45900: SC=SA: RETURN
45200 IY=1
45300 SC=SC + ":" + RIGHT$(SA,LEN(SA)-ID-1)
45400 RETURN
45600 REM *****************************
45700 REM * WRITE OUTPUT LINE, IF ANY *
45800 REM *****************************
45900 IF SC <> "" THEN PRINT #2, SC
46000 SC=""
46100 KL=0
46200 RETURN
46400 REM ********************
46500 REM * IS THIS A REMARK *
46600 REM ********************
46700 KR=INSTR(SA,"REM")
46800 I1=INSTR(SA,"'")
46900 IF KR=0 THEN KR=I1
47000 IF I1 > 0 AND I1 < KR THEN KR=I1
47100 IF KR=0 THEN RETURN
47200 I1=KR-ID-1
47400 RETURN
47600 REM *************************
47700 REM ★ DISPLAY ERROR MESSAGE *
47800 REM *************************
47900 PRINT TAB(5);"***** ERROR - RETRY *****"
48000 RETURN
