#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>

#ifndef FLASH_DEV
#  define FLASH_DEV "/dev/rwd1"
#endif

char *devname= FLASH_DEV;

void
hex_dump(unsigned char *buf, int n, int offset)
{
  int i;
  unsigned char buf2[128];

  for (i = 0; i < n; i++) {
    if (i % 16 == 0) {
      printf("%04X: ", offset + i);
    }
    printf("%02X ", buf[i]);
    sprintf(&buf2[i % 16], "%c", isprint(buf[i]) ? buf[i] : '.');
    if (i % 16 == 15) {
      printf(" %s\n", buf2);
    }
  }
  if (i % 16) {
    while (i % 16) printf("   ");
    printf(" %s\n", buf2);
  }
}

int 
read_sector(int fd, unsigned char *buf, int n, int offset)
{
  int res;

  if (lseek(fd, offset, SEEK_SET) < 0) {
    perror("lseek()");
    return(-1);
  }

  if ((res = read(fd, buf, n)) != n) {
    perror("read(): unexpected return value.");
    return(-1);
  }
  return (res);
}

int 
write_sector(int fd, unsigned char *buf, int n, int offset)
{
  int res;

  if (lseek(fd, offset, SEEK_SET) < 0) {
    perror("lseek()");
    return(-1);
  }

  if ((res = write(fd, buf, n)) != n) {
    perror("write(): unexpected return value.");
    return(-1);
  }
  return (res);
}

main(int ac, char *av[])
{
  enum { BOOT_DISP, BOOT_SET, BOOT_CLEAR } boot = BOOT_DISP;
  int offset;
  int fd;
  int n, i;
  unsigned char buf[512];
  unsigned short ipl_head, ipl_cyl, ipl_sec;

  for (i = 1; i < ac; i++) {
    if (av[i][0] == '-') {
      if (strcasecmp(av[i], "-on") == 0) {
        boot = BOOT_SET;
      }
      if (strcasecmp(av[i], "-off") == 0) {
        boot= BOOT_CLEAR;
      }
    } else {
      if (av[i][0] == '/') {
	devname = av[i];
      } else {
        static char buf[256];
        sprintf(buf, "/dev/r%s", av[i]);
        devname = buf;
      }
    }
  }

  if ((fd = open(FLASH_DEV, boot == BOOT_DISP ? O_RDONLY : O_RDWR)) < 0) {
    perror(FLASH_DEV);
    exit(1);
  }

  offset = 0;
  if ((n = read_sector(fd, buf, 512, offset)) < 0) {
    exit(1);
  }
  /*hex_dump(buf, n, offset);
  */

  ipl_head = buf[0x1BF];
  ipl_cyl  = buf[0x1C1] | (buf[0x1C0] << 2 ) & 0xFF00;
  ipl_sec  = (buf[0x1C0] & 0x3F) - 1;

  printf("FAT Type %d\n", buf[0x1C2] );
  printf("IPL head=%02x  cyl=%02x  sec=%02x\n",
	 ipl_head, ipl_cyl, ipl_sec );

  printf("Card boot: %02x%02x", buf[0x1FC], buf[0x1FD]);
  if (boot == BOOT_DISP) {
    printf("\n");
  } else {
    if (boot == BOOT_SET) {
      buf[0x1FC] = 0x53;
      buf[0x1FD] = 0x4E;
    } else {
      buf[0x1FC] = 0x00;
      buf[0x1FD] = 0x00;
    }
    printf(" -> %02x%02x\n", buf[0x1FC], buf[0x1FD]);
    write_sector(fd, buf, 512, offset);
  }

  close(fd);

  exit(0);
}
