/*
 * todocnv.c		Kazuya 'Sharl' Masuda <sharl@hauN.org>
 *
 * v0.4 e CRLF  SPACE ɕϊ
 * v0.3 UNIX ł傤
 * v0.2 V[Nbgǉ
 * v0.1 폜ς݃tOǉ
 * v0.0 Ƃ肠
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

/* size 16 */
typedef struct {
  unsigned long endmark;	/* `FbNp? */
  unsigned long offset;		/* f[^t@C擪̃ItZbg */
  unsigned long startmark;	/* `FbNp? */
  unsigned long dummy;		/* 킩 */
} INDEX;

/* size 37 */
typedef struct {
  unsigned char startmark[4];	/* `FbNp? */
  unsigned char dummy[3];	/* Ȃ񂾂? */
  unsigned char endmark[4];	/* `FbNp? */
  unsigned char date[16];	/* ALAēĂ */
  unsigned char delete;		/* 폜}[N */
  unsigned char rank;		/* N */
  unsigned char secret;		/* V[Nbg */
  unsigned char moto;		/* ˗ */
  unsigned char saki;		/* ˗敶 */
  unsigned char content[3];	/* e content[1] Kv */
  unsigned char end[2];		/* I[? */
} DATA;

#define IDXFILE	"todo.idx"
#define DATFILE	"todo.dat"

#ifdef MSDOS
#define ENDIAN(x) (x)
#else
#define ENDIAN(x) ((x << 24) | ((x << 8) & 0xFF0000) | ((x >> 8) & 0xFF00) | ((x >> 24) & 0xFF))
#endif

char *progname;
INDEX idx;
DATA data;
unsigned char buf[256];
unsigned char strbuf[255 * 3 + 1];
int delete = 0;
unsigned long del_offset;

int debug = 0;

/****************************************
****************************************/
int
main(int argc, char *argv[])
{
  FILE *ifp, *dfp;
  unsigned long startmark, endmark;

  progname = argv[0];

  if (argc != 1)
    debug = 1;

  if (sizeof(INDEX) != 16) {
    fprintf(stderr, "%s: INDEX is %d\n", progname, sizeof(INDEX));
    return EXIT_FAILURE;
  }

  if (sizeof(DATA) != 37) {
    fprintf(stderr, "%s: DATA is %d\n", progname, sizeof(DATA));
    return EXIT_FAILURE;
  }

  if ((ifp = fopen(IDXFILE, "rb")) == NULL) {
    perror(IDXFILE);
    return EXIT_FAILURE;
  }
  if ((dfp = fopen(DATFILE, "rb")) == NULL) {
    perror(DATFILE);
    return EXIT_FAILURE;
  }

  /* header read */
  fread(&idx, sizeof(INDEX), 1, ifp);

  for (;;) {
    int rdlen;

    /**/
    rdlen = fread(&idx, sizeof(INDEX), 1, ifp);
    if (rdlen == 0)
      break;
    if (rdlen != 1) {
      fprintf(stderr, "%s: index read error\n", progname);
      return EXIT_FAILURE;
    }

    fseek(dfp, ENDIAN(idx.offset), SEEK_SET);
    fread(&data, sizeof(DATA), 1, dfp);
    fread(strbuf, data.moto + data.saki + data.content[1], 1, dfp);

    memcpy(&startmark, data.startmark, sizeof(unsigned long));
    memcpy(&endmark, data.endmark, sizeof(unsigned long));

    if (idx.startmark != startmark && idx.endmark != endmark) {
      fprintf(stderr, "%s: data mismath\n", progname);
      return EXIT_FAILURE;
    }
    
    /* data.dummy \ */
    if (debug) {
      printf("[%02x][%02x][%02x],",
	     data.dummy[0],
	     data.dummy[1], 
	     data.dummy[2] /* XV񐔂? */);
    }

    /* 폜tOALA\ */
    memcpy(buf, data.date, 16);
    buf[16] = 0;
    {
      int limy, limm, limd;
      int inpy, inpm, inpd;
      sscanf(buf, "%4d%2d%2d%4d%2d%2d",
	     &limy, &limm, &limd, &inpy, &inpm, &inpd);
      printf("%c,\"%4d/%02d/%02d\",\"%4d/%02d/%02d\",",
	     data.delete, inpy, inpm, inpd, limy, limm, limd);
    }

    /* N\ */
    printf("\"%c\",", data.rank);
    if (debug)
      printf("[%c],", data.secret);

    /* ˗\ */
    memcpy(buf, strbuf, data.moto);
    buf[data.moto] = 0;
    printf("\"%s\",", buf);
    
    /* ˗\ */
    memcpy(buf, strbuf + data.moto, data.saki);
    buf[data.saki] = 0;
    printf("\"%s\",", buf);

    /* e\ */
    memcpy(buf, strbuf + data.moto + data.saki, data.content[1]);
    buf[data.content[1]] = 0;
    {
      unsigned char *p;

      for (p = buf; *p; p++)
	if (*p == 0x0D || *p == 0x0A)
	  *p = ' ';
    }
    printf("\"%s\"\n", buf);

  }
  
  fclose(dfp);
  fclose(ifp);
  
  return EXIT_SUCCESS;
}
