

/* 
 *  This table was derived from on-air transmissions.  It certainly has omissions and 
 *  almost certainly contains errors.  Use entirely at your own risk. 
 */ 
 
static struct hufftab fsat_huffman2[] = 
{ 
    { START,  0x00000000,  5, 'H'}, 
    { START,  0x08000000,  6, 'O'}, 
    { START,  0x0c000000,  7, 'K'}, 
    { START,  0x0e000000,  8, '2'}, 
    { START,  0x0f000000,  9, 'Q'}, 
    { START,  0x0f800000, 10, '9'}, 
    { START,  0x0fc00000, 10, '8'}, 
    { START,  0x10000000,  4, 'J'}, 
    { START,  0x20000000,  5, 'I'}, 
    { START,  0x28000000,  5, 'R'}, 
    { START,  0x30000000,  4, 'D'}, 
    { START,  0x40000000,  3, 'A'}, 
    { START,  0x62000000,  8, 'U'}, 
    { START,  0x63000000,  8, '('}, 
    { START,  0x64000000,  6, '['}, 
    { START,  0x68000000,  5, 'F'}, 
    { START,  0x70000000,  5, '.'}, 
    { START,  0x78000000,  5, 'W'}, 
    { START,  0x80000000,  3, 'C'}, 
    { START,  0xa0000000,  4, 'S'}, 
    { START,  0xb0000000,  8, '1'}, 
    { START,  0xb1000000,  9, '3'}, 
    { START,  0xb1800000, 10, '6'}, 
    { START,  0xb1c00000, 10, '5'}, 
    { START,  0xb2000000, 10, 'Z'}, 
    { START,  0xb2400000, 10, '7'}, 
    { START,  0xb2800000, 10, '4'}, 
    { START,  0xb2f00000, 12, ' '}, 
    { START,  0xb3000000,  8, 'V'}, 
    { START,  0xb4000000,  6, 'L'}, 
    { START,  0xb8000000,  5, 'M'}, 
    { START,  0xc0000000,  5, 'B'}, 
    { START,  0xc8000000,  5, 'P'}, 
    { START,  0xd0000000,  7, 'Y'}, 
    { START,  0xd2000000,  7, 'G'}, 
    { START,  0xd4000000,  6, 'E'}, 
    { START,  0xd8000000,  5, 'N'}, 
    { START,  0xe0000000,  3, 'T'}, 
    { ' ',    0x00000000,  6, 'A'}, 
    { ' ',    0x04000000,  8, 'k'}, 
    { ' ',    0x05000000,  8, 'O'}, 
    { ' ',    0x06000000,  7, 'v'}, 
    { ' ',    0x08000000,  7, 'G'}, 
    { ' ',    0x0a000000,  7, 'N'}, 
    { ' ',    0x0c000000,  6, 'M'}, 
    { ' ',    0x10000000,  4, 'o'}, 
    { ' ',    0x20000000,  4, 's'}, 
    { ' ',    0x30000000,  5, 'd'}, 
    { ' ',    0x38000000, 10, '3'}, 
    { ' ',    0x38400000, 10, '8'}, 
    { ' ',    0x38800000, 10, '6'}, 
    { ' ',    0x38c00000, 11, '0'}, 
    { ' ',    0x38e60000, 15, '$'}, 
    { ' ',    0x38f00000, 12, 'X'}, 
    { ' ',    0x39000000,  9, 'q'}, 
    { ' ',    0x39800000,  9, 'U'}, 
    { ' ',    0x3a000000,  7, 'y'}, 
    { ' ',    0x3c000000,  6, 'e'}, 
    { ' ',    0x40000000,  3, 'a'}, 
    { ' ',    0x60000000,  5, '['}, 
    { ' ',    0x68000000,  8, '-'}, 
    { ' ',    0x69000000,  9, 'V'}, 
    { ' ',    0x69800000, 11, '\''}, 
    { ' ',    0x69a00000, 11, '9'}, 
    { ' ',    0x69c00000, 10, '5'}, 
    { ' ',    0x6a000000,  7, 'H'}, 
    { ' ',    0x6c000000,  9, 'Y'}, 
    { ' ',    0x6c800000,  9, ' '}, 
    { ' ',    0x6d000000,  8, '1'}, 
    { ' ',    0x6e000000,  7, 'L'}, 
    { ' ',    0x70000000,  6, 'B'}, 
    { ' ',    0x74000000,  6, 'C'}, 
    { ' ',    0x78000000,  5, 'p'}, 
    { ' ',    0x80000000,  3, 't'}, 
    { ' ',    0xa0000000,  6, 'T'}, 
    { ' ',    0xa4000000,  7, 'J'}, 
    { ' ',    0xa6000000,  7, 'F'}, 
    { ' ',    0xa8000000,  5, 'b'}, 
    { ' ',    0xb0000000, 10, '('}, 
    { ' ',    0xb0400000, 11, 'Z'}, 
    { ' ',    0xb0600000, 13, ESCAPE}, 
    { ' ',    0xb0680000, 13, '.'}, 
    { ' ',    0xb0700000, 13, '&'}, 
    { ' ',    0xb0780000, 14, '"'}, 
    { ' ',    0xb07c0000, 14, 'z'}, 
    { ' ',    0xb0800000,  9, '2'}, 
    { ' ',    0xb1000000,  8, 'K'}, 
    { ' ',    0xb2000000,  7, 'R'}, 
    { ' ',    0xb4000000,  6, 'S'}, 
    { ' ',    0xb8000000,  6, 'g'}, 
    { ' ',    0xbc000000,  7, 'u'}, 
    { ' ',    0xbe000000,  8, 'j'}, 
    { ' ',    0xbf000000, 10, STOP}, 
    { ' ',    0xbf800000, 10, '7'}, 
    { ' ',    0xbfc00000, 11, '4'}, 
    { ' ',    0xbfe00000, 11, 'Q'}, 
    { ' ',    0xc0000000,  6, 'r'}, 
    { ' ',    0xc4000000,  7, 'D'}, 
    { ' ',    0xc6000000,  7, 'W'}, 
    { ' ',    0xc8000000,  5, 'c'}, 
    { ' ',    0xd0000000,  5, 'h'}, 
    { ' ',    0xd8000000,  6, 'n'}, 
    { ' ',    0xdc000000,  6, 'l'}, 
    { ' ',    0xe0000000,  5, 'w'}, 
    { ' ',    0xe8000000,  5, 'i'}, 
    { ' ',    0xf0000000,  8, 'I'}, 
    { ' ',    0xf1000000,  8, 'E'}, 
    { ' ',    0xf2000000,  7, 'P'}, 
    { ' ',    0xf4000000,  6, 'm'}, 
    { ' ',    0xf8000000,  5, 'f'}, 
    { '!',    0x00000000,  4, ':'}, 
    { '!',    0x11c00000, 10, '?'}, 
    { '!',    0x40000000,  2, STOP}, 
    { '!',    0x80000000,  1, ' '}, 
    { '"',    0x20000000,  3, '.'}, 
    { '"',    0x90000000,  6, 'm'}, 
    { '"',    0x9e000000,  8, 'P'}, 
    { '"',    0x9f000000, 10, ESCAPE}, 
    { '"',    0xac000000,  6, 'I'}, 
    { '"',    0xb0000000,  7, 'c'}, 
    { '"',    0xb4000000,  8, 'r'}, 
    { '"',    0xc0000000,  2, ' '}, 
    { '$',    0x00000000,  1, '1'}, 
    { '$',    0xb0000000,  4, '2'}, 
    { '$',    0xde000000,  9, '3'}, 
    { '%',    0x80000000,  1, ' '}, 
    { '&',    0x00000000,  4, 'E'}, 
    { '&',    0x16000000,  9, ESCAPE}, 
    { '&',    0x18000000,  6, 'A'}, 
    { '&',    0x20000000,  3, 'B'}, 
    { '&',    0x40000000,  2, 'w'}, 
    { '&',    0x80000000,  1, ' '}, 
    { '(',    0x00000000,  3, 'P'}, 
    { '(',    0x23000000,  8, 'E'}, 
    { '(',    0x24000000,  6, 'a'}, 
    { '(',    0x28000000,  6, 'S'}, 
    { '(',    0x2c000000,  7, 'D'}, 
    { '(',    0x2e000000,  8, 'W'}, 
    { '(',    0x2f000000, 10, '4'}, 
    { '(',    0x30000000,  6, 'R'}, 
    { '(',    0x34800000, 10, '3'}, 
    { '(',    0x35a00000, 13, ESCAPE}, 
    { '(',    0x35a80000, 13, 'u'}, 
    { '(',    0x35b00000, 12, 'O'}, 
    { '(',    0x36000000,  7, 'K'}, 
    { '(',    0x38000000,  5, 'T'}, 
    { '(',    0x40000000,  2, '1'}, 
    { '(',    0x80000000,  4, '2'}, 
    { '(',    0x9c000000,  6, 'e'}, 
    { '(',    0xa0000000,  3, 't'}, 
    { '(',    0xc2000000,  9, 'w'}, 
    { '(',    0xc2800000,  9, 'B'}, 
    { '(',    0xc3000000,  8, 'g'}, 
    { '(',    0xc4000000,  7, 'G'}, 
    { '(',    0xc8000000,  7, 'M'}, 
    { '(',    0xca000000,  7, 'H'}, 
    { '(',    0xcc000000,  7, 'C'}, 
    { '(',    0xd0000000,  4, '5'}, 
    { '(',    0xe0000000,  4, 'N'}, 
    { '(',    0xf0000000,  6, 'J'}, 
    { '(',    0xf4000000,  6, 'A'}, 
    { ')',    0x00000000,  1, ' '}, 
    { ')',    0x80000000,  5, ':'}, 
    { ')',    0x8c000000,  6, ';'}, 
    { ')',    0x90000000,  4, ','}, 
    { ')',    0xc0000000,  2, '.'}, 
    { '+',    0x40000000,  2, ' '}, 
    { ',',    0x20000000,  3, '0'}, 
    { ',',    0x40000000,  2, 'S'}, 
    { ',',    0x80000000,  1, ' '}, 
    { '-',    0x00000000,  2, ' '}, 
    { '-',    0x40000000,  4, 't'}, 
    { '-',    0x50000000,  4, 'b'}, 
    { '-',    0x60000000,  4, 'w'}, 
    { '-',    0x70000000,  4, 'u'}, 
    { '-',    0x80000000,  5, 'c'}, 
    { '-',    0x88000000,  6, '9'}, 
    { '-',    0x8c000000,  7, 'S'}, 
    { '-',    0x8e000000,  8, 'C'}, 
    { '-',    0x8f000000, 10, 'F'}, 
    { '-',    0x8f480000, 13, '0'}, 
    { '-',    0x8f600000, 11, 'K'}, 
    { '-',    0x8f800000,  9, 'H'}, 
    { '-',    0x90000000,  4, 'o'}, 
    { '-',    0xa0000000,  4, 's'}, 
    { '-',    0xb0000000,  4, 'f'}, 
    { '-',    0xc0000000,  6, 'h'}, 
    { '-',    0xc4000000,  9, 'A'}, 
    { '-',    0xc4800000, 10, 'j'}, 
    { '-',    0xc4c00000, 10, 'P'}, 
    { '-',    0xc5000000,  8, 'W'}, 
    { '-',    0xc6000000,  9, '6'}, 
    { '-',    0xc6800000,  9, 'B'}, 
    { '-',    0xc7000000,  8, 'g'}, 
    { '-',    0xc8000000,  6, '1'}, 
    { '-',    0xcc000000,  6, 'y'}, 
    { '-',    0xd0000000,  7, 'e'}, 
    { '-',    0xd2000000,  7, 'i'}, 
    { '-',    0xd4000000,  6, 'r'}, 
    { '-',    0xd8000000,  5, 'l'}, 
    { '-',    0xe0000000,  6, 'a'}, 
    { '-',    0xe4000000, 11, 'v'}, 
    { '-',    0xe4200000, 11, 'Z'}, 
    { '-',    0xe4800000, 10, '5'}, 
    { '-',    0xe4c00000, 10, 'T'}, 
    { '-',    0xe5000000,  8, 'J'}, 
    { '-',    0xe6000000,  8, 'D'}, 
    { '-',    0xe7000000, 16, '\''}, 
    { '-',    0xe7080000, 14, '3'}, 
    { '-',    0xe70c0000, 14, '8'}, 
    { '-',    0xe7400000, 10, 'I'}, 
    { '-',    0xe7800000,  9, 'M'}, 
    { '-',    0xe8000000,  5, 'd'}, 
    { '-',    0xf0000000,  6, 'm'}, 
    { '-',    0xf4000000,  9, 'E'}, 
    { '-',    0xf4800000,  9, 'L'}, 
    { '-',    0xf5000000,  8, '2'}, 
    { '-',    0xf6000000,  7, 'n'}, 
    { '-',    0xf8000000,  6, 'p'}, 
    { '-',    0xfc000000,  8, '7'}, 
    { '-',    0xfd000000,  9, 'U'}, 
    { '-',    0xfd800000,  9, 'k'}, 
    { '-',    0xfe000000,  8, 'G'}, 
    { '-',    0xff000000,  8, 'O'}, 
    { '.',    0x00000000,  7, 'a'}, 
    { '.',    0x02000000,  7, '['}, 
    { '.',    0x04000000,  6, 'u'}, 
    { '.',    0x08000000,  8, '4'}, 
    { '.',    0x09000000, 10, 'N'}, 
    { '.',    0x09400000, 12, 'E'}, 
    { '.',    0x09500000, 12, ':'}, 
    { '.',    0x09600000, 15, '?'}, 
    { '.',    0x09700000, 13, 'K'}, 
    { '.',    0x09780000, 13, 'Y'}, 
    { '.',    0x09800000, 10, 't'}, 
    { '.',    0x0a000000,  9, '5'}, 
    { '.',    0x0b000000, 11, 'r'}, 
    { '.',    0x0b300000, 14, '"'}, 
    { '.',    0x0b360000, 17, 'd'}, 
    { '.',    0x0b368000, 18, ESCAPE}, 
    { '.',    0x0b370000, 16, 'k'}, 
    { '.',    0x0b380000, 13, 'O'}, 
    { '.',    0x0b400000, 10, 'R'}, 
    { '.',    0x0c000000,  9, 'T'}, 
    { '.',    0x0d000000,  9, 'M'}, 
    { '.',    0x0dc00000, 10, 'P'}, 
    { '.',    0x0e000000,  8, 'H'}, 
    { '.',    0x0f000000,  9, 'C'}, 
    { '.',    0x0f800000,  9, '2'}, 
    { '.',    0x10000000,  5, 'i'}, 
    { '.',    0x18000000,  8, 'S'}, 
    { '.',    0x19000000,  8, 'W'}, 
    { '.',    0x1a000000,  7, '3'}, 
    { '.',    0x1c000000,  8, 'o'}, 
    { '.',    0x1d800000,  9, 'D'}, 
    { '.',    0x1e000000,  8, '1'}, 
    { '.',    0x1f000000,  9, 'B'}, 
    { '.',    0x1f800000, 12, '\''}, 
    { '.',    0x1f980000, 13, '('}, 
    { '.',    0x1fa00000, 11, 'G'}, 
    { '.',    0x1fc00000, 10, 'I'}, 
    { '.',    0x20000000,  5, '0'}, 
    { '.',    0x28000000,  5, 'c'}, 
    { '.',    0x30000000,  4, '.'}, 
    { '.',    0x40000000,  4, STOP}, 
    { '.',    0x80000000,  1, ' '}, 
    { '/',    0x00000000,  4, '5'}, 
    { '/',    0x10000000,  5, 'T'}, 
    { '/',    0x20000000,  4, '8'}, 
    { '/',    0x30000000,  5, 'B'}, 
    { '/',    0x38000000,  5, '2'}, 
    { '/',    0x45e80000, 13, 'c'}, 
    { '/',    0x54800000,  9, 'U'}, 
    { '/',    0x80000000,  7, 'F'}, 
    { '/',    0x82000000, 11, 'v'}, 
    { '/',    0x82400000, 10, 'J'}, 
    { '/',    0x82a00000, 12, 'l'}, 
    { '/',    0x82c00000, 10, '9'}, 
    { '/',    0x83000000,  8, 'm'}, 
    { '/',    0x84000000,  7, 's'}, 
    { '/',    0x86000000,  7, 'M'}, 
    { '/',    0x88000000,  5, '3'}, 
    { '/',    0x90000000,  5, '7'}, 
    { '/',    0x98000000,  7, 'H'}, 
    { '/',    0x9a000000,  8, 'W'}, 
    { '/',    0x9b000000,  9, 'L'}, 
    { '/',    0x9b800000, 12, 'V'}, 
    { '/',    0x9b900000, 14, ESCAPE}, 
    { '/',    0x9c000000,  7, 'D'}, 
    { '/',    0x9e000000,  7, 'A'}, 
    { '/',    0xa0000000,  5, '6'}, 
    { '/',    0xa8000000,  8, 'G'}, 
    { '/',    0xaa000000,  7, 'S'}, 
    { '/',    0xac000000,  8, 'd'}, 
    { '/',    0xae000000,  8, 'N'}, 
    { '/',    0xaf800000,  9, 'I'}, 
    { '/',    0xb0000000,  5, 'a'}, 
    { '/',    0xb8000000,  9, 'E'}, 
    { '/',    0xb8800000,  9, 'R'}, 
    { '/',    0xb9000000,  8, 'C'}, 
    { '/',    0xba000000,  9, 'K'}, 
    { '/',    0xbb000000,  8, 'P'}, 
    { '/',    0xbc000000,  6, '4'}, 
    { '/',    0xc0000000,  3, '1'}, 
    { '0',    0x00000000,  1, '0'}, 
    { '0',    0x80000000,  6, '4'}, 
    { '0',    0x84000000,  6, 't'}, 
    { '0',    0x88000000,  5, 's'}, 
    { '0',    0x90000000,  4, 'a'}, 
    { '0',    0xa0000000,  7, '3'}, 
    { '0',    0xa2000000,  7, '7'}, 
    { '0',    0xa4000000,  6, '5'}, 
    { '0',    0xa8000000,  8, ')'}, 
    { '0',    0xa9000000,  8, '/'}, 
    { '0',    0xaa000000,  7, ']'}, 
    { '0',    0xac000000,  7, '-'}, 
    { '0',    0xae000000,  7, '1'}, 
    { '0',    0xb0000000,  4, 'p'}, 
    { '0',    0xc0000000,  5, '.'}, 
    { '0',    0xc8000000,  5, '8'}, 
    { '0',    0xd0000000,  6, '6'}, 
    { '0',    0xd4000000,  8, STOP}, 
    { '0',    0xd5000000,  8, '9'}, 
    { '0',    0xd6000000,  9, '%'}, 
    { '0',    0xd6800000, 10, ':'}, 
    { '0',    0xd6e80000, 14, 'k'}, 
    { '0',    0xd6f00000, 12, 'm'}, 
    { '0',    0xd7000000,  8, '2'}, 
    { '0',    0xd8000000,  5, ','}, 
    { '0',    0xe0000000,  3, ' '}, 
    { '1',    0x00000000,  2, '9'}, 
    { '1',    0x40000000,  5, '6'}, 
    { '1',    0x48000000,  5, '8'}, 
    { '1',    0x50000000,  4, ' '}, 
    { '1',    0x60000000,  7, STOP}, 
    { '1',    0x62000000,  7, '-'}, 
    { '1',    0x64000000,  6, '7'}, 
    { '1',    0x68000000,  5, '/'}, 
    { '1',    0x70000000,  4, '2'}, 
    { '1',    0x80000000,  3, '1'}, 
    { '1',    0xa0000000,  5, ']'}, 
    { '1',    0xa8000000,  7, ')'}, 
    { '1',    0xaa000000,  8, '\''}, 
    { '1',    0xab000000,  9, 'X'}, 
    { '1',    0xabc00000, 11, 't'}, 
    { '1',    0xabe00000, 11, 'R'}, 
    { '1',    0xac000000,  7, ':'}, 
    { '1',    0xae000000,  7, 's'}, 
    { '1',    0xb0000000,  4, '.'}, 
    { '1',    0xc0000000,  4, '5'}, 
    { '1',    0xd0000000,  5, '3'}, 
    { '1',    0xd8000000,  6, '4'}, 
    { '1',    0xdc000000,  7, ','}, 
    { '1',    0xde000000,  7, 'x'}, 
    { '1',    0xe0000000,  3, '0'}, 
    { '2',    0x00000000,  3, ' '}, 
    { '2',    0x20000000,  5, ']'}, 
    { '2',    0x30000000,  4, '/'}, 
    { '2',    0x40000000,  3, '.'}, 
    { '2',    0x60000000,  6, '6'}, 
    { '2',    0x64000000,  6, '2'}, 
    { '2',    0x68000000,  5, '1'}, 
    { '2',    0x70000000,  6, ':'}, 
    { '2',    0x74000000,  6, '-'}, 
    { '2',    0x79000000,  8, '3'}, 
    { '2',    0x7a000000,  8, 't'}, 
    { '2',    0x7c000000,  6, ')'}, 
    { '2',    0x80000000,  3, '5'}, 
    { '2',    0xa2000000,  8, 'n'}, 
    { '2',    0xa3000000,  9, 'a'}, 
    { '2',    0xa3800000, 10, '\''}, 
    { '2',    0xa3d00000, 13, '"'}, 
    { '2',    0xa3de0000, 15, 'L'}, 
    { '2',    0xa4000000,  7, '8'}, 
    { '2',    0xa6000000,  7, '9'}, 
    { '2',    0xa8000000,  5, '4'}, 
    { '2',    0xb0000000,  4, ','}, 
    { '2',    0xc0000000,  2, '0'}, 
    { '3',    0x00000000,  2, ' '}, 
    { '3',    0x40000000,  5, '2'}, 
    { '3',    0x4cda0000, 15, 'm'}, 
    { '3',    0x50000000,  5, ')'}, 
    { '3',    0x58000000,  6, 'D'}, 
    { '3',    0x5c000000,  7, '7'}, 
    { '3',    0x5e000000,  7, '3'}, 
    { '3',    0x60000000,  5, ':'}, 
    { '3',    0x68000000,  6, '4'}, 
    { '3',    0x70000000,  5, '-'}, 
    { '3',    0x78980000, 14, ESCAPE}, 
    { '3',    0x7a000000,  7, '6'}, 
    { '3',    0x7c000000,  6, '5'}, 
    { '3',    0x80000000,  2, '0'}, 
    { '3',    0xc0000000,  3, '.'}, 
    { '3',    0xe0000000,  4, '/'}, 
    { '3',    0xf0000000,  6, ','}, 
    { '3',    0xf4000000,  8, '8'}, 
    { '3',    0xf5000000,  9, '9'}, 
    { '3',    0xf5800000, 10, 'r'}, 
    { '3',    0xf6000000,  7, 't'}, 
    { '3',    0xf8000000,  5, ']'}, 
    { '4',    0x00000000,  3, '4'}, 
    { '4',    0x20000000,  4, '/'}, 
    { '4',    0x30000000,  5, '1'}, 
    { '4',    0x38000000,  6, '2'}, 
    { '4',    0x3c000000,  7, ':'}, 
    { '4',    0x40000000,  2, ' '}, 
    { '4',    0x80000000,  3, '.'}, 
    { '4',    0xa0000000,  4, '5'}, 
    { '4',    0xb0000000,  4, '-'}, 
    { '4',    0xc0000000,  3, '0'}, 
    { '4',    0xe0000000,  7, 't'}, 
    { '4',    0xe2000000,  7, '3'}, 
    { '4',    0xe4000000,  6, '8'}, 
    { '4',    0xe8000000,  5, ']'}, 
    { '4',    0xf0000000,  5, ','}, 
    { '4',    0xf8000000,  6, ')'}, 
    { '4',    0xfc000000, 10, '9'}, 
    { '4',    0xfc800000, 10, '7'}, 
    { '4',    0xfce40000, 15, ESCAPE}, 
    { '4',    0xfd000000,  8, '6'}, 
    { '5',    0x00000000,  2, '0'}, 
    { '5',    0x40000000,  3, '.'}, 
    { '5',    0x60000000,  5, '/'}, 
    { '5',    0x68000000,  6, '3'}, 
    { '5',    0x6c000000,  7, ':'}, 
    { '5',    0x6e000000,  8, '4'}, 
    { '5',    0x6f200000, 11, ';'}, 
    { '5',    0x6f440000, 14, 'f'}, 
    { '5',    0x6fc00000, 10, '1'}, 
    { '5',    0x70000000,  4, 'p'}, 
    { '5',    0x80000000,  2, ' '}, 
    { '5',    0xc0000000,  4, '5'}, 
    { '5',    0xd0000000,  5, 'a'}, 
    { '5',    0xd8000000,  5, '-'}, 
    { '5',    0xe0000000,  7, ')'}, 
    { '5',    0xe6000000,  7, ','}, 
    { '5',    0xe8000000,  5, '6'}, 
    { '5',    0xf0000000,  6, '2'}, 
    { '5',    0xf4000000,  7, '7'}, 
    { '5',    0xf6000000,  7, '9'}, 
    { '5',    0xf8000000,  6, '8'}, 
    { '5',    0xfc000000,  6, ']'}, 
    { '6',    0x00000000,  2, ' '}, 
    { '6',    0x40000000,  7, '6'}, 
    { '6',    0x44000000,  6, '-'}, 
    { '6',    0x48000000,  5, '1'}, 
    { '6',    0x50000000,  4, ']'}, 
    { '6',    0x60000000,  5, '7'}, 
    { '6',    0x68000000,  6, '5'}, 
    { '6',    0x6c000000,  6, '4'}, 
    { '6',    0x70000000,  5, ')'}, 
    { '6',    0x78000000,  7, '3'}, 
    { '6',    0x7a000000,  7, '2'}, 
    { '6',    0x7c000000,  6, '8'}, 
    { '6',    0x80000000,  2, '.'}, 
    { '6',    0xc0000000,  5, ','}, 
    { '6',    0xc8000000,  5, ':'}, 
    { '6',    0xd0000000,  5, '/'}, 
    { '6',    0xd9fc0000, 15, ESCAPE}, 
    { '6',    0xda000000,  7, '9'}, 
    { '6',    0xdc000000,  6, 't'}, 
    { '6',    0xe0000000,  3, '0'}, 
    { '7',    0x00000000,  4, '8'}, 
    { '7',    0x10000000,  8, STOP}, 
    { '7',    0x11200000, 13, ESCAPE}, 
    { '7',    0x11d00000, 12, '?'}, 
    { '7',    0x12000000,  7, '3'}, 
    { '7',    0x14000000,  6, '6'}, 
    { '7',    0x18000000,  6, '2'}, 
    { '7',    0x1c000000,  6, '1'}, 
    { '7',    0x20000000,  3, ' '}, 
    { '7',    0x40000000,  4, '7'}, 
    { '7',    0x50000000,  5, '/'}, 
    { '7',    0x58000000,  8, ':'}, 
    { '7',    0x59000000,  8, 'p'}, 
    { '7',    0x5a000000,  7, ','}, 
    { '7',    0x5c000000,  6, 't'}, 
    { '7',    0x60000000,  3, '0'}, 
    { '7',    0x80000000,  6, '9'}, 
    { '7',    0x84000000,  7, 'a'}, 
    { '7',    0x86000000,  7, '4'}, 
    { '7',    0x88000000,  6, ')'}, 
    { '7',    0x90000000,  4, ']'}, 
    { '7',    0xa0000000,  3, '-'}, 
    { '7',    0xc0000000,  2, '.'}, 
    { '8',    0x00000000,  3, '4'}, 
    { '8',    0x20000000,  5, '/'}, 
    { '8',    0x28000000,  7, ':'}, 
    { '8',    0x2a000000,  7, ','}, 
    { '8',    0x2c000000,  8, 'p'}, 
    { '8',    0x2d000000,  8, '-'}, 
    { '8',    0x2e100000, 12, '\''}, 
    { '8',    0x2e800000,  9, STOP}, 
    { '8',    0x2f000000,  8, 'a'}, 
    { '8',    0x30000000,  4, '0'}, 
    { '8',    0x40000000,  2, ' '}, 
    { '8',    0x80000000,  4, '9'}, 
    { '8',    0x90000000,  4, '7'}, 
    { '8',    0xa0000000,  5, '3'}, 
    { '8',    0xa8000000,  6, ')'}, 
    { '8',    0xad000000,  8, '2'}, 
    { '8',    0xae000000,  7, 't'}, 
    { '8',    0xb0000000,  4, '8'}, 
    { '8',    0xc0000000,  3, '.'}, 
    { '8',    0xe0000000,  4, '1'}, 
    { '8',    0xf0000000,  5, '5'}, 
    { '8',    0xf8000000,  6, '6'}, 
    { '8',    0xfc000000,  6, ']'}, 
    { '9',    0x00000000,  3, '5'}, 
    { '9',    0x20000000,  3, ']'}, 
    { '9',    0x40000000,  5, '2'}, 
    { '9',    0x48000000,  6, '1'}, 
    { '9',    0x4c000000,  6, '/'}, 
    { '9',    0x50000000,  4, '0'}, 
    { '9',    0x60000000,  4, '.'}, 
    { '9',    0x70000000,  4, '-'}, 
    { '9',    0x80000000,  4, '4'}, 
    { '9',    0x90000000,  4, '8'}, 
    { '9',    0xa0000000,  5, '3'}, 
    { '9',    0xa8000000,  6, 't'}, 
    { '9',    0xac000000,  8, ':'}, 
    { '9',    0xad000000,  9, ','}, 
    { '9',    0xadd80000, 15, ESCAPE}, 
    { '9',    0xae000000,  7, ')'}, 
    { '9',    0xb0000000,  4, '6'}, 
    { '9',    0xc0000000,  4, ' '}, 
    { '9',    0xd0000000,  4, '7'}, 
    { '9',    0xe0000000,  3, '9'}, 
    { ':',    0x40000000,  2, '0'}, 
    { ':',    0x80000000,  1, ' '}, 
    { ';',    0x80000000,  1, ' '}, 
    { '=',    0x80000000,  1, ESCAPE}, 
    { '?',    0x00000000,  3, ':'}, 
    { '?',    0x20000000,  5, '!'}, 
    { '?',    0x28000000,  6, ';'}, 
    { '?',    0x2c000000,  7, '\''}, 
    { '?',    0x40000000,  2, STOP}, 
    { '?',    0x80000000,  1, ' '}, 
    { '@',    0xd0000000,  4, 'b'}, 
    { 'A',    0x00000000,  4, 's'}, 
    { 'A',    0x10000000,  4, 'm'}, 
    { 'A',    0x20000000,  4, 'd'}, 
    { 'A',    0x30000000,  5, 'c'}, 
    { 'A',    0x38000000, 10, 'C'}, 
    { 'A',    0x38400000, 11, 'P'}, 
    { 'A',    0x38700000, 12, 'K'}, 
    { 'A',    0x38800000, 10, ','}, 
    { 'A',    0x38c00000, 11, '-'}, 
    { 'A',    0x39c80000, 13, 'W'}, 
    { 'A',    0x39d00000, 12, 'M'}, 
    { 'A',    0x39ef8000, 18, ESCAPE}, 
    { 'A',    0x39f00000, 12, 'Y'}, 
    { 'A',    0x3ac00000, 11, 'A'}, 
    { 'A',    0x38f00000, 12, '&'}, 
    { 'A',    0x39000000,  9, 'h'}, 
    { 'A',    0x39800000, 10, 'y'}, 
    { 'A',    0x3a000000,  9, '.'}, 
    { 'A',    0x3a800000, 10, 'S'}, 
    { 'A',    0x3b000000, 10, 'k'}, 
    { 'A',    0x3b400000, 10, 'T'}, 
    { 'A',    0x3b800000,  9, 'B'}, 
    { 'A',    0x3c000000,  6, 'b'}, 
    { 'A',    0x40000000,  2, ' '}, 
    { 'A',    0x80000000,  4, 'r'}, 
    { 'A',    0x90000000,  5, 'u'}, 
    { 'A',    0x98100000, 13, '\''}, 
    { 'A',    0x98180000, 13, ':'}, 
    { 'A',    0x98800000, 10, 'F'}, 
    { 'A',    0x98c00000, 10, 'z'}, 
    { 'A',    0x99000000,  8, 'v'}, 
    { 'A',    0x9a000000,  9, 'q'}, 
    { 'A',    0x9aa00000, 11, 'x'}, 
    { 'A',    0x9ac00000, 10, 'a'}, 
    { 'A',    0x9b000000,  8, 'p'}, 
    { 'A',    0x9c000000,  6, 't'}, 
    { 'A',    0xa0000000,  5, 'g'}, 
    { 'A',    0xa8000000,  7, 'w'}, 
    { 'A',    0xaa000000,  7, 'i'}, 
    { 'A',    0xac000000,  6, 'f'}, 
    { 'A',    0xb0000000,  4, 'l'}, 
    { 'A',    0xc0000000,  3, 'D'}, 
    { 'A',    0xe0000000,  3, 'n'}, 
    { 'B',    0x00000000,  2, 'C'}, 
    { 'B',    0x40000000,  3, 'a'}, 
    { 'B',    0x60000000,  8, 'T'}, 
    { 'B',    0x61000000,  8, '.'}, 
    { 'B',    0x62000000,  9, 'A'}, 
    { 'B',    0x62800000, 10, 'O'}, 
    { 'B',    0x62e80000, 15, '-'}, 
    { 'B',    0x62f00000, 12, 'W'}, 
    { 'B',    0x63000000,  8, 'y'}, 
    { 'B',    0x64000000,  8, 'I'}, 
    { 'B',    0x65000000, 11, '&'}, 
    { 'B',    0x65600000, 11, 'M'}, 
    { 'B',    0x65940000, 15, 'S'}, 
    { 'B',    0x65960000, 15, 'F'}, 
    { 'B',    0x65a00000, 12, ','}, 
    { 'B',    0x65b00000, 12, '1'}, 
    { 'B',    0x65e00000, 12, ESCAPE}, 
    { 'B',    0x65f00000, 12, 'P'}, 
    { 'B',    0x66000000,  8, 'h'}, 
    { 'B',    0x67000000,  8, ' '}, 
    { 'B',    0x68000000,  5, 'l'}, 
    { 'B',    0x70000000,  4, 'i'}, 
    { 'B',    0x80000000,  4, 'u'}, 
    { 'B',    0x90000000,  4, 'o'}, 
    { 'B',    0xa0000000,  3, 'r'}, 
    { 'B',    0xc0000000,  3, 'e'}, 
    { 'B',    0xe0000000,  3, 'B'}, 
    { 'C',    0x00000000,  2, 'h'}, 
    { 'C',    0x40000000,  5, '\''}, 
    { 'C',    0x48000000,  9, 'A'}, 
    { 'C',    0x48b00000, 13, 'z'}, 
    { 'C',    0x48b80000, 16, ':'}, 
    { 'C',    0x48b90000, 17, ESCAPE}, 
    { 'C',    0x49000000,  8, 'I'}, 
    { 'C',    0x4a000000,  7, 'y'}, 
    { 'C',    0x4c000000,  6, 'e'}, 
    { 'C',    0x50000000,  4, 'r'}, 
    { 'C',    0x60000000,  3, 'B'}, 
    { 'C',    0x80000000,  3, 'a'}, 
    { 'C',    0xa0000000,  4, '.'}, 
    { 'C',    0xb0400000, 10, 'D'}, 
    { 'C',    0xb0920000, 15, '7'}, 
    { 'C',    0xb0b00000, 12, 'H'}, 
    { 'C',    0xb1000000, 10, 'S'}, 
    { 'C',    0xb1400000, 10, 'T'}, 
    { 'C',    0xb1900000, 14, 'P'}, 
    { 'C',    0xb1a00000, 11, 'J'}, 
    { 'C',    0xb1c00000, 10, 'G'}, 
    { 'C',    0xb2000000,  7, ','}, 
    { 'C',    0xb4000000,  6, 'u'}, 
    { 'C',    0xb8000000,  5, 'i'}, 
    { 'C',    0xc0000000,  3, 'o'}, 
    { 'C',    0xe0000000,  4, ' '}, 
    { 'C',    0xf0000000,  4, 'l'}, 
    { 'D',    0x00000000,  2, 'a'}, 
    { 'D',    0x40000000,  2, ','}, 
    { 'D',    0x80000000,  3, 'r'}, 
    { 'D',    0xa0000000,  3, 'o'}, 
    { 'D',    0xc0000000,  3, 'e'}, 
    { 'D',    0xe0000000,  4, 'i'}, 
    { 'D',    0xf0000000,  8, '.'}, 
    { 'D',    0xf2000000,  7, ' '}, 
    { 'D',    0xf4140000, 16, 'B'}, 
    { 'D',    0xf4180000, 14, '9'}, 
    { 'D',    0xf4200000, 11, 'M'}, 
    { 'D',    0xf4400000, 11, '&'}, 
    { 'D',    0xf4600000, 11, 'V'}, 
    { 'D',    0xf4800000, 10, 'h'}, 
    { 'D',    0xf4d00000, 12, 's'}, 
    { 'D',    0xf4e80000, 13, 'j'}, 
    { 'D',    0xf5000000,  9, 'w'}, 
    { 'D',    0xf5800000,  9, 'W'}, 
    { 'D',    0xf6000000,  7, '\''}, 
    { 'D',    0xf8400000, 11, '-'}, 
    { 'D',    0xf8600000, 11, 'G'}, 
    { 'D',    0xf8800000,  9, 'N'}, 
    { 'D',    0xf9000000,  9, 'C'}, 
    { 'D',    0xf9c00000, 10, 'I'}, 
    { 'D',    0xfa000000,  8, 'y'}, 
    { 'D',    0xfb000000, 12, 'v'}, 
    { 'D',    0xfb100000, 13, ESCAPE}, 
    { 'D',    0xfb400000, 10, ':'}, 
    { 'D',    0xfb800000,  9, 'J'}, 
    { 'D',    0xfc000000,  6, 'u'}, 
    { 'E',    0x00000000,  3, 'p'}, 
    { 'E',    0x20000000,  5, 's'}, 
    { 'E',    0x28000000,  6, '.'}, 
    { 'E',    0x2c000000,  6, 'i'}, 
    { 'E',    0x30000000,  5, 'r'}, 
    { 'E',    0x38000000,  5, 'u'}, 
    { 'E',    0x40000000,  3, 'a'}, 
    { 'E',    0x60000000,  3, 'n'}, 
    { 'E',    0x80000000,  5, 'E'}, 
    { 'E',    0x88000000,  5, ' '}, 
    { 'E',    0x90000000,  4, 'm'}, 
    { 'E',    0xa0000000,  4, 'x'}, 
    { 'E',    0xb0000000,  7, 'y'}, 
    { 'E',    0xb2000000,  7, 't'}, 
    { 'E',    0xb4000000,  6, ':'}, 
    { 'E',    0xb8000000,  7, 'g'}, 
    { 'E',    0xba040000, 14, 'S'}, 
    { 'E',    0xba160000, 16, ESCAPE}, 
    { 'E',    0xba400000, 11, 'f'}, 
    { 'E',    0xba600000, 11, 'o'}, 
    { 'E',    0xba800000, 10, 'R'}, 
    { 'E',    0xbac00000, 10, 'F'}, 
    { 'E',    0xbb000000,  9, 'w'}, 
    { 'E',    0xbbc00000, 10, 'C'}, 
    { 'E',    0xbe000000,  9, 'c'}, 
    { 'E',    0xbea00000, 11, 'e'}, 
    { 'E',    0xbef00000, 12, '\''}, 
    { 'E',    0xbf000000,  9, 'b'}, 
    { 'E',    0xbf800000, 11, 'h'}, 
    { 'E',    0xbfe00000, 11, 'D'}, 
    { 'E',    0xc0000000,  3, 'l'}, 
    { 'E',    0xe0000000,  4, 'v'}, 
    { 'E',    0xf0000000,  4, 'd'}, 
    { 'F',    0x00000000,  2, 'o'}, 
    { 'F',    0x40000000,  3, 'e'}, 
    { 'F',    0x60000000,  4, 'l'}, 
    { 'F',    0x70000000,  5, 'u'}, 
    { 'F',    0x78000000,  7, ' '}, 
    { 'F',    0x7a000000,  7, 'O'}, 
    { 'F',    0x7c000000, 10, '.'}, 
    { 'F',    0x7c900000, 13, 'y'}, 
    { 'F',    0x7c980000, 13, ','}, 
    { 'F',    0x7ca00000, 11, 'T'}, 
    { 'F',    0x7d000000,  8, 'A'}, 
    { 'F',    0x7ee80000, 14, 'I'}, 
    { 'F',    0x7ef00000, 12, '1'}, 
    { 'F',    0x7f000000,  8, 'B'}, 
    { 'F',    0x80000000,  2, 'r'}, 
    { 'F',    0xc0000000,  3, 'i'}, 
    { 'F',    0xe0000000,  3, 'a'}, 
    { 'G',    0x00000000,  2, 'r'}, 
    { 'G',    0x40000000,  2, 'a'}, 
    { 'G',    0x84800000, 11, ';'}, 
    { 'G',    0x84000000,  9, '-'}, 
    { 'G',    0x84a00000, 11, ','}, 
    { 'G',    0x84c00000, 11, 'A'}, 
    { 'G',    0x86000000,  9, 'C'}, 
    { 'G',    0x86d60000, 15, '\''}, 
    { 'G',    0x87000000,  8, 'P'}, 
    { 'G',    0x88000000,  5, 'n'}, 
    { 'G',    0x90000000,  4, 'u'}, 
    { 'G',    0xa0000000,  3, 'o'}, 
    { 'G',    0xc0000000,  3, 'e'}, 
    { 'G',    0xe0000000,  7, 'y'}, 
    { 'G',    0xe2000000,  7, ' '}, 
    { 'G',    0xe4000000, 10, '.'}, 
    { 'G',    0xe4400000, 10, 'I'}, 
    { 'G',    0xe5000000,  8, 'h'}, 
    { 'G',    0xe6000000,  7, 'w'}, 
    { 'G',    0xe8000000,  5, 'l'}, 
    { 'G',    0xf0000000,  4, 'i'}, 
    { 'H',    0x00000000,  2, 'e'}, 
    { 'H',    0x40000000,  2, 'a'}, 
    { 'H',    0x80000000,  2, 'o'}, 
    { 'H',    0xc0000000,  3, 'i'}, 
    { 'H',    0xe0000000,  5, 'R'}, 
    { 'H',    0xea000000, 10, 'S'}, 
    { 'H',    0xea400000, 10, '.'}, 
    { 'H',    0xea8c0000, 15, 'D'}, 
    { 'H',    0xea8e0000, 16, ESCAPE}, 
    { 'H',    0xeaa00000, 11, 'G'}, 
    { 'H',    0xeb000000,  8, 'I'}, 
    { 'H',    0xec000000,  7, 'y'}, 
    { 'H',    0xee000000,  9, 'Q'}, 
    { 'H',    0xee800000,  9, 'M'}, 
    { 'H',    0xef800000,  9, ' '}, 
    { 'H',    0xf0000000,  4, 'u'}, 
    { 'I',    0x00000000,  1, 'n'}, 
    { 'I',    0x80000000,  5, 'T'}, 
    { 'I',    0x88000000,  6, 'c'}, 
    { 'I',    0x8d000000,  9, 'P'}, 
    { 'I',    0x8da00000, 11, '5'}, 
    { 'I',    0x8e000000,  7, '\''}, 
    { 'I',    0x90000000,  4, 's'}, 
    { 'I',    0xa0000000,  8, 'A'}, 
    { 'I',    0xa1000000,  8, 'v'}, 
    { 'I',    0xa2000000,  9, 'w'}, 
    { 'I',    0xa2a00000, 11, '9'}, 
    { 'I',    0xa2c00000, 10, 'y'}, 
    { 'I',    0xa3000000,  9, ':'}, 
    { 'I',    0xa3d00000, 12, ')'}, 
    { 'I',    0xa4000000,  6, 'm'}, 
    { 'I',    0xa8000000,  5, 'a'}, 
    { 'I',    0xb4000000,  6, '.'}, 
    { 'I',    0xb8000000,  9, 'p'}, 
    { 'I',    0xb8800000, 11, 'b'}, 
    { 'I',    0xb8c00000, 11, '-'}, 
    { 'I',    0xb9000000,  8, 'V'}, 
    { 'I',    0xba000000,  7, 'l'}, 
    { 'I',    0xbc000000,  6, 'd'}, 
    { 'I',    0xc0000000,  3, 't'}, 
    { 'I',    0xe0000000,  5, ' '}, 
    { 'I',    0xe8800000,  9, ','}, 
    { 'I',    0xe9000000,  8, 'f'}, 
    { 'I',    0xea000000, 10, 'g'}, 
    { 'I',    0xea400000, 10, 'D'}, 
    { 'I',    0xea800000,  9, 'Y'}, 
    { 'I',    0xeb000000,  8, 'o'}, 
    { 'I',    0xec000000,  6, 'I'}, 
    { 'I',    0xf0000000,  4, 'r'}, 
    { 'J',    0x00000000,  2, 'e'}, 
    { 'J',    0x40000000,  5, ' '}, 
    { 'J',    0x48c00000, 10, ','}, 
    { 'J',    0x49000000,  8, 'r'}, 
    { 'J',    0x4a400000, 10, '-'}, 
    { 'J',    0x4ac00000, 11, 'n'}, 
    { 'J',    0x4aec0000, 15, ESCAPE}, 
    { 'J',    0x4af80000, 13, '\''}, 
    { 'J',    0x4b000000,  9, 's'}, 
    { 'J',    0x4b800000, 10, 'K'}, 
    { 'J',    0x4bc00000, 10, 'T'}, 
    { 'J',    0x4c000000,  7, 'D'}, 
    { 'J',    0x4e000000,  7, '.'}, 
    { 'J',    0x50000000,  4, 'i'}, 
    { 'J',    0x60000000,  3, 'u'}, 
    { 'J',    0x80000000,  2, 'a'}, 
    { 'J',    0xc0000000,  2, 'o'}, 
    { 'K',    0x00000000,  2, 'i'}, 
    { 'K',    0x40000000,  2, 'a'}, 
    { 'K',    0x80000000,  2, 'e'}, 
    { 'K',    0xc0000000,  5, 'n'}, 
    { 'K',    0xc8000000,  5, 'o'}, 
    { 'K',    0xd0000000,  6, '\''}, 
    { 'K',    0xd4e00000, 12, '-'}, 
    { 'K',    0xd5000000, 10, 'w'}, 
    { 'K',    0xd5600000, 12, ':'}, 
    { 'K',    0xd5800000,  9, 'G'}, 
    { 'K',    0xd6000000,  7, '.'}, 
    { 'K',    0xd8000000,  5, 'r'}, 
    { 'K',    0xe0000000,  6, 'u'}, 
    { 'K',    0xe4500000, 12, 'S'}, 
    { 'K',    0xe4800000,  9, ','}, 
    { 'K',    0xe5000000,  8, 'h'}, 
    { 'K',    0xe6000000,  7, 'l'}, 
    { 'K',    0xe8000000,  5, ' '}, 
    { 'K',    0xf0000000,  4, 'y'}, 
    { 'L',    0x00000000,  2, 'i'}, 
    { 'L',    0x40000000,  4, 'u'}, 
    { 'L',    0x50000000,  6, 'l'}, 
    { 'L',    0x54000000,  6, 'A'}, 
    { 'L',    0x58000000,  9, 'I'}, 
    { 'L',    0x59400000, 10, '\''}, 
    { 'L',    0x59a00000, 11, '.'}, 
    { 'L',    0x5a680000, 16, ESCAPE}, 
    { 'L',    0x5a700000, 12, 'S'}, 
    { 'L',    0x5c000000,  6, 'y'}, 
    { 'L',    0x60000000,  3, ']'}, 
    { 'L',    0x80000000,  2, 'o'}, 
    { 'L',    0xc0000000,  3, 'e'}, 
    { 'L',    0xe0000000,  3, 'a'}, 
    { 'M',    0x00000000,  2, 'o'}, 
    { 'M',    0x40000000,  9, '1'}, 
    { 'M',    0x40800000, 10, 'A'}, 
    { 'M',    0x41000000,  8, 'C'}, 
    { 'M',    0x42000000,  7, ' '}, 
    { 'M',    0x44000000,  9, 'h'}, 
    { 'M',    0x44800000, 10, 'z'}, 
    { 'M',    0x45000000,  9, 'I'}, 
    { 'M',    0x45800000, 12, 'R'}, 
    { 'M',    0x45b60000, 15, '2'}, 
    { 'M',    0x45b80000, 13, 'D'}, 
    { 'M',    0x45c00000, 11, '.'}, 
    { 'M',    0x45f00000, 13, 'E'}, 
    { 'M',    0x45fc0000, 14, 'w'}, 
    { 'M',    0x46000000,  8, 'F'}, 
    { 'M',    0x47800000,  9, 'X'}, 
    { 'M',    0x48000000,  5, 'y'}, 
    { 'M',    0x50000000,  4, 'c'}, 
    { 'M',    0x60000000,  3, 'e'}, 
    { 'M',    0x80000000,  6, 'S'}, 
    { 'M',    0x84000000,  6, 'P'}, 
    { 'M',    0x88000000,  5, 'r'}, 
    { 'M',    0x90000000,  4, 'u'}, 
    { 'M',    0xa0000000,  3, 'i'}, 
    { 'M',    0xc0000000,  2, 'a'}, 
    { 'N',    0x00000000,  2, 'a'}, 
    { 'N',    0x43500000, 12, 'M'}, 
    { 'N',    0x44000000,  7, 'y'}, 
    { 'N',    0x47000000,  8, ' '}, 
    { 'N',    0x48000000,  6, 'A'}, 
    { 'N',    0x4e000000,  9, 'L'}, 
    { 'N',    0x4f680000, 13, ESCAPE}, 
    { 'N',    0x50000000,  5, 'u'}, 
    { 'N',    0x58000000,  5, 'E'}, 
    { 'N',    0x60000000,  3, 'i'}, 
    { 'N',    0x80000000,  2, 'o'}, 
    { 'N',    0xc0000000,  2, 'e'}, 
    { 'O',    0x00000000,  4, 's'}, 
    { 'O',    0x20000000,  6, 'o'}, 
    { 'O',    0x28000000,  5, 'U'}, 
    { 'O',    0x40000000,  4, 'r'}, 
    { 'O',    0x50000000,  6, 'b'}, 
    { 'O',    0x54000000,  6, 'm'}, 
    { 'O',    0x58000000,  5, 'h'}, 
    { 'O',    0x60000000,  9, 'K'}, 
    { 'O',    0x60a00000, 12, ':'}, 
    { 'O',    0x61000000,  8, 't'}, 
    { 'O',    0x62000000,  8, 'k'}, 
    { 'O',    0x63200000, 11, 'L'}, 
    { 'O',    0x6c000000,  6, 'v'}, 
    { 'O',    0x70000000,  5, 'f'}, 
    { 'O',    0x78000000,  5, 'w'}, 
    { 'O',    0x80000000,  4, 'u'}, 
    { 'O',    0x90000000,  5, '.'}, 
    { 'O',    0x98000000,  8, 'g'}, 
    { 'O',    0x99c00000, 10, '-'}, 
    { 'O',    0x9a000000,  7, 'd'}, 
    { 'O',    0x9c000000,  6, 'c'}, 
    { 'O',    0xa0000000,  4, 'p'}, 
    { 'O',    0xb0000000,  4, 'l'}, 
    { 'O',    0xc0000000,  5, ' '}, 
    { 'O',    0xc8000000,  7, 'a'}, 
    { 'O',    0xcb200000, 11, 'A'}, 
    { 'O',    0xcb600000, 11, 'C'}, 
    { 'O',    0xcc000000,  6, 'x'}, 
    { 'O',    0xd0000000,  4, '\''}, 
    { 'O',    0xe0000000,  3, 'n'}, 
    { 'P',    0x00000000,  3, 'i'}, 
    { 'P',    0x20000000,  4, 'h'}, 
    { 'P',    0x31100000, 12, 'G'}, 
    { 'P',    0x31400000, 10, 'y'}, 
    { 'P',    0x32000000,  8, 'D'}, 
    { 'P',    0x33540000, 16, ESCAPE}, 
    { 'P',    0x33580000, 13, 'J'}, 
    { 'P',    0x33600000, 12, 'A'}, 
    { 'P',    0x33800000,  9, ','}, 
    { 'P',    0x34000000,  7, 'C'}, 
    { 'P',    0x36000000, 10, 'E'}, 
    { 'P',    0x36400000, 10, '\''}, 
    { 'P',    0x36900000, 12, 'F'}, 
    { 'P',    0x36a00000, 13, 'f'}, 
    { 'P',    0x36a80000, 13, 'R'}, 
    { 'P',    0x36b00000, 14, 'Y'}, 
    { 'P',    0x37000000,  8, 's'}, 
    { 'P',    0x38000000,  7, '.'}, 
    { 'P',    0x3a000000,  7, ' '}, 
    { 'P',    0x3c000000,  6, 'u'}, 
    { 'P',    0x40000000,  3, 'e'}, 
    { 'P',    0x60000000,  3, 'l'}, 
    { 'P',    0x80000000,  3, 'o'}, 
    { 'P',    0xa0000000,  3, 'r'}, 
    { 'P',    0xc0000000,  2, 'a'}, 
    { 'Q',    0x40000000,  5, 'a'}, 
    { 'Q',    0x4b000000,  8, '&'}, 
    { 'Q',    0x50000000,  4, '.'}, 
    { 'Q',    0x60000000,  3, ' '}, 
    { 'Q',    0x80000000,  1, 'u'}, 
    { 'R',    0x10000000,  6, ' '}, 
    { 'R',    0x15000000,  9, 'F'}, 
    { 'R',    0x16000000,  8, '.'}, 
    { 'R',    0x17000000, 10, 'N'}, 
    { 'R',    0x17c00000, 10, 'H'}, 
    { 'R',    0x18000000,  5, 'E'}, 
    { 'R',    0x20000000,  5, 'h'}, 
    { 'R',    0x28000000,  6, 'y'}, 
    { 'R',    0x2d800000,  9, 'n'}, 
    { 'R',    0x2e000000,  8, 'S'}, 
    { 'R',    0x2f800000,  9, 'A'}, 
    { 'R',    0x30000000,  4, 'u'}, 
    { 'R',    0x40000000,  2, 'a'}, 
    { 'R',    0x80000000,  3, 'i'}, 
    { 'R',    0xa0000000,  3, 'e'}, 
    { 'R',    0xc0000000,  2, 'o'}, 
    { 'S',    0x00000000,  4, 'a'}, 
    { 'S',    0x10000000,  5, 'p'}, 
    { 'S',    0x18000000,  5, ','}, 
    { 'S',    0x20000000,  4, 'h'}, 
    { 'S',    0x30000000,  5, 'L'}, 
    { 'S',    0x38000000,  7, 'w'}, 
    { 'S',    0x3a000000,  8, 'q'}, 
    { 'S',    0x3b000000,  9, 'P'}, 
    { 'S',    0x3b800000, 10, 'A'}, 
    { 'S',    0x3bc40000, 16, 'G'}, 
    { 'S',    0x3bc60000, 15, '}'}, 
    { 'S',    0x3be00000, 12, 'S'}, 
    { 'S',    0x3c000000,  6, 'k'}, 
    { 'S',    0x40000000,  5, 'i'}, 
    { 'S',    0x48000000,  5, 'u'}, 
    { 'S',    0x50000000,  5, 'o'}, 
    { 'S',    0x58000000,  5, 'c'}, 
    { 'S',    0x60000000,  5, 'e'}, 
    { 'S',    0x69000000,  8, 'n'}, 
    { 'S',    0x6a000000,  7, ' '}, 
    { 'S',    0x6c000000,  8, 'l'}, 
    { 'S',    0x6d100000, 14, 'O'}, 
    { 'S',    0x6d140000, 16, '-'}, 
    { 'S',    0x6d160000, 15, 'B'}, 
    { 'S',    0x6d180000, 13, ESCAPE}, 
    { 'S',    0x6d200000, 11, '.'}, 
    { 'S',    0x6d4c0000, 16, '3'}, 
    { 'S',    0x6d4e8000, 17, 's'}, 
    { 'S',    0x6d500000, 12, 'E'}, 
    { 'S',    0x6d600000, 12, 'v'}, 
    { 'S',    0x6d700000, 14, 'z'}, 
    { 'S',    0x6d740000, 15, 'H'}, 
    { 'S',    0x6d780000, 13, 'g'}, 
    { 'S',    0x6d800000,  9, 'y'}, 
    { 'S',    0x6e000000,  7, 'm'}, 
    { 'S',    0x70000000,  4, 't'}, 
    { 'S',    0x80000000,  1, ']'}, 
    { 'T',    0x00000000,  1, 'h'}, 
    { 'T',    0x80000000,  3, 'o'}, 
    { 'T',    0xa0000000,  4, 'V'}, 
    { 'T',    0xb0000000,  4, 'w'}, 
    { 'T',    0xc0000000,  4, 'r'}, 
    { 'T',    0xd0000000,  5, 'a'}, 
    { 'T',    0xd8000000,  5, 'i'}, 
    { 'T',    0xe0000000,  5, 'u'}, 
    { 'T',    0xe8000000,  7, 'H'}, 
    { 'T',    0xea000000,  8, ' '}, 
    { 'T',    0xeb000000,  8, 'y'}, 
    { 'T',    0xec000000,  7, 'W'}, 
    { 'T',    0xee000000, 10, 'S'}, 
    { 'T',    0xee400000, 11, 'A'}, 
    { 'T',    0xee680000, 13, '-'}, 
    { 'T',    0xee800000,  9, 'M'}, 
    { 'T',    0xef000000, 12, '.'}, 
    { 'T',    0xef140000, 14, '4'}, 
    { 'T',    0xef200000, 11, 's'}, 
    { 'T',    0xef400000, 13, 'C'}, 
    { 'T',    0xef480000, 14, 'O'}, 
    { 'T',    0xef4c0000, 15, 'E'}, 
    { 'T',    0xef540000, 15, '\''}, 
    { 'T',    0xef580000, 13, 'c'}, 
    { 'T',    0xef800000,  9, 'x'}, 
    { 'T',    0xf0000000,  4, 'e'}, 
    { 'U',    0x00000000,  2, 'K'}, 
    { 'U',    0x40000000,  6, 'g'}, 
    { 'U',    0x44000000,  8, 'k'}, 
    { 'U',    0x45000000,  8, 't'}, 
    { 'U',    0x46000000,  8, 'E'}, 
    { 'U',    0x47000000,  8, '-'}, 
    { 'U',    0x48000000,  8, 'F'}, 
    { 'U',    0x4ac00000, 11, 'b'}, 
    { 'U',    0x4b800000,  9, 'Z'}, 
    { 'U',    0x4c000000,  8, '2'}, 
    { 'U',    0x4d000000, 10, 'i'}, 
    { 'U',    0x4d800000, 10, 'a'}, 
    { 'U',    0x4e000000, 10, '.'}, 
    { 'U',    0x50000000,  5, 's'}, 
    { 'U',    0x58000000,  5, 'r'}, 
    { 'U',    0x60000000,  3, 'S'}, 
    { 'U',    0x80000000,  2, 'n'}, 
    { 'U',    0xc0000000,  3, 'p'}, 
    { 'U',    0xe0000000,  6, ' '}, 
    { 'U',    0xe4000000,  7, 'm'}, 
    { 'U',    0xe8000000,  5, 'R'}, 
    { 'U',    0xf0000000,  4, 'l'}, 
    { 'V',    0x00000000,  3, '.'}, 
    { 'V',    0x20000000,  3, 'a'}, 
    { 'V',    0x40000000,  2, ' '}, 
    { 'V',    0x81000000,  8, '1'}, 
    { 'V',    0x84780000, 13, '8'}, 
    { 'V',    0x91000000,  9, 'D'}, 
    { 'V',    0x91800000,  9, 'u'}, 
    { 'V',    0x94000000, 10, ';'}, 
    { 'V',    0x94400000, 11, ESCAPE}, 
    { 'V',    0x94780000, 13, 'W'}, 
    { 'V',    0x94800000,  9, ','}, 
    { 'V',    0x95000000,  8, '\''}, 
    { 'V',    0x96000000,  8, ':'}, 
    { 'V',    0x97000000,  8, 'l'}, 
    { 'V',    0x98000000,  5, 'o'}, 
    { 'V',    0xa0000000,  3, 'e'}, 
    { 'V',    0xc0000000,  2, 'i'}, 
    { 'W',    0x00000000,  2, 'h'}, 
    { 'W',    0x40000000,  4, 'r'}, 
    { 'W',    0x50800000,  9, '.'}, 
    { 'W',    0x51000000, 10, '\''}, 
    { 'W',    0x51800000, 11, '2'}, 
    { 'W',    0x51a00000, 11, ':'}, 
    { 'W',    0x52000000,  7, ' '}, 
    { 'W',    0x54000000,  7, 'y'}, 
    { 'W',    0x56000000,  9, 'I'}, 
    { 'W',    0x56b40000, 16, ESCAPE}, 
    { 'W',    0x56b80000, 13, 'u'}, 
    { 'W',    0x56c00000, 11, 'V'}, 
    { 'W',    0x57000000,  9, 'W'}, 
    { 'W',    0x58000000,  5, 'O'}, 
    { 'W',    0x60000000,  3, 'a'}, 
    { 'W',    0x80000000,  2, 'i'}, 
    { 'W',    0xc0000000,  3, 'o'}, 
    { 'W',    0xe0000000,  3, 'e'}, 
    { 'X',    0x00000000,  3, 'a'}, 
    { 'X',    0x43000000, 10, ')'}, 
    { 'X',    0x50000000,  5, '-'}, 
    { 'X',    0x6a000000,  7, '.'}, 
    { 'X',    0x70000000,  4, 't'}, 
    { 'X',    0x80000000,  1, ' '}, 
    { 'Y',    0x00000000,  2, 'e'}, 
    { 'Y',    0x40000000,  3, 'u'}, 
    { 'Y',    0x60000000,  5, 'a'}, 
    { 'Y',    0x6e000000, 13, '-'}, 
    { 'Y',    0x6e380000, 13, ','}, 
    { 'Y',    0x6f000000,  8, 'i'}, 
    { 'Y',    0x78000000,  5, ' '}, 
    { 'Y',    0x80000000,  1, 'o'}, 
    { 'Z',    0x08000000,  5, 'Z'}, 
    { 'Z',    0x10000000,  5, ' '}, 
    { 'Z',    0x18000000,  5, 'u'}, 
    { 'Z',    0x20000000,  4, 'z'}, 
    { 'Z',    0x30000000,  4, 'i'}, 
    { 'Z',    0x03400000, 10, '-'}, 
    { 'Z',    0x40000000,  2, 'a'}, 
    { 'Z',    0x80000000,  2, 'e'}, 
    { 'Z',    0xc0000000,  2, 'o'}, 
    { '[',    0x00000000,  4, '2'}, 
    { '[',    0x10000000, 11, 'J'}, 
    { '[',    0x10800000,  9, 'C'}, 
    { '[',    0x11000000,  9, 'f'}, 
    { '[',    0x14000000,  6, 'n'}, 
    { '[',    0x1c000000, 11, 'L'}, 
    { '[',    0x1c240000, 15, ESCAPE}, 
    { '[',    0x1c280000, 13, 'D'}, 
    { '[',    0x1c400000, 10, 'T'}, 
    { '[',    0x1c800000,  9, 'c'}, 
    { '[',    0x30000000,  4, '1'}, 
    { '[',    0x40000000,  2, 'A'}, 
    { '[',    0x80000000,  1, 'S'}, 
    { '\'',   0x00000000,  4, 'l'}, 
    { '\'',   0x10000000,  6, 'n'}, 
    { '\'',   0x14000000,  6, '.'}, 
    { '\'',   0x18000000,  6, 'C'}, 
    { '\'',   0x1c000000,  8, 'S'}, 
    { '\'',   0x1d000000,  9, 'f'}, 
    { '\'',   0x1d800000,  9, 'g'}, 
    { '\'',   0x1e000000, 10, 'o'}, 
    { '\'',   0x1e400000, 10, 'K'}, 
    { '\'',   0x1e840000, 14, '0'}, 
    { '\'',   0x1e900000, 12, 'W'}, 
    { '\'',   0x1ea00000, 11, '?'}, 
    { '\'',   0x1ec00000, 10, 'a'}, 
    { '\'',   0x1f000000,  8, 'p'}, 
    { '\'',   0x20000000,  3, 't'}, 
    { '\'',   0x40000000,  3, ' '}, 
    { '\'',   0x60000000,  6, 'B'}, 
    { '\'',   0x64000000,  9, 'F'}, 
    { '\'',   0x64800000,  9, 'h'}, 
    { '\'',   0x65000000,  8, 'D'}, 
    { '\'',   0x66000000, 11, 'E'}, 
    { '\'',   0x66400000, 10, 'u'}, 
    { '\'',   0x66800000,  9, 'H'}, 
    { '\'',   0x67900000, 12, ':'}, 
    { '\'',   0x67b40000, 16, ESCAPE}, 
    { '\'',   0x67b80000, 13, 'y'}, 
    { '\'',   0x68000000,  5, 'r'}, 
    { '\'',   0x70000000,  7, 'd'}, 
    { '\'',   0x72400000, 10, 'I'}, 
    { '\'',   0x72800000,  9, 'R'}, 
    { '\'',   0x73800000,  9, 'T'}, 
    { '\'',   0x74000000,  6, 'A'}, 
    { '\'',   0x78000000,  7, 'v'}, 
    { '\'',   0x7a000000, 10, 'w'}, 
    { '\'',   0x7a400000, 10, 'b'}, 
    { '\'',   0x7a800000,  9, 'G'}, 
    { '\'',   0x7b000000,  8, 'i'}, 
    { '\'',   0x7c000000,  8, 'c'}, 
    { '\'',   0x7d000000,  8, 'm'}, 
    { '\'',   0x7e000000, 13, '6'}, 
    { '\'',   0x7e100000, 12, 'q'}, 
    { '\'',   0x7e220000, 15, 'U'}, 
    { '\'',   0x7e300000, 12, 'M'}, 
    { '\'',   0x7e400000, 10, 'e'}, 
    { '\'',   0x7e800000,  9, 'L'}, 
    { '\'',   0x7f000000,  8, ','}, 
    { '\'',   0x80000000,  1, 's'}, 
    { ']',    0x04000000,  6, ','}, 
    { ']',    0x20000000,  3, '.'}, 
    { ']',    0x40000000,  2, ' '}, 
    { ']',    0x80000000,  1, STOP}, 
    { 'a',    0x00000000,  4, 'm'}, 
    { 'a',    0x10000000,  6, 'p'}, 
    { 'a',    0x14000000,  7, 'w'}, 
    { 'a',    0x16000000,  9, ','}, 
    { 'a',    0x16800000,  9, '\''}, 
    { 'a',    0x17000000,  8, 'z'}, 
    { 'a',    0x18000000,  5, 'd'}, 
    { 'a',    0x20000000,  3, 'r'}, 
    { 'a',    0x40000000,  2, 'n'}, 
    { 'a',    0x80000000,  5, 'i'}, 
    { 'a',    0x88000000,  6, 'u'}, 
    { 'a',    0x8c000000,  6, 'v'}, 
    { 'a',    0x90000000,  4, 's'}, 
    { 'a',    0xa0000000,  3, 't'}, 
    { 'a',    0xc0000000,  5, 'y'}, 
    { 'a',    0xc8000000,  8, '.'}, 
    { 'a',    0xc9000000, 11, 'a'}, 
    { 'a',    0xc9200000, 11, '-'}, 
    { 'a',    0xc9400000, 12, 'q'}, 
    { 'a',    0xc9500000, 14, '!'}, 
    { 'a',    0xc9550000, 17, 'J'}, 
    { 'a',    0xc9560000, 16, ';'}, 
    { 'a',    0xc9570000, 16, ')'}, 
    { 'a',    0xc9580000, 18, 'R'}, 
    { 'a',    0xc9590000, 16, '/'}, 
    { 'a',    0xc95c0000, 14, '?'}, 
    { 'a',    0xc9600000, 11, 'j'}, 
    { 'a',    0xc9800000,  9, 'e'}, 
    { 'a',    0xca000000, 11, ':'}, 
    { 'a',    0xca200000, 11, 'o'}, 
    { 'a',    0xca400000, 10, 'x'}, 
    { 'a',    0xca800000,  9, 'h'}, 
    { 'a',    0xcb000000,  8, 'f'}, 
    { 'a',    0xcc000000,  6, 'g'}, 
    { 'a',    0xd0000000,  5, 'c'}, 
    { 'a',    0xd8000000,  6, 'b'}, 
    { 'a',    0xdc000000,  6, 'k'}, 
    { 'a',    0xe0000000,  4, ' '}, 
    { 'a',    0xf0000000,  4, 'l'}, 
    { 'b',    0x00000000,  2, 'e'}, 
    { 'b',    0x40000000,  3, 'u'}, 
    { 'b',    0x60000000,  3, 'a'}, 
    { 'b',    0x80000000,  3, 'y'}, 
    { 'b',    0xa0000000,  3, 'o'}, 
    { 'b',    0xc0000000,  4, 'l'}, 
    { 'b',    0xd0000000,  6, 's'}, 
    { 'b',    0xd4000000,  9, 'j'}, 
    { 'b',    0xd4800000, 13, '?'}, 
    { 'b',    0xd4880000, 14, 'f'}, 
    { 'b',    0xd48c0000, 16, '/'}, 
    { 'b',    0xd4900000, 13, 'v'}, 
    { 'b',    0xd4984000, 19, ESCAPE}, 
    { 'b',    0xd4a00000, 11, ':'}, 
    { 'b',    0xd4c00000, 10, '\''}, 
    { 'b',    0xd5000000,  8, 'c'}, 
    { 'b',    0xd6000000,  9, ','}, 
    { 'b',    0xd6800000,  9, '.'}, 
    { 'b',    0xd7000000, 11, 'w'}, 
    { 'b',    0xd7200000, 11, 'd'}, 
    { 'b',    0xd7400000, 11, 'h'}, 
    { 'b',    0xd7600000, 11, '&'}, 
    { 'b',    0xd7800000, 12, 'm'}, 
    { 'b',    0xd7900000, 12, 'n'}, 
    { 'b',    0xd7a00000, 11, '-'}, 
    { 'b',    0xd7c00000, 10, 't'}, 
    { 'b',    0xd8000000,  6, ' '}, 
    { 'b',    0xdc000000,  6, 'b'}, 
    { 'b',    0xe0000000,  4, 'r'}, 
    { 'b',    0xf0000000,  4, 'i'}, 
    { 'c',    0x00000000,  2, 'o'}, 
    { 'c',    0x40000000,  4, 'i'}, 
    { 'c',    0x50000000,  4, 'l'}, 
    { 'c',    0x60000000,  3, 'a'}, 
    { 'c',    0x80000000,  3, 'e'}, 
    { 'c',    0xa0000000,  5, 'u'}, 
    { 'c',    0xa8000000,  5, 'r'}, 
    { 'c',    0xb0000000,  4, 'k'}, 
    { 'c',    0xc0000000,  3, 'h'}, 
    { 'c',    0xe0000000,  5, ' '}, 
    { 'c',    0xe8000000,  7, 'y'}, 
    { 'c',    0xea000000,  7, 'c'}, 
    { 'c',    0xec000000, 12, ':'}, 
    { 'c',    0xec100000, 15, 'b'}, 
    { 'c',    0xec120000, 15, ESCAPE}, 
    { 'c',    0xec1b0000, 16, 'V'}, 
    { 'c',    0xec1c0000, 14, 'E'}, 
    { 'c',    0xec200000, 11, 'n'}, 
    { 'c',    0xec400000, 10, 'G'}, 
    { 'c',    0xec800000, 13, 'N'}, 
    { 'c',    0xec900000, 12, '-'}, 
    { 'c',    0xeca00000, 12, 'A'}, 
    { 'c',    0xecb00000, 14, '?'}, 
    { 'c',    0xecb80000, 15, ';'}, 
    { 'c',    0xecba0000, 17, 'U'}, 
    { 'c',    0xecc00000, 11, 'D'}, 
    { 'c',    0xece00000, 12, 'L'}, 
    { 'c',    0xecf00000, 12, '\''}, 
    { 'c',    0xed000000,  8, 's'}, 
    { 'c',    0xee000000,  8, '.'}, 
    { 'c',    0xef000000, 11, 'K'}, 
    { 'c',    0xef200000, 12, 'd'}, 
    { 'c',    0xef300000, 14, 'M'}, 
    { 'c',    0xef380000, 13, 'F'}, 
    { 'c',    0xef400000, 12, 'q'}, 
    { 'c',    0xef500000, 12, 'I'}, 
    { 'c',    0xef600000, 11, 'C'}, 
    { 'c',    0xef800000,  9, ','}, 
    { 'c',    0xf0000000,  4, 't'}, 
    { 'd',    0x00000000,  1, ' '}, 
    { 'd',    0x80000000,  8, 'h'}, 
    { 'd',    0x81000000,  8, ':'}, 
    { 'd',    0x82000000,  8, 'm'}, 
    { 'd',    0x83000000, 11, '!'}, 
    { 'd',    0x83300000, 12, ')'}, 
    { 'd',    0x83400000, 12, 'k'}, 
    { 'd',    0x83500000, 12, ';'}, 
    { 'd',    0x83600000, 15, 'z'}, 
    { 'd',    0x83640000, 16, ESCAPE}, 
    { 'd',    0x83660000, 15, 'q'}, 
    { 'd',    0x836c0000, 14, 'j'}, 
    { 'd',    0x83700000, 12, '/'}, 
    { 'd',    0x83800000,  9, 'f'}, 
    { 'd',    0x84000000,  6, 'd'}, 
    { 'd',    0x88000000,  5, '.'}, 
    { 'd',    0x90000000,  8, 'w'}, 
    { 'd',    0x91000000,  8, 'n'}, 
    { 'd',    0x92000000,  7, '-'}, 
    { 'd',    0x94000000,  6, 'l'}, 
    { 'd',    0x98000000,  5, 'o'}, 
    { 'd',    0xa0000000,  3, 'e'}, 
    { 'd',    0xc0000000,  4, 'a'}, 
    { 'd',    0xd0000000,  6, 'u'}, 
    { 'd',    0xd4000000, 11, 'p'}, 
    { 'd',    0xd4200000, 11, 't'}, 
    { 'd',    0xd4400000, 10, '?'}, 
    { 'd',    0xd4800000, 10, 'b'}, 
    { 'd',    0xd4c00000, 10, 'c'}, 
    { 'd',    0xd5000000,  8, '\''}, 
    { 'd',    0xd6000000,  7, 'v'}, 
    { 'd',    0xd8000000,  5, 'r'}, 
    { 'd',    0xe0000000,  4, 'i'}, 
    { 'd',    0xf0000000,  7, 'g'}, 
    { 'd',    0xf2000000,  7, ','}, 
    { 'd',    0xf4000000,  6, 'y'}, 
    { 'd',    0xf8000000,  5, 's'}, 
    { 'e',    0x00000000,  4, 'd'}, 
    { 'e',    0x10000000,  5, 'c'}, 
    { 'e',    0x18000000,  6, 'x'}, 
    { 'e',    0x1c000000,  7, 'f'}, 
    { 'e',    0x1e000000,  8, '-'}, 
    { 'e',    0x1f000000,  8, 'h'}, 
    { 'e',    0x20000000,  6, 'v'}, 
    { 'e',    0x24000000,  6, 'i'}, 
    { 'e',    0x28000000,  6, 'y'}, 
    { 'e',    0x2c000000,  8, 'k'}, 
    { 'e',    0x2d000000, 10, ')'}, 
    { 'e',    0x2d400000, 10, 'q'}, 
    { 'e',    0x2d800000,  9, ':'}, 
    { 'e',    0x2e000000,  7, 'b'}, 
    { 'e',    0x30000000,  4, 'a'}, 
    { 'e',    0x40000000,  3, 's'}, 
    { 'e',    0x60000000,  5, 'e'}, 
    { 'e',    0x68000000,  5, 'w'}, 
    { 'e',    0x70000000,  6, 'm'}, 
    { 'e',    0x74000000,  7, ','}, 
    { 'e',    0x76000000,  8, '\''}, 
    { 'e',    0x77000000, 11, 'z'}, 
    { 'e',    0x77240000, 14, '4'}, 
    { 'e',    0x77280000, 14, 'B'}, 
    { 'e',    0x772c0000, 16, ESCAPE}, 
    { 'e',    0x772d4000, 18, 'G'}, 
    { 'e',    0x772f4000, 21, '2'}, 
    { 'e',    0x77300000, 13, '/'}, 
    { 'e',    0x77380000, 14, ']'}, 
    { 'e',    0x773c0000, 14, ';'}, 
    { 'e',    0x77400000, 10, '?'}, 
    { 'e',    0x77800000, 10, 'u'}, 
    { 'e',    0x77c00000, 11, '!'}, 
    { 'e',    0x77e00000, 12, STOP}, 
    { 'e',    0x77f00000, 12, 'j'}, 
    { 'e',    0x78000000,  5, 't'}, 
    { 'e',    0x80000000,  2, ' '}, 
    { 'e',    0xc0000000,  3, 'r'}, 
    { 'e',    0xe0000000,  5, 'l'}, 
    { 'e',    0xe8000000,  6, '.'}, 
    { 'e',    0xec000000,  7, 'p'}, 
    { 'e',    0xee000000,  8, 'g'}, 
    { 'e',    0xef000000,  8, 'o'}, 
    { 'e',    0xf0000000,  4, 'n'}, 
    { 'f',    0x00000000,  2, 'o'}, 
    { 'f',    0x40000000,  3, 'i'}, 
    { 'f',    0x60000000,  5, 't'}, 
    { 'f',    0x68000000,  8, 's'}, 
    { 'f',    0x69000000,  8, 'y'}, 
    { 'f',    0x6a000000, 10, '?'}, 
    { 'f',    0x6a400000, 12, 'm'}, 
    { 'f',    0x6a500000, 16, 'h'}, 
    { 'f',    0x6a560000, 16, ';'}, 
    { 'f',    0x6a600000, 11, ':'}, 
    { 'f',    0x6a800000, 11, '\''}, 
    { 'f',    0x6aa00000, 11, 'g'}, 
    { 'f',    0x6ac00000, 10, ','}, 
    { 'f',    0x6b000000,  9, '.'}, 
    { 'f',    0x6b800000, 12, ESCAPE}, 
    { 'f',    0x6b980000, 14, ')'}, 
    { 'f',    0x6b9c0000, 14, 'w'}, 
    { 'f',    0x6bb00000, 12, 'n'}, 
    { 'f',    0x6bc00000, 10, '-'}, 
    { 'f',    0x6c000000,  6, 'l'}, 
    { 'f',    0x70000000,  4, 'a'}, 
    { 'f',    0x80000000,  2, ' '}, 
    { 'f',    0xc0000000,  3, 'r'}, 
    { 'f',    0xe0000000,  4, 'e'}, 
    { 'f',    0xf0000000,  5, 'u'}, 
    { 'f',    0xf8000000,  5, 'f'}, 
    { 'g',    0x00000000,  3, 'a'}, 
    { 'g',    0x20000000,  9, 'd'}, 
    { 'g',    0x20800000, 10, '?'}, 
    { 'g',    0x20c00000, 10, 'm'}, 
    { 'g',    0x21000000,  8, '\''}, 
    { 'g',    0x22000000,  8, '-'}, 
    { 'g',    0x23000000,  8, ':'}, 
    { 'g',    0x24000000,  6, ','}, 
    { 'g',    0x28000000,  6, 'n'}, 
    { 'g',    0x2c000000,  7, 'y'}, 
    { 'g',    0x2e000000, 13, 'k'}, 
    { 'g',    0x2e080000, 14, ')'}, 
    { 'g',    0x2e0c0000, 14, '"'}, 
    { 'g',    0x2e100000, 12, ';'}, 
    { 'g',    0x2e200000, 11, '!'}, 
    { 'g',    0x2e400000, 13, 'p'}, 
    { 'g',    0x2e480000, 16, ESCAPE}, 
    { 'g',    0x2e4e0000, 15, '/'}, 
    { 'g',    0x2e600000, 11, 'f'}, 
    { 'g',    0x2e800000,  9, 'b'}, 
    { 'g',    0x2f000000,  9, 't'}, 
    { 'g',    0x2f800000,  9, 'w'}, 
    { 'g',    0x30000000,  4, 'u'}, 
    { 'g',    0x40000000,  3, 'h'}, 
    { 'g',    0x60000000,  4, 'r'}, 
    { 'g',    0x70000000,  5, 'l'}, 
    { 'g',    0x78000000,  6, 'g'}, 
    { 'g',    0x7c000000,  6, '.'}, 
    { 'g',    0x80000000,  4, 'i'}, 
    { 'g',    0x90000000,  5, 's'}, 
    { 'g',    0x98000000,  5, 'o'}, 
    { 'g',    0xa0000000,  3, 'e'}, 
    { 'g',    0xc0000000,  2, ' '}, 
    { 'h',    0x00000000,  1, 'e'}, 
    { 'h',    0x80000000,  3, 'o'}, 
    { 'h',    0xa0000000,  3, 'i'}, 
    { 'h',    0xc0000000,  3, ' '}, 
    { 'h',    0xe0000000,  9, 'd'}, 
    { 'h',    0xe0880000, 15, 'p'}, 
    { 'h',    0xe08a0000, 15, ';'}, 
    { 'h',    0xe08c0000, 15, '/'}, 
    { 'h',    0xe0900000, 12, 'c'}, 
    { 'h',    0xe0a00000, 13, 'h'}, 
    { 'h',    0xe0a80000, 13, 'k'}, 
    { 'h',    0xe0b00000, 12, '?'}, 
    { 'h',    0xe0c00000, 10, 'w'}, 
    { 'h',    0xe1000000,  8, 'y'}, 
    { 'h',    0xe2000000,  9, 's'}, 
    { 'h',    0xe2800000, 10, '\''}, 
    { 'h',    0xe2c00000, 10, '-'}, 
    { 'h',    0xe3000000,  8, 'l'}, 
    { 'h',    0xe4000000,  6, 'r'}, 
    { 'h',    0xe8000000,  8, '.'}, 
    { 'h',    0xe9000000,  8, 'n'}, 
    { 'h',    0xea000000,  9, ','}, 
    { 'h',    0xea800000, 12, '!'}, 
    { 'h',    0xea910000, 17, ESCAPE}, 
    { 'h',    0xea940000, 14, 'g'}, 
    { 'h',    0xea980000, 13, 'f'}, 
    { 'h',    0xeaa00000, 11, 'm'}, 
    { 'h',    0xeac00000, 11, ':'}, 
    { 'h',    0xeae00000, 11, 'b'}, 
    { 'h',    0xeb000000,  8, 'u'}, 
    { 'h',    0xec000000,  6, 't'}, 
    { 'h',    0xf0000000,  4, 'a'}, 
    { 'i',    0x00000000,  3, 't'}, 
    { 'i',    0x20000000,  5, 'a'}, 
    { 'i',    0x28000000,  6, 'p'}, 
    { 'i',    0x2c000000,  7, 'z'}, 
    { 'i',    0x2e000000,  9, '-'}, 
    { 'i',    0x2e800000,  9, 'x'}, 
    { 'i',    0x2f000000,  8, 'b'}, 
    { 'i',    0x30000000,  4, 'l'}, 
    { 'i',    0x40000000,  3, 's'}, 
    { 'i',    0x60000000,  5, 'm'}, 
    { 'i',    0x68000000,  5, 'd'}, 
    { 'i',    0x70000000,  5, 'v'}, 
    { 'i',    0x78000000,  6, 'f'}, 
    { 'i',    0x7c000000,  7, ' '}, 
    { 'i',    0x7e000000,  8, 'k'}, 
    { 'i',    0x7f000000, 10, 'u'}, 
    { 'i',    0x7f400000, 11, '.'}, 
    { 'i',    0x7f600000, 15, '/'}, 
    { 'i',    0x7f622000, 19, 'C'}, 
    { 'i',    0x7f624000, 19, ESCAPE}, 
    { 'i',    0x7f627000, 20, ';'}, 
    { 'i',    0x7f640000, 14, ':'}, 
    { 'i',    0x7f680000, 13, 'i'}, 
    { 'i',    0x7f700000, 12, 'w'}, 
    { 'i',    0x7f800000, 10, 'q'}, 
    { 'i',    0x7fc00000, 11, ','}, 
    { 'i',    0x7fe00000, 14, 'h'}, 
    { 'i',    0x7fe50000, 18, ')'}, 
    { 'i',    0x7fe80000, 13, 'j'}, 
    { 'i',    0x7ff00000, 12, '\''}, 
    { 'i',    0x80000000,  2, 'n'}, 
    { 'i',    0xc0000000,  4, 'o'}, 
    { 'i',    0xd0000000,  4, 'c'}, 
    { 'i',    0xe0000000,  5, 'g'}, 
    { 'i',    0xe8000000,  5, 'r'}, 
    { 'i',    0xf0000000,  4, 'e'}, 
    { 'j',    0x00000000,  1, 'o'}, 
    { 'j',    0x80000000,  5, 'i'}, 
    { 'j',    0x88800000, 11, 'n'}, 
    { 'j',    0x88a00000, 13, ESCAPE}, 
    { 'j',    0x8a000000,  7, ' '}, 
    { 'j',    0x90000000,  4, 'e'}, 
    { 'j',    0xa0000000,  3, 'a'}, 
    { 'j',    0xc0000000,  2, 'u'}, 
    { 'k',    0x00000000,  3, 's'}, 
    { 'k',    0x20000000,  4, '.'}, 
    { 'k',    0x30000000,  6, '\''}, 
    { 'k',    0x34000000,  6, 'a'}, 
    { 'k',    0x38000000,  6, 'p'}, 
    { 'k',    0x3c000000,  6, ','}, 
    { 'k',    0x40000000,  7, '/'}, 
    { 'k',    0x42000000, 10, 'r'}, 
    { 'k',    0x42800000, 10, '?'}, 
    { 'k',    0x42c00000, 11, 'j'}, 
    { 'k',    0x42e00000, 12, ')'}, 
    { 'k',    0x43000000, 10, 't'}, 
    { 'k',    0x43400000, 10, 'g'}, 
    { 'k',    0x43800000,  9, 'b'}, 
    { 'k',    0x44000000,  7, '-'}, 
    { 'k',    0x46000000,  7, 'o'}, 
    { 'k',    0x48000000,  5, 'y'}, 
    { 'k',    0x50000000,  6, 'l'}, 
    { 'k',    0x54000000,  6, 'f'}, 
    { 'k',    0x58000000,  6, 'n'}, 
    { 'k',    0x5c000000,  9, 'w'}, 
    { 'k',    0x5c800000,  9, 'm'}, 
    { 'k',    0x5d000000,  8, ':'}, 
    { 'k',    0x5e000000,  9, 'h'}, 
    { 'k',    0x5e800000, 12, ';'}, 
    { 'k',    0x5e900000, 12, 'c'}, 
    { 'k',    0x5eb00000, 13, '!'}, 
    { 'k',    0x5ec00000, 10, 'd'}, 
    { 'k',    0x5f000000,  9, 'u'}, 
    { 'k',    0x5f800000,  9, 'k'}, 
    { 'k',    0x60000000,  3, 'i'}, 
    { 'k',    0x80000000,  2, ' '}, 
    { 'k',    0xc0000000,  2, 'e'}, 
    { 'l',    0x00000000,  4, 'u'}, 
    { 'l',    0x10000000,  4, 'd'}, 
    { 'l',    0x20000000,  4, 'y'}, 
    { 'l',    0x30000000,  6, '.'}, 
    { 'l',    0x34000000,  7, 'v'}, 
    { 'l',    0x36000000, 10, 'r'}, 
    { 'l',    0x36400000, 10, 'h'}, 
    { 'l',    0x36800000,  9, ':'}, 
    { 'l',    0x37000000,  8, 'c'}, 
    { 'l',    0x38000000,  6, 't'}, 
    { 'l',    0x3c000000,  7, 'f'}, 
    { 'l',    0x3e000000,  8, '-'}, 
    { 'l',    0x3f000000, 10, 'n'}, 
    { 'l',    0x3f400000, 10, 'g'}, 
    { 'l',    0x3f800000,  9, 'b'}, 
    { 'l',    0x40000000,  3, 'a'}, 
    { 'l',    0x60000000,  3, 'i'}, 
    { 'l',    0x80000000,  3, 'l'}, 
    { 'l',    0xa0000000,  5, 's'}, 
    { 'l',    0xa8000000,  7, 'm'}, 
    { 'l',    0xaa000000,  7, 'k'}, 
    { 'l',    0xac000000,  7, 'p'}, 
    { 'l',    0xae000000,  9, '\''}, 
    { 'l',    0xae800000, 11, '?'}, 
    { 'l',    0xaea80000, 15, ';'}, 
    { 'l',    0xaeaa0000, 17, '@'}, 
    { 'l',    0xaeaa8000, 17, 'j'}, 
    { 'l',    0xaeab0000, 16, ESCAPE}, 
    { 'l',    0xaeac0000, 14, '/'}, 
    { 'l',    0xaeb00000, 13, 'z'}, 
    { 'l',    0xaeb80000, 15, 'E'}, 
    { 'l',    0xaebc0000, 16, ')'}, 
    { 'l',    0xaec00000, 10, 'w'}, 
    { 'l',    0xaf000000,  8, ','}, 
    { 'l',    0xb0000000,  4, 'o'}, 
    { 'l',    0xc0000000,  3, 'e'}, 
    { 'l',    0xe0000000,  3, ' '}, 
    { 'm',    0x00000000,  2, 'a'}, 
    { 'm',    0x40000000,  2, 'e'}, 
    { 'm',    0x80000000,  5, '.'}, 
    { 'm',    0x88000000,  5, 's'}, 
    { 'm',    0x90000000,  4, 'p'}, 
    { 'm',    0xa0000000,  7, ','}, 
    { 'm',    0xa3000000,  9, ':'}, 
    { 'm',    0xa3800000, 11, '?'}, 
    { 'm',    0xa3a00000, 11, '!'}, 
    { 'm',    0xa3c00000, 10, 'r'}, 
    { 'm',    0xa4000000,  6, 'y'}, 
    { 'm',    0xa8000000,  7, '/'}, 
    { 'm',    0xaa000000,  9, '\''}, 
    { 'm',    0xaa800200, 23, STOP}, 
    { 'm',    0xaaa00000, 11, 'w'}, 
    { 'm',    0xaac00000, 10, 'f'}, 
    { 'm',    0xab000000, 10, 'l'}, 
    { 'm',    0xab400000, 14, ')'}, 
    { 'm',    0xab440000, 14, ESCAPE}, 
    { 'm',    0xab490000, 17, 'k'}, 
    { 'm',    0xab498000, 17, 'z'}, 
    { 'm',    0xab4c0000, 14, 'd'}, 
    { 'm',    0xab500000, 13, 't'}, 
    { 'm',    0xab600000, 11, 'h'}, 
    { 'm',    0xab800000, 10, 'n'}, 
    { 'm',    0xabc00000, 11, '-'}, 
    { 'm',    0xabf00000, 13, ';'}, 
    { 'm',    0xabf80000, 13, 'c'}, 
    { 'm',    0xac000000,  6, 'b'}, 
    { 'm',    0xb0000000,  4, 'o'}, 
    { 'm',    0xc0000000,  4, 'i'}, 
    { 'm',    0xd0000000,  5, 'u'}, 
    { 'm',    0xd8000000,  5, 'm'}, 
    { 'm',    0xe0000000,  3, ' '}, 
    { 'n',    0x00000000,  4, 's'}, 
    { 'n',    0x10000000,  8, 'm'}, 
    { 'n',    0x11000000, 11, 'p'}, 
    { 'n',    0x11200000, 13, '/'}, 
    { 'n',    0x11300000, 12, ';'}, 
    { 'n',    0x11400000, 10, 'z'}, 
    { 'n',    0x11800000,  9, 'w'}, 
    { 'n',    0x12000000,  7, 'u'}, 
    { 'n',    0x14000000,  8, 'l'}, 
    { 'n',    0x15000000,  8, '-'}, 
    { 'n',    0x16000000,  7, 'v'}, 
    { 'n',    0x18000000,  7, 'f'}, 
    { 'n',    0x1a000000, 10, 'h'}, 
    { 'n',    0x1a400000, 13, ESCAPE}, 
    { 'n',    0x1a480000, 14, 'B'}, 
    { 'n',    0x1a500000, 12, ')'}, 
    { 'n',    0x1a600000, 11, 'x'}, 
    { 'n',    0x1a800000,  9, ':'}, 
    { 'n',    0x1b000000, 10, 'b'}, 
    { 'n',    0x1b400000, 10, 'j'}, 
    { 'n',    0x1b800000, 10, 'r'}, 
    { 'n',    0x1bc00000, 12, '!'}, 
    { 'n',    0x1bd00000, 12, 'q'}, 
    { 'n',    0x1be00000, 11, '?'}, 
    { 'n',    0x1c000000,  6, '.'}, 
    { 'n',    0x20000000,  3, 't'}, 
    { 'n',    0x40000000,  2, ' '}, 
    { 'n',    0x80000000,  3, 'g'}, 
    { 'n',    0xa0000000,  4, 'a'}, 
    { 'n',    0xb0000000,  5, 'c'}, 
    { 'n',    0xb8000000,  7, 'k'}, 
    { 'n',    0xba000000,  7, '\''}, 
    { 'n',    0xbc000000,  6, 'n'}, 
    { 'n',    0xc0000000,  5, 'i'}, 
    { 'n',    0xc8000000,  7, 'y'}, 
    { 'n',    0xca000000,  7, ','}, 
    { 'n',    0xcc000000,  6, 'o'}, 
    { 'n',    0xd0000000,  4, 'e'}, 
    { 'n',    0xe0000000,  3, 'd'}, 
    { 'o',    0x00000000,  4, 'l'}, 
    { 'o',    0x10000000,  5, 'v'}, 
    { 'o',    0x18000000,  6, 'k'}, 
    { 'o',    0x1c000000,  6, 'i'}, 
    { 'o',    0x20000000,  3, 'u'}, 
    { 'o',    0x40000000,  5, 's'}, 
    { 'o',    0x48000000,  5, 'p'}, 
    { 'o',    0x50000000,  6, 'g'}, 
    { 'o',    0x54000000,  9, '-'}, 
    { 'o',    0x54800000,  9, ','}, 
    { 'o',    0x55000000,  8, 'h'}, 
    { 'o',    0x56000000,  7, 'e'}, 
    { 'o',    0x58000000,  7, 'y'}, 
    { 'o',    0x5a000000,  7, 'a'}, 
    { 'o',    0x5c000000,  6, 'c'}, 
    { 'o',    0x60000000,  3, ' '}, 
    { 'o',    0x80000000,  3, 'r'}, 
    { 'o',    0xa0000000,  5, 't'}, 
    { 'o',    0xa8000000,  5, 'o'}, 
    { 'o',    0xb0000000,  8, '.'}, 
    { 'o',    0xb1000000, 13, '!'}, 
    { 'o',    0xb10d0000, 16, ';'}, 
    { 'o',    0xb10e0000, 16, 'G'}, 
    { 'o',    0xb10ff000, 20, 'C'}, 
    { 'o',    0xb1100000, 12, '?'}, 
    { 'o',    0xb1200000, 11, ':'}, 
    { 'o',    0xb1400000, 10, '\''}, 
    { 'o',    0xb1800000, 14, '/'}, 
    { 'o',    0xb1840000, 14, ')'}, 
    { 'o',    0xb1880000, 13, 'q'}, 
    { 'o',    0xb1900000, 12, 'j'}, 
    { 'o',    0xb1a00000, 11, 'z'}, 
    { 'o',    0xb1c00000, 10, 'x'}, 
    { 'o',    0xb2000000,  7, 'b'}, 
    { 'o',    0xb4000000,  6, 'd'}, 
    { 'o',    0xb8000000,  5, 'w'}, 
    { 'o',    0xc0000000,  4, 'm'}, 
    { 'o',    0xd0000000,  4, 'f'}, 
    { 'o',    0xe0000000,  3, 'n'}, 
    { 'p',    0x00000000,  4, 'p'}, 
    { 'p',    0x10000000,  8, '-'}, 
    { 'p',    0x11200000, 11, 'f'}, 
    { 'p',    0x11400000, 11, 'k'}, 
    { 'p',    0x11600000, 11, '!'}, 
    { 'p',    0x11800000,  9, '?'}, 
    { 'p',    0x12000000,  7, 'd'}, 
    { 'p',    0x14000000,  6, 'm'}, 
    { 'p',    0x18000000,  5, 't'}, 
    { 'p',    0x20000000,  3, 'l'}, 
    { 'p',    0x40000000,  3, ' '}, 
    { 'p',    0x60000000,  3, 'o'}, 
    { 'p',    0x80000000,  5, 'u'}, 
    { 'p',    0x88000000,  5, 'h'}, 
    { 'p',    0x90000000,  5, 's'}, 
    { 'p',    0x98000000, 17, ESCAPE}, 
    { 'p',    0x98080000, 13, 'g'}, 
    { 'p',    0x98100000, 12, '/'}, 
    { 'p',    0x98200000, 11, 'c'}, 
    { 'p',    0x98400000, 11, 'n'}, 
    { 'p',    0x98600000, 11, 'w'}, 
    { 'p',    0x98800000,  9, ':'}, 
    { 'p',    0x99000000, 10, '\''}, 
    { 'p',    0x99c00000, 10, 'b'}, 
    { 'p',    0x9a000000,  7, 'y'}, 
    { 'p',    0x9c000000,  7, '.'}, 
    { 'p',    0x9e000000,  7, ','}, 
    { 'p',    0xa0000000,  3, 'r'}, 
    { 'p',    0xc0000000,  4, 'a'}, 
    { 'p',    0xd0000000,  4, 'i'}, 
    { 'p',    0xe0000000,  3, 'e'}, 
    { 'q',    0x00000000,  3, ','}, 
    { 'q',    0x20000000,  3, '.'}, 
    { 'q',    0x44000000,  6, 'a'}, 
    { 'q',    0x60000000,  3, ' '}, 
    { 'q',    0x80000000,  1, 'u'}, 
    { 'r',    0x00000000,  3, 'a'}, 
    { 'r',    0x20000000,  3, 'o'}, 
    { 'r',    0x40000000,  4, 's'}, 
    { 'r',    0x50000000,  4, 't'}, 
    { 'r',    0x60000000,  7, 'f'}, 
    { 'r',    0x62018000, 17, 'Z'}, 
    { 'r',    0x62040000, 16, 'x'}, 
    { 'r',    0x62050000, 16, ESCAPE}, 
    { 'r',    0x62080000, 13, ';'}, 
    { 'r',    0x62100000, 12, 'q'}, 
    { 'r',    0x62200000, 12, 'j'}, 
    { 'r',    0x62400000, 11, '!'}, 
    { 'r',    0x62600000, 12, '/'}, 
    { 'r',    0x62740000, 14, 'z'}, 
    { 'r',    0x62780000, 13, ')'}, 
    { 'r',    0x62800000,  9, ':'}, 
    { 'r',    0x63000000,  8, '\''}, 
    { 'r',    0x64000000,  7, ','}, 
    { 'r',    0x66000000,  7, 'v'}, 
    { 'r',    0x68000000,  6, 'u'}, 
    { 'r',    0x6c000000,  6, 'm'}, 
    { 'r',    0x70000000,  5, 'd'}, 
    { 'r',    0x78000000,  8, '-'}, 
    { 'r',    0x79000000,  8, 'b'}, 
    { 'r',    0x7a000000,  9, 'w'}, 
    { 'r',    0x7a800000, 10, '?'}, 
    { 'r',    0x7ac00000, 10, 'h'}, 
    { 'r',    0x7b000000,  8, 'p'}, 
    { 'r',    0x7c000000,  6, 'k'}, 
    { 'r',    0x80000000,  3, 'i'}, 
    { 'r',    0xa0000000,  5, 'n'}, 
    { 'r',    0xa8000000,  5, 'y'}, 
    { 'r',    0xb0000000,  7, 'c'}, 
    { 'r',    0xb2000000,  7, 'g'}, 
    { 'r',    0xb4000000,  6, 'l'}, 
    { 'r',    0xb8000000,  6, '.'}, 
    { 'r',    0xbc000000,  6, 'r'}, 
    { 'r',    0xc0000000,  3, ' '}, 
    { 'r',    0xe0000000,  3, 'e'}, 
    { 's',    0x00000000,  1, ' '}, 
    { 's',    0x80000000,  4, '.'}, 
    { 's',    0x90000000, 10, '!'}, 
    { 's',    0x90400000, 10, 'g'}, 
    { 's',    0x90800000,  9, 'b'}, 
    { 's',    0x91000000,  8, 'n'}, 
    { 's',    0x92000000,  9, 'f'}, 
    { 's',    0x92800000, 10, 'r'}, 
    { 's',    0x92c00000, 12, '/'}, 
    { 's',    0x92d00000, 12, ')'}, 
    { 's',    0x92e20000, 15, '"'}, 
    { 's',    0x92e58000, 17, '@'}, 
    { 's',    0x92e60000, 15, 'z'}, 
    { 's',    0x92e80000, 13, 'v'}, 
    { 's',    0x92f00000, 12, STOP}, 
    { 's',    0x93000000,  8, 'm'}, 
    { 's',    0x94000000,  6, 'c'}, 
    { 's',    0x98000000,  5, ','}, 
    { 's',    0xa0000000,  3, 't'}, 
    { 's',    0xc0000000,  5, 'o'}, 
    { 's',    0xc8000000,  5, 's'}, 
    { 's',    0xd0000000,  6, 'u'}, 
    { 's',    0xd4000000,  8, 'y'}, 
    { 's',    0xd5000000,  9, 'w'}, 
    { 's',    0xd5800000, 10, '?'}, 
    { 's',    0xd5c00000, 10, '-'}, 
    { 's',    0xd6000000,  8, ':'}, 
    { 's',    0xd7000000, 12, ']'}, 
    { 's',    0xd7100000, 12, ';'}, 
    { 's',    0xd7200000, 11, 'd'}, 
    { 's',    0xd7400000, 10, 'q'}, 
    { 's',    0xd7800000,  9, '\''}, 
    { 's',    0xd8000000,  6, 'p'}, 
    { 's',    0xdc000000,  8, 'l'}, 
    { 's',    0xdd000000,  8, 'k'}, 
    { 's',    0xde000000,  7, 'a'}, 
    { 's',    0xe0000000,  4, 'e'}, 
    { 's',    0xf0000000,  5, 'h'}, 
    { 's',    0xf8000000,  5, 'i'}, 
    { 't',    0x00000000,  3, 'i'}, 
    { 't',    0x20000000,  4, 'a'}, 
    { 't',    0x30000000,  5, 'u'}, 
    { 't',    0x38000000,  9, 'n'}, 
    { 't',    0x38800000, 11, '!'}, 
    { 't',    0x38a00000, 13, 'g'}, 
    { 't',    0x38a80000, 13, ';'}, 
    { 't',    0x38b94000, 19, 'j'}, 
    { 't',    0x38ba0000, 16, 'E'}, 
    { 't',    0x38bc0000, 14, ')'}, 
    { 't',    0x38c00000, 10, '?'}, 
    { 't',    0x39000000,  8, '-'}, 
    { 't',    0x3a000000,  7, 'c'}, 
    { 't',    0x3c000000,  6, '.'}, 
    { 't',    0x40000000,  3, 'o'}, 
    { 't',    0x60000000,  3, 'e'}, 
    { 't',    0x80000000,  2, 'h'}, 
    { 't',    0xc0000000,  8, 'v'}, 
    { 't',    0xc1000000,  8, 'm'}, 
    { 't',    0xc2000000,  7, 'l'}, 
    { 't',    0xc4000000,  6, 't'}, 
    { 't',    0xc8000000,  5, 'r'}, 
    { 't',    0xd0000000,  6, 'y'}, 
    { 't',    0xd4000000, 11, 'z'}, 
    { 't',    0xd4300000, 13, 'p'}, 
    { 't',    0xd4380000, 14, '/'}, 
    { 't',    0xd43c0000, 14, 'k'}, 
    { 't',    0xd4400000, 10, 'b'}, 
    { 't',    0xd4800000, 10, ':'}, 
    { 't',    0xd4c00000, 11, 'd'}, 
    { 't',    0xd4e00000, 11, 'f'}, 
    { 't',    0xd5000000,  8, 'w'}, 
    { 't',    0xd6000000,  8, ','}, 
    { 't',    0xd7000000,  8, '\''}, 
    { 't',    0xd8000000,  5, 's'}, 
    { 't',    0xe0000000,  3, ' '}, 
    { 'u',    0x00000000,  5, 'b'}, 
    { 'u',    0x08000000,  5, ' '}, 
    { 'u',    0x10000000,  4, 'd'}, 
    { 'u',    0x20000000,  4, 'e'}, 
    { 'u',    0x30000000,  5, 'i'}, 
    { 'u',    0x38000000,  7, 'y'}, 
    { 'u',    0x3a000000,  8, 'z'}, 
    { 'u',    0x3b000000, 11, 'w'}, 
    { 'u',    0x3b200000, 12, 'q'}, 
    { 'u',    0x3b300000, 13, 'j'}, 
    { 'u',    0x3b380000, 15, 'u'}, 
    { 'u',    0x3b3a0000, 15, '?'}, 
    { 'u',    0x3b400000, 10, '-'}, 
    { 'u',    0x3b800000, 10, 'o'}, 
    { 'u',    0x3bc00000, 11, ':'}, 
    { 'u',    0x3be00000, 12, 'h'}, 
    { 'u',    0x3bf00000, 12, 'v'}, 
    { 'u',    0x3c000000,  8, '\''}, 
    { 'u',    0x3d000000,  9, ','}, 
    { 'u',    0x3d800000, 10, '.'}, 
    { 'u',    0x3dc00000, 10, 'x'}, 
    { 'u',    0x3e000000,  8, 'f'}, 
    { 'u',    0x3f000000,  8, 'k'}, 
    { 'u',    0x40000000,  5, 'a'}, 
    { 'u',    0x48000000,  5, 'g'}, 
    { 'u',    0x50000000,  4, 'l'}, 
    { 'u',    0x60000000,  3, 't'}, 
    { 'u',    0x80000000,  4, 'p'}, 
    { 'u',    0x90000000,  5, 'c'}, 
    { 'u',    0x98000000,  5, 'm'}, 
    { 'u',    0xa0000000,  3, 'n'}, 
    { 'u',    0xc0000000,  3, 's'}, 
    { 'u',    0xe0000000,  3, 'r'}, 
    { 'v',    0x00000000,  3, 'a'}, 
    { 'v',    0x20000000,  9, 'u'}, 
    { 'v',    0x20b00000, 12, 'v'}, 
    { 'v',    0x20c00000, 11, ','}, 
    { 'v',    0x20e40000, 15, 't'}, 
    { 'v',    0x20e78000, 18, ESCAPE}, 
    { 'v',    0x20f00000, 12, 'l'}, 
    { 'v',    0x21000000,  8, '\''}, 
    { 'v',    0x22000000,  9, 's'}, 
    { 'v',    0x22800000, 10, 'r'}, 
    { 'v',    0x22c00000, 11, 'n'}, 
    { 'v',    0x22e00000, 12, '@'}, 
    { 'v',    0x22f00000, 12, ':'}, 
    { 'v',    0x23000000,  8, 'y'}, 
    { 'v',    0x24000000,  6, ' '}, 
    { 'v',    0x28000000,  5, '.'}, 
    { 'v',    0x30000000,  4, 'o'}, 
    { 'v',    0x40000000,  2, 'i'}, 
    { 'v',    0x80000000,  1, 'e'}, 
    { 'w',    0x00000000,  2, 'i'}, 
    { 'w',    0x40000000,  5, '.'}, 
    { 'w',    0x50000000,  4, 'a'}, 
    { 'w',    0x60000000,  3, 'e'}, 
    { 'w',    0x80000000,  3, ' '}, 
    { 'w',    0xa0000000,  3, 's'}, 
    { 'w',    0xc0000000,  3, 'h'}, 
    { 'w',    0xe0000000,  5, 'n'}, 
    { 'w',    0xe8000000, 11, 'f'}, 
    { 'w',    0xe8200000, 11, ']'}, 
    { 'w',    0xe8400000, 11, '!'}, 
    { 'w',    0xe8680000, 13, 'u'}, 
    { 'w',    0xe8700000, 12, 'g'}, 
    { 'w',    0xe8800000, 10, ':'}, 
    { 'w',    0xe8c00000, 12, '?'}, 
    { 'w',    0xe8d00000, 12, 't'}, 
    { 'w',    0xe8e00000, 11, 'k'}, 
    { 'w',    0xe9000000,  9, 'c'}, 
    { 'w',    0xe9800000, 10, 'm'}, 
    { 'w',    0xe9c00000, 10, '\''}, 
    { 'w',    0xea000000,  8, ','}, 
    { 'w',    0xeb000000,  8, 'l'}, 
    { 'w',    0xec000000,  7, 'r'}, 
    { 'w',    0xee000000, 10, 'd'}, 
    { 'w',    0xee400000, 11, '-'}, 
    { 'w',    0xee640000, 14, 'j'}, 
    { 'w',    0xee800000,  9, 'b'}, 
    { 'w',    0xef000000,  8, 'y'}, 
    { 'w',    0xf0000000,  4, 'o'}, 
    { 'x',    0x00000000,  4, 'i'}, 
    { 'x',    0x10000000,  5, 'u'}, 
    { 'x',    0x18000000,  6, 'f'}, 
    { 'x',    0x1c000000,  7, ','}, 
    { 'x',    0x1e000000,  7, 'm'}, 
    { 'x',    0x20000000,  4, 'a'}, 
    { 'x',    0x30b00000, 12, '/'}, 
    { 'x',    0x30c00000, 10, '?'}, 
    { 'x',    0x32000000,  7, 'y'}, 
    { 'x',    0x34000000,  6, 'o'}, 
    { 'x',    0x38000000,  5, 'e'}, 
    { 'x',    0x40000000,  2, 'p'}, 
    { 'x',    0x80000000,  4, 'c'}, 
    { 'x',    0x90000000,  6, '.'}, 
    { 'x',    0x94000000,  9, ':'}, 
    { 'x',    0x94800000, 10, 'l'}, 
    { 'x',    0x94e00000, 11, 'b'}, 
    { 'x',    0x95000000,  8, '\''}, 
    { 'x',    0x97000000,  9, 'h'}, 
    { 'x',    0x97800000, 10, 'w'}, 
    { 'x',    0x97d80000, 13, ';'}, 
    { 'x',    0x97e00000, 11, ')'}, 
    { 'x',    0x98000000,  5, '-'}, 
    { 'x',    0xa0000000,  3, ' '}, 
    { 'x',    0xc0000000,  2, 't'}, 
    { 'y',    0x00000000,  3, 'o'}, 
    { 'y',    0x20000000,  7, 'w'}, 
    { 'y',    0x22000000, 11, ')'}, 
    { 'y',    0x222a0000, 15, 'x'}, 
    { 'y',    0x22300000, 12, 'k'}, 
    { 'y',    0x22400000, 10, ';'}, 
    { 'y',    0x22c00000, 12, ESCAPE}, 
    { 'y',    0x22e00000, 11, '/'}, 
    { 'y',    0x23000000,  8, 'b'}, 
    { 'y',    0x24000000,  6, 'a'}, 
    { 'y',    0x28000000,  6, 'i'}, 
    { 'y',    0x2c000000,  6, 'd'}, 
    { 'y',    0x30000000,  4, 's'}, 
    { 'y',    0x40000000,  8, '?'}, 
    { 'y',    0x41000000,  8, 'r'}, 
    { 'y',    0x42000000,  8, 'p'}, 
    { 'y',    0x43000000,  8, 'f'}, 
    { 'y',    0x44000000,  6, 'n'}, 
    { 'y',    0x48000000,  5, ','}, 
    { 'y',    0x50000000,  4, '.'}, 
    { 'y',    0x60000000,  5, 'e'}, 
    { 'y',    0x68000000,  7, 't'}, 
    { 'y',    0x6a000000,  7, 'm'}, 
    { 'y',    0x6c000000,  6, ':'}, 
    { 'y',    0x70000000,  5, '\''}, 
    { 'y',    0x78000000, 10, 'h'}, 
    { 'y',    0x78400000, 10, '!'}, 
    { 'y',    0x78810000, 16, 'T'}, 
    { 'y',    0x78830000, 16, 'P'}, 
    { 'y',    0x78880000, 13, '"'}, 
    { 'y',    0x78900000, 12, STOP}, 
    { 'y',    0x78a00000, 11, ']'}, 
    { 'y',    0x78c00000, 10, 'g'}, 
    { 'y',    0x79000000,  8, 'c'}, 
    { 'y',    0x7a000000,  7, '-'}, 
    { 'y',    0x7c000000,  6, 'l'}, 
    { 'y',    0x80000000,  1, ' '}, 
    { 'z',    0x04000000,  7, '\''}, 
    { 'z',    0x07000000,  8, 't'}, 
    { 'z',    0x08000000,  6, ','}, 
    { 'z',    0x0c000000,  6, '.'}, 
    { 'z',    0x10000000,  4, 'l'}, 
    { 'z',    0x20000000,  3, 'a'}, 
    { 'z',    0x40000000,  4, 'y'}, 
    { 'z',    0x50000000,  5, 'o'}, 
    { 'z',    0x5c800000, 11, 's'}, 
    { 'z',    0x5cc00000, 12, 'h'}, 
    { 'z',    0x5d000000,  8, 'm'}, 
    { 'z',    0x5e000000,  9, '-'}, 
    { 'z',    0x5e800000,  9, 'u'}, 
    { 'z',    0x5f100000, 14, 'q'}, 
    { 'z',    0x5f140000, 14, 'n'}, 
    { 'z',    0x5f180000, 13, 'v'}, 
    { 'z',    0x5f800000,  9, 'b'}, 
    { 'z',    0x60000000,  3, 'z'}, 
    { 'z',    0x80000000,  2, 'e'}, 
    { 'z',    0xc0000000,  3, ' '}, 
    { 'z',    0xe0000000,  3, 'i'}, 
    { '}',    0x0819c000, 18, STOP} 
}; 
