/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic morris
 *
 *   $Id: http.c,v 1.2 2003/11/18 23:04:59 dom Exp $
 *   $Date: 2003/11/18 23:04:59 $
 *
 *   Do things with http
 *
 */

#include "mediamvp.h"

static int         http_open_direct(char *host, int port, char *url);

/* Slightly crusty routine to open url */
int http_open(char *url)
{
    char    hostname[256];
    char   *ptr;
    char   *host;
    int     port = 80;
    char   *path;

    if ( strncmp(url,"http://",7) ) {
        return -1;
    }

    host = url + 7;

    if ( ( ptr = strchr(host,':') ) != NULL ) {
        *ptr = 0;   /* hostname now null terminated */
        strcpy(hostname,host);
        ptr++;
        port = atoi(ptr);
        path = strchr(ptr,'/');
    } else {
        port = 80;
        if ( ( ptr = strchr(url,'/') ) != NULL ) {
            strncpy(hostname,ptr,ptr - host);
        }
        path = ptr;
    }

    if ( path == NULL ) {
        path = "";
    } else {
        while ( (ptr = strchr(path,'\r')) || (ptr = strchr(path,'\n')) ) {
            *ptr = 0;
        }
    }
    
    return http_open_direct(hostname,port,path);
}

static int http_open_direct(char *host, int port, char *url)
{
    char     buf[256];
    int      sock;
    int      len;


    sock = tcp_connect(host,port);

    len = snprintf(buf,sizeof(buf),"GET %s HTTP/1.0\r\nHost: %s\r\nUser-agent: MediaMVP server\r\n\r\n",url,host);

    write(sock,buf,len);
   
    fcntl(sock,F_SETFL,O_NONBLOCK);

    return sock;
}
