/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: misc.c,v 1.5 2003/12/13 13:44:35 dom Exp $
 *   $Date: 2003/12/13 13:44:35 $
 *
 *
 *   Miscellaenous routines
 */


#include "libmvp_internal.h"
#include <stdarg.h>


void dump_hex(int level, unsigned char *buf, int len)
{
    int       i;

    if ( initparams.debug_level <= level ) {
        for ( i = 0; i < len; i++ ) {
            fprintf(initparams.logfile,"%02x",buf[i]);
            if ( i % 2 ) {
                fprintf(initparams.logfile," ");
            }
        }
        fprintf(initparams.logfile,"\n");
        fflush(initparams.logfile);
    }
}


void Dprintf(int level, char *fmt, ...)
{
   va_list             ap;

   va_start(ap,fmt);

   if ( initparams.debug_level <= level ) {
       vfprintf(initparams.logfile,fmt,ap);
       fflush(initparams.logfile);
   }

   va_end(ap);
}


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
