/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: mediamvp.h,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   Internal definitions
 */


#ifndef MEDIAMVP_H
#define MEDIAMVP_H

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/queue.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdint.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netdb.h>
#include <float.h>
#include <math.h>

#include <event.h>

#include "config.h"

/* Drag in some message types */
#include "msgs.h"

#include "keys.h"

#ifndef WIN32
enum { FALSE = 0, TRUE };
#endif



typedef struct _gui gui_t;
typedef struct _stream  stream_t;
typedef struct _render  render_t;
typedef unsigned char bool_t;


/* dongle.c */
typedef struct {
    char      address[30];      /* Should be more than enough */
    int       tvmode;
    int       flickermode;
    int       aspectratio;
    int       videooutput;      /* Sent by client?!? */
    char      inuse;
    gui_t    *gui;
    stream_t *stream;
} dongle_t;


/* Application */
extern void       gui_send_play(gui_t *gui, char *name);
extern void       gui_send_message(gui_t *gui, mvprfbmsg_t *msg);
extern void       gui_send_settings(gui_t *gui, int subcommand);


/* render.c */
extern void            render_set_fgcol(render_t *render, int red, int green, int blue);
extern void            render_set_bgcol(render_t *render, int red, int green, int blue);
extern void            render_printrow(render_t *render, int row, char *text);
extern void            render_clear(render_t *render);
extern void            render_printrow_width(render_t *render, int row, int x, int width,char *text);
extern int             render_get_maxrows(render_t *render);
extern int             render_get_depth(render_t *render);
extern int             render_get_width(render_t *render);
extern int             render_get_textspace(render_t *render, char *text);
extern int             render_get_xoffset(render_t *render);
extern int             render_get_yoffset(render_t *render);


/* stream.c */
#define MEDIA_MASK       3
#define MEDIA_MPEG       1
#define MEDIA_MP3        2
#define MEDIA_SOCKET   128


extern int        stream_get_type(stream_t *stream);
extern int        stream_get_lasttype(stream_t *stream);

/* udp.c */
extern int        udp_init();
extern void       udp_exit();


/* urlhandler.c  */
extern void       urlhandler_add(char *prefix,
                                 int      (*open)(char *name, int *type),
                                 int      (*close)(char *name, int fd),
                                 off_t    (*seek)(char *name, int fd, off_t offset, int whence));


/* Starting up and shutting down the server */
extern int        mediamvp_server_init(int stream_port, int gui_port, int dongleversion,
                                       int width, int depth, int guiwidth, int guidepth);
extern void       mediamvp_server_stop();


/* These function should be implemented by your application level */
extern void      *new_app(dongle_t *dongle, render_t *render, gui_t *gui);
extern void       delete_app(void *app);
extern void       app_keypress(void *app, int code);
extern void       app_ack(void *app, int ackcode, uint8_t *buf, int buflen);

#endif /* MEDIAMVP_H */
