/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: mvp.c,v 1.1.1.1 2003/12/04 00:10:13 dom Exp $
 *   $Date: 2003/12/04 00:10:13 $
 *
 *
 *   More wrapping up of the C code, this effectively a version of
 *   the main code.
 *
 */

#include "mvp_internal.h"


int        c_width          = RFB_WIDTH;
int        c_depth          = RFB_DEPTH;
int        c_totwidth       = RFB_WIDTH;
int        c_totdepth       = RFB_DEPTH;
int        c_gui_port       = 5906;
int        c_stream_port    = 6337;
int        dongle_version   = 21330;

int mediamvp_server_init(int stream_port, int gui_port, int dongle_version,
                         int width, int depth, int guiwidth, int guidepth)
{
    c_stream_port = stream_port;
    c_gui_port    = gui_port;
    dongle_version = dongle_version;
    c_totwidth = width;
    c_totdepth = depth;
    c_width = guiwidth;
    c_depth = guidepth;

    event_init();
    udp_init();
    gui_init();
    stream_init();
    urlhandler_init();

    return 0;
}


void mediamvp_server_stop()
{
    udp_exit();
    gui_exit();
    stream_exit();
    dongle_closeall();
}

