/*
 *   MediaMVP Server
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: main.c,v 1.3 2003/12/04 12:12:39 dom Exp $
 *   $Date: 2003/12/04 12:12:39 $
 *
 *
 *   Startup..
 */

#include "libmvp.h"

#include "app.h"
#include "libini.h"



static char       *c_interface;


static mvpinit_t   init = MVPINIT_INITIALISER;

int main(int argc, char *argv[])
{
    char hostbuf[2048];


    iniparse_init();

    iniparse_add("main:interface",OPT_STR,&c_interface);
    iniparse_add("main:dongleversion",OPT_INT,&init.dongle_version);
    iniparse_add("main:streamport",OPT_INT,&init.stream_port);
    iniparse_add("main:guiport",OPT_INT,&init.gui_port);
    iniparse_add("main:width",OPT_INT,&init.gui_width);
    iniparse_add("main:depth",OPT_INT,&init.gui_depth);
    iniparse_add("main:screenwidth",OPT_INT,&init.screen_width);
    iniparse_add("main:screendepth",OPT_INT,&init.screen_depth);
    iniparse_add("main:mpegbufsize",OPT_INT,&init.mpeg_bufsize);
    iniparse_add("main:mp3bufsize",OPT_INT,&init.mp3_bufsize);

    
    app_config();

    iniparse_file("mediamvp.conf");
    iniparse_cleanup();


    if ( c_interface == NULL ) {
        if ( gethostname(hostbuf,sizeof(hostbuf)-1) == -1 ) {
            perror("gethostbyname");
            exit(1);
        }
        c_interface = hostbuf;
    }

    if ( ( init.main_interfaceip = host_resolve(c_interface) ) == - 1 ) {
        fprintf(stderr,"Cannot resolve host <%s>\n",c_interface);
        exit(1);
    }

    event_init();

    app_init(&init);

    mediamvp_server_init(&init);

   
    event_dispatch();

    return 0;
}

    


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
