/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: libmvp.h,v 1.4 2003/12/04 21:03:37 dom Exp $
 *   $Date: 2003/12/04 21:03:37 $
 *
 *   This file contains all application accessible information
 */


#ifndef LIBMVP_H
#define LIBMVP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/queue.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdint.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <resolv.h>
#include <netdb.h>
#include <float.h>
#include <math.h>

#include <event.h>

#include "config.h"

/* Drag in some message types */
#include "msgs.h"

#include "keys.h"

#ifndef WIN32
enum { FALSE = 0, TRUE };
#endif



typedef struct _gui gui_t;
typedef struct _stream  stream_t;
typedef struct _render  render_t;
typedef unsigned char bool_t;


/* dongle.c - all we need to expose here is the settings really... */
typedef struct {
    char      address[30];      /* Should be more than enough */
    int       tvmode;
    int       flickermode;
    int       aspectratio;
    int       videooutput;      /* Sent by client?!? */
    char      inuse;
    gui_t    *gui;
    stream_t *stream;
} dongle_t;


/* Application */
extern void            dongle_send_play(dongle_t *dongle, char *name);
extern void            dongle_send_message(dongle_t *dongle, mvprfbmsg_t *msg);
extern void            dongle_send_settings(dongle_t *dongle, int subcommand);
extern int             dongle_get_type(dongle_t *dongle);
extern int             dongle_get_lasttype(dongle_t *dongle);

/* render.c */
extern void            render_set_fgcol(render_t *render, int red, int green, int blue);
extern void            render_set_bgcol(render_t *render, int red, int green, int blue);
extern void            render_printrow(render_t *render, int row, char *text);
extern void            render_clear(render_t *render);
extern void            render_printrow_width(render_t *render, int row, int x, int width,char *text);
extern int             render_get_maxrows(render_t *render);
extern int             render_get_depth(render_t *render);
extern int             render_get_width(render_t *render);
extern int             render_get_textspace(render_t *render, char *text);
extern int             render_get_xoffset(render_t *render);
extern int             render_get_yoffset(render_t *render);


/* stream.c */
#define MEDIA_MASK       3
#define MEDIA_MPEG       1
#define MEDIA_MP3        2
#define MEDIA_SOCKET   128






/* urlhandler.c  */
extern void       urlhandler_add(char *prefix,
                                 int      (*open)(char *name, int *type),
                                 int      (*close)(char *name, int fd),
                                 off_t    (*seek)(char *name, int fd, off_t offset, int whence));



/* Error warning levels */
enum { DEBUG = 0, INFO, ERROR };

/* Starting up and shutting down the server */
typedef struct {
    uint32_t main_interfaceip; 
    int      gui_port;
    int      stream_port;
    int      dongle_version;
    int      screen_width;
    int      screen_depth;
    int      gui_width;
    int      gui_depth;
    int      mpeg_bufsize;
    int      mp3_bufsize;
    int      debug_level;
    FILE    *logfile;
    void  *(*new_app)(dongle_t *dongle, render_t *render);
    void   (*delete_app)(void *param);
    void   (*app_keypress)(void *app, int keycode);
    void   (*app_handle_ack)(void *app, int ackcode, unsigned char *buf, int buflen);
} mvpinit_t;
#define MVPINIT_INITIALISER { -1, 5906, 6337, 21323, 720, 576, 640, 480, 200000, 4000, DEBUG  }

extern int        mediamvp_server_init(mvpinit_t *init);
extern void       mediamvp_server_stop();



#ifdef __cplusplus
}
#endif


#endif /* LIBMVP_H */
