/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: dongle.c,v 1.7 2004/01/14 20:40:24 dom Exp $
 *   $Date: 2004/01/14 20:40:24 $
 *
 *
 *   Dongle registration - maintains a list of dongles with their subcomponents 
 */


#include "libmvp_internal.h"


static int        dongles_num   = 0;
static dongle_t  *dongles       = NULL;



dongle_t *dongle_return(char *address)
{
    dongle_t  *dongle;
    int        i;
    int        first = -1;

    for ( i = 0; i < dongles_num; i++ ) {
        if ( strcmp(dongles[i].address,address) == 0 && dongles[i].inuse ) {
            return &dongles[i];
        }
        if ( dongles[i].inuse == FALSE ) {
            first = i;
        }
    }

    Dprintf(DEBUG,"Registering new dongle at IP %s\n",address);

    if ( first != -1 ) {
        dongle=&dongles[first];
    } else {
        i = dongles_num++;
        dongles = realloc(dongles,dongles_num * sizeof(dongle_t));
        dongle = &dongles[i];
    }


    strcpy(dongle->address,address);
    dongle->inuse = TRUE;
    dongle->gui = NULL;
    dongle->stream = NULL;

    /* Reset to defaults - we ask client for details of these settings */
    dongle->tvmode = 0;
    dongle->videooutput = 0;
    dongle->flickermode = 0;
    dongle->aspectratio = 0;

    return dongle;
}


void dongle_close(dongle_t *dongle)
{

    Dprintf(DEBUG,"Closing dongle at address %s\n",dongle->address);

    if ( dongle->gui ) {
        delete_gui(dongle->gui);
    }

    if ( dongle->stream ) {
        delete_stream(dongle->stream);
    }
    dongle->stream = NULL;
    dongle->gui    = NULL;
    /* Close gui/stream here */
    dongle->inuse = FALSE;
}

void dongle_closeall()
{
    int          i;

    for ( i = 0; i < dongles_num; i++ ) {
        dongle_close(&dongles[i]);
    }
}

void dongle_send_play(dongle_t *dongle, char *name)
{
    if ( dongle->gui ) {
        gui_send_play(dongle->gui,name);
    }
}


void dongle_send_message(dongle_t *dongle, int msgtype)
{
    if ( dongle->gui ) {
        gui_send_message(dongle->gui,msgtype);
    }
}

void dongle_send_settings(dongle_t *dongle, int subcommand)
{
    if ( dongle->gui ) {
        gui_send_settings(dongle->gui,subcommand);
    }
}

int dongle_get_type(dongle_t *dongle)
{
    if ( dongle->stream ) {
        return stream_get_type(dongle->stream);
    } else {
        return 0;
    }
}

int dongle_get_lasttype(dongle_t *dongle)
{
    if ( dongle->stream ) {
        return stream_get_lasttype(dongle->stream);
    } else {
        return 0;
    }
}


/*
 * Local Variables:
 *  indent-tabs-mode:nil
 *  require-final-newline:t
 *  c-basic-offset: 4
 * End:
 */
