/*
 *   MediaMVP Server Library
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: libmvp.h,v 1.11 2004/01/16 23:06:24 dom Exp $
 *   $Date: 2004/01/16 23:06:24 $
 *
 *   This file contains all application accessible information
 */


#ifndef LIBMVP_H
#define LIBMVP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/queue.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdint.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <resolv.h>
#include <netdb.h>
#include <float.h>
#include <math.h>
#include <ctype.h>

#include <event.h>

#include "config.h"

/* Drag in some message types */
#include "msgs.h"

#include "keys.h"

#ifndef WIN32
enum { FALSE = 0, TRUE };
#endif



typedef struct _gui gui_t;
typedef struct _stream  stream_t;
typedef struct _render  render_t;
typedef unsigned char bool_t;


/* dongle.c - all we need to expose here is the settings really... */
typedef struct {
    char      address[30];      /* Should be more than enough */
    int       tvmode;
    int       flickermode;
    int       aspectratio;
    int       videooutput;      /* Sent by client?!? */
    char      inuse;
    gui_t    *gui;
    stream_t *stream;
} dongle_t;


/* Application */
extern void            dongle_send_play(dongle_t *dongle, char *name);
extern void            dongle_send_message(dongle_t *dongle, int msgtype);
extern void            dongle_send_settings(dongle_t *dongle, int subcommand);
extern int             dongle_get_type(dongle_t *dongle);
extern int             dongle_get_lasttype(dongle_t *dongle);

/* render.c */
extern void            render_set_fgcol(render_t *render, int red, int green, int blue);
extern void            render_set_bgcol(render_t *render, int red, int green, int blue);
extern void            render_printrow(render_t *render, int row, char *text);
extern void            render_clear(render_t *render);
extern void            render_printrow_width(render_t *render, int row, int x, int width, char *text);
extern int             render_get_maxrows(render_t *render);
extern int             render_get_depth(render_t *render);
extern int             render_get_width(render_t *render);
extern int             render_get_textspace(render_t *render, char *text);
extern int             render_get_xoffset(render_t *render);
extern int             render_get_yoffset(render_t *render);


/* stream.c */
#define MEDIA_MASK       3
#define MEDIA_MPEG       1
#define MEDIA_MP3        2
#define MEDIA_LIVE      64
#define MEDIA_SOCKET   128






/* urlhandler.c  - fops has to passed through so that we can then call playlist_check on it and types get
 propogated about the place
*/
typedef struct _fops fops_t;
typedef void (*readready_cb)(void *);

struct _fops {
    char        *prefix;
    void      *(*open)(char *name, int *type, fops_t **fops_ptr, readready_cb cb, void *cb_ptr);
    void       (*close)(void *ptr);
    off_t      (*seek)(void *ptr, off_t offset, int whence);
    int        (*read)(void *ptr, unsigned char *buf, size_t buflen);
};

/* Nasty function to determine info about playlists - check playlist.c for param details */
extern int        playlist_check(char *incoming_name, int fd, void *urlptr, int *filetype, void **return_ptr,
                                  fops_t **fops_ptr,readready_cb cb,void *cb_ptr);

extern void       urlhandler_add(char *prefix, fops_t *fops);


/* Error warning levels */
enum { MOO = 0, DEBUG, INFO, ERROR };
extern void            Dprintf(int level, char *fmt,...);

/* Starting up and shutting down the server */
typedef struct {
    uint32_t main_interfaceip; 
    int      gui_port;
    int      stream_port;
    int      dongle_version;
    int      screen_width;
    int      screen_depth;
    int      gui_width;
    int      gui_depth;
    int      mpeg_bufsize;
    int      mp3_bufsize;
    int      debug_level;
    FILE    *logfile;
    void  *(*new_app)(dongle_t *dongle, render_t *render);
    void   (*delete_app)(void *param);
    void   (*app_keypress)(void *app, int keycode);
    void   (*app_handle_ack)(void *app, int ackcode, unsigned char *buf, int buflen);
} mvpinit_t;
#define MVPINIT_INITIALISER { -1, 5906, 6337, 21323, 720, 576, 640, 480, 200000, 4000, DEBUG  }

extern int        mediamvp_server_init(mvpinit_t *init);
extern void       mediamvp_server_stop();


/* Some quite dirty media detection routines, buf should be at least 4 bytes long  */
extern int        file_get_type(char *filename);
extern int        file_get_type_fd(int fd, unsigned char *buf);
#ifdef __cplusplus
}
#endif


#endif /* LIBMVP_H */
