/*
 *   Small .ini file reader for z88dk/anything
 *
 *   Will parse those Windows style files, with basic functionality -
 *   handles booleans, ints and strings
 *
 *   (C) D.J.Morris <dom@jadara.org.uk> 7/8/2001
 *
 */

#ifndef __LIBINI_H__

    
/* Available option types */
#define OPT_INT         0
#define OPT_STR                1
#define OPT_BOOL        2


/* Call this first to initialise the structures */
extern int          iniparse_init();

/* Add an option with this, type is one of the following */
#define OPT_INT         0
#define OPT_STR                1
#define OPT_BOOL        2
#define OPT_ARRAY       64
extern int          iniparse_add(char sopt, char *key, char *desc, unsigned char type, void *ptr);
extern int          iniparse_add_array(char sopt, char *key, char *desc, unsigned char type, void *ptr, int *num_ptr);





/* Call this to parse the file and fill in the options */
extern int          iniparse(char *filename, int argc, char *argv[]);
extern int          iniparse_args(int argc, char *argv[]);
extern int          iniparse_file(char *filename);

/* When you've got all your options, call this to cleanup afterwards */
extern void         iniparse_cleanup();

extern void         iniparse_help();


#endif /* __LIBINI_H_ */
