/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: vdrrecurl.h,v 1.4 2004/07/11 16:13:38 dom Exp $
 *   $Date: 2004/07/11 16:13:38 $
 *
 *
 *   Handle the vdr:// URL type
 */


#ifndef VDRRECURL_H
#define VDRRECURL_H

class cMediamvpVdrRecURL  {
private:
    int                   fd; /* Current file being read */
    int                   curfile; /* Current file */
    char                 *name;
    size_t                offset;
    char                  filename[FILENAME_MAX+1];  /* Directory where file is */
    unsigned char                  tmp[100];
    size_t                   tmplen;
    void OpenFile();

public:
    cMediamvpVdrRecURL();
    ~cMediamvpVdrRecURL();
    static void Init();
    static void *sOpen(char *name, int *type, fops_t **fops, readready_cb cb, void *cb_ptr);
    static off_t sSeek(void *ptr, off_t offset, int whence);
    static void sClose(void *ptr);
    static int sRead(void *ptr, unsigned char *buf, size_t buflen);
    static int sInfo(void *ptr, int cmd, void *args);
    int GopSeek(gopseek_t *gop);
    off_t Seek(off_t offset, int whence);
    size_t Read(unsigned char *buf, size_t buflen);
    off_t CurrentOffset();

};

#endif
