/*
 *   MediaMVP Server Image Library
 *
 *   (C) 2004 Dominic Morris
 *
 *   $Id: libmvpimage.h,v 1.3 2005/03/31 10:45:58 dom Exp $
 *   $Date: 2005/03/31 10:45:58 $
 *
 *   Image display library - minimal at the moment
 */


#ifndef LIBMVPIMG_H
#define LIBMVPIMG_H

#ifdef __cplusplus
extern "C" {
#endif


#ifdef HAVE_LIBJPEG
extern int             mvp_jpeg_display(surface_t *surface,char *filename, 
                                        int x0, int y0, int width, int depth);
#endif

#ifdef HAVE_MAGICK
/* Image stuff */
typedef enum
{
        SHRINK,
        SCALE_DOWN,
        EXPAND,
        SCALE_UP,
} mvp_scale_method_t;

extern int        mvp_buffer_display(surface_t *surface, void *buffer, size_t buffer_len, int x0, int y0, int width, int depth, int rotate, mvp_scale_method_t stype);
extern int        mvp_image_display(surface_t *surface, char *filename, int x0, int y0, int width, int depth, int rotate, mvp_scale_method_t stype);
#endif

#ifdef __cplusplus
}
#endif


#endif /* LIBMVP_H */
