/*
 *   MediaMVP Plugin
 *
 *   (C) 2003 Dominic Morris
 *
 *   $Id: misc.c,v 1.5 2005/03/31 10:45:57 dom Exp $
 *   $Date: 2005/03/31 10:45:57 $
 *
 *   Misc stuff, stolen from streamdev
 */



/* Media mvp receiver */


#include "misc.h"



cChannel *ChannelFromString(char *String) 
{
    cChannel *channel = NULL;

    if (isnumber(String)) {
        int temp = strtol(String, NULL, 10);
        if (temp >= 1 && temp <= Channels.MaxNumber())
            channel = Channels.GetByNumber(temp);
    } else {
        channel = Channels.GetByChannelID(tChannelID::FromString(String));

        if (channel == NULL) {
            int i  = 1;
            while ((channel = Channels.GetByNumber(i, 1)) != NULL) {
                if (String == channel->Name())
                    break;

                i = channel->Number() + 1;
            }
        }
    }
    return channel;
}

/** \brief Find the textual representation of the next channel
 *
 *  \param String textual name of the current direction
 *  \param direction Which direction to remove in
 *
 *  \param Returns a string representation of the next channel, or NULL if not available
 */
char *ChannelSkip(char *String, int direction)
{
    cChannel *channel = NULL;

    if ( (channel = ChannelFromString(String) ) != NULL ) {
        do {
            if ( direction > 0 ) {
                channel = Channels.Next(channel);
            } else {
                channel = Channels.Prev(channel);
            }
        } while (channel != NULL &&  channel->GroupSep() );
    }

    if ( channel != NULL ) {
        return strdup(channel->GetChannelID().ToString());
    }
    return NULL;
}
