#define _FILE_OFFSET_BITS 64
#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <math.h>
#include <time.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sys/user.h>
#include <sys/poll.h>


#include "device.h"
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/ioctl.h>

extern "C" {
#include "videodev.h"
#include "videodev2.h"

#include "ivtv-ext-api.h"
}


cPvr350Device::cPvr350Device(void)
{

    fd_out = open("/dev/video16", O_WRONLY); // |O_NONBLOCK);
    int fd2 = open("/tmp/video16", O_WRONLY|O_CREAT|O_TRUNC); // |O_NONBLOCK);

    if ( fd_out < 0 ) {
        printf("Can't open device\n");
    }
    int fbno;
    char  fbdev[FILENAME_MAX+1];
    if (ioctl(fd_out, IVTV_IOC_GET_FB, &fbno) < 0) {
        perror("IVTV_IOC_GET_FB");
        return ;
    }
    
    if (fbno < 0) {
        printf("invalid fb, are you using the ivtv-fb module?\n");
        return ;
    }

    snprintf(fbdev,sizeof(fbdev),"/dev/fb%d",fbno);
    if ( (fbfd = open(fbdev,O_RDWR)) > 0 ) {

        struct ivtvfb_ioctl_state_info fbstate;
        memset(&fbstate, 0, sizeof(fbstate));

        if (ioctl(fbfd, IVTVFB_IOCTL_GET_STATE, &fbstate) < 0) {
            perror("IVTVFB_IOCTL_GET_STATE");
            return;
        }

        initglobalalpha = fbstate.status;
        storedglobalalpha = fbstate.alpha;

        fbstate.status &= ~IVTVFB_STATUS_GLOBAL_ALPHA;
        fbstate.status |= IVTVFB_STATUS_LOCAL_ALPHA;
        fbstate.alpha = 0;

        if (ioctl(fbfd, IVTVFB_IOCTL_SET_STATE, &fbstate) < 0) {
            perror("IVTVFB_IOCTL_SET_STATE");
            return ;
        }

        struct ivtvfb_ioctl_get_frame_buffer igfb;
        memset(&igfb, 0, sizeof(igfb));

        ioctl(fbfd, IVTVFB_IOCTL_GET_FRAME_BUFFER, &igfb);

        osdbufsize = igfb.size;
        stride = igfb.sizex * 4;
        printf("sizex %d sizey %d size %d\n",igfb.sizex,igfb.sizey,igfb.size);
        printf("Size %d %d\n",stride,osdbufsize + PAGE_SIZE);

        osdbuffer = new unsigned char[osdbufsize + PAGE_SIZE];
        osdbuf_aligned = (unsigned char *)((int)osdbuffer + (PAGE_SIZE - 1));
        osdbuf_aligned = (unsigned char *)((int)osdbuf_aligned & PAGE_MASK);

        memset(osdbuf_aligned, 0x00, osdbufsize);
#if 1
        struct ivtv_osd_coords osdcoords;
        memset(&osdcoords, 0, sizeof(osdcoords));
        ioctl(fbfd, IVTVFB_IOCTL_GET_ACTIVE_BUFFER, &osdcoords);

        struct ivtvfb_ioctl_dma_host_to_ivtv_args prep;
        memset(&prep, 0, sizeof(prep));

        prep.source = osdbuf_aligned;
        prep.dest_offset = 0;
        prep.count = osdcoords.max_offset;

        memset(osdbuf_aligned, 0x00, osdbufsize);

        ioctl(fbfd, IVTVFB_IOCTL_PREP_FRAME, &prep);
        printf("Offset %d max %d stride %d lines %d x %d y %d\n",osdcoords.offset,osdcoords.max_offset,
               osdcoords.pixel_stride,osdcoords.lines,osdcoords.x,osdcoords.y);

 
        osdcoords.lines = 576;
        osdcoords.offset = 0;
        osdcoords.pixel_stride = 720 * 2;

        ioctl(fbfd, IVTVFB_IOCTL_SET_ACTIVE_BUFFER, &osdcoords);
#endif

    } else {
        printf("Can't open framebuffer..\n");
    }

    decoder = new cMpeg2Decoder(fd_out);

    struct v4l2_control ctrl;
    int ret;
    memset(&ctrl, 0, sizeof(ctrl));

    ctrl.id = V4L2_CID_IVTV_DEC_PREBUFFER;
    ctrl.value = 0;

    if ( ( ret =ioctl(fd_out, VIDIOC_S_CTRL, &ctrl) ) < 0 ) {
        printf("1: %d\n",ret);
    }

    ctrl.id = V4L2_CID_IVTV_DEC_NUM_BUFFERS;
    ctrl.value = 0;

    if ( ( ret =ioctl(fd_out, VIDIOC_S_CTRL, &ctrl) ) < 0 ) {
        printf("2: %d\n",ret);
    }

    mute = 0;
}

cPvr350Device::~cPvr350Device()
{
    Cancel();
}

void cPvr350Device::MakePrimaryDevice(bool On)
{
    printf("Now primary\n");
}


bool cPvr350Device::HasDecoder(void) const
{
    return true; // We can decode MPEG2
}

bool cPvr350Device::CanReplay(void) const 
{
    return true;  // We can replay
}

int cPvr350Device::ProvidesCa(int Ca) 
{
    return 0;
}


bool cPvr350Device::SetPlayMode(ePlayMode PlayMode)
{ 
    int          ret;
    m_PlayMode = PlayMode;
    printf("Set playmode called %d\n",PlayMode);
    switch ( PlayMode ) {
    case pmNone:
        struct ivtv_ioctl_fwapi   fwcall;

        fwcall.cmd = 0x02;
        fwcall.args = 1;
        fwcall.data[0] = 1;

        decoder->Clear();

        if ((ret = ioctl(fd_out, IVTV_IOC_FWAPI, &fwcall)) < 0) {
            printf("STOP_DECODE %d\n",ret);
        }
        break;
    default:    
        ivtv_cfg_start_decode startd;
        decoder->Clear();

        memset(&startd, 0, sizeof(startd));
        if ( ( ret = ioctl(fd_out, IVTV_IOC_S_START_DECODE, &startd) ) <  0 ) {
            printf("3: %d\n",ret);
        }
        if ( ( ret = ioctl(fd_out, IVTV_IOC_PLAY, 0) ) < 0 ) {
            printf("4: %d\n",ret);
        }
    }
    return true;
}

void cPvr350Device::TrickSpeed(int Speed) 
{
//    ioctl(fd_out, IVTV_IOC_S_SLOW_FAST, 0);
}


void cPvr350Device::SetVideoFormat(bool VideoFormat16_9)
{
    struct {                       /* list_registers/set_regesters */
        unsigned char reg;
        unsigned char val;
    } saa7115_reg;

    printf("Video mode %d\n",VideoFormat16_9);
#if 1
    saa7115_reg.reg = 0x26;
    if ( VideoFormat16_9 ) {
        saa7115_reg.val = 0x07;
    } else {
        saa7115_reg.val = 0x08;
    }
    ioctl(fd_out,SAA7127_SET_REG,&saa7115_reg);
    saa7115_reg.reg = 0x27;
    saa7115_reg.val = 0x80;
    ioctl(fd_out,SAA7127_SET_REG,&saa7115_reg);
#endif
}


void cPvr350Device::Clear(void) 
{
    decoder->Clear();
}

void cPvr350Device::Play(void) 
{
    printf("Play called\n");
    ioctl(fd_out, IVTV_IOC_PLAY, 0);
}

void cPvr350Device::Freeze(void) 
{    
    printf("Freeze called\n");
    ioctl(fd_out, IVTV_IOC_PAUSE, 0);
}

void cPvr350Device::Mute(void) 
{
    struct v4l2_control ctrl;
    printf("Mute called\n");

    ctrl.id = V4L2_CID_IVTV_DEC_SP_MUTE;
    mute ^= 1;
    ctrl.value = mute;
    printf("Setting mute %d\n",mute);
    if ( ioctl(fd_out,VIDIOC_S_CTRL, &ctrl) < 0 ) 
        printf("Mute failed\n");
}

int cPvr350Device::PlayVideo(const uchar *Data, int Length)
{
    int len;

    len = decoder->Decode(Data,Length);


    return Length;
}

void cPvr350Device::SetVolumeDevice(int Volume)
{
    struct v4l2_control ctrl;
    printf("Volume called %d\n",Volume);
    if ( Volume == 0 ) {
        mute = 0;
        Mute();
    } else {
        mute = 1;
        Mute();
    }
#if 0
    ctrl.value = ( Volume * 256 );
    ctrl.id = V4L2_CID_AUDIO_VOLUME;
    if ( ioctl(fd_out,VIDIOC_S_CTRL, &ctrl) < 0 ) 
        printf("Volume failed\n");
#endif
}

void cPvr350Device::StillPicture(const uchar *Data, int Length) 
{
    printf("StillPicture not implemented yet...\n");
}

bool cPvr350Device::Poll(cPoller &Poller, int TimeoutMs) 
{
    //  return true;

    Poller.Add(fd_out,true);
    return Poller.Poll(TimeoutMs);
}

cOsdBase *cPvr350Device::NewOsd(int x, int y)
{
    return new cPvr350Osd(fbfd,osdbuffer,x,y);
}

