/*
 * pvr350.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: pvr350.c,v 1.5 2004/02/01 16:12:23 dom Exp $
 */

#include <vdr/plugin.h>
#include "device.h"

static const char *VERSION        = "0.0.2";
static const char *DESCRIPTION    = "An output device for the PVR350";

class cPluginPvr350 : public cPlugin {
private:
  // Add any member variables or functions you may need here.
public:
  cPluginPvr350(void);
  virtual ~cPluginPvr350();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return DESCRIPTION; }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  };

cPluginPvr350::cPluginPvr350(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
}

cPluginPvr350::~cPluginPvr350()
{
  // Clean up after yourself!
}

const char *cPluginPvr350::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginPvr350::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginPvr350::Initialize(void)
{
  // Initialize any background activities the plugin shall perform.
    new cPvr350Device();
  return true;
}

bool cPluginPvr350::Start(void)
{
  // Start any background activities the plugin shall perform.
  return true;
}

void cPluginPvr350::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}


cMenuSetupPage *cPluginPvr350::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return NULL;
}

bool cPluginPvr350::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  return false;
}

VDRPLUGINCREATOR(cPluginPvr350); // Don't touch this!
