

#include "ringbuff.h"
#include "writer.h"

#include <unistd.h>
#include <fcntl.h>


cPvr350Writer::cPvr350Writer(cRingBuffLinear *ring, int fd)
{
    output = fd;

    m_RingBuffer = ring;
    running = true;

    Start();
}



cPvr350Writer::~cPvr350Writer()
{
    running = false;
    Cancel();
}



void cPvr350Writer::Action()
{ 
    unsigned char *buf;
    int length;
    int max = 4000;
    printf("Writer started pid %d\n",getpid());
        while(running) {
        if ( (buf = m_RingBuffer->Get(length) ) != NULL ) {
            /* Writing a length of 4000 seems to keep ivtv happy */
	    if ( length >= max) {
		length = max;
                safe_write(output,buf,length);                           
                m_RingBuffer->Del(length);  
            } else {
	        cCondWait::SleepMs(1);
            }
        } else {
	    cCondWait::SleepMs(1);
        }
                         
    }       
}

