.J
CORE DEFINITIONS
VOCABULARY ASSEMBLER
: CODE CREATE HEX ASSEMBLER ;
ASSEMBLER DEFINITIONS
HEX
: 8* 2* 2* 2* ;

0 CCONSTANT B
1 CCONSTANT C
2 CCONSTANT D
3 CCONSTANT E
4 CCONSTANT H
5 CCONSTANT L
6 CCONSTANT M
7 CCONSTANT A

00 CCONSTANT BC
10 CCONSTANT DE
20 CCONSTANT HL
30 CCONSTANT AF
30 CCONSTANT SP

00 CCONSTANT NZ
08 CCONSTANT Z
10 CCONSTANT NC
18 CCONSTANT CY
20 CCONSTANT PO
28 CCONSTANT PE
30 CCONSTANT P
38 CCONSTANT N

: @X DD C, 8007 ;
: @Y FD C, 8007 ; 
: IX DD C, HL ;
: IY FD C, HL ;

: 1BYTE <BUILDS C, DOES> C@ C, ;

3F 1BYTE CCF,
AF 1BYTE CLA,
2F 1BYTE CPL,
27 1BYTE DAA,
F3 1BYTE DSI,
FB 1BYTE ENI,
76 1BYTE HLT,
00 1BYTE NOP,
A7 1BYTE RCF,
37 1BYTE SCF,
C9 1BYTE RET,
08 1BYTE XAA,
D9 1BYTE XAL,
EB 1BYTE XDH,

: 2BYTE <BUILDS C, DOES> ED C, C@ C, ;

46 2BYTE IM0,
56 2BYTE IM1,
5E 2BYTE IM2,
44 2BYTE NEG,
4D 2BYTE RTI,
45 2BYTE RTN,
6F 2BYTE RLD,
67 2BYTE RRD,
57 2BYTE LAI,
5F 2BYTE LAR,
4F 2BYTE LRA,
47 2BYTE LIA,

: MOV, OVER 8* OVER + 40 + C, + 0< IF C, THEN ;

: MVI, OVER 8* 06  + C, SWAP 0< IF SWAP C, THEN C, ;
 
: BCORDE 2DUP BC = SWAP DE = OR ;
: LDA, BCORDE IF 0A + C, ELSE 3A C, , THEN ; 
: STA, BCORDE IF 02 + C, ELSE 32 C, , THEN ;
: DMI, SWAP 01 + C, , ; 
: DSM, DUP HL = IF 22 C, DROP ELSE ED C, 43 + C, THEN , ;
: DLM. SWAP DUP  HL =  IF 2A C, DROP ELSE ED C, 4B + C, THEN , ;
: 1MASK  <BUILDS C, DOES> C@ SWAP 8* + C, ;
C5 1MASK PSH,
C1 1MASK POP,
: 8ALG <BUILDS C, DOES> C@ OVER + C, 0< IF C, THEN ;

80 8ALG ADD,
88 8ALG ADC,
90 8ALG SUB,
98 8ALG SBC,
A0 8ALG AND,
A8 8ALG XOR,
B0 8ALG IOR,
B8 8ALG CMP,

: 8IM <BUILDS C, DOES> C@ C, C, ;

C6 8IM ADI,
CE 8IM ACI,
D6 8IM SUI,
DE 8IM SCI,
E6 8IM ANI,
EE 8IM XOI,
F6 8IM ORI,
FE 8IM CPI,

: INC, DUP 8* 04 + C, IF C, THEN ;
: DEC, DUP 8* 05 + C, IF C, THEN ;
: DAD, 09 + C, ; 
: DAI, SWAP OVER = IF -1 DP +! THEN DAD, ;
: DAC, ED C, 4A + C, ; 
: DSC, ED C, 42 + C, ; 
: DSB, EDA7 , 42 + C, ; 

03 1MASK DIN,
0B 1MASK DDC,

: RSG <BUILDS C, DOES> CB C, C@ DUP 20 - 0< IF OVER 07 =
IF  -1 DP +! THEN THEN OVER 0< IF LROT C, THEN + C, ;

00 RSG RLC,
08 RSG RRC,
10 RSG RLT,
18 RSG RRT,
20 RSG SLR,
28 RSG SRR,
38 RSG SRL,

: BITAD <BUILDS C, DOES> CB C, C@ LROT 8* + OVER + SWAP 0<
IF SWAP C, THEN C, ;

40 BITAD BIT,
80 BITAD RES,
C0 BITAD SET,

00 CCONSTANT IC
01 CCONSTANT DC
10 CCONSTANT IR
11 CCONSTANT DR

: BDIR <BUILDS C, DOES> ED C, C@ + C, ;

A0 BDIR CLD,
A1 BDIR CCP,
A2 BDIR CIN,
A3 BDIR COT,

: RST, 8* C7 + C, ;

DB 8IM INA,
D3 8IM OTA,

: XST, E3 C, DROP ;
: JPM, E9 C, DROP ;
: LSP, F9 C, DROP ;
: LABEL ' 2+ HERE SWAP ! ;
: CAL, CD C, , ;
: CCODE <BUILDS C, DOES> C@ + C, , ;

C4 CCODE CLC,
C0 CCODE RTC,

: JMP, C3 C, , ;

C2 CCODE JPC,

18  8IM JPR,
: JRC, 10 + C, C, ; 
10 8IM DJN,

: BEGIN HERE ;
-1 CCONSTANT U
: JRC DUP 0< IF DROP JPR, ELSE JRC, THEN ;
: JAC DUP 0< IF DROP JMP, ELSE JPC, THEN ;
: END DUP 20 - 0< 
              IF OVER HERE  2+ - DUP 80 - 0<  
                          IF 2SWAP DROP  JRC 
                            ELSE DROP JAC THEN 
              ELSE JAC THEN ; 

: RIF 0 SWAP JRC, HERE ;
: AIF 0 SWAP JPC, HERE 2+ ;
: ATHEN HERE SWAP ! ;
: RTHEN OVER - SWAP 1- C! ;
: RRELSE HERE 2+ RTHEN 18 , HERE ;
: RAELSE HERE 3 + RTHEN 0 JMP, HERE 2- ;
: ARELSE ATHEN 18 , HERE ;
: AAELSE ATHEN 0 JMP, HERE 2- ;
: RWHILE SWAP U END HERE RTHEN ;
: AWHILE SWAP U END HERE ATHEN ;
: DO HERE B LROT MVI, ;
: LOOP HERE 2+ - DJN, ;
: DJN, B DEC, NZ JPC, ;
: NEXT IX JPM, CORE ;
CORE DEFINITIONS
DECIMAL
