	XLIB FileEprDelSpace

	LIB FlashStoreFileEpr
	LIB FileEprFileEntryInfo

if QDOS
	include "flstore_def"
	include "#error_def"
else
	include "flstore.def"
	include "#error.def"
endif

; ************************************************************************
;
; Standard Z88 File Eprom Format, including support for sub File Eprom
; area in application cards (below application banks in first free 64K boundary)
;
; Return amount of deleted file space in File Eprom Area, inserted in slot C.
;
; ------------------------------------------------------------------------
;
; $Header: /Z88/StdLib/FileEprom/EprDelSp.asm 3     16-08-98 16:02 Gbs $
;
; $History: EprDelSp.asm $
; 
; *****************  Version 3  *****************
; User: Gbs          Date: 16-08-98   Time: 16:02
; Updated in $/Z88/StdLib/FileEprom
; Extended for Sub File Eprom handling.
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 24-01-98   Time: 20:41
; Updated in $/Z88/StdLib/FileEprom
; INCLUDE directives optimized (if any)
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 20-01-98   Time: 8:55
; Created in $/Z88/StdLib/FileEprom
; Added to SourceSafe
;
; ------------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Dec 1997 - Aug 1998
;
; ------------------------------------------------------------------------
;
; IN:
;	C = slot number containing File Eprom Area
;
; OUT:
;	Fc = 0, File Eprom available
;		DEBC = Amount of deleted file space used on File Eprom
;
;	Fc = 1, 
;		A = RC_ONF
;		File Eprom was not found in slot C.
;
; Registers changed after return:
;	......../IXIY same
;	AFBCDEHL/.... different
;
.FileEprDelSpace
				LD	E,C					; preserve slot number
				LD	A, FSFLE_SCPT
				CALL FlashStoreFileEpr		; check for presence of "oz" File Eprom in slot
				JR	C, no_fileepr
				JR	NZ, no_fileepr			; File Eprom not available in slot...
				LD	A,$C0
				CP	L					; offset $3FC0 (beginning of "oz" header) ?
				JR	NZ,no_fileepr			; no, a FS II partition header was found...
				
				LD	A,E
				AND	@00000011				; slots (0), 1, 2 or 3 possible
				RRCA
				RRCA						; converted to Slot mask $40, $80 or $C0
				OR	B
				SUB	D					; D = total banks of File Eprom Area
				INC	A
				LD	B,A					; B is now bottom bank of File Eprom
				LD	HL,$4000				; BHL points at first File Entry...

				EXX
				LD	BC,0
				LD	D,B
				LD	E,C
				EXX
.scan_eprom
				CALL FileEprFileEntryInfo	; scan all file entries...
				CALL CalcDelFileSpace		; add file space (for deleted file entry)
				JR	NC, scan_eprom			; look in next File Entry...

				EXX						; return DEBC (amount of deleted file space)
				CP	A					; Fc = 0, File Eprom parsed...
				RET
.no_fileepr
				SCF
				LD	A,RC_ONF
				RET


; ************************************************************************
;
; Add file space to current sum, if file is marked as deleted.
;
; IN:
;	Fz = File status (active or deleted)
;	CDE = length of file
;
; OUT:
;	(Amount of deleted file space updated)
;
.CalcDelFileSpace	RET	C					; not a valid File Entry
				RET	NZ					; file is active, ignore
				PUSH AF					; preserve Z80 status flags

				PUSH BC
				PUSH DE
				EXX
				POP	HL
				ADD	HL,BC
				LD	B,H
				LD	C,L
				POP	HL
				LD	A,E
				ADC	A,L
				LD	E,A					; delspace (DEBC) += <file length>
				EXX

				POP	AF
				RET
