	XLIB FlashStore_CheckPartitionID

	LIB MemReadByte
	
	XDEF DeviceCode
		
if QDOS
	include "#flashepr_def"
else
	include "#flashepr.def"
endif


; ************************************************************************
;
; Check presence of FlashStore Partition Identifier.
; This is an internal, low level routine used by high level library
; routines for validation of a Partition Identifier in the specified bank B.
;
; ----------------------------------------------------------------------
;
; Design & programming by Gunther Strube, InterLogic, Aug 1998
;
; ----------------------------------------------------------------------
; Version History:
;
; $Header: /Z88/StdLib/FlashStore/FStPtId.asm 2     16-08-98 16:18 Gbs $
;
; $History: FStPtId.asm $
; 
; *****************  Version 2  *****************
; User: Gbs          Date: 16-08-98   Time: 16:18
; Updated in $/Z88/StdLib/FlashStore
; Size byte of Partition moved to offset $3C in ID header.
; 
; *****************  Version 1  *****************
; User: Gbs          Date: 16-04-98   Time: 21:05
; Created in $/Z88/StdLib/FlashStore
; ----------------------------------------------------------------------
;
; FlashStore Partition Identifier (32 bytes):
;
; $3FE0: 0, 0, 0
; $3FE3: Label (15 bytes)
; $3FF2: Date of Format
; $3FF5: Time of Format
; $3FF8: Format counter (24bit integer)
; $3FFB: File Format Version
; $3FFC: Size of File Partition Area in 16K banks
; $3FFD: Device Code of Flash Eprom.
; $3FFE: 'FS'
;
; ----------------------------------------------------------------------
;
; IN:
;	BHL = absolute pointer to potential Partition Identifier, $xFE0 or $xF00
;	(B = must be defined for specific bank in specific slot, 
;	 HL = must be masked to specific segment that is free for bank binding)
;
; OUT:
;	Fc = 0 always.
;
;	Fz = 1, Partition Identifier found at BHL.
;		A = Intel Chip Device Code
;		C = size of physical Card in 16K banks (defined by Device Code)
;		D = Size of Partition in 16K banks
;	Fz = 0, Partition Identifier not found.
;		A undefined
;		C undefined
;		D undefined
;
; Registers changed after return:
;	..B..EHL/IXIY same
;	AF.CD.../.... different
;
.FlashStore_CheckPartitionID

				PUSH HL
				PUSH	DE

				LD	L,$E0
				XOR	A
				LD	C,A
				CALL MemReadByte			; $xFE0, bank B
				XOR	C
				JR	NZ, exit_CheckPartition	; ($xFE0) <> $00!
				LD	A,1
				CALL MemReadByte			
				XOR	C
				JR	NZ, exit_CheckPartition	; ($xFE1) <> $00!
				LD	A,2
				CALL MemReadByte			
				XOR	C
				JR	NZ, exit_CheckPartition	; ($xFE2) <> $00!

				LD	A,$1E
				CALL MemReadByte			; $xFFE, bank B
				LD	D,A
				LD	A,$1F
				CALL MemReadByte			; $xFFF, bank B
				LD	E,A
				CP	A
				PUSH	HL
				LD	HL,$4653				; "FS"?
				SBC	HL,DE				; Fz = 1, Header found...
				POP	HL
				JR	NZ, exit_CheckPartition

				LD	A,$1C
				CALL MemReadByte			
				LD	D,A					; D = Size of Partition in 16K banks

				LD	A,$1D
				CALL MemReadByte			; A = Intel Flash Eprom Device Code
				CALL DeviceCode			; If invalid device code, then there's no header
										; otherwise C = physical size of card in 16K banks
.exit_CheckPartition
				SCF
				CCF						; Fc = 0 always
				POP	HL
				LD	E,L					; original E restored
				POP	HL					; original HL restored
				RET


; ************************************************************************
;
; In:
;	A = Potential Device Code
;
; Out:
;	Fz = 1, Flash Eprom Device Code found
;		C = total size of card in 16K banks
;	Fz = 0, Unknown Device Code
;
; Registers changed after return:
;	A.B.DEHL/IXIY same
;	.F.C..../.... different
;
.DeviceCode		PUSH HL
				PUSH BC

				LD	B, 4				; check 4 different Intel Chip identifications
				LD	HL, FlashEpromTypes
.devcode_loop		CP	(HL)
				INC	HL
				LD	C,(HL)			; C = physical size of card in 16K banks
				JR	Z, found_devcode
				INC	HL
				DJNZ	devcode_loop
				OR	H				; Fz = 0, indicate not found...
.found_devcode
				LD	L,C
				POP	BC
				LD	C,L				; size of card in banks...
				POP	HL
				RET
.FlashEpromTypes
				DEFB fe_i020, 16
				DEFB fe_i004, 32
				DEFB fe_i008, 64
				DEFB fe_i8s5, 64
			
