
    MODULE MemoryLoad

    XREF Write_Msg
    XREF SkipSpaces, Get_constant
    XREF Input_buffer
    XREF Memory_Range
    XREF nofile_msg
    XREF Use_IntErrhandler, RST_ApplErrhandler

    XDEF Memory_RamTop

if QDOS
	INCLUDE "defs_h"
	INCLUDE "#fileio_def"
	INCLUDE "#director_def"
endif
if MSDOS | UNIX
	INCLUDE "defs.h"
	INCLUDE "#fileio.def"
	INCLUDE "#director.def"
endif
if Z88
	INCLUDE "defs.h"
	INCLUDE ":*//fileio.def"
	INCLUDE ":*//director.def"
endif


; *******************************************************************************************
;
; Input memory	address parameter
;
.Memory_RamTop		CALL	SkipSpaces
				JP	C, default_address	 ; no parameter, use default value
				LD	C,16
				CALL	Get_Constant		 ; get address	(16bit hex value)
				RET	C
				JR	check_address

.default_address	LD	DE,$2001			 ; Default RAM	Top address

.check_address		LD	A,(IY + RamTopPage)	 ; High byte of physical	RAM top...
				CP	D				 ; is address higher than allocated RAM?
				JR	C, mem_range		 ; Yes - out of memory range
				LD	A,D
				CP	$20				 ; address lower than $2000?
				JR	C, mem_range		 ; Yes - out of memory range

.set_ramtop		LD	(IY + HoleStart),E
				LD	(IY + HoleStart+1),D ; new RAM top
				CALL	Memory_range
				RET

.mem_range		LD	HL, range_msg
				CALL	Write_Msg
				CALL	Memory_range
				RET

.range_msg		DEFM	"Illegal RAM top!" & 0
