
;	 ZZZZZZZZZZZZZZZZZZZZ	8888888888888		00000000000
;   ZZZZZZZZZZZZZZZZZZZZ	   88888888888888888    0000000000000
;			  ZZZZZ	   888		  888  0000		0000
;			ZZZZZ	   88888888888888888  0000		0000
;		   ZZZZZ			8888888888888	  0000		0000		 AAAAAA		 SSSSSSSSSSS	MMMM		 MMMM
;		 ZZZZZ		   88888888888888888  0000		0000		AAAAAAAA	    SSSS			MMMMMM   MMMMMM
;	    ZZZZZ			   8888		 8888  0000		0000	    AAAA	AAAA	    SSSSSSSSSSS	MMMMMMMMMMMMMMM
;	  ZZZZZ			   8888		 8888  0000		0000	   AAAAAAAAAAAA	 SSSSSSSSSSS	MMMM	MMMMM MMMM
;	ZZZZZZZZZZZZZZZZZZZZZ  88888888888888888    0000000000000	  AAAA	  AAAA		  SSSSS	MMMM		 MMMM
;  ZZZZZZZZZZZZZZZZZZZZZ		8888888888888		00000000000	 AAAA	   AAAA  SSSSSSSSSSS	MMMM		 MMMM
;
; Copyright (C) Gunther Strube, InterLogic 1995

	MODULE Fast_32bit_addition

	XDEF	Add32bit

; ******************************************************************************
;
;	Unsigned 32bit	addition
;
;	IN:	HL =	pointer to unsigned	32bit integer (low byte - high byte order)
;		DEBC	= 32bit integer to be added with (HL)
;
;	OUT:	HL =	pointer to result (	same	as HL(in)	)
;	NB:	Overflow is not reported
;
;	Registers	changed after return:
;		..BCDEHL/IXIY	same
;		AF....../....	different
;
.Add32bit			PUSH	IX
				PUSH	HL
				POP	IX				; IX	points at	32bit integer
				LD	L,(IX+0)
				LD	H,(IX+1)
				ADD	HL,BC
				LD	(IX+0),L
				LD	(IX+1),H
				LD	L,(IX+2)
				LD	H,(IX+3)
				ADC	HL,DE
				LD	(IX+2),L
				LD	(IX+3),H
.exit_add32bit		PUSH	IX
				POP	HL				; HL	points at	32bit result
				POP	IX				; restore	original IX
				RET
