* Conversion routine long integer to ASCII string
* PWITTE December 28th 1992
*
* V0.02 March 19th 2004 - nomenclature

         section code

         xdef cv_lin2str

*
cv_lin2str
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Convert signed long integer in d1 to ascii in buffer
*
* input :
*        d1.l = lint to convert
*
* output:    cc set
*        d1.w = len of string
*        a0  -> string in buffer (len+str)
*        errors: no fail
*        no other registers affected but buffer overwritten
*
regs    reg d2-d4/a0/a2
        movea.l (a6),a0         a0 -> buffer
        movem.l regs,-(a7)
        moveq   #0,d3           d3 = length counter
        tst.l   d1              test sign
        beq.s   exit            zero
        bpl.s   start           positive, so skip this
        neg.l   d1              un-twos-complement number
        moveq   #'-',d4         this number starts with a minus
        bsr.s   mv_char         insert it
start
        lea.l   decimals,a2     a2 -> decimals list
        moveq   #9-1,d0         d0 = counter
*
first_digit
*                               locate first non-zero digit
        cmp.l   (a2)+,d1        too big?
        dbcc    d0,first_digit    yes, try next size
*
        bcs.s   exit              no, exit with ones
        subq.l  #4,a2           readjust "divisor" pointer
*
next_digit
        moveq   #-1,d4          d4 = decimal counter
        move.l  (a2)+,d2        trial "divide" by decimal value
next_trial
        addq.b  #1,d4           d2 goes at least this many times into number
        sub.l   d2,d1           try it
        bcc.s   next_trial      it goes, try some more
        add.l   d2,d1           that's as far as it goes
        bsr.s   mv_num          write value into string
lend
        dbra    d0,next_digit   go for next digit
*
exit
        move.b  d1,d4           remainder = ones
        bsr.s   mv_num          add to string even if zero
        move.w  d3,d1           length
        movem.l (a7)+,regs      point to string in buffer
        move.w  d1,0(a6,a0.l)   put length in place
        moveq   #0,d0           ;no error
        rts
*
mv_num
        addi.b  #'0',d4         convert to ascii
mv_char
        move.b  d4,2(a6,a0.l)   put digit in place (leaving room for length)
        addq.l  #1,a0           increment pointer
        addq.w  #1,d3           increment length
        rts
*
decimals
        dc.l 1000000000
        dc.l  100000000
        dc.l   10000000
        dc.l    1000000
        dc.l     100000
        dc.l      10000
        dc.l       1000
        dc.l        100
        dc.l         10

         end
