/***************************************************************************
 *                       StreamPalmTXT.cpp  -  description
 *                               -------------------
 *  begin                : Tue March 1 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "StreamPalmTXT.h"

StreamPalmTXT::~StreamPalmTXT()
{
/*    QDir dir;
    dir = QDir::QDir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }*/
}

QChar StreamPalmTXT::isTag(QChar t)
{
    int p;
    if (prevRemoveSpacePads != removeSpacePads)
    {
	prevRemoveSpacePads = removeSpacePads;
	p = getPosition();
	int maxLines = 40;
	unsigned char s[maxLines];
	unsigned char n,v;
	int tempPos,shift;
	QString line;
	for (int i = 0;i<maxLines;i++) s[i] = 0;
	shift = (getSize()/maxLines);
	tempPos = 0;
	for (int i = 0;i<maxLines;i++)
	{
	    setPosition(tempPos);
	    if (atEnd()) break;
	    textstream->readLine();
	    line = textstream->readLine();
	    tempPos += shift;
	    n = line.find(QRegExp("[^ ]"));
	    if (n >= maxLines) continue;
	    ++s[n];
	}
	n = 0;
	v = 0;
	for (int i = 0;i<maxLines;i++)
	{
	    if (s[i] > 0) ++v;
	    if (s[i] > n)
	    {
		n = s[i];
		spacePadded = i;
	    }
	}
	if (n < (maxLines/2)) spacePadded = 0;
	if (v > (maxLines/7)) spacePadded = 255;
	setPosition(p);
    }
    QChar ch;
    QString s;
    QString spaceRegExp = "^ ";
    int c;
    if (t.latin1() > 0x1f) return t;
    if (t != '\n') return t;
    p = getPosition();
    c = 10;
    s = "";
    if (reparagraph)
    {
	if (textstream->atEnd())
	{
	    newLine = true;
	    return QChar();
	}
	while (1)
	{
	    textstream->operator>>(ch);
	    if (recode) ch = decoder->getQChar(ch);
	    if (textstream->atEnd())
	    {
		newLine = true;
		return QChar();
	    }
	    if (stripCR && (ch == '\r')) continue;
	    if (ch == '\r') ch = '\n';
	    break;
	}
	if (ch == '\n')
	{
	    newLine = true;
	    newParagraph = true;
	    return QChar();
	}
	s.append(ch);
        while (c)
        {
	    if (textstream->atEnd()) break;
    	    textstream->operator>>(ch);
	    if (stripCR && (ch == '\r')) continue;
	    if (ch == '\r') ch = '\n';
	    s.append(ch);
	    --c;
        }
	//printf("-->%s<--\n",s.latin1());
	if (s.find(QRegExp("^\\s*[\\-\"`']"),0)>-1)
	{
	    newLine = true;
	    setPosition(p);
	    //printf("1\n");
	    return QChar();
	}
	if (removeSpacePads && spacePadded)
	{
	    for (unsigned int i=0;i<spacePadded;i++)
	    {
		spaceRegExp += " ";		
	    }
	    if (s.find(QRegExp(spaceRegExp),0)>-1)
	    {
		newParagraph = true;
		newLine = true;
		setPosition(p);
		return QChar();
	    }
	} else if (s.find(QRegExp("^\\s+"),0)>-1)
	{
	    newParagraph = true;
	    newLine = true;
	    setPosition(p);
	    //printf("2\n");
	    return QChar();
	}
    } else {
	newParagraph = true;
	newLine = true;
	return QChar();
    }
    setPosition(p);
    return ' ';
}

bool StreamPalmTXT::openFile(const QString & filepath)
{
    char out_char[256],rim_char[256];
    plucker_file = new char[256];
    QString out_file,rim_file;
    QDir dir;
    out_file = "/tmp/justreader/palmdoc.tmp\0";
    rim_file = "/tmp/justreader/palmdoc.rim\0";
    strncpy(plucker_file,(filepath+"\0").latin1(),(filepath+"\0").length()+1);
    strncpy(out_char,out_file.latin1(),out_file.length()+1);
    strncpy(rim_char,rim_file.latin1(),rim_file.length()+1);
    //printf("%s\n%s\n%s\n",plucker_file,out_char,rim_char);
    //plucker_file[255] = 0;
    //out_char[255] = 0;
    //rim_file[255] = 0;
    QFile f;
    int docType;
    if ( !QFile::exists( filepath ) ) return false;
    f.setName( filepath ); 
    if (!f.open( IO_ReadOnly ))
    {
	return false;
    }
    fileOpened = true;
    f.close();
    if (file.isOpen()) file.close();
    dir = QDir::QDir("/tmp/justreader");
    dir.mkdir("/tmp/justreader");
    for(unsigned int i=0;i<dir.count();i++)
    {
	QFile::QFile("/tmp/justreader/"+ dir.operator[](i)).remove();
    }
    docType = Decomp(plucker_file,out_char,rim_char,reorderPlucker);
    if (docType == 0) return false; 
    file.setName( out_file ); 
    file.open( IO_ReadOnly );
    docSize = file.size();
    numberOfPages = int(docSize/2000) + 1;
    newParagraph = false;
    newLine = false;
    if (textstream) textstream->~QTextStream();
    textstream = new QTextStream(&file);
    resetTags();
    setEncoding(encoding);
    if (links) delete [] links;
    links = 0;
    linksFound = false;
    return true;
}

