/*
** FAAD2 - Freeware Advanced Audio (AAC) Decoder including SBR decoding
** Copyright (C) 2003 M. Bakker, Ahead Software AG, http://www.nero.com
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** Any non-GPL usage of this software or parts of this software is strictly
** forbidden.
**
** Commercial non-GPL licensing of this software is possible.
** For more info contact Ahead Software through Mpeg4AAClicense@nero.com.
**
** $Id: cfft_tab.h,v 1.2 2003/10/03 22:22:27 alex Exp $
**/

#ifndef __CFFT_TAB_H__
#define __CFFT_TAB_H__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef FIXED_POINT

complex_t cfft_tab_512[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99992472), COEF_CONST(0.01227154) },
    { COEF_CONST(0.99969882), COEF_CONST(0.02454123) },
    { COEF_CONST(0.99932235), COEF_CONST(0.03680722) },
    { COEF_CONST(0.99879545), COEF_CONST(0.04906768) },
    { COEF_CONST(0.99811810), COEF_CONST(0.06132074) },
    { COEF_CONST(0.99729043), COEF_CONST(0.07356457) },
    { COEF_CONST(0.99631262), COEF_CONST(0.08579732) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.99390697), COEF_CONST(0.11022221) },
    { COEF_CONST(0.99247956), COEF_CONST(0.12241068) },
    { COEF_CONST(0.99090266), COEF_CONST(0.13458072) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.98730141), COEF_CONST(0.15885815) },
    { COEF_CONST(0.98527765), COEF_CONST(0.17096190) },
    { COEF_CONST(0.98310548), COEF_CONST(0.18303989) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97831738), COEF_CONST(0.20711139) },
    { COEF_CONST(0.97570211), COEF_CONST(0.21910124) },
    { COEF_CONST(0.97293997), COEF_CONST(0.23105812) },
    { COEF_CONST(0.97003126), COEF_CONST(0.24298020) },
    { COEF_CONST(0.96697646), COEF_CONST(0.25486568) },
    { COEF_CONST(0.96377605), COEF_CONST(0.26671278) },
    { COEF_CONST(0.96043050), COEF_CONST(0.27851969) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.95330602), COEF_CONST(0.30200595) },
    { COEF_CONST(0.94952816), COEF_CONST(0.31368175) },
    { COEF_CONST(0.94560730), COEF_CONST(0.32531032) },
    { COEF_CONST(0.94154406), COEF_CONST(0.33688986) },
    { COEF_CONST(0.93733901), COEF_CONST(0.34841868) },
    { COEF_CONST(0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(0.92850608), COEF_CONST(0.37131721) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91911387), COEF_CONST(0.39399207) },
    { COEF_CONST(0.91420972), COEF_CONST(0.40524134) },
    { COEF_CONST(0.90916800), COEF_CONST(0.41642958) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.89867449), COEF_CONST(0.43861625) },
    { COEF_CONST(0.89322430), COEF_CONST(0.44961134) },
    { COEF_CONST(0.88763964), COEF_CONST(0.46053872) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.87607008), COEF_CONST(0.48218375) },
    { COEF_CONST(0.87008697), COEF_CONST(0.49289823) },
    { COEF_CONST(0.86397284), COEF_CONST(0.50353837) },
    { COEF_CONST(0.85772860), COEF_CONST(0.51410276) },
    { COEF_CONST(0.85135520), COEF_CONST(0.52458972) },
    { COEF_CONST(0.84485358), COEF_CONST(0.53499764) },
    { COEF_CONST(0.83822471), COEF_CONST(0.54532498) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.82458931), COEF_CONST(0.56573182) },
    { COEF_CONST(0.81758481), COEF_CONST(0.57580823) },
    { COEF_CONST(0.81045717), COEF_CONST(0.58579791) },
    { COEF_CONST(0.80320752), COEF_CONST(0.59569931) },
    { COEF_CONST(0.79583687), COEF_CONST(0.60551101) },
    { COEF_CONST(0.78834641), COEF_CONST(0.61523163) },
    { COEF_CONST(0.78073722), COEF_CONST(0.62485951) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.76516724), COEF_CONST(0.64383155) },
    { COEF_CONST(0.75720882), COEF_CONST(0.65317285) },
    { COEF_CONST(0.74913639), COEF_CONST(0.66241580) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.73265427), COEF_CONST(0.68060100) },
    { COEF_CONST(0.72424710), COEF_CONST(0.68954057) },
    { COEF_CONST(0.71573079), COEF_CONST(0.69837630) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.69837624), COEF_CONST(0.71573085) },
    { COEF_CONST(0.68954051), COEF_CONST(0.72424710) },
    { COEF_CONST(0.68060100), COEF_CONST(0.73265427) },
    { COEF_CONST(0.67155892), COEF_CONST(0.74095118) },
    { COEF_CONST(0.66241574), COEF_CONST(0.74913639) },
    { COEF_CONST(0.65317285), COEF_CONST(0.75720888) },
    { COEF_CONST(0.64383155), COEF_CONST(0.76516730) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.62485945), COEF_CONST(0.78073728) },
    { COEF_CONST(0.61523157), COEF_CONST(0.78834641) },
    { COEF_CONST(0.60551101), COEF_CONST(0.79583693) },
    { COEF_CONST(0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(0.58579785), COEF_CONST(0.81045717) },
    { COEF_CONST(0.57580817), COEF_CONST(0.81758481) },
    { COEF_CONST(0.56573176), COEF_CONST(0.82458931) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.54532498), COEF_CONST(0.83822471) },
    { COEF_CONST(0.53499758), COEF_CONST(0.84485358) },
    { COEF_CONST(0.52458966), COEF_CONST(0.85135520) },
    { COEF_CONST(0.51410270), COEF_CONST(0.85772866) },
    { COEF_CONST(0.50353837), COEF_CONST(0.86397284) },
    { COEF_CONST(0.49289817), COEF_CONST(0.87008697) },
    { COEF_CONST(0.48218375), COEF_CONST(0.87607014) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.46053869), COEF_CONST(0.88763964) },
    { COEF_CONST(0.44961131), COEF_CONST(0.89322430) },
    { COEF_CONST(0.43861622), COEF_CONST(0.89867449) },
    { COEF_CONST(0.42755505), COEF_CONST(0.90398932) },
    { COEF_CONST(0.41642952), COEF_CONST(0.90916800) },
    { COEF_CONST(0.40524128), COEF_CONST(0.91420978) },
    { COEF_CONST(0.39399201), COEF_CONST(0.91911387) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.37131718), COEF_CONST(0.92850608) },
    { COEF_CONST(0.35989499), COEF_CONST(0.93299282) },
    { COEF_CONST(0.34841865), COEF_CONST(0.93733901) },
    { COEF_CONST(0.33688983), COEF_CONST(0.94154406) },
    { COEF_CONST(0.32531026), COEF_CONST(0.94560736) },
    { COEF_CONST(0.31368172), COEF_CONST(0.94952822) },
    { COEF_CONST(0.30200592), COEF_CONST(0.95330602) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.27851966), COEF_CONST(0.96043056) },
    { COEF_CONST(0.26671273), COEF_CONST(0.96377605) },
    { COEF_CONST(0.25486562), COEF_CONST(0.96697646) },
    { COEF_CONST(0.24298014), COEF_CONST(0.97003126) },
    { COEF_CONST(0.23105808), COEF_CONST(0.97293997) },
    { COEF_CONST(0.21910121), COEF_CONST(0.97570211) },
    { COEF_CONST(0.20711134), COEF_CONST(0.97831738) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.18303984), COEF_CONST(0.98310548) },
    { COEF_CONST(0.17096186), COEF_CONST(0.98527765) },
    { COEF_CONST(0.15885811), COEF_CONST(0.98730141) },
    { COEF_CONST(0.14673044), COEF_CONST(0.98917651) },
    { COEF_CONST(0.13458067), COEF_CONST(0.99090266) },
    { COEF_CONST(0.12241063), COEF_CONST(0.99247956) },
    { COEF_CONST(0.11022217), COEF_CONST(0.99390697) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(0.08579727), COEF_CONST(0.99631262) },
    { COEF_CONST(0.07356452), COEF_CONST(0.99729043) },
    { COEF_CONST(0.06132070), COEF_CONST(0.99811810) },
    { COEF_CONST(0.04906763), COEF_CONST(0.99879545) },
    { COEF_CONST(0.03680718), COEF_CONST(0.99932241) },
    { COEF_CONST(0.02454119), COEF_CONST(0.99969882) },
    { COEF_CONST(0.01227149), COEF_CONST(0.99992472) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.01227158), COEF_CONST(0.99992472) },
    { COEF_CONST(-0.02454127), COEF_CONST(0.99969882) },
    { COEF_CONST(-0.03680727), COEF_CONST(0.99932235) },
    { COEF_CONST(-0.04906772), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.06132078), COEF_CONST(0.99811810) },
    { COEF_CONST(-0.07356461), COEF_CONST(0.99729043) },
    { COEF_CONST(-0.08579735), COEF_CONST(0.99631262) },
    { COEF_CONST(-0.09801719), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.11022225), COEF_CONST(0.99390697) },
    { COEF_CONST(-0.12241072), COEF_CONST(0.99247950) },
    { COEF_CONST(-0.13458076), COEF_CONST(0.99090260) },
    { COEF_CONST(-0.14673053), COEF_CONST(0.98917651) },
    { COEF_CONST(-0.15885819), COEF_CONST(0.98730141) },
    { COEF_CONST(-0.17096193), COEF_CONST(0.98527765) },
    { COEF_CONST(-0.18303993), COEF_CONST(0.98310548) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.20711142), COEF_CONST(0.97831738) },
    { COEF_CONST(-0.21910129), COEF_CONST(0.97570211) },
    { COEF_CONST(-0.23105815), COEF_CONST(0.97293991) },
    { COEF_CONST(-0.24298023), COEF_CONST(0.97003126) },
    { COEF_CONST(-0.25486571), COEF_CONST(0.96697646) },
    { COEF_CONST(-0.26671281), COEF_CONST(0.96377605) },
    { COEF_CONST(-0.27851975), COEF_CONST(0.96043050) },
    { COEF_CONST(-0.29028472), COEF_CONST(0.95694029) },
    { COEF_CONST(-0.30200601), COEF_CONST(0.95330602) },
    { COEF_CONST(-0.31368178), COEF_CONST(0.94952816) },
    { COEF_CONST(-0.32531035), COEF_CONST(0.94560730) },
    { COEF_CONST(-0.33688989), COEF_CONST(0.94154406) },
    { COEF_CONST(-0.34841874), COEF_CONST(0.93733895) },
    { COEF_CONST(-0.35989508), COEF_CONST(0.93299282) },
    { COEF_CONST(-0.37131724), COEF_CONST(0.92850608) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.39399210), COEF_CONST(0.91911387) },
    { COEF_CONST(-0.40524137), COEF_CONST(0.91420972) },
    { COEF_CONST(-0.41642961), COEF_CONST(0.90916800) },
    { COEF_CONST(-0.42755514), COEF_CONST(0.90398932) },
    { COEF_CONST(-0.43861628), COEF_CONST(0.89867443) },
    { COEF_CONST(-0.44961137), COEF_CONST(0.89322430) },
    { COEF_CONST(-0.46053877), COEF_CONST(0.88763958) },
    { COEF_CONST(-0.47139677), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.48218381), COEF_CONST(0.87607002) },
    { COEF_CONST(-0.49289826), COEF_CONST(0.87008703) },
    { COEF_CONST(-0.50353843), COEF_CONST(0.86397284) },
    { COEF_CONST(-0.51410282), COEF_CONST(0.85772860) },
    { COEF_CONST(-0.52458972), COEF_CONST(0.85135514) },
    { COEF_CONST(-0.53499764), COEF_CONST(0.84485352) },
    { COEF_CONST(-0.54532504), COEF_CONST(0.83822465) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.56573188), COEF_CONST(0.82458931) },
    { COEF_CONST(-0.57580823), COEF_CONST(0.81758481) },
    { COEF_CONST(-0.58579791), COEF_CONST(0.81045717) },
    { COEF_CONST(-0.59569937), COEF_CONST(0.80320752) },
    { COEF_CONST(-0.60551107), COEF_CONST(0.79583687) },
    { COEF_CONST(-0.61523163), COEF_CONST(0.78834635) },
    { COEF_CONST(-0.62485951), COEF_CONST(0.78073710) },
    { COEF_CONST(-0.63439333), COEF_CONST(0.77301049) },
    { COEF_CONST(-0.64383161), COEF_CONST(0.76516724) },
    { COEF_CONST(-0.65317291), COEF_CONST(0.75720882) },
    { COEF_CONST(-0.66241580), COEF_CONST(0.74913633) },
    { COEF_CONST(-0.67155898), COEF_CONST(0.74095106) },
    { COEF_CONST(-0.68060106), COEF_CONST(0.73265415) },
    { COEF_CONST(-0.68954057), COEF_CONST(0.72424698) },
    { COEF_CONST(-0.69837630), COEF_CONST(0.71573085) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.71573085), COEF_CONST(0.69837624) },
    { COEF_CONST(-0.72424716), COEF_CONST(0.68954051) },
    { COEF_CONST(-0.73265433), COEF_CONST(0.68060094) },
    { COEF_CONST(-0.74095118), COEF_CONST(0.67155886) },
    { COEF_CONST(-0.74913645), COEF_CONST(0.66241562) },
    { COEF_CONST(-0.75720888), COEF_CONST(0.65317285) },
    { COEF_CONST(-0.76516730), COEF_CONST(0.64383155) },
    { COEF_CONST(-0.77301049), COEF_CONST(0.63439327) },
    { COEF_CONST(-0.78073728), COEF_CONST(0.62485945) },
    { COEF_CONST(-0.78834647), COEF_CONST(0.61523151) },
    { COEF_CONST(-0.79583693), COEF_CONST(0.60551095) },
    { COEF_CONST(-0.80320758), COEF_CONST(0.59569913) },
    { COEF_CONST(-0.81045723), COEF_CONST(0.58579785) },
    { COEF_CONST(-0.81758487), COEF_CONST(0.57580817) },
    { COEF_CONST(-0.82458937), COEF_CONST(0.56573176) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.83822477), COEF_CONST(0.54532486) },
    { COEF_CONST(-0.84485358), COEF_CONST(0.53499746) },
    { COEF_CONST(-0.85135525), COEF_CONST(0.52458954) },
    { COEF_CONST(-0.85772866), COEF_CONST(0.51410276) },
    { COEF_CONST(-0.86397290), COEF_CONST(0.50353837) },
    { COEF_CONST(-0.87008703), COEF_CONST(0.49289814) },
    { COEF_CONST(-0.87607014), COEF_CONST(0.48218369) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139663) },
    { COEF_CONST(-0.88763964), COEF_CONST(0.46053857) },
    { COEF_CONST(-0.89322436), COEF_CONST(0.44961137) },
    { COEF_CONST(-0.89867449), COEF_CONST(0.43861625) },
    { COEF_CONST(-0.90398932), COEF_CONST(0.42755505) },
    { COEF_CONST(-0.90916800), COEF_CONST(0.41642949) },
    { COEF_CONST(-0.91420978), COEF_CONST(0.40524122) },
    { COEF_CONST(-0.91911387), COEF_CONST(0.39399192) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.92850614), COEF_CONST(0.37131724) },
    { COEF_CONST(-0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(-0.93733907), COEF_CONST(0.34841865) },
    { COEF_CONST(-0.94154412), COEF_CONST(0.33688980) },
    { COEF_CONST(-0.94560736), COEF_CONST(0.32531020) },
    { COEF_CONST(-0.94952822), COEF_CONST(0.31368160) },
    { COEF_CONST(-0.95330608), COEF_CONST(0.30200580) },
    { COEF_CONST(-0.95694035), COEF_CONST(0.29028472) },
    { COEF_CONST(-0.96043056), COEF_CONST(0.27851969) },
    { COEF_CONST(-0.96377611), COEF_CONST(0.26671273) },
    { COEF_CONST(-0.96697646), COEF_CONST(0.25486559) },
    { COEF_CONST(-0.97003126), COEF_CONST(0.24298008) },
    { COEF_CONST(-0.97293997), COEF_CONST(0.23105797) },
    { COEF_CONST(-0.97570217), COEF_CONST(0.21910107) },
    { COEF_CONST(-0.97831738), COEF_CONST(0.20711140) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.98310548), COEF_CONST(0.18303984) },
    { COEF_CONST(-0.98527765), COEF_CONST(0.17096181) },
    { COEF_CONST(-0.98730141), COEF_CONST(0.15885803) },
    { COEF_CONST(-0.98917651), COEF_CONST(0.14673033) },
    { COEF_CONST(-0.99090266), COEF_CONST(0.13458052) },
    { COEF_CONST(-0.99247956), COEF_CONST(0.12241070) },
    { COEF_CONST(-0.99390697), COEF_CONST(0.11022220) },
    { COEF_CONST(-0.99518472), COEF_CONST(0.09801710) },
    { COEF_CONST(-0.99631262), COEF_CONST(0.08579723) },
    { COEF_CONST(-0.99729049), COEF_CONST(0.07356445) },
    { COEF_CONST(-0.99811810), COEF_CONST(0.06132058) },
    { COEF_CONST(-0.99879545), COEF_CONST(0.04906749) },
    { COEF_CONST(-0.99932241), COEF_CONST(0.03680724) },
    { COEF_CONST(-0.99969882), COEF_CONST(0.02454121) },
    { COEF_CONST(-0.99992472), COEF_CONST(0.01227149) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99969882), COEF_CONST(0.02454123) },
    { COEF_CONST(0.99879545), COEF_CONST(0.04906768) },
    { COEF_CONST(0.99729043), COEF_CONST(0.07356457) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.99247956), COEF_CONST(0.12241068) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.98527765), COEF_CONST(0.17096190) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97570211), COEF_CONST(0.21910124) },
    { COEF_CONST(0.97003126), COEF_CONST(0.24298020) },
    { COEF_CONST(0.96377605), COEF_CONST(0.26671278) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.94952816), COEF_CONST(0.31368175) },
    { COEF_CONST(0.94154406), COEF_CONST(0.33688986) },
    { COEF_CONST(0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91420972), COEF_CONST(0.40524134) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.89322430), COEF_CONST(0.44961134) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.87008697), COEF_CONST(0.49289823) },
    { COEF_CONST(0.85772860), COEF_CONST(0.51410276) },
    { COEF_CONST(0.84485358), COEF_CONST(0.53499764) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.81758481), COEF_CONST(0.57580823) },
    { COEF_CONST(0.80320752), COEF_CONST(0.59569931) },
    { COEF_CONST(0.78834641), COEF_CONST(0.61523163) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.75720882), COEF_CONST(0.65317285) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.72424710), COEF_CONST(0.68954057) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.68954051), COEF_CONST(0.72424710) },
    { COEF_CONST(0.67155892), COEF_CONST(0.74095118) },
    { COEF_CONST(0.65317285), COEF_CONST(0.75720888) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.61523157), COEF_CONST(0.78834641) },
    { COEF_CONST(0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(0.57580817), COEF_CONST(0.81758481) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.53499758), COEF_CONST(0.84485358) },
    { COEF_CONST(0.51410270), COEF_CONST(0.85772866) },
    { COEF_CONST(0.49289817), COEF_CONST(0.87008697) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.44961131), COEF_CONST(0.89322430) },
    { COEF_CONST(0.42755505), COEF_CONST(0.90398932) },
    { COEF_CONST(0.40524128), COEF_CONST(0.91420978) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.35989499), COEF_CONST(0.93299282) },
    { COEF_CONST(0.33688983), COEF_CONST(0.94154406) },
    { COEF_CONST(0.31368172), COEF_CONST(0.94952822) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.26671273), COEF_CONST(0.96377605) },
    { COEF_CONST(0.24298014), COEF_CONST(0.97003126) },
    { COEF_CONST(0.21910121), COEF_CONST(0.97570211) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.17096186), COEF_CONST(0.98527765) },
    { COEF_CONST(0.14673044), COEF_CONST(0.98917651) },
    { COEF_CONST(0.12241063), COEF_CONST(0.99247956) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(0.07356452), COEF_CONST(0.99729043) },
    { COEF_CONST(0.04906763), COEF_CONST(0.99879545) },
    { COEF_CONST(0.02454119), COEF_CONST(0.99969882) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99879545), COEF_CONST(0.04906768) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97003126), COEF_CONST(0.24298020) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.94154406), COEF_CONST(0.33688986) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.85772860), COEF_CONST(0.51410276) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.80320752), COEF_CONST(0.59569931) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.67155892), COEF_CONST(0.74095118) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.51410270), COEF_CONST(0.85772866) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.42755505), COEF_CONST(0.90398932) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.33688983), COEF_CONST(0.94154406) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.24298014), COEF_CONST(0.97003126) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.14673044), COEF_CONST(0.98917651) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(0.04906763), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.04906772), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.09801719), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.14673053), COEF_CONST(0.98917651) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.24298023), COEF_CONST(0.97003126) },
    { COEF_CONST(-0.29028472), COEF_CONST(0.95694029) },
    { COEF_CONST(-0.33688989), COEF_CONST(0.94154406) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.42755514), COEF_CONST(0.90398932) },
    { COEF_CONST(-0.47139677), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.51410282), COEF_CONST(0.85772860) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.59569937), COEF_CONST(0.80320752) },
    { COEF_CONST(-0.63439333), COEF_CONST(0.77301049) },
    { COEF_CONST(-0.67155898), COEF_CONST(0.74095106) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.74095118), COEF_CONST(0.67155886) },
    { COEF_CONST(-0.77301049), COEF_CONST(0.63439327) },
    { COEF_CONST(-0.80320758), COEF_CONST(0.59569913) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.85772866), COEF_CONST(0.51410276) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139663) },
    { COEF_CONST(-0.90398932), COEF_CONST(0.42755505) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.94154412), COEF_CONST(0.33688980) },
    { COEF_CONST(-0.95694035), COEF_CONST(0.29028472) },
    { COEF_CONST(-0.97003126), COEF_CONST(0.24298008) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.98917651), COEF_CONST(0.14673033) },
    { COEF_CONST(-0.99518472), COEF_CONST(0.09801710) },
    { COEF_CONST(-0.99879545), COEF_CONST(0.04906749) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99729043), COEF_CONST(0.07356457) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.97570211), COEF_CONST(0.21910124) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.87008697), COEF_CONST(0.49289823) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.78834641), COEF_CONST(0.61523157) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.68954057), COEF_CONST(0.72424710) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.57580817), COEF_CONST(0.81758481) },
    { COEF_CONST(0.51410276), COEF_CONST(0.85772866) },
    { COEF_CONST(0.44961134), COEF_CONST(0.89322430) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(0.31368175), COEF_CONST(0.94952816) },
    { COEF_CONST(0.24298018), COEF_CONST(0.97003126) },
    { COEF_CONST(0.17096189), COEF_CONST(0.98527765) },
    { COEF_CONST(0.09801713), COEF_CONST(0.99518472) },
    { COEF_CONST(0.02454123), COEF_CONST(0.99969882) },
    { COEF_CONST(-0.04906768), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.12241068), COEF_CONST(0.99247950) },
    { COEF_CONST(-0.19509032), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.26671275), COEF_CONST(0.96377605) },
    { COEF_CONST(-0.33688986), COEF_CONST(0.94154406) },
    { COEF_CONST(-0.40524131), COEF_CONST(0.91420972) },
    { COEF_CONST(-0.47139674), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.53499764), COEF_CONST(0.84485352) },
    { COEF_CONST(-0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(-0.65317285), COEF_CONST(0.75720882) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.75720882), COEF_CONST(0.65317285) },
    { COEF_CONST(-0.80320752), COEF_CONST(0.59569937) },
    { COEF_CONST(-0.84485358), COEF_CONST(0.53499770) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139683) },
    { COEF_CONST(-0.91420978), COEF_CONST(0.40524122) },
    { COEF_CONST(-0.94154406), COEF_CONST(0.33688980) },
    { COEF_CONST(-0.96377605), COEF_CONST(0.26671273) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.99247956), COEF_CONST(0.12241070) },
    { COEF_CONST(-0.99879545), COEF_CONST(0.04906772) },
    { COEF_CONST(-0.99969882), COEF_CONST(-0.02454115) },
    { COEF_CONST(-0.99518472), COEF_CONST(-0.09801727) },
    { COEF_CONST(-0.98527765), COEF_CONST(-0.17096199) },
    { COEF_CONST(-0.97003126), COEF_CONST(-0.24298024) },
    { COEF_CONST(-0.94952816), COEF_CONST(-0.31368178) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.89322430), COEF_CONST(-0.44961131) },
    { COEF_CONST(-0.85772860), COEF_CONST(-0.51410270) },
    { COEF_CONST(-0.81758481), COEF_CONST(-0.57580811) },
    { COEF_CONST(-0.77301043), COEF_CONST(-0.63439322) },
    { COEF_CONST(-0.72424710), COEF_CONST(-0.68954062) },
    { COEF_CONST(-0.67155898), COEF_CONST(-0.74095118) },
    { COEF_CONST(-0.61523157), COEF_CONST(-0.78834647) },
    { COEF_CONST(-0.55557024), COEF_CONST(-0.83146977) },
    { COEF_CONST(-0.49289820), COEF_CONST(-0.87008697) },
    { COEF_CONST(-0.42755508), COEF_CONST(-0.90398937) },
    { COEF_CONST(-0.35989502), COEF_CONST(-0.93299276) },
    { COEF_CONST(-0.29028466), COEF_CONST(-0.95694035) },
    { COEF_CONST(-0.21910124), COEF_CONST(-0.97570211) },
    { COEF_CONST(-0.14673047), COEF_CONST(-0.98917651) },
    { COEF_CONST(-0.07356455), COEF_CONST(-0.99729043) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(0.09801713), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.19509032), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.47139674), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139683) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.99518472), COEF_CONST(-0.09801727) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.77301043), COEF_CONST(-0.63439322) },
    { COEF_CONST(-0.55557024), COEF_CONST(-0.83146977) },
    { COEF_CONST(-0.29028466), COEF_CONST(-0.95694035) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.00000001), COEF_CONST(-1.00000000) }
};

complex_t cfft_tab_480[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99991435), COEF_CONST(0.01308960) },
    { COEF_CONST(0.99965733), COEF_CONST(0.02617695) },
    { COEF_CONST(0.99922901), COEF_CONST(0.03925982) },
    { COEF_CONST(0.99862951), COEF_CONST(0.05233596) },
    { COEF_CONST(0.99785894), COEF_CONST(0.06540313) },
    { COEF_CONST(0.99691731), COEF_CONST(0.07845910) },
    { COEF_CONST(0.99580491), COEF_CONST(0.09150162) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.99306846), COEF_CONST(0.11753740) },
    { COEF_CONST(0.99144489), COEF_CONST(0.13052620) },
    { COEF_CONST(0.98965138), COEF_CONST(0.14349262) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.98555607), COEF_CONST(0.16934951) },
    { COEF_CONST(0.98325491), COEF_CONST(0.18223552) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.97534233), COEF_CONST(0.22069745) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.96923089), COEF_CONST(0.24615330) },
    { COEF_CONST(0.96592581), COEF_CONST(0.25881904) },
    { COEF_CONST(0.96245521), COEF_CONST(0.27144045) },
    { COEF_CONST(0.95881975), COEF_CONST(0.28401536) },
    { COEF_CONST(0.95501995), COEF_CONST(0.29654160) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.94693011), COEF_CONST(0.32143945) },
    { COEF_CONST(0.94264150), COEF_CONST(0.33380687) },
    { COEF_CONST(0.93819135), COEF_CONST(0.34611708) },
    { COEF_CONST(0.93358040), COEF_CONST(0.35836795) },
    { COEF_CONST(0.92880952), COEF_CONST(0.37055743) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91879123), COEF_CONST(0.39474389) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.90814316), COEF_CONST(0.41865975) },
    { COEF_CONST(0.90258527), COEF_CONST(0.43051112) },
    { COEF_CONST(0.89687276), COEF_CONST(0.44228873) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.88498765), COEF_CONST(0.46561453) },
    { COEF_CONST(0.87881708), COEF_CONST(0.47715878) },
    { COEF_CONST(0.87249601), COEF_CONST(0.48862126) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.85940641), COEF_CONST(0.51129311) },
    { COEF_CONST(0.85264015), COEF_CONST(0.52249855) },
    { COEF_CONST(0.84572780), COEF_CONST(0.53361452) },
    { COEF_CONST(0.83867055), COEF_CONST(0.54463905) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.82412618), COEF_CONST(0.56640625) },
    { COEF_CONST(0.81664157), COEF_CONST(0.57714522) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.80125380), COEF_CONST(0.59832460) },
    { COEF_CONST(0.79335332), COEF_CONST(0.60876143) },
    { COEF_CONST(0.78531694), COEF_CONST(0.61909395) },
    { COEF_CONST(0.77714592), COEF_CONST(0.62932038) },
    { COEF_CONST(0.76884180), COEF_CONST(0.63943899) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.75183982), COEF_CONST(0.65934587) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.73432249), COEF_CONST(0.67880076) },
    { COEF_CONST(0.72537434), COEF_CONST(0.68835455) },
    { COEF_CONST(0.71630192), COEF_CONST(0.69779050) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.69779044), COEF_CONST(0.71630198) },
    { COEF_CONST(0.68835455), COEF_CONST(0.72537440) },
    { COEF_CONST(0.67880070), COEF_CONST(0.73432255) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.65934581), COEF_CONST(0.75183982) },
    { COEF_CONST(0.64944804), COEF_CONST(0.76040596) },
    { COEF_CONST(0.63943899), COEF_CONST(0.76884186) },
    { COEF_CONST(0.62932038), COEF_CONST(0.77714598) },
    { COEF_CONST(0.61909395), COEF_CONST(0.78531694) },
    { COEF_CONST(0.60876143), COEF_CONST(0.79335338) },
    { COEF_CONST(0.59832460), COEF_CONST(0.80125386) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.57714516), COEF_CONST(0.81664157) },
    { COEF_CONST(0.56640619), COEF_CONST(0.82412618) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.54463899), COEF_CONST(0.83867061) },
    { COEF_CONST(0.53361452), COEF_CONST(0.84572780) },
    { COEF_CONST(0.52249855), COEF_CONST(0.85264021) },
    { COEF_CONST(0.51129305), COEF_CONST(0.85940641) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.48862121), COEF_CONST(0.87249607) },
    { COEF_CONST(0.47715873), COEF_CONST(0.87881714) },
    { COEF_CONST(0.46561450), COEF_CONST(0.88498765) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.44228867), COEF_CONST(0.89687276) },
    { COEF_CONST(0.43051106), COEF_CONST(0.90258533) },
    { COEF_CONST(0.41865972), COEF_CONST(0.90814316) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.39474383), COEF_CONST(0.91879123) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.37055740), COEF_CONST(0.92880958) },
    { COEF_CONST(0.35836792), COEF_CONST(0.93358046) },
    { COEF_CONST(0.34611702), COEF_CONST(0.93819135) },
    { COEF_CONST(0.33380681), COEF_CONST(0.94264150) },
    { COEF_CONST(0.32143945), COEF_CONST(0.94693011) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.29654154), COEF_CONST(0.95501995) },
    { COEF_CONST(0.28401530), COEF_CONST(0.95881975) },
    { COEF_CONST(0.27144042), COEF_CONST(0.96245527) },
    { COEF_CONST(0.25881901), COEF_CONST(0.96592581) },
    { COEF_CONST(0.24615325), COEF_CONST(0.96923089) },
    { COEF_CONST(0.23344533), COEF_CONST(0.97236991) },
    { COEF_CONST(0.22069740), COEF_CONST(0.97534233) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.18223549), COEF_CONST(0.98325491) },
    { COEF_CONST(0.16934946), COEF_CONST(0.98555607) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.14349258), COEF_CONST(0.98965138) },
    { COEF_CONST(0.13052616), COEF_CONST(0.99144489) },
    { COEF_CONST(0.11753736), COEF_CONST(0.99306846) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(0.09150158), COEF_CONST(0.99580491) },
    { COEF_CONST(0.07845905), COEF_CONST(0.99691731) },
    { COEF_CONST(0.06540309), COEF_CONST(0.99785894) },
    { COEF_CONST(0.05233591), COEF_CONST(0.99862951) },
    { COEF_CONST(0.03925977), COEF_CONST(0.99922901) },
    { COEF_CONST(0.02617691), COEF_CONST(0.99965733) },
    { COEF_CONST(0.01308955), COEF_CONST(0.99991435) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.01308964), COEF_CONST(0.99991435) },
    { COEF_CONST(-0.02617699), COEF_CONST(0.99965733) },
    { COEF_CONST(-0.03925986), COEF_CONST(0.99922901) },
    { COEF_CONST(-0.05233600), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.06540318), COEF_CONST(0.99785894) },
    { COEF_CONST(-0.07845914), COEF_CONST(0.99691731) },
    { COEF_CONST(-0.09150167), COEF_CONST(0.99580491) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.11753745), COEF_CONST(0.99306846) },
    { COEF_CONST(-0.13052624), COEF_CONST(0.99144489) },
    { COEF_CONST(-0.14349267), COEF_CONST(0.98965138) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.16934955), COEF_CONST(0.98555607) },
    { COEF_CONST(-0.18223557), COEF_CONST(0.98325491) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.22069748), COEF_CONST(0.97534227) },
    { COEF_CONST(-0.23344541), COEF_CONST(0.97236991) },
    { COEF_CONST(-0.24615334), COEF_CONST(0.96923089) },
    { COEF_CONST(-0.25881910), COEF_CONST(0.96592581) },
    { COEF_CONST(-0.27144051), COEF_CONST(0.96245521) },
    { COEF_CONST(-0.28401539), COEF_CONST(0.95881969) },
    { COEF_CONST(-0.29654163), COEF_CONST(0.95501995) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.32143950), COEF_CONST(0.94693011) },
    { COEF_CONST(-0.33380690), COEF_CONST(0.94264150) },
    { COEF_CONST(-0.34611711), COEF_CONST(0.93819129) },
    { COEF_CONST(-0.35836801), COEF_CONST(0.93358046) },
    { COEF_CONST(-0.37055749), COEF_CONST(0.92880952) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.39474392), COEF_CONST(0.91879123) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(-0.41865978), COEF_CONST(0.90814310) },
    { COEF_CONST(-0.43051115), COEF_CONST(0.90258527) },
    { COEF_CONST(-0.44228873), COEF_CONST(0.89687276) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.46561456), COEF_CONST(0.88498759) },
    { COEF_CONST(-0.47715881), COEF_CONST(0.87881714) },
    { COEF_CONST(-0.48862129), COEF_CONST(0.87249595) },
    { COEF_CONST(-0.50000006), COEF_CONST(0.86602539) },
    { COEF_CONST(-0.51129311), COEF_CONST(0.85940641) },
    { COEF_CONST(-0.52249861), COEF_CONST(0.85264009) },
    { COEF_CONST(-0.53361458), COEF_CONST(0.84572780) },
    { COEF_CONST(-0.54463911), COEF_CONST(0.83867055) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.56640631), COEF_CONST(0.82412612) },
    { COEF_CONST(-0.57714522), COEF_CONST(0.81664157) },
    { COEF_CONST(-0.58778530), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.59832466), COEF_CONST(0.80125374) },
    { COEF_CONST(-0.60876149), COEF_CONST(0.79335332) },
    { COEF_CONST(-0.61909401), COEF_CONST(0.78531694) },
    { COEF_CONST(-0.62932044), COEF_CONST(0.77714586) },
    { COEF_CONST(-0.63943905), COEF_CONST(0.76884180) },
    { COEF_CONST(-0.64944810), COEF_CONST(0.76040596) },
    { COEF_CONST(-0.65934587), COEF_CONST(0.75183970) },
    { COEF_CONST(-0.66913068), COEF_CONST(0.74314481) },
    { COEF_CONST(-0.67880082), COEF_CONST(0.73432249) },
    { COEF_CONST(-0.68835461), COEF_CONST(0.72537428) },
    { COEF_CONST(-0.69779050), COEF_CONST(0.71630186) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.71630198), COEF_CONST(0.69779032) },
    { COEF_CONST(-0.72537440), COEF_CONST(0.68835449) },
    { COEF_CONST(-0.73432255), COEF_CONST(0.67880070) },
    { COEF_CONST(-0.74314487), COEF_CONST(0.66913044) },
    { COEF_CONST(-0.75183988), COEF_CONST(0.65934575) },
    { COEF_CONST(-0.76040602), COEF_CONST(0.64944804) },
    { COEF_CONST(-0.76884186), COEF_CONST(0.63943905) },
    { COEF_CONST(-0.77714598), COEF_CONST(0.62932026) },
    { COEF_CONST(-0.78531694), COEF_CONST(0.61909389) },
    { COEF_CONST(-0.79335338), COEF_CONST(0.60876143) },
    { COEF_CONST(-0.80125386), COEF_CONST(0.59832448) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.81664157), COEF_CONST(0.57714522) },
    { COEF_CONST(-0.82412624), COEF_CONST(0.56640613) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.83867061), COEF_CONST(0.54463905) },
    { COEF_CONST(-0.84572786), COEF_CONST(0.53361434) },
    { COEF_CONST(-0.85264021), COEF_CONST(0.52249849) },
    { COEF_CONST(-0.85940647), COEF_CONST(0.51129305) },
    { COEF_CONST(-0.86602545), COEF_CONST(0.50000006) },
    { COEF_CONST(-0.87249607), COEF_CONST(0.48862115) },
    { COEF_CONST(-0.87881714), COEF_CONST(0.47715873) },
    { COEF_CONST(-0.88498765), COEF_CONST(0.46561456) },
    { COEF_CONST(-0.89100653), COEF_CONST(0.45399037) },
    { COEF_CONST(-0.89687276), COEF_CONST(0.44228864) },
    { COEF_CONST(-0.90258533), COEF_CONST(0.43051112) },
    { COEF_CONST(-0.90814322), COEF_CONST(0.41865960) },
    { COEF_CONST(-0.91354549), COEF_CONST(0.40673658) },
    { COEF_CONST(-0.91879123), COEF_CONST(0.39474386) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.92880958), COEF_CONST(0.37055734) },
    { COEF_CONST(-0.93358046), COEF_CONST(0.35836792) },
    { COEF_CONST(-0.93819135), COEF_CONST(0.34611690) },
    { COEF_CONST(-0.94264150), COEF_CONST(0.33380675) },
    { COEF_CONST(-0.94693017), COEF_CONST(0.32143945) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.95501995), COEF_CONST(0.29654145) },
    { COEF_CONST(-0.95881975), COEF_CONST(0.28401530) },
    { COEF_CONST(-0.96245527), COEF_CONST(0.27144048) },
    { COEF_CONST(-0.96592587), COEF_CONST(0.25881892) },
    { COEF_CONST(-0.96923095), COEF_CONST(0.24615324) },
    { COEF_CONST(-0.97236997), COEF_CONST(0.23344538) },
    { COEF_CONST(-0.97534233), COEF_CONST(0.22069728) },
    { COEF_CONST(-0.97814763), COEF_CONST(0.20791161) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.98325491), COEF_CONST(0.18223536) },
    { COEF_CONST(-0.98555607), COEF_CONST(0.16934940) },
    { COEF_CONST(-0.98768836), COEF_CONST(0.15643445) },
    { COEF_CONST(-0.98965138), COEF_CONST(0.14349243) },
    { COEF_CONST(-0.99144489), COEF_CONST(0.13052608) },
    { COEF_CONST(-0.99306846), COEF_CONST(0.11753736) },
    { COEF_CONST(-0.99452192), COEF_CONST(0.10452849) },
    { COEF_CONST(-0.99580491), COEF_CONST(0.09150149) },
    { COEF_CONST(-0.99691737), COEF_CONST(0.07845904) },
    { COEF_CONST(-0.99785894), COEF_CONST(0.06540315) },
    { COEF_CONST(-0.99862951), COEF_CONST(0.05233581) },
    { COEF_CONST(-0.99922901), COEF_CONST(0.03925974) },
    { COEF_CONST(-0.99965733), COEF_CONST(0.02617695) },
    { COEF_CONST(-0.99991435), COEF_CONST(0.01308943) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99965733), COEF_CONST(0.02617695) },
    { COEF_CONST(0.99862951), COEF_CONST(0.05233596) },
    { COEF_CONST(0.99691731), COEF_CONST(0.07845910) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.99144489), COEF_CONST(0.13052620) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.98325491), COEF_CONST(0.18223552) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.96592581), COEF_CONST(0.25881904) },
    { COEF_CONST(0.95881975), COEF_CONST(0.28401536) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.94264150), COEF_CONST(0.33380687) },
    { COEF_CONST(0.93358040), COEF_CONST(0.35836795) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.90258527), COEF_CONST(0.43051112) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.87881708), COEF_CONST(0.47715878) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.85264015), COEF_CONST(0.52249855) },
    { COEF_CONST(0.83867055), COEF_CONST(0.54463905) },
    { COEF_CONST(0.82412618), COEF_CONST(0.56640625) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.79335332), COEF_CONST(0.60876143) },
    { COEF_CONST(0.77714592), COEF_CONST(0.62932038) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.72537434), COEF_CONST(0.68835455) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.68835455), COEF_CONST(0.72537440) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.64944804), COEF_CONST(0.76040596) },
    { COEF_CONST(0.62932038), COEF_CONST(0.77714598) },
    { COEF_CONST(0.60876143), COEF_CONST(0.79335338) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.56640619), COEF_CONST(0.82412618) },
    { COEF_CONST(0.54463899), COEF_CONST(0.83867061) },
    { COEF_CONST(0.52249855), COEF_CONST(0.85264021) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.47715873), COEF_CONST(0.87881714) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.43051106), COEF_CONST(0.90258533) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.35836792), COEF_CONST(0.93358046) },
    { COEF_CONST(0.33380681), COEF_CONST(0.94264150) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.28401530), COEF_CONST(0.95881975) },
    { COEF_CONST(0.25881901), COEF_CONST(0.96592581) },
    { COEF_CONST(0.23344533), COEF_CONST(0.97236991) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.18223549), COEF_CONST(0.98325491) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.13052616), COEF_CONST(0.99144489) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(0.07845905), COEF_CONST(0.99691731) },
    { COEF_CONST(0.05233591), COEF_CONST(0.99862951) },
    { COEF_CONST(0.02617691), COEF_CONST(0.99965733) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.02617699), COEF_CONST(0.99965733) },
    { COEF_CONST(-0.05233600), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.07845914), COEF_CONST(0.99691731) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.13052624), COEF_CONST(0.99144489) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.18223557), COEF_CONST(0.98325491) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.23344541), COEF_CONST(0.97236991) },
    { COEF_CONST(-0.25881910), COEF_CONST(0.96592581) },
    { COEF_CONST(-0.28401539), COEF_CONST(0.95881969) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.33380690), COEF_CONST(0.94264150) },
    { COEF_CONST(-0.35836801), COEF_CONST(0.93358046) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(-0.43051115), COEF_CONST(0.90258527) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.47715881), COEF_CONST(0.87881714) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99862951), COEF_CONST(0.05233596) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.96592581), COEF_CONST(0.25881904) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.93358040), COEF_CONST(0.35836795) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.83867055), COEF_CONST(0.54463905) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.77714592), COEF_CONST(0.62932038) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.62932038), COEF_CONST(0.77714598) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.54463899), COEF_CONST(0.83867061) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.35836792), COEF_CONST(0.93358046) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.25881901), COEF_CONST(0.96592581) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(0.05233591), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.05233600), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.25881910), COEF_CONST(0.96592581) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.35836801), COEF_CONST(0.93358046) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.50000006), COEF_CONST(0.86602539) },
    { COEF_CONST(-0.54463911), COEF_CONST(0.83867055) },
    { COEF_CONST(-0.58778530), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.62932044), COEF_CONST(0.77714586) },
    { COEF_CONST(-0.66913068), COEF_CONST(0.74314481) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.74314487), COEF_CONST(0.66913044) },
    { COEF_CONST(-0.77714598), COEF_CONST(0.62932026) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.83867061), COEF_CONST(0.54463905) },
    { COEF_CONST(-0.86602545), COEF_CONST(0.50000006) },
    { COEF_CONST(-0.89100653), COEF_CONST(0.45399037) },
    { COEF_CONST(-0.91354549), COEF_CONST(0.40673658) },
    { COEF_CONST(-0.93358046), COEF_CONST(0.35836792) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.96592587), COEF_CONST(0.25881892) },
    { COEF_CONST(-0.97814763), COEF_CONST(0.20791161) },
    { COEF_CONST(-0.98768836), COEF_CONST(0.15643445) },
    { COEF_CONST(-0.99452192), COEF_CONST(0.10452849) },
    { COEF_CONST(-0.99862951), COEF_CONST(0.05233581) },
    { COEF_CONST(-1.00000000), COEF_CONST(-0.00000009) },
    { COEF_CONST(-0.99862951), COEF_CONST(-0.05233599) },
    { COEF_CONST(-0.99452186), COEF_CONST(-0.10452867) },
    { COEF_CONST(-0.98768830), COEF_CONST(-0.15643461) },
    { COEF_CONST(-0.97814757), COEF_CONST(-0.20791179) },
    { COEF_CONST(-0.96592581), COEF_CONST(-0.25881907) },
    { COEF_CONST(-0.95105648), COEF_CONST(-0.30901697) },
    { COEF_CONST(-0.93358040), COEF_CONST(-0.35836810) },
    { COEF_CONST(-0.91354543), COEF_CONST(-0.40673673) },
    { COEF_CONST(-0.89100647), COEF_CONST(-0.45399055) },
    { COEF_CONST(-0.86602533), COEF_CONST(-0.50000018) },
    { COEF_CONST(-0.83867049), COEF_CONST(-0.54463917) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(-0.77714592), COEF_CONST(-0.62932044) },
    { COEF_CONST(-0.74314475), COEF_CONST(-0.66913062) },
    { COEF_CONST(-0.70710671), COEF_CONST(-0.70710689) },
    { COEF_CONST(-0.66913050), COEF_CONST(-0.74314487) },
    { COEF_CONST(-0.62932032), COEF_CONST(-0.77714598) },
    { COEF_CONST(-0.58778518), COEF_CONST(-0.80901712) },
    { COEF_CONST(-0.54463893), COEF_CONST(-0.83867055) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99691731), COEF_CONST(0.07845910) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.85264015), COEF_CONST(0.52249855) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.64944804), COEF_CONST(0.76040596) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.52249855), COEF_CONST(0.85264021) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.23344533), COEF_CONST(0.97236991) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.07845905), COEF_CONST(0.99691731) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.58778530), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.89100653), COEF_CONST(0.45399037) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.98768836), COEF_CONST(0.15643445) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.07845914), COEF_CONST(0.99691731) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.52249861), COEF_CONST(0.85264009) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.85264021), COEF_CONST(0.52249849) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.99691737), COEF_CONST(0.07845904) },
    { COEF_CONST(-0.98768830), COEF_CONST(-0.15643461) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(-0.64944798), COEF_CONST(-0.76040608) },
    { COEF_CONST(-0.45399040), COEF_CONST(-0.89100665) },
    { COEF_CONST(-0.23344524), COEF_CONST(-0.97236991) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.30901712), COEF_CONST(-0.95105648) }
};

complex_t cfft_tab_64[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(0.09801713), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.19509032), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.47139674), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139683) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.99518472), COEF_CONST(-0.09801727) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.77301043), COEF_CONST(-0.63439322) },
    { COEF_CONST(-0.55557024), COEF_CONST(-0.83146977) },
    { COEF_CONST(-0.29028466), COEF_CONST(-0.95694035) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.00000001), COEF_CONST(-1.00000000) }
};

complex_t cfft_tab_60[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.50000006), COEF_CONST(0.86602539) },
    { COEF_CONST(-0.66913068), COEF_CONST(0.74314481) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.91354549), COEF_CONST(0.40673658) },
    { COEF_CONST(-0.97814763), COEF_CONST(0.20791161) },
    { COEF_CONST(-1.00000000), COEF_CONST(-0.00000009) },
    { COEF_CONST(-0.97814757), COEF_CONST(-0.20791179) },
    { COEF_CONST(-0.91354543), COEF_CONST(-0.40673673) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(-0.66913050), COEF_CONST(-0.74314487) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.30901712), COEF_CONST(-0.95105648) }
};

#ifdef LD_DEC

complex_t cfft_tab_256[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99969882), COEF_CONST(0.02454123) },
    { COEF_CONST(0.99879545), COEF_CONST(0.04906768) },
    { COEF_CONST(0.99729043), COEF_CONST(0.07356457) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.99247956), COEF_CONST(0.12241068) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.98527765), COEF_CONST(0.17096190) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97570211), COEF_CONST(0.21910124) },
    { COEF_CONST(0.97003126), COEF_CONST(0.24298020) },
    { COEF_CONST(0.96377605), COEF_CONST(0.26671278) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.94952816), COEF_CONST(0.31368175) },
    { COEF_CONST(0.94154406), COEF_CONST(0.33688986) },
    { COEF_CONST(0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91420972), COEF_CONST(0.40524134) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.89322430), COEF_CONST(0.44961134) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.87008697), COEF_CONST(0.49289823) },
    { COEF_CONST(0.85772860), COEF_CONST(0.51410276) },
    { COEF_CONST(0.84485358), COEF_CONST(0.53499764) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.81758481), COEF_CONST(0.57580823) },
    { COEF_CONST(0.80320752), COEF_CONST(0.59569931) },
    { COEF_CONST(0.78834641), COEF_CONST(0.61523163) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.75720882), COEF_CONST(0.65317285) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.72424710), COEF_CONST(0.68954057) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.68954051), COEF_CONST(0.72424710) },
    { COEF_CONST(0.67155892), COEF_CONST(0.74095118) },
    { COEF_CONST(0.65317285), COEF_CONST(0.75720888) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.61523157), COEF_CONST(0.78834641) },
    { COEF_CONST(0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(0.57580817), COEF_CONST(0.81758481) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.53499758), COEF_CONST(0.84485358) },
    { COEF_CONST(0.51410270), COEF_CONST(0.85772866) },
    { COEF_CONST(0.49289817), COEF_CONST(0.87008697) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.44961131), COEF_CONST(0.89322430) },
    { COEF_CONST(0.42755505), COEF_CONST(0.90398932) },
    { COEF_CONST(0.40524128), COEF_CONST(0.91420978) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.35989499), COEF_CONST(0.93299282) },
    { COEF_CONST(0.33688983), COEF_CONST(0.94154406) },
    { COEF_CONST(0.31368172), COEF_CONST(0.94952822) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.26671273), COEF_CONST(0.96377605) },
    { COEF_CONST(0.24298014), COEF_CONST(0.97003126) },
    { COEF_CONST(0.21910121), COEF_CONST(0.97570211) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.17096186), COEF_CONST(0.98527765) },
    { COEF_CONST(0.14673044), COEF_CONST(0.98917651) },
    { COEF_CONST(0.12241063), COEF_CONST(0.99247956) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(0.07356452), COEF_CONST(0.99729043) },
    { COEF_CONST(0.04906763), COEF_CONST(0.99879545) },
    { COEF_CONST(0.02454119), COEF_CONST(0.99969882) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99879545), COEF_CONST(0.04906768) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.97003126), COEF_CONST(0.24298020) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.94154406), COEF_CONST(0.33688986) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.85772860), COEF_CONST(0.51410276) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.80320752), COEF_CONST(0.59569931) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.67155892), COEF_CONST(0.74095118) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.51410270), COEF_CONST(0.85772866) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.42755505), COEF_CONST(0.90398932) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.33688983), COEF_CONST(0.94154406) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.24298014), COEF_CONST(0.97003126) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.14673044), COEF_CONST(0.98917651) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(0.04906763), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.04906772), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.09801719), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.14673053), COEF_CONST(0.98917651) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.24298023), COEF_CONST(0.97003126) },
    { COEF_CONST(-0.29028472), COEF_CONST(0.95694029) },
    { COEF_CONST(-0.33688989), COEF_CONST(0.94154406) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.42755514), COEF_CONST(0.90398932) },
    { COEF_CONST(-0.47139677), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.51410282), COEF_CONST(0.85772860) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.59569937), COEF_CONST(0.80320752) },
    { COEF_CONST(-0.63439333), COEF_CONST(0.77301049) },
    { COEF_CONST(-0.67155898), COEF_CONST(0.74095106) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.74095118), COEF_CONST(0.67155886) },
    { COEF_CONST(-0.77301049), COEF_CONST(0.63439327) },
    { COEF_CONST(-0.80320758), COEF_CONST(0.59569913) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.85772866), COEF_CONST(0.51410276) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139663) },
    { COEF_CONST(-0.90398932), COEF_CONST(0.42755505) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.94154412), COEF_CONST(0.33688980) },
    { COEF_CONST(-0.95694035), COEF_CONST(0.29028472) },
    { COEF_CONST(-0.97003126), COEF_CONST(0.24298008) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.98917651), COEF_CONST(0.14673033) },
    { COEF_CONST(-0.99518472), COEF_CONST(0.09801710) },
    { COEF_CONST(-0.99879545), COEF_CONST(0.04906749) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99729043), COEF_CONST(0.07356457) },
    { COEF_CONST(0.98917651), COEF_CONST(0.14673047) },
    { COEF_CONST(0.97570211), COEF_CONST(0.21910124) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.93299282), COEF_CONST(0.35989505) },
    { COEF_CONST(0.90398932), COEF_CONST(0.42755508) },
    { COEF_CONST(0.87008697), COEF_CONST(0.49289823) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.78834641), COEF_CONST(0.61523157) },
    { COEF_CONST(0.74095112), COEF_CONST(0.67155898) },
    { COEF_CONST(0.68954057), COEF_CONST(0.72424710) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.57580817), COEF_CONST(0.81758481) },
    { COEF_CONST(0.51410276), COEF_CONST(0.85772866) },
    { COEF_CONST(0.44961134), COEF_CONST(0.89322430) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(0.31368175), COEF_CONST(0.94952816) },
    { COEF_CONST(0.24298018), COEF_CONST(0.97003126) },
    { COEF_CONST(0.17096189), COEF_CONST(0.98527765) },
    { COEF_CONST(0.09801713), COEF_CONST(0.99518472) },
    { COEF_CONST(0.02454123), COEF_CONST(0.99969882) },
    { COEF_CONST(-0.04906768), COEF_CONST(0.99879545) },
    { COEF_CONST(-0.12241068), COEF_CONST(0.99247950) },
    { COEF_CONST(-0.19509032), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.26671275), COEF_CONST(0.96377605) },
    { COEF_CONST(-0.33688986), COEF_CONST(0.94154406) },
    { COEF_CONST(-0.40524131), COEF_CONST(0.91420972) },
    { COEF_CONST(-0.47139674), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.53499764), COEF_CONST(0.84485352) },
    { COEF_CONST(-0.59569931), COEF_CONST(0.80320752) },
    { COEF_CONST(-0.65317285), COEF_CONST(0.75720882) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.75720882), COEF_CONST(0.65317285) },
    { COEF_CONST(-0.80320752), COEF_CONST(0.59569937) },
    { COEF_CONST(-0.84485358), COEF_CONST(0.53499770) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139683) },
    { COEF_CONST(-0.91420978), COEF_CONST(0.40524122) },
    { COEF_CONST(-0.94154406), COEF_CONST(0.33688980) },
    { COEF_CONST(-0.96377605), COEF_CONST(0.26671273) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.99247956), COEF_CONST(0.12241070) },
    { COEF_CONST(-0.99879545), COEF_CONST(0.04906772) },
    { COEF_CONST(-0.99969882), COEF_CONST(-0.02454115) },
    { COEF_CONST(-0.99518472), COEF_CONST(-0.09801727) },
    { COEF_CONST(-0.98527765), COEF_CONST(-0.17096199) },
    { COEF_CONST(-0.97003126), COEF_CONST(-0.24298024) },
    { COEF_CONST(-0.94952816), COEF_CONST(-0.31368178) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.89322430), COEF_CONST(-0.44961131) },
    { COEF_CONST(-0.85772860), COEF_CONST(-0.51410270) },
    { COEF_CONST(-0.81758481), COEF_CONST(-0.57580811) },
    { COEF_CONST(-0.77301043), COEF_CONST(-0.63439322) },
    { COEF_CONST(-0.72424710), COEF_CONST(-0.68954062) },
    { COEF_CONST(-0.67155898), COEF_CONST(-0.74095118) },
    { COEF_CONST(-0.61523157), COEF_CONST(-0.78834647) },
    { COEF_CONST(-0.55557024), COEF_CONST(-0.83146977) },
    { COEF_CONST(-0.49289820), COEF_CONST(-0.87008697) },
    { COEF_CONST(-0.42755508), COEF_CONST(-0.90398937) },
    { COEF_CONST(-0.35989502), COEF_CONST(-0.93299276) },
    { COEF_CONST(-0.29028466), COEF_CONST(-0.95694035) },
    { COEF_CONST(-0.21910124), COEF_CONST(-0.97570211) },
    { COEF_CONST(-0.14673047), COEF_CONST(-0.98917651) },
    { COEF_CONST(-0.07356455), COEF_CONST(-0.99729043) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99518472), COEF_CONST(0.09801714) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.88192123), COEF_CONST(0.47139674) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.77301043), COEF_CONST(0.63439333) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.47139671), COEF_CONST(0.88192129) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.29028463), COEF_CONST(0.95694035) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(0.09801710), COEF_CONST(0.99518472) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.98078525), COEF_CONST(0.19509032) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.55557019), COEF_CONST(0.83146966) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.19509028), COEF_CONST(0.98078531) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.19509037), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.55557030), COEF_CONST(0.83146954) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.83146966), COEF_CONST(0.55557019) },
    { COEF_CONST(-0.92387956), COEF_CONST(0.38268328) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95694035), COEF_CONST(0.29028466) },
    { COEF_CONST(0.83146960), COEF_CONST(0.55557024) },
    { COEF_CONST(0.63439327), COEF_CONST(0.77301043) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(0.09801713), COEF_CONST(0.99518472) },
    { COEF_CONST(-0.19509032), COEF_CONST(0.98078525) },
    { COEF_CONST(-0.47139674), COEF_CONST(0.88192123) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.88192129), COEF_CONST(0.47139683) },
    { COEF_CONST(-0.98078531), COEF_CONST(0.19509031) },
    { COEF_CONST(-0.99518472), COEF_CONST(-0.09801727) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.77301043), COEF_CONST(-0.63439322) },
    { COEF_CONST(-0.55557024), COEF_CONST(-0.83146977) },
    { COEF_CONST(-0.29028466), COEF_CONST(-0.95694035) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.38268343), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.00000001), COEF_CONST(-1.00000000) }
};

complex_t cfft_tab_240[] =
{
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99965733), COEF_CONST(0.02617695) },
    { COEF_CONST(0.99862951), COEF_CONST(0.05233596) },
    { COEF_CONST(0.99691731), COEF_CONST(0.07845910) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.99144489), COEF_CONST(0.13052620) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.98325491), COEF_CONST(0.18223552) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.96592581), COEF_CONST(0.25881904) },
    { COEF_CONST(0.95881975), COEF_CONST(0.28401536) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.94264150), COEF_CONST(0.33380687) },
    { COEF_CONST(0.93358040), COEF_CONST(0.35836795) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.90258527), COEF_CONST(0.43051112) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.87881708), COEF_CONST(0.47715878) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.85264015), COEF_CONST(0.52249855) },
    { COEF_CONST(0.83867055), COEF_CONST(0.54463905) },
    { COEF_CONST(0.82412618), COEF_CONST(0.56640625) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.79335332), COEF_CONST(0.60876143) },
    { COEF_CONST(0.77714592), COEF_CONST(0.62932038) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.72537434), COEF_CONST(0.68835455) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.68835455), COEF_CONST(0.72537440) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.64944804), COEF_CONST(0.76040596) },
    { COEF_CONST(0.62932038), COEF_CONST(0.77714598) },
    { COEF_CONST(0.60876143), COEF_CONST(0.79335338) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.56640619), COEF_CONST(0.82412618) },
    { COEF_CONST(0.54463899), COEF_CONST(0.83867061) },
    { COEF_CONST(0.52249855), COEF_CONST(0.85264021) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.47715873), COEF_CONST(0.87881714) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.43051106), COEF_CONST(0.90258533) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.35836792), COEF_CONST(0.93358046) },
    { COEF_CONST(0.33380681), COEF_CONST(0.94264150) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.28401530), COEF_CONST(0.95881975) },
    { COEF_CONST(0.25881901), COEF_CONST(0.96592581) },
    { COEF_CONST(0.23344533), COEF_CONST(0.97236991) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.18223549), COEF_CONST(0.98325491) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.13052616), COEF_CONST(0.99144489) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(0.07845905), COEF_CONST(0.99691731) },
    { COEF_CONST(0.05233591), COEF_CONST(0.99862951) },
    { COEF_CONST(0.02617691), COEF_CONST(0.99965733) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.02617699), COEF_CONST(0.99965733) },
    { COEF_CONST(-0.05233600), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.07845914), COEF_CONST(0.99691731) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.13052624), COEF_CONST(0.99144489) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.18223557), COEF_CONST(0.98325491) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.23344541), COEF_CONST(0.97236991) },
    { COEF_CONST(-0.25881910), COEF_CONST(0.96592581) },
    { COEF_CONST(-0.28401539), COEF_CONST(0.95881969) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.33380690), COEF_CONST(0.94264150) },
    { COEF_CONST(-0.35836801), COEF_CONST(0.93358046) },
    { COEF_CONST(-0.38268349), COEF_CONST(0.92387950) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(-0.43051115), COEF_CONST(0.90258527) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.47715881), COEF_CONST(0.87881714) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99862951), COEF_CONST(0.05233596) },
    { COEF_CONST(0.99452192), COEF_CONST(0.10452846) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.97814763), COEF_CONST(0.20791170) },
    { COEF_CONST(0.96592581), COEF_CONST(0.25881904) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.93358040), COEF_CONST(0.35836795) },
    { COEF_CONST(0.91354543), COEF_CONST(0.40673664) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.86602539), COEF_CONST(0.50000000) },
    { COEF_CONST(0.83867055), COEF_CONST(0.54463905) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.77714592), COEF_CONST(0.62932038) },
    { COEF_CONST(0.74314481), COEF_CONST(0.66913062) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.66913056), COEF_CONST(0.74314487) },
    { COEF_CONST(0.62932038), COEF_CONST(0.77714598) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.54463899), COEF_CONST(0.83867061) },
    { COEF_CONST(0.49999997), COEF_CONST(0.86602545) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.40673661), COEF_CONST(0.91354549) },
    { COEF_CONST(0.35836792), COEF_CONST(0.93358046) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.25881901), COEF_CONST(0.96592581) },
    { COEF_CONST(0.20791166), COEF_CONST(0.97814763) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.10452842), COEF_CONST(0.99452192) },
    { COEF_CONST(0.05233591), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.05233600), COEF_CONST(0.99862951) },
    { COEF_CONST(-0.10452851), COEF_CONST(0.99452192) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.20791174), COEF_CONST(0.97814757) },
    { COEF_CONST(-0.25881910), COEF_CONST(0.96592581) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.35836801), COEF_CONST(0.93358046) },
    { COEF_CONST(-0.40673670), COEF_CONST(0.91354543) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.50000006), COEF_CONST(0.86602539) },
    { COEF_CONST(-0.54463911), COEF_CONST(0.83867055) },
    { COEF_CONST(-0.58778530), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.62932044), COEF_CONST(0.77714586) },
    { COEF_CONST(-0.66913068), COEF_CONST(0.74314481) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.74314487), COEF_CONST(0.66913044) },
    { COEF_CONST(-0.77714598), COEF_CONST(0.62932026) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.83867061), COEF_CONST(0.54463905) },
    { COEF_CONST(-0.86602545), COEF_CONST(0.50000006) },
    { COEF_CONST(-0.89100653), COEF_CONST(0.45399037) },
    { COEF_CONST(-0.91354549), COEF_CONST(0.40673658) },
    { COEF_CONST(-0.93358046), COEF_CONST(0.35836792) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.96592587), COEF_CONST(0.25881892) },
    { COEF_CONST(-0.97814763), COEF_CONST(0.20791161) },
    { COEF_CONST(-0.98768836), COEF_CONST(0.15643445) },
    { COEF_CONST(-0.99452192), COEF_CONST(0.10452849) },
    { COEF_CONST(-0.99862951), COEF_CONST(0.05233581) },
    { COEF_CONST(-1.00000000), COEF_CONST(-0.00000009) },
    { COEF_CONST(-0.99862951), COEF_CONST(-0.05233599) },
    { COEF_CONST(-0.99452186), COEF_CONST(-0.10452867) },
    { COEF_CONST(-0.98768830), COEF_CONST(-0.15643461) },
    { COEF_CONST(-0.97814757), COEF_CONST(-0.20791179) },
    { COEF_CONST(-0.96592581), COEF_CONST(-0.25881907) },
    { COEF_CONST(-0.95105648), COEF_CONST(-0.30901697) },
    { COEF_CONST(-0.93358040), COEF_CONST(-0.35836810) },
    { COEF_CONST(-0.91354543), COEF_CONST(-0.40673673) },
    { COEF_CONST(-0.89100647), COEF_CONST(-0.45399055) },
    { COEF_CONST(-0.86602533), COEF_CONST(-0.50000018) },
    { COEF_CONST(-0.83867049), COEF_CONST(-0.54463917) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(-0.77714592), COEF_CONST(-0.62932044) },
    { COEF_CONST(-0.74314475), COEF_CONST(-0.66913062) },
    { COEF_CONST(-0.70710671), COEF_CONST(-0.70710689) },
    { COEF_CONST(-0.66913050), COEF_CONST(-0.74314487) },
    { COEF_CONST(-0.62932032), COEF_CONST(-0.77714598) },
    { COEF_CONST(-0.58778518), COEF_CONST(-0.80901712) },
    { COEF_CONST(-0.54463893), COEF_CONST(-0.83867055) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.99691731), COEF_CONST(0.07845910) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.92387950), COEF_CONST(0.38268346) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.85264015), COEF_CONST(0.52249855) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.64944804), COEF_CONST(0.76040596) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.52249855), COEF_CONST(0.85264021) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.23344533), COEF_CONST(0.97236991) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(0.07845905), COEF_CONST(0.99691731) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.98768836), COEF_CONST(0.15643448) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.70710677), COEF_CONST(0.70710677) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.45399046), COEF_CONST(0.89100653) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.00000004), COEF_CONST(1.00000000) },
    { COEF_CONST(-0.15643451), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.45399055), COEF_CONST(0.89100647) },
    { COEF_CONST(-0.58778530), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(-0.89100653), COEF_CONST(0.45399037) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.98768836), COEF_CONST(0.15643445) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.97236991), COEF_CONST(0.23344538) },
    { COEF_CONST(0.89100653), COEF_CONST(0.45399052) },
    { COEF_CONST(0.76040596), COEF_CONST(0.64944810) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.38268340), COEF_CONST(0.92387950) },
    { COEF_CONST(0.15643443), COEF_CONST(0.98768836) },
    { COEF_CONST(-0.07845914), COEF_CONST(0.99691731) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.52249861), COEF_CONST(0.85264009) },
    { COEF_CONST(-0.70710683), COEF_CONST(0.70710677) },
    { COEF_CONST(-0.85264021), COEF_CONST(0.52249849) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.99691737), COEF_CONST(0.07845904) },
    { COEF_CONST(-0.98768830), COEF_CONST(-0.15643461) },
    { COEF_CONST(-0.92387950), COEF_CONST(-0.38268343) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(-0.64944798), COEF_CONST(-0.76040608) },
    { COEF_CONST(-0.45399040), COEF_CONST(-0.89100665) },
    { COEF_CONST(-0.23344524), COEF_CONST(-0.97236991) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.95105654), COEF_CONST(0.30901700) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.80901700), COEF_CONST(0.58778524) },
    { COEF_CONST(0.30901697), COEF_CONST(0.95105654) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.80901706), COEF_CONST(0.58778518) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.58778524), COEF_CONST(0.80901700) },
    { COEF_CONST(-0.30901703), COEF_CONST(0.95105648) },
    { COEF_CONST(-0.95105654), COEF_CONST(0.30901679) },
    { COEF_CONST(-0.80901694), COEF_CONST(-0.58778536) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(1.00000000), COEF_CONST(0.00000000) },
    { COEF_CONST(0.30901712), COEF_CONST(-0.95105648) }
};

#endif

#endif

#ifdef __cplusplus
}
#endif
#endif
