/*  XMMS - Software volume managment.
 *  Copyright (C) 2001-2003 Matthieu Sozeau
 *  Original implementation from a patch by Tomas Simonaitis <haden@homelan.lt>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libbeep/configfile.h>
#include "softvolume.h"

gboolean soft_volume_enabled;
gint soft_volume_left;
gint soft_volume_right;

void soft_volume_load(char *section, SoftVolumeConfig * c)
{
    ConfigFile *cfgfile;

    if (c == NULL)
	return;

    char *sec = (section == NULL ? "xmms" : section);

    c->enabled = FALSE;
    c->volume_left = 0;
    c->volume_right = 0;

    cfgfile = xmms_cfg_open_default_file();

    xmms_cfg_read_boolean(cfgfile, sec, "softvolume_enable", &c->enabled);
    xmms_cfg_read_int(cfgfile, sec, "softvolume_left", &c->volume_left);
    xmms_cfg_read_int(cfgfile, sec, "softvolume_right", &c->volume_right);

    xmms_cfg_free(cfgfile);
}

void soft_volume_save(SoftVolumeConfig * c, char *section)
{
    ConfigFile *cfgfile;
    char *sec = (section == NULL ? "xmms" : section);

    cfgfile = xmms_cfg_open_default_file();

    if (section != NULL)
	xmms_cfg_write_boolean(cfgfile, sec, "softvolume_enable",
			       c->enabled);
    xmms_cfg_write_int(cfgfile, sec, "softvolume_left", c->volume_left);
    xmms_cfg_write_int(cfgfile, sec, "softvolume_right", c->volume_right);

    xmms_cfg_write_default_file(cfgfile);
    xmms_cfg_free(cfgfile);
}

void soft_volume_get(SoftVolumeConfig * c, int *l, int *r)
{
    if (c) {
	*l = c->volume_left;
	*r = c->volume_right;
    }
}

void soft_volume_set(SoftVolumeConfig * c, int l, int r)
{
    if (c) {
	c->volume_left = l;
	c->volume_right = r;
    }
}

// FIXME this is ugly
#define effect(type, max, min) { \
int len = length / sizeof(type); \
type *sdata = (type *) data; \
for (i = 0; i < len / 2; ++i) { \
int v = (int) ((*(sdata) * c->volume_left) / 100); \
*(sdata++) = (type) ((v > max) ? max : ((v < min) ? min : v)); \
v = (int) ((*(sdata) * c->volume_right) / 100); \
*(sdata++) = (type) ((v > max) ? max : ((v < min) ? min : v)); } }

void soft_volume_effect(SoftVolumeConfig * c, gpointer data,
			AFormat format, int length)
{
    int i;

    if (!c)
	return;

    if (c->volume_right == -1)
	c->volume_right = c->volume_left;

    switch (format) {
#ifdef WORDS_BIGENDIAN
    case FMT_S16_LE:
    case FMT_U16_LE:
	break;

    case FMT_U16_NE:
    case FMT_U16_BE:
	effect(short, 65535, 0);
	break;

    case FMT_S16_BE:
    case FMT_S16_NE:
	effect(short, 32767, -32768);
	break;
#else
    case FMT_S16_BE:
    case FMT_U16_BE:
	break;

    case FMT_U16_LE:
    case FMT_U16_NE:
	effect(short, 65535, 0);
	break;

    case FMT_S16_LE:
    case FMT_S16_NE:
	effect(short, 32767, -32768);
	break;
#endif
    case FMT_U8:
	effect(char, 255, 0);
	break;
    case FMT_S8:
	effect(char, 127, -128);
	break;
    }
}
